@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.ExpenseCategory') &nbsp; &nbsp; &nbsp;</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('expenseCategory-export')
                        <span id="print-modal">
                            <a href="#" @click.prevent="is_show_modal = !is_show_modal" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                            </a>
                            <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                            v-if="is_show_modal" 
                                :value-type="'expense_cagories_all'"
                                @closed="closeModal">
                            </report-modal>
                        </span>
                    @endpermission
                    {{-- @permission('expenseCategory-create')
                    <a href="{{route('expenseCategory.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission --}}
                    @permission(['expenseCategory-create'])
                    <span id="create-modal">
                        <a href="#" @click.prevent="showModal" class="btn  btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </a>
                    </span>
                    @endpermission
                </div>
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
            </div>
            <div class="portlet-body">
                <!--Begin Form-->
                {!! Form::open(array('route' => 'expenseCategory.create','method'=>'POST','class'=>'form-horizontal','id'=>'expense-category-form')) !!}
                {{ csrf_field() }}
                
                <div class="well well-lg" id="expense-category" v-show="show_create"  v-cloak>
                    <div class="form-body">
                        <div class="row">
                        <div class="col-md-9">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Name'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.ExpenseCategory'),'v-model'=>'name','autocomplete'=>'off'])}}
                                    <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div>
        
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                    {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 6, 'cols' => 30,'v-model'=>'description')) !!}
        
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <button type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                            <a @click="show_create = false, clearData()" class="btn btn-danger"><i class="fa fa-mail-reply"></i>@lang('layout.Cancel')</a>
                        </div>
                    </div>
                </div>
                </div>
                {!! Form::close() !!}
                <!--End Form-->
                <table class="table table-striped table-bordered table-hover" id="ExpenseCategory">
                    <thead>
                    <tr>
                        {{--<th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.UpdatedAt')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
     let data_table = 0;
     $(document).ready(function () {
        getRecord();
    });
    function getRecord() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        if (data_table != 0) {
                data_table.destroy();
        }
        data_table = $('#ExpenseCategory').DataTable({
            ajax: '{{route("expenseCategory.index")}}',
            pageLength: '{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            fixedHeader:true,
            order: [["0", "{{getRowOrder()}}"]],
            
            columns: [
              /*  {data: 'id', name: 'id', orderable: false, searchable: false},*/
                {data: 'name', name: 'name'},
                {data: 'description', name: 'description'},
                {data: 'created_at', name: 'created_at', searchable: false},
                {data: 'updated_at', name: 'updated_at', searchable: false},
                {data: 'action', name: 'action', orderable: false, searchable: false},
            ]
        });
    }


new Vue({
    el: '#company_ll',
    methods: {
        setCompany: function (event) {
            window.location.reload();
        }
    }
});

var print = new Vue({
            el: '#print-modal',
            data:{
                is_show_modal: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },
    
            methods:{
                closeModal: function(){
                    print.is_show_modal = !print.is_show_modal;
                }
            }
        });


    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.show_create = true;

            }
        }
    });

        let vu = new Vue({
                el: '#expense-category',
                data: {
                    show_create:false,
                    name:null,
                    description:null
                },
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    regForm(e.target);
                                }
                            })
                    },

                    alertfun() {
                        alert('ok');
                    },
                    saveAndNew() {
                        this.$validator.validate()
                            .then(valid => {
                                if (valid) {

                                    // v.disabled = true;
                                    var url = "{{route('expenseCategory.store')}}";
                                    form_id = 'expense-category-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function(response) {
                                            toggleBlock(0);
                                            if (response.data.result == 1) {
                                                // $('#' + form_id).trigger('reset');
                                                toastr.success('', response.data.message);
                                                vu.clearData();

                                                getRecord();
                                                // location.reload();
                                            } else {
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('', message);
                                                // v.disabled = false;
                                            }
                                            // v.disabled = false;
                                        })
                                        .catch(function(error) {
                                            toggleBlock(0);
                                            console.log(error);
                                            var message = "{{__('message.Warning')}}";
                                            // v.disabled = false;
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });

                                }
                            })
                    },
                    clearData()
                    {
                        vu.name= null
                        vu.description=null
                    }
                }
            })


    </script>


@endpush
