@extends('layouts.app')
@section('style')

<?php
$menu_session = session()->get('getMenu');
//  $bgcolor = "bg-blue-ebonyclay bg-font-blue-ebonyclay";
//  $bgcolortext = "bg-blue-ebonyclay bg-font-blue-ebonyclay"; 

$bgcolor = "#eceef1";
$bgcolortext = "#eceef1";
$menu_text_color = "#333";
$company_bg_color = "#eceef1";





if(getMenuColor()!='')
{
   $bgcolor = getMenuColor();
   $bgcolortext = getMenuColor();
   $menu_text_color = getMenuTextColor();

   $company_bg_color = getCompanyBgColorDashboard();

   // dd($bgcolor,$bgcolortext);
}

if(themColor()=="newTheme"){
   $bgcolor = "#eceef1";
   $bgcolortext = "#eceef1";
   $menu_text_color = "#333";
   
}


?>
<style>
    /* .v-select input[type=search],
    .v-select input[type=search]:focus {

        width: 50% !important;
    } */

    .table>tbody>tr>td,
    .table>tbody>tr>th,
    .table>tfoot>tr>td,
    .table>tfoot>tr>th,
    .table>thead>tr>td,
    .table>thead>tr>th {
        padding: 8px;
        padding: 4px 2px;
    }

    .dashboard-stat2:hover {
        /* background-color: #e7e7f3; */
        background-color: #caedf3;
    }

    .widget-thumb .widget-thumb-body .widget-thumb-body-stat {
        font-size: 14px !important;
    }

    .company-info{
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 5px;
            padding: 5px;
            background-color: {{($company_bg_color)?$company_bg_color:'#eceef1'}}; 
        }
        .company-name{
            font-size: 30px;
            padding:7px;
            color: {{getCompanyNameColorDashboard()}};
        }
        .company-logo{
            width: 120px;
            height: 120px;
            background-color: #fff;
            border-radius:{{getCompanyLogoBorderRadius()}}%;
        }
        .current-date{
            font-size: 18px;
            color: {{getCompanyNameColorDashboard()}};
        } 

        .widget-thumb.bordered{
            border: 1px solid #a9b9d1 !important;
        }
        .widget-thumb {
            padding: 20px;
            border-radius: 10px;
        }
        .widget-thumb .widget-thumb-wrap .widget-thumb-icon
        {
            float: {{(session()->get("system_direction") == "ltr"?"right":"left")}};
        }

        .mainExchangeDashboardCards{
            display: flex; 
            flex-direction: row;
            justify-content: center;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }
        .exchangeDashboardCards{
            width: 260px !important;
        }
</style>

@endsection
@section('content')
<!--Begin Menu-->
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered" style="padding: 1px 20px 1px 20px; margin: 0px;">
        <template v-cloak id="company_ll">
            <company @company="setCompany"></company>
        </template>
    </div>
</div>
<!--End Menu-->
@if(getCompanyProfile()=="true")
    <div class="company-info" style="display: flex;justify-content: space-between;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px">
    <img alt="" class="company-logo" style="border:3px solid #fff;border-radius:8%;background-size: center center;width:15%;"  src="{{asset('uploads/'.company()['logo'])}}" >
        <div class="company-name" style="text-align: center;">  
            {!!company()['name']!!}
        </div>
        <div class="current-date">
            @if(isset($date))
                <span style="font-size: 18px;display: flex; flex-direction: column; justify-content: center; align-items: center;">
                    <img src="{{asset('menu_img/calendar.png')}}" style="width: 30%;height:30%;border-radius:9px; margin-bottom: 10px;"> 
                    <span>
                        <span>{{convertdate($date, 0, 'jalali')}}  &nbsp;</span><span style="color: red;font-weight: bolder;"> / </span><span>&nbsp;  {{convertdate($date, 2, 'gregorian')}}</span> 
                    </span>
                </span> 
            @endif  
        </div>
    </div>
    <br>
@endif
@permission('dashboard-list')



<div class="row">
    <div class="col-md-12 col-sm-12" id="cashe-chart">
        <div :class="fullSc">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.DailyProfitAndLossChart')</span>
                </div>
                {{-- <div class=" caption form-group col-md-4">
                    <label class="control-label col-md-2">@lang('layout.Type'):</label>
                    <div class="col-md-10">
                        <v-select placeholder="@lang('layout.SelectType')" label="type" :options="{{ json_encode($type) }}" v-model="data_type" @input="getAccounts()"></v-select>
                    </div>
                </div>
                <div class=" caption form-group col-md-4">
                    <label class="control-label col-md-2">@lang('layout.Class'):</label>
                    <div class="col-md-10">
                        <v-select placeholder="@lang('layout.SelectClass')" label="name" :options="{{ json_encode($accountClass) }}" v-model="data_class" @input="getAccounts()"></v-select>
                    </div>
                </div> --}}
                <div class="form-group col-md-4" >
                    <div class="form-group">
                        <div class="input-group">
                            <input class="form-control date" id="chashe_chart_from_date"  autocomplete="off">
                            
                            <span class="input-group-addon"> @lang('layout.To') </span>
                            <input class="form-control date" id="chashe_chart_to_date"  autocomplete="off">
                        </div>
                    </div>
                    
                </div>
                <div class="form-group col-md-4" >
                    <div class="col-md-7">
                        <button  @click="getData()" class="btn blue"><i class="fa fa-repeat"></i></button>
                    </div>
                    
                </div>
                
                <div class="actions">
                    <button class="btn green" onclick="printChart('cashe_chart')"><i class="fa fa-print"></i></button>
                    <!-- <button  class="btn red" onclick="downloadChart('today_income_and_expense_chart','chart')" ><i class="fa fa-print"></i></button> -->
                    <button class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                        <i class="fa fa-expand"></i>
                    </a>
                </div>
            </div>
            <div class="portlet-body">
                <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                    <table class="dashboard-tabel table-bordered" width="50%">
                        <thead>

                        </thead>
                        <tbody>

                        </tbody>
                    </table>        
                </div>
                <div class="alert alert-info" v-show="loading">
                    <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                </div>
                <div>
                    <canvas id="cashe_chart" height="280" width="600" ></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

@permission('cheque-list')
<div class="portlet light" style="padding: 0.5% 1%;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-bar-chart font-green-haze"></i>
            <span class="caption-subject bold uppercase font-green-haze">@lang('menu.Cheque')</span>
        </div>
    </div>
    <div class="row mainExchangeDashboardCards">
        <!-- $sendChequeOff->dollarAmount, $ReceiveChequeOff->dollarAmount, $sendChequeOn->dollarAmount, $ReceiveChequeOn->dollarAmount, $chequeCommission->comDollarAmount -->
        <div class="exchangeDashboardCards">
            {{Form::open(['route' => 'cheque.report','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="allChequeReports" />
            <input type="hidden" name="report_format" value="pdf" />
            <input type="hidden" name="type_name" value="Send" />
            <input type="hidden" name="status" value="off" />
            <a>
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.Send') @lang('layout.Implemented')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-blue">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-subtitle">{{getReportCurrency()}}</span>
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($sendChequeOff)?myRound($sendChequeOff->dollarAmount):0}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </a>
            {{Form::close()}}
        </div>

        <div class="exchangeDashboardCards">
            {{Form::open(['route' => 'cheque.report','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="allChequeReports" />
            <input type="hidden" name="report_format" value="pdf" />
            <input type="hidden" name="type_name" value="Receive" />
            <input type="hidden" name="status" value="off" />
            <a>
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.Receive') @lang('layout.Implemented')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-blue">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-subtitle">{{getReportCurrency()}}</span>
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($ReceiveChequeOff)?myRound($ReceiveChequeOff->dollarAmount):0}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </a>
            {{Form::close()}}
        </div>

        <div class="exchangeDashboardCards">
            {{Form::open(['route' => 'cheque.report','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="allChequeReports" />
            <input type="hidden" name="report_format" value="pdf" />
            <input type="hidden" name="type_name" value="Send" />
            <input type="hidden" name="status" value="on" />
            <a>
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading"> @lang('layout.Send') @lang('layout.NotImplemented')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-red-haze">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-subtitle">{{getReportCurrency()}}</span>
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($sendChequeOn)?myRound($sendChequeOn->dollarAmount):0}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </a>
            {{Form::close()}}
        </div>

        <div class="exchangeDashboardCards">
            {{Form::open(['route' => 'cheque.report','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="allChequeReports" />
            <input type="hidden" name="report_format" value="pdf" />
            <input type="hidden" name="type_name" value="Receive" />
            <input type="hidden" name="status" value="on" />
            <a>
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.Receive') @lang('layout.NotImplemented')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-red-haze">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-subtitle">{{getReportCurrency()}}</span>
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($ReceiveChequeOn)?myRound($ReceiveChequeOn->dollarAmount):0}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </a>
            {{Form::close()}}
        </div>

        <div class="exchangeDashboardCards">
            {{Form::open(['route' => 'cheque.report','method' => 'DELETE','class' => 'inline'])}}
            <input type="hidden" name="type" value="allChequeReports" />
            <input type="hidden" name="report_format" value="pdf" />
            <a>
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.Commission')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-purple">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-subtitle">{{getReportCurrency()}}</span>
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($chequeCommission)?myRound($chequeCommission->comDollarAmount):0}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </a>
            {{Form::close()}}
        </div>
    </div>
</div>
@endpermission

@permission('currencyExchange-list')
<div class="portlet light" style="padding: 0.5% 1%;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-bar-chart font-green-haze"></i>
            <span class="caption-subject bold uppercase font-green-haze">@lang('menu.CurrencyExchange')</span>
        </div>
    </div>

    <div class="row">

        <!-- $BuyCurrency->baseAmount, $SaleCurrency->baseAmount, $currencyGainLoss->base_gl_amount -->

        {{Form::open(['route' => 'currencyExchange.report','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="allCurrencyExchangeReports" />
        <input type="hidden" name="report_format" value="pdf" />
        <input type="hidden" name="type_name" value="BuyCurrency" />
        <a>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.BuyCurrency')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-red-haze">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($BuyCurrency)?myRound($BuyCurrency->baseAmount):0}} {{getReportCurrency()}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        {{Form::close()}}

        {{Form::open(['route' => 'currencyExchange.report','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="allCurrencyExchangeReports" />
        <input type="hidden" name="report_format" value="pdf" />
        <input type="hidden" name="type_name" value="SaleCurrency" />
        <a>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.SaleCurrency')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-blue">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($SaleCurrency)?myRound($SaleCurrency->baseAmount):0}} {{getReportCurrency()}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        {{Form::close()}}

        {{Form::open(['route' => 'currencyExchange.report','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="allCurrencyExchangeReports" />
        <input type="hidden" name="report_format" value="pdf" />
        <a>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading"> @lang('layout.ProfitAndLoss')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-green-jungle">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($currencyGainLoss)?myRound($currencyGainLoss->base_gl_amount):0}} {{getReportCurrency()}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        {{Form::close()}}

    </div>
</div>
@endpermission

@permission('loan-list')
<div class="portlet light" style="padding: 0.5% 1%;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-bar-chart font-green-haze"></i>
            <span class="caption-subject bold uppercase font-green-haze">@lang('menu.ReceivablePayment')</span>
        </div>
    </div>

    <div class="row">

        <!-- $getLoan->exchanged_amount, $payLoan->exchanged_amount -->

        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="allLoanReports" />
        <input type="hidden" name="report_format" value="pdf" />
        <input type="hidden" name="type_name" value="getLoan" />
        <a>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.GetLoan')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-blue">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($getLoan)?myRound($getLoan->exchanged_amount):0}} {{getReportCurrency()}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        {{Form::close()}}

        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="allLoanReports" />
        <input type="hidden" name="report_format" value="pdf" />
        <input type="hidden" name="type_name" value="PayLoan" />
        <a>
            <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white margin-bottom-10 text-uppercase" style="padding: 5px;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                    <button type="submit" class="btn" style="background: none;">
                        <h4 class="widget-thumb-heading">@lang('layout.PayLoan')</h4>
                    </button>
                    <div class="widget-thumb-wrap">
                        <span class="widget-thumb-icon bg-red-haze">
                            <i class="fa fa-money" style="color: white"></i>
                        </span>
                        <button type="submit" class="btn" style="background: none;">
                            <div class="widget-thumb-body" style="overflow: visible;">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{($payLoan)?myRound($payLoan->exchanged_amount):0}} {{getReportCurrency()}}</span>
                            </div>
                        </button>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        {{Form::close()}}

    </div>
</div>
@endpermission




{{-- @if(getDashboardGraphs('bank_balance')=="true")
<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption">
            <i class="icon-bar-chart font-green-haze"></i>
            <span class="caption-subject bold uppercase font-green-haze">@lang('layout.BankAccounts')</span>
        </div>
    </div>

    <div class="row">
        @if($accountClass)
        <?php
        $accuon = $bankAccounts;
        ?>
        @foreach($accountClass as $clas)
        <h3 class="col-lg-12 col-md-12 col-sm-12 col-xs-12">{{$clas['name']}}</h3>
        @foreach($bankAccounts as $key => $bank)
        @if($clas['id'] == $bank['class_id'])

        <a href="{{route('account.show',['id' => $bank['id']])}}">
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                    <h4 class="widget-thumb-heading">{{$bank['name']}}</h4>
                    <div class="widget-thumb-wrap">
                        <i class="widget-thumb-icon {{(themColor()=='newTheme')?'bg-white':'bg-purple'}}   fa fa-bank"></i>
                        <div class="widget-thumb-body">
                            <span class="widget-thumb-subtitle">{{$bank['currency']}}</span>
                            <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}}</span>
                        </div>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        <?php
        $accuon = Arr::except($accuon, $key);
        ?>
        @endif
        @endforeach


        @endforeach

        <h3 class="col-lg-12 col-md-12 col-sm-12 col-xs-12">@lang('layout.OtherAccount')</h3>

        @foreach($accuon as $bank)
        <a href="{{route('account.show',['id' => $bank['id']])}}">
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                    <h4 class="widget-thumb-heading">{{$bank['name']}}</h4>
                    <div class="widget-thumb-wrap">
                        <i class="widget-thumb-icon {{(themColor()=='newTheme')?'bg-white':'bg-purple'}}   fa fa-bank"></i>
                        <div class="widget-thumb-body">
                            <span class="widget-thumb-subtitle">{{$bank['currency']}}</span>
                            <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}}</span>
                        </div>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        @endforeach

        @else
        @foreach($bankAccounts as $bank)
        <a href="{{route('account.show',['id' => $bank['id']])}}">
            <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                <!-- BEGIN WIDGET THUMB -->
                <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                    <h4 class="widget-thumb-heading">{{$bank['name']}}</h4>
                    <div class="widget-thumb-wrap">
                        <i class="widget-thumb-icon {{(themColor()=='newTheme')?'bg-white':'bg-purple'}}   fa fa-bank"></i>
                        <div class="widget-thumb-body">
                            <span class="widget-thumb-subtitle">{{$bank['currency']}}</span>
                            <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}}</span>
                        </div>
                    </div>
                </div>
                <!-- END WIDGET THUMB -->
            </div>
        </a>
        @endforeach
        @endif
    </div>

    <div class="row">


        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-bar-chart font-green-haze"></i>
                    <span class="caption-subject bold uppercase font-green-haze">@lang('layout.Total')</span>
                </div>
            </div>



            <div class="row">
                @foreach($bankAccountsPerCurrency as $bank)

                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                    <!-- BEGIN WIDGET THUMB -->
                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                        <h4 class="widget-thumb-heading">@lang('currency.'.($bank->currency)) ({{$bank->currency}})</h4>
                        <div class="widget-thumb-wrap">
                            <i class="widget-thumb-icon  {{(themColor()=='newTheme')?'bg-white':'bg-green'}}   fa fa-money"></i>
                            <div class="widget-thumb-body">
                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank->balance)}}</span>
                            </div>
                        </div>
                    </div>
                    <!-- END WIDGET THUMB -->
                </div>
                @endforeach
            </div>
        </div>


    </div>
</div>

@endif --}}

@if(getDashboardGraphs('bank_balance')=="true")
<div class="portlet light" style="padding: 0.5% 1%;box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
        <div class="portlet-title">
                <div class="caption">
                    <i class="icon-bar-chart font-green-haze"></i>
                    <span class="caption-subject bold uppercase font-green-haze">@lang('layout.BankAccounts')</span>
                </div>
            </div>


            <div class="row">
            @if($accountClass)
                <?php 
                $accuon = $bankAccounts; 
                ?>
                @foreach($accountClass as $clas)
                <h4 class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="background-color: #eceef1;padding:15px;border-radius:5px; text-align: center;">{{$clas['name']}}</h4>


                @foreach($bankAccounts as $key => $bank)
                @if($clas['id'] == $bank['class_id'])
                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                    <a  href="{{route('account.show',['id' => $bank['id']])}}" style="text-decoration: none;color:black">
                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                        <h4 class="widget-thumb-heading">{{$bank['name']}} </h4>
                        <div class="widget-thumb-wrap">
                            <span class="widget-thumb-icon bg-yellow-gold">
                                <i class="fa fa-briefcase" style="color: white"></i>
                            </span>
                            <div class="details">
                                <div class="number">
                                    <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}} {{$bank['currency']}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    </a>
                </div>

                <?php 
                    $accuon = Arr::except($accuon, $key);
                ?>
                @endif
                @endforeach
                @endforeach

                <h4 class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="background-color: #eceef1;padding:15px;border-radius:5px">@lang('layout.OtherAccount')</h4>
                
                @foreach($accuon as $bank)
                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                    <a  href="{{route('account.show',['id' => $bank['id']])}}" style="text-decoration: none;color:black">
                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                        <h4 class="widget-thumb-heading">{{$bank['name']}} </h4>
                        <div class="widget-thumb-wrap">
                            <span class="widget-thumb-icon bg-yellow-gold">
                                <i class="fa fa-briefcase" style="color: white"></i>
                            </span>
                            <div class="details">
                                <div class="number">
                                    <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}} {{$bank['currency']}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    </a>
                </div>

                @endforeach

            @else
                @foreach($bankAccounts as $bank)
                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                    <a  href="{{route('account.show',['id' => $bank['id']])}}" style="text-decoration: none;color:black">
                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20" style="box-shadow: 0px 0px 3px rgba(187, 187, 187, 0.69);border-radius: 8px;">
                        <h4 class="widget-thumb-heading">{{$bank['name']}} </h4>
                        <div class="widget-thumb-wrap">
                            <span class="widget-thumb-icon bg-blue-soft">
                                <i class="fa fa-briefcase" style="color: white"></i>
                            </span>
                            <div class="details">
                                <div class="number">
                                    <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank['balance'])}} {{$bank['currency']}}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    </a>
                </div>

                @endforeach
            @endif
            </div>

    <div class="row">
        <div class="portlet light" >
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-bar-chart font-green-haze"></i>
                    <span class="caption-subject bold uppercase font-green-haze">@lang('layout.Total')</span>
                </div>
            </div>
            <div class="row">
                @foreach($bankAccountsPerCurrency as $bank)
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                        <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                            <h4 class="widget-thumb-heading">@lang('currency.'.($bank->currency)) ({{$bank->currency}}) </h4>
                            <div class="widget-thumb-wrap">
                                <span class="widget-thumb-icon bg-blue-steel">
                                    <i class="fa fa-money" style="color: white"></i>
                                </span>
                                <div class="details">
                                    <div class="number">
                                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="815">{{myRound($bank->balance)}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                @endforeach
            </div>
        </div>
    </div>
</div>

@endif
<!----------------------------------------------------------------------------
            | BEGIN  Income And Expenses Charts
            |---------------------------------------------------------------------------->

<div class="table-scrollable">
    <div class="col-md-12 col-sm-12" id="income-and-expense-chart">
        <div class="portlet light">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.Cheque')</span>
                </div>
                <div class="actions">

                    <button class="btn green" onclick="printChart('income_and_expense_chart')"><i class="fa fa-print"></i></button>
                    <button class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>


                </div>
            </div>
            <div class="portlet-body">

                <div style="padding: 0px;margin:0px" class="dashboard-stat2 col-md-4 col-sm-12" v-show="this.chart !=null && !loading">
                    <table class="dashboard-tabel table-bordered" width="100%">
                        <thead>
                            <tr style="background-color: rgb(84, 199, 211);">
                                <th colspan="3">@lang('layout.Total') </th>
                            </tr>

                        </thead>
                        <tbody>
                            <span>
                                <tr>
                                    <td class="highlight">@lang('layout.Send') @lang('layout.Implemented')</td>
                                    <td class=""> {{($sendChequeOff)?myRound($sendChequeOff->dollarAmount):0}}</td>
                                    <td class=""> {{getHomeCurrency()['code']}}</td>
                                </tr>
                                <tr>
                                    <td class="highlight">@lang('layout.Receive') @lang('layout.Implemented')</td>
                                    <td class=""> {{($ReceiveChequeOff)?myRound($ReceiveChequeOff->dollarAmount):0}}</td>
                                    <td class=""> {{getHomeCurrency()['code']}}</td>
                                </tr>
                                <tr>
                                    <td class="highlight">@lang('layout.Send') @lang('layout.NotImplemented')</td>
                                    <td class=""> {{($sendChequeOn)?myRound($sendChequeOn->dollarAmount):0}}</td>
                                    <td class=""> {{getHomeCurrency()['code']}}</td>
                                </tr>
                                <tr>
                                    <td class="highlight">@lang('layout.Receive') @lang('layout.NotImplemented')</td>
                                    <td class=""> {{($ReceiveChequeOn)?myRound($ReceiveChequeOn->dollarAmount):0}}</td>
                                    <td class=""> {{getHomeCurrency()['code']}}</td>
                                </tr>
                                <tr>
                                    <td class="highlight">@lang('layout.Commission')</td>
                                    <td class=""> {{($chequeCommission)?myRound($chequeCommission->comDollarAmount):0}}</td>
                                    <td class=""> {{getHomeCurrency()['code']}}</td>
                                </tr>
                            </span>
                        </tbody>
                    </table>
                </div>

                <div class="alert alert-info" v-show="loading">
                    <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                </div>


                <div>
                    <canvas id="income_and_expense_chart" height="280" width="600"></canvas>
                </div>
            </div>
        </div>
    </div>

</div>


<div class="row">

    <!-- start currency Exchange -->
    <div class="col-md-6 col-sm-12">
        <div class="col-md-12 col-sm-12" id="currency-exchange-chart">
            <div :class="fullSc">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                        <span class="caption-subject bold uppercase">@lang('menu.CurrencyExchange')</span>
                    </div>
                    <div class="actions">
                        <button type="submit" class="btn green" onclick="printChart('currency_exchange_chart')"><i class="fa fa-print"></i></button>
                        <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                        <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                            <i class="fa fa-expand"></i>
                        </a>
                    </div>
                </div>

                <div class="portlet-body">
                    <div style="padding: 0px;margin:0px" class="dashboard-stat2 col-md-4 col-sm-12" v-show="this.chart !=null && !loading">

                        <table class="dashboard-tabel table-bordered" width="100%">
                            <thead>
                                <tr style="background-color: rgb(84, 199, 211);">
                                    <th colspan="3">@lang('layout.Total') </th>
                                </tr>
                            </thead>
                            <tbody>
                                <span>
                                    <tr>
                                        <td class="highlight">@lang('layout.BuyCurrency')</td>
                                        <td class=""> {{($BuyCurrency)?myRound($BuyCurrency->baseAmount):0}}</td>
                                        <td class=""> {{getHomeCurrency()['code']}}</td>
                                    </tr>
                                    <tr>
                                        <td class="highlight">@lang('layout.SaleCurrency')</td>
                                        <td class=""> {{($SaleCurrency)?myRound($SaleCurrency->baseAmount):0}}</td>
                                        <td class=""> {{getHomeCurrency()['code']}}</td>
                                    </tr>
                                    <tr>
                                        <td class="highlight">@lang('layout.ProfitAndLoss')</td>
                                        <td class=""> {{($currencyGainLoss)?myRound($currencyGainLoss->base_gl_amount):0}}</td>
                                        <td class=""> {{getHomeCurrency()['code']}}</td>
                                    </tr>
                                </span>
                            </tbody>
                        </table>
                    </div>
                    <div class="alert alert-info" v-show="loading">
                        <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                    </div>
                    <div>
                        <canvas id="currency_exchange_chart" height="280" width="600"></canvas>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end currency Exchange -->

    <!-- start loan -->
    <div class="col-md-6 col-sm-12">
        <div class="col-md-12 col-sm-12" id="loan-chart">
            <div :class="fullSc">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                        <span class="caption-subject bold uppercase">@lang('menu.ReceivablePayment')</span>
                    </div>
                    <div class="actions">
                        <button type="submit" class="btn green" onclick="printChart('loan_chart')"><i class="fa fa-print"></i></button>
                        <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                        <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                            <i class="fa fa-expand"></i>
                        </a>
                    </div>
                </div>

                <div class="portlet-body">
                    <div style="padding: 0px;margin:0px" class="dashboard-stat2  col-md-4 col-sm-12" v-show="this.chart !=null && !loading">

                        <table class="dashboard-tabel table-bordered" width="100%">
                            <thead>
                                <tr style="background-color: rgb(84, 199, 211);">
                                    <th colspan="3">@lang('layout.Total') </th>
                                </tr>
                            </thead>
                            <tbody>
                                <span>
                                    <tr>
                                        <td class="highlight">@lang('layout.GetLoan')</td>
                                        <td class=""> {{($getLoan)?myRound($getLoan->exchanged_amount):0}}</td>
                                        <td class=""> {{getHomeCurrency()['code']}}</td>
                                    </tr>
                                    <tr>
                                        <td class="highlight">@lang('layout.PayLoan')</td>
                                        <td class=""> {{($payLoan)?myRound($payLoan->exchanged_amount):0}}</td>
                                        <td class=""> {{getHomeCurrency()['code']}}</td>
                                    </tr>
                                </span>
                            </tbody>
                        </table>
                    </div>
                    <div class="alert alert-info" v-show="loading">
                        <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                    </div>
                    <div>
                        <canvas id="loan_chart" height="280" width="600"></canvas>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end loan -->

</div>
<div class="row">
    <div class="col-md-12 col-sm-12" id="today-income-and-expense-chart">
        <div :class="fullSc">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.Account')</span>
                </div>
                <div class=" caption form-group col-md-4">
                    <label class="control-label col-md-2">@lang('layout.Type'):</label>
                    <div class="col-md-10">
                        <v-select placeholder="@lang('layout.SelectType')" label="type" :options="{{ json_encode($type) }}" v-model="data_type" @input="getAccounts()"></v-select>
                    </div>
                </div>
                <div class=" caption form-group col-md-4">
                    <label class="control-label col-md-2">@lang('layout.Class'):</label>
                    <div class="col-md-10">
                        <v-select placeholder="@lang('layout.SelectClass')" label="name" :options="{{ json_encode($accountClass) }}" v-model="data_class" @input="getAccounts()"></v-select>
                    </div>
                </div>
                <div class="actions">
                    <button class="btn green" onclick="printChart('today_income_and_expense_chart')"><i class="fa fa-print"></i></button>
                    <!-- <button  class="btn red" onclick="downloadChart('today_income_and_expense_chart','chart')" ><i class="fa fa-print"></i></button> -->
                    <button class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                    <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                        <i class="fa fa-expand"></i>
                    </a>
                </div>
            </div>
            <div class="portlet-body">
                <div style="padding: 0px;margin:0px" class="dashboard-stat2" v-show="this.chart !=null && !loading">
                    <table class="dashboard-tabel table-bordered" width="50%">
                        <thead>

                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
                <div class="alert alert-info" v-show="loading">
                    <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                </div>
                <div>
                    <canvas id="today_income_and_expense_chart" height="280" width="600"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<!----------------------------------------------------------------------------
            | End  Income And Expenses Charts
            |---------------------------------------------------------------------------->


<hr>




<!-- END CONTENT -->
@endpermission


@if(!\Entrust::can('dashboard-list'))
<h1 class="page-title"></h1>
<div class="row">
    <div class="col-md-12">


        <div class="portlet light bordered">
            <div class="portlet-title note note-info note-bordered">

                <div class="caption">
                    <i class="icon-bar-chart font-green-haze"></i>
                    <span class="caption-subject bold uppercase font-green-haze" style="font-size: 20px">@lang('menu.Dashboard')</span>
                </div>

            </div>

        </div>
    </div>
</div>
@endif
@endsection
@include('groupCompanyFilter.select')
@push('scripts')

<script src="{{ asset('assets/scripts/dashboard.min.js') }}"></script>
<script src="{{ asset('chart/Chart.bundle.js') }}"></script>


<script>
    Vue.component('v-select', VueSelect.VueSelect);


    //--------------------------------------------------------
    //              Begin  Income And Expense                       
    //--------------------------------------------------------//
    let incomeAndExpense = new Vue({
        el: '#income-and-expense-chart',
        data: {
            chart: null,
            dates: [],
            label: [],
            color: [],
            loading: false,
            type: 'income_expense_all',
            fullSc: 'portlet light bordered'

        },
        mounted() {
            this.getData();
        },
        methods: {
            getData: function() {
                this.loading = true;
                if (this.chart != null) {
                    this.chart.destroy();
                }

                type_temp = this.type;

                axios.get("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp)

                    .then(response => {
                        if (response.data.amount.length > 0) {

                            this.dates = response.data.amount;
                            this.label = response.data.label;
                            this.color = response.data.color;

                            incomeAndExpense.chartData(this.dates, this.label, this.color);
                        }


                    })

                    .catch(function(error) {})
                    .finally(() => (this.loading = false));

            },
            fullScreen() {
                if (this.fullSc == 'portlet light bordered portlet-fullscreen') {
                    this.fullSc = 'portlet light bordered';
                } else {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates, label, color) {
                var ctx_income_and_expense = document.getElementById("income_and_expense_chart");
                incomeAndExpense.chart = new Chart(ctx_income_and_expense, {
                    // type: 'polarArea',
                    type: 'doughnut',
                    // type: 'line',
                    // type: 'radar',
                    // type: 'bubble',
                    // type: 'scatter',
                    data: {
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth: 2
                        }],
                    },
                    options: {
                        legend: {
                            display: true,
                            position: 'right',
                            align: 'center',

                            labels: {
                                fontSize: 14,
                                fontColor: 'red',
                                boxWidth: 20,
                                boxHeight: 20
                            }
                        },
                        elements: {
                            rectangle: {
                                borderWidth: 1,
                                borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: true,
                            text: '@lang("menu.Cheque")',
                            position: 'left',
                            fontSize: 16,
                        }
                    }
                });
            }

        }
    });
    //--------------------------------------------------------
    //              End Income And Expense                       
    //--------------------------------------------------------//

    //--------------------------------------------------------
    //              Begin TOtal loan                      
    //--------------------------------------------------------//

    let totalIncomeAndExpense = new Vue({
        el: '#loan-chart',
        data: {
            chart: null,
            dates: [],
            label: [],
            color: [],
            loading: false,
            type: 'loan',
            fullSc: 'portlet light bordered'

        },
        mounted() {
            this.getData();
        },
        methods: {
            getData: function() {
                this.loading = true;
                if (this.chart != null) {
                    this.chart.destroy();
                }

                var type_temp = this.type;

                axios.get("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp)

                    .then(response => {
                        // console.log(1239, response.data);
                        if (response.data.amount.length > 0) {

                            this.dates = response.data.amount;
                            this.label = response.data.label;
                            this.color = response.data.color;
                            // console.log(123, this.dates,this.label,this.color, type_temp);
                            totalIncomeAndExpense.chartData(this.dates, this.label, this.color);
                        }


                    })

                    .catch(function(error) {})
                    .finally(() => (this.loading = false));

            },
            fullScreen() {
                if (this.fullSc == 'portlet light bordered portlet-fullscreen') {
                    this.fullSc = 'portlet light bordered';
                } else {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates, label, color) {
                var ctx_total_income_and_expense = document.getElementById("loan_chart");
                totalIncomeAndExpense.chart = new Chart(ctx_total_income_and_expense, {
                    // type: 'polarArea',
                    // type: 'bar',
                    type: 'doughnut',
                    // type: 'line',
                    // type: 'radar',
                    // type: 'bubble',
                    // type: 'scatter',
                    data: {
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth: 2
                        }],
                    },
                    options: {
                        legend: {
                            display: false,
                            position: 'right',
                            align: 'center',

                            labels: {
                                fontSize: 14,
                                fontColor: 'red',
                                boxWidth: 20,
                                boxHeight: 20


                            }
                        },
                        elements: {
                            rectangle: {
                                borderWidth: 2,
                                borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: true,
                            text: '@lang("menu.ReceivablePayment")',
                            position: 'left',
                            fontSize: 20,
                        }
                    }
                });
            }

        }
    });

    //--------------------------------------------------------
    //              End TOtal loan                     
    //--------------------------------------------------------//


    //--------------------------------------------------------
    //              Begin TOtal currency-exchange-chart                       
    //--------------------------------------------------------//

    let currencyExchange = new Vue({
        el: '#currency-exchange-chart',
        data: {
            chart: null,
            dates: [],
            label: [],
            color: [],
            loading: false,
            type: 'currency_exchange',
            fullSc: 'portlet light bordered'

        },
        mounted() {
            this.getData();
        },
        methods: {
            getData: function() {
                this.loading = true;
                if (this.chart != null) {
                    this.chart.destroy();
                }

                var type_temp = this.type;

                axios.get("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp)

                    .then(response => {
                        // console.log(1239, response.data);
                        if (response.data.amount.length > 0) {

                            this.dates = response.data.amount;
                            this.label = response.data.label;
                            this.color = response.data.color;
                            // console.log(123, this.dates,this.label,this.color, type_temp);
                            currencyExchange.chartData(this.dates, this.label, this.color);
                        }


                    })

                    .catch(function(error) {})
                    .finally(() => (this.loading = false));

            },
            fullScreen() {
                if (this.fullSc == 'portlet light bordered portlet-fullscreen') {
                    this.fullSc = 'portlet light bordered';
                } else {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates, label, color) {
                var ctx_total_income_and_expense = document.getElementById("currency_exchange_chart");
                currencyExchange.chart = new Chart(ctx_total_income_and_expense, {
                    // type: 'polarArea',
                    // type: 'bar',
                    type: 'doughnut',
                    // type: 'line',
                    // type: 'radar',
                    // type: 'bubble',
                    // type: 'scatter',
                    data: {
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth: 2
                        }],
                    },
                    options: {
                        legend: {
                            display: false,
                            position: 'right',
                            align: 'center',

                            labels: {
                                fontSize: 14,
                                fontColor: 'red',
                                boxWidth: 20,
                                boxHeight: 20


                            }
                        },
                        elements: {
                            rectangle: {
                                borderWidth: 2,
                                borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: true,
                            text: '@lang("menu.CurrencyExchange")',
                            position: 'left',
                            fontSize: 20,
                        }
                    }
                });
            }

        }
    });

    //--------------------------------------------------------
    //              End TOtal currency-exchange-chart                     
    //--------------------------------------------------------//

    //--------------------------------------------------------
    //              Begin Today Income And Expense                       
    //--------------------------------------------------------//

    let todayIncomeAndExpense = new Vue({
        el: '#today-income-and-expense-chart',
        data: {
            chart: null,
            dates: [],
            label: [],
            color: [],
            loading: false,
            data_type: null,
            data_class: null,
            type: 'income_expense_all_total',
            fullSc: 'portlet light bordered'

        },
        mounted() {
            this.getData();
        },
        methods: {
            getAccounts() {
                var type = (this.data_type) ? this.data_type.type : null;
                var class_id = (this.data_class) ? this.data_class.id : null;
                this.getData(type, class_id);
            },
            getData: function(data_type = '', class_id = '') {
                this.loading = true;
                if (this.chart != null) {
                    this.chart.destroy();
                }

                type_temp = this.type;
                // console.log("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp + "&data_type=" + data_type);

                axios.get("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp + "&data_type=" + data_type + "&class_id=" + class_id)

                    .then(response => {
                        // console.log(response);
                        if (response.data.data.length > 0) {

                            this.dates = response.data.data;
                            this.label = response.data.label;
                            this.color = response.data.color;

                            todayIncomeAndExpense.chartData(this.dates, this.label, this.color);
                        }


                    })

                    .catch(function(error) {})
                    .finally(() => (this.loading = false));

            },
            fullScreen() {
                if (this.fullSc == 'portlet light bordered portlet-fullscreen') {
                    this.fullSc = 'portlet light bordered';
                } else {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            chartData(dates, label, color) {
                var ctx_today_income_and_expense = document.getElementById("today_income_and_expense_chart");
                todayIncomeAndExpense.chart = new Chart(ctx_today_income_and_expense, {
                    // type: 'bar',
                    // type: 'polarArea',
                    // type: 'doughnut',
                    type: 'bar',
                    // type: 'line',
                    // type: 'radar',
                    // type: 'bubble',
                    // type: 'scatter',
                    data: {
                        labels: label,
                        datasets: [{
                            backgroundColor: color,
                            data: dates,
                            borderWidth: 2
                        }],
                    },
                    options: {
                        legend: {
                            display: false,
                            position: 'right',
                            align: 'center',

                            labels: {
                                // fontSize:18,
                                // fontColor:'red',
                                // boxWidth:80
                                // boxHeight:80
                            }
                        },
                        elements: {
                            rectangle: {
                                borderWidth: 2,
                                borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: true,
                            text: '@lang("menu.Account")',
                            // position:'left',
                            // fontSize: 16,
                        }
                    }
                });
            }

        }
    });

    //--------------------------------------------------------
    //              End Today Income And Expense                       
    //--------------------------------------------------------//
    
    
    //--------------------------------------------------------
    //              Begin cashe                      
    //--------------------------------------------------------//

    let casheChart = new Vue({
        el: '#cashe-chart',
        data: {
            chart: null,
            dates: [],
            label: [],
            color: [],
            loading: false,
            data_type: null,
            data_class: null,
            type: 'chash_chart',
            fullSc: 'portlet light bordered'

        },
        mounted() {
            this.getData();
        },
        methods: {
            getAccounts() {
                var type = (this.data_type) ? this.data_type.type : null;
                var class_id = (this.data_class) ? this.data_class.id : null;
                this.getData(type, class_id);
            },
            getData: function(data_type = '', class_id = '') {
                var ch_vs = this;
                ch_vs.loading = true;
                if (ch_vs.chart != null) {
                    ch_vs.chart.destroy();
                }
                type_temp = ch_vs.type;

                var from_date = document.getElementById('chashe_chart_from_date').value;
                var to_date   = document.getElementById('chashe_chart_to_date').value;

                axios.get("{{route('exchangeDashboard.chartjsDa')}}?type=" + type_temp + "&data_type=" + data_type + "&class_id=" + class_id+"&from_date="+from_date+"&to_date="+to_date)

                    .then(response => {
                        if (response.data.data1.length > 0) {

                            ch_vs.label = response.data.label;
                            // console.log('DDDDDDD',response.data);

                            // ch_vs.dates = response.data.data;
                            // ch_vs.color = response.data.color;
                            ch_vs.morningRates = response.data.data1;
                            ch_vs.nightRates = response.data.data2;
                            ch_vs.colorMorning = response.data.color1;
                            ch_vs.colorNight = response.data.color2;

                            // console.log(212121, ch_vs.morningRates,ch_vs.nightRates, ch_vs.label, ch_vs.colorMorning,ch_vs.colorNight);
                            casheChart.chartData(ch_vs.morningRates,ch_vs.nightRates, ch_vs.label, ch_vs.colorMorning,ch_vs.colorNight);
                        }


                    })

                    .catch(function(error) {})
                    .finally(() => (ch_vs.loading = false));

            },
            fullScreen() {
                if (this.fullSc == 'portlet light bordered portlet-fullscreen') {
                    this.fullSc = 'portlet light bordered';
                } else {
                    this.fullSc = 'portlet light bordered portlet-fullscreen';
                }
            },
            // chartData(dates, label, color) {
            //     var ctx_chashe = document.getElementById("cashe_chart");
            //     casheChart.chart = new Chart(ctx_chashe, {
            //         type: 'bar',
            //         data: {
            //             labels: label,
            //             datasets: [{
            //                 backgroundColor: color,
            //                 data: dates,
            //                 borderWidth: 2
            //             }],
            //         },
            //         options: {
            //             legend: {
            //                 display: false,
            //                 position: 'right',
            //                 align: 'center',
            //             },
            //             elements: {
            //                 rectangle: {
            //                     borderWidth: 2,
            //                     borderColor: 'rgb(0, 255, 0)',
            //                     borderSkipped: 'bottom'
            //                 }
            //             },
            //             responsive: true,
            //             title: {
            //                 display: true,
            //                 text: '@lang("menu.Account")',
            //             }
            //         }
            //     });
            // }

            chartData(morningRates, nightRates, labels, colorMorning, colorNight) {
                var ctx_chashe = document.getElementById("cashe_chart").getContext('2d');

                // Ensure previous chart instance is destroyed if exists
                if (casheChart && casheChart.chart) {
                    casheChart.chart.destroy();
                }

                // Create a new chart
                casheChart.chart = new Chart(ctx_chashe, {
                    type: 'bar',
                    data: {
                        labels: labels,  // Labels for the x-axis
                        datasets: [
                            {
                                label: "@lang('layout.ChangeRateProfit')",  // Label for the first dataset
                                data: morningRates,  // Morning data
                                borderColor: 'rgb(255, 127, 80)',
                                borderWidth: 1,
                                type: 'line',
                                tension: 0
                            },
                            {
                                label: "@lang('layout.NetProfit')",  // Label for the second dataset
                                data: nightRates,  // Night data
                                fill: false,
                                borderColor: 'rgb(75, 192, 192)',
                                tension: 0.5,
                                borderWidth: 2,
                                type: 'line',
                            },
                            {
                                label: "@lang('layout.ChangeRateProfit')",  // Label for the first dataset
                                data: morningRates,  // Morning data
                                backgroundColor: 'rgb(255 127 80)',  // Color for morning bars
                                borderColor: 'rgb(75, 192, 192)',
                                borderWidth: 1,
                            },
                            {
                                label: "@lang('layout.NetProfit')",  // Label for the second dataset
                                data: nightRates,  // Night data
                                fill: false,
                                tension: 0,
                                backgroundColor: 'rgb(135, 206, 250)',  // Color for night bars
                            }
                        ],
                    },
                    options: {
                        legend: {
                            display: true,  // Display the legend to differentiate between Morning and Night
                            position: 'right',
                            align: 'center',
                        },
                        elements: {
                            rectangle: {
                                borderWidth: 2,
                                // borderColor: 'rgb(0, 255, 0)',
                                borderSkipped: 'bottom'
                            }
                        },
                        responsive: true,
                        title: {
                            display: true,
                            text: '@lang("menu.Account")',  // Chart title
                        },
                        scales: {
                            x: {
                                // To create space between bars
                                stacked: false,  // Make sure bars are not stacked
                                barPercentage: 0.35,  // Controls the width of the bars
                                categoryPercentage: 0.5,  // Controls the spacing between groups
                            },
                            y: {
                                stacked: false  // Make sure bars are not stacked
                            }
                        }
                    }
                });
            }


        }
    });

    //--------------------------------------------------------
    //              End cashe                      
    //--------------------------------------------------------//


    //--------------------------------------------------------
    //              Print Function   Chart                     
    //--------------------------------------------------------//
    function printChart(chartId) {
        id = chartId;

        var canvas = document.getElementById(id);
        var win = window.open(canvas.toDataURL(), '_blank', 'toolbar=yse,scrollbars=yes,resizable=yes');
        // var win = window.open(canvas.toDataURL(),'_blank');

        win.document.write("<br><img onclick = 'window.print()' src='" + canvas.toDataURL() + "'/>");

        // 'today_income_and_expense_chart','chart'
    }

    //--------------------------------------------------------
    //           End   Print Function   Chart                     
    //--------------------------------------------------------// 

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload();
            }
        }
    });
</script>



@endpush