@extends('layouts.factor-master')


@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('menu.Cheque')</h3>
<table class="main-table">
    <tr>
        <th> @lang('layout.Number')</th>
        <th> @lang('layout.ChequeNumber')</th>
        <th> @lang('layout.Type')</th>
        <th> @lang('layout.Sender')</th>
        <th> @lang('layout.IDNumber')</th>
        <th> @lang('layout.Reciever')</th>
        <th> @lang('layout.IDNumber')</th>
    </tr>
    <tr>
        <th class=""> {{ $cheque->number}} </th>
        <th class=""> {{ $cheque->ref_no}} </th>
        <th class=""> {{ __('type.' . $cheque->type)}} </th>
        <th class=""> {{ $cheque->sender}} </th>
        <th class=""> {{ $cheque->sen_ssn_number}} </th>
        <th class=""> {{ $cheque->reciever}} </th>
        <th class=""> {{ $cheque->rec_ssn_number}} </th>
    </tr>
</table>
<table class="main-table" style="margin-top: 15px;">
    <tr>
        <th> @lang('layout.Account')</th>
        <th> @lang('layout.Currency')</th>
        <th> @lang('layout.Rate')</th>
        <th> @lang('layout.Amount')</th>
        <th>@lang('layout.Description')</th>
    </tr>
    <tr>
        <th class=""> {{ $cheque->Account}} </th>
        <th class=""> {{ $cheque->currency}} </th>
        <th class=""> {{ myRound($cheque->rate)}} </th>
        <th class=""><b> {{ myRound($cheque->amount)}} </b> </th>
        <th align="center">
            <?php
            $des = wordwrap($cheque->description, 60, "<br/>\n", false);
            echo $des;
            ?>
        </th>
    </tr>
</table>

<table class="main-table" style="margin-top: 15px;">
    <thead>
        <tr>
            <th width="25%"> @lang('layout.Commission') </th>
            <th width="35%"> @lang('layout.Date') </th>
            <th width="40%">@lang('layout.MohrAndSignature')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <th>{{myRound($cheque->commission_amount)}} {{$cheque->commission_currency}}</th>
            <th>{{convertDate($cheque->date)}} ----- {{$cheque->date}}</th>
            <th style="height: 40px"></th>
        </tr>
    </tbody>
</table>




@if(company()['exchange_message'])
<table width="100%">
    <tr>
        <th style="font-size: 14px;">{!!company()['exchange_message']!!}</th>
    </tr>

    <tr>
        <th></th>
        <th></th>
    </tr>


</table>
@endif
@endsection