@extends('layouts.app')

@section('content')

<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ExchangeBrokerDetails')
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
             
            @permission(['exchangeBroker-create'])
            <a href="{{route('exchangeBrokerRow.edit', ['id' => $exchangeBroker->id])}}" class="hidden-print">
                <button class="btn btn-success">
                    <i class="fa fa-plus"></i> @lang('layout.AddNew')
                </button>
            </a>
            @endpermission
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center">@lang('layout.Number')</th>
                        <th class="text-center">@lang('layout.Vendor')</th>
                        <th class="text-center">@lang('layout.Amount')</th>
                        <th class="text-center">@lang('layout.Rate')</th>
                        <th class="text-center">@lang('layout.ExchangedCurrency')</th>
                        <th class="text-center">@lang('layout.Rate')</th>
                        <th class="text-center">@lang('layout.Type')</th>
                        <th class="text-center">@lang('layout.Date')</th>
                        <th class="text-center">@lang('layout.DueDate')</th>
                        @if(systemConfig()[29] == 1)
                        <th class="text-center">@lang('layout.TransactionConfirm')</th>
                        @endif
                        <th class="text-center">@lang('layout.MonetarySource')</th>
                        <th class="text-center">@lang('layout.TransactionType')</th>
                        <th class="text-center">@lang('layout.User')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ $exchangeBroker->number}} </td>
                        <td class="text-center"> {{ $exchangeBroker->Member}} </td>
                        <td class="text-center"> {{ myRound($exchangeBroker->amount)}} {{ $exchangeBroker->currency}} </td>
                        <td class="text-center"> {{myRound($exchangeBroker->rate)}} </td>
                        <td class="text-center"> {{ $exchangeBroker->ex_currency}} </td>
                        <td class="text-center"> {{myRound($exchangeBroker->ex_rate)}} </td>
                        <td class="text-center"> {{ __('type.'.$exchangeBroker->type) }} </td>
                        <td class="text-center"> {{ $exchangeBroker->date }} </td>
                        <td class="text-center"> {{ $exchangeBroker->due_date }} </td>
                        @if(systemConfig()[29] == 1)
                            @if($exchangeBroker->transaction_confirm)
                            <td class="text-center">
                                @lang('layout.yes')
                            </td>
                            @else
                            <td class="text-center">
                              
                            </td>
                            @endif  
                            @endif  
                        <td class="text-center"> {{$exchangeBroker->monetary_source}} </td>
                        <td class="text-center"> {{$exchangeBroker->trans_type}} </td>
                        <td class="text-center"> {{$exchangeBroker->username}} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center">@lang('layout.Received')</th>
                        <th class="text-center">@lang('layout.Remain')</th>
                        @if($exchangeBroker->type == 'Commission')
                        <th class="text-center">@lang('layout.Account')</th> 
                        <th class="text-center">@lang('layout.Amount') @lang('layout.Commission')</th>
                        @endif
                        @if($exchangeBroker->type == 'Exchange')
                        <th class="text-center">@lang('layout.Income')</th> 
                        @endif
                        <th class="text-center">@lang('layout.Description')</th> 
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ myRound($rec_amount)}} {{ $exchangeBroker->currency}} </td>
                        <td class="text-center"> {{ myRound($exchangeBroker->amount - $rec_amount)}} {{ $exchangeBroker->currency}} </td>
                        @if($exchangeBroker->type == 'Commission')
                        <td class="text-center"> {{ $exchangeBroker->account}} </td>
                        <td class="text-center"> {{ myRound($exchangeBroker->commission_amount)}} {{ $exchangeBroker->commission_currency}} </td>
                        @endif
                        @if($exchangeBroker->type == 'Exchange')
                        <td class="text-center"> {{ myRound($income_amount)}} {{ $exchangeBroker->currency}} </td>
                        @endif
                        <td class="text-center"> {{$exchangeBroker->description}} </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class=" hidden-print">
    <div class="tabbable tabbable-tabdrop">

        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.CustomerDetails')</a>
            </li>
            <li class="">
                <a href="#tab3" data-toggle="tab" id="tab_cheque">@lang('layout.ExchangeCheque')</a>
            </li>
            <li class="">
                <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab1">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.CustomerDetails')</span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerDetails"/>
                                    <input type="hidden" name="report_format" value="excel"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}} 

                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerDetails"/>
                                    <input type="hidden" name="report_format" value="pdf"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i>  @lang('layout.PDF')</button>
                                    {{Form::close()}}  
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="exchangeBroker">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Customer') </th>
                                        <th>@lang('layout.Amount') </th>
                                        <th>@lang('layout.Currency') </th>
                                        <th>@lang('layout.Rate') </th>
                                        <th>@lang('layout.PayAmount') </th>
                                        <th>@lang('layout.Remain') </th>
                                        <th>@lang('layout.Description') </th>
                                        <th>@lang('layout.Action') </th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>
            <div class="tab-pane" id="tab3">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ExchangeCheque')</span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerCheque"/>
                                    <input type="hidden" name="report_format" value="excel"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}} 

                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerCheque"/>
                                    <input type="hidden" name="report_format" value="pdf"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i>  @lang('layout.PDF')</button>
                                    {{Form::close()}}  
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="exchangeBrokerCheque">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Customer') </th>
                                        <th>@lang('layout.Vendor') </th>
                                        <th>@lang('layout.CardOwner') </th>
                                        <th>@lang('layout.CardNumber') </th>
                                        <th>@lang('layout.TrackingNumber') </th>
                                        <th>@lang('layout.ShabaNumber') </th>
                                        <th>@lang('layout.Amount') </th>
                                        <th>@lang('layout.Currency') </th>
                                        <th>@lang('layout.Rate') </th>
                                        <th>@lang('layout.Exchange') @lang('layout.Amount') </th>
                                        <th>@lang('layout.ExchangedCurrency') </th>
                                        <th>@lang('layout.ExchangedRate') </th>
                                        <th>@lang('layout.Date') </th>
                                        <th>@lang('layout.Description') </th>
                                        <th>@lang('layout.Action') </th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>
            <div class="tab-pane" id="tab2">
                <div class="">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                <div class="portlet-body">
                                    <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="redirect_route" value="exchangeBroker.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$exchangeBroker->id}}">
                                        <input type="hidden" name="path" value="uploads/exchange_broker">
                                        <input type="hidden" name="table_name" value="exchange_brokers">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" rows="8" class="form-control" style="resize: none;"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                        <div>
                                                            <span class="btn default btn-file">
                                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>
                                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                            <img src="" alt=""> </div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 165px; line-height: 10px;"> </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-center">
                                            <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.AttachmentTitle')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

@endsection

@push('scripts')

<script>
    $(document).ready(function() {

        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#exchangeBroker').DataTable({
           ajax:{
                url:'{{route("exchangeBroker.show",$exchangeBroker->id)}}',
                data:{type:'customerDetail'}
            },
              
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns:[
                { data: 'Member', name: 'Member' },
                { data: 'amount', name: 'amount' },
                { data: 'currency', name: 'currency' },
                { data: 'rate', name: 'rate' },
                { data: 'rec_amount', name: 'rec_amount' },
                { data: 'remain_amount', name: 'remain_amount' },
                { data: 'description', name: 'description' },
                { data: 'action', name: 'action',orderable:false,searchable:false }
        ]

        });

        $('#tab_cheque').on('shown.bs.tab', function(event){
            $('#exchangeBrokerCheque').DataTable({
            ajax:{
                    url:'{{route("exchangeBroker.show",$exchangeBroker->id)}}',
                    data:{type:'exchangeBrokerCheque'}
                },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                columns:[
                    { data: 'Member', name: 'Member' },
                    { data: 'ToMember', name: 'ToMember' },
                    { data: 'card_owner', name: 'card_owner' },
                    { data: 'card_number', name: 'card_number' },
                    { data: 'tracking_number', name: 'tracking_number' },
                    { data: 'shaba_number', name: 'shaba_number' },
                    { data: 'from_pay_amount', name: 'from_pay_amount' },
                    { data: 'from_pay_currency', name: 'from_pay_currency' },
                    { data: 'from_pay_rate', name: 'from_pay_rate' },
                    { data: 'to_pay_amount', name: 'to_pay_amount' },
                    { data: 'to_pay_currency', name: 'to_pay_currency' },
                    { data: 'to_pay_rate', name: 'to_pay_rate' },
                    { data: 'date', name: 'date' },
                    { data: 'description', name: 'description' },
                    { data: 'action', name: 'action',orderable:false,searchable:false }
                ]

            });
        });

        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("exchangeBroker.show",$exchangeBroker->id)}}',
                data: {
                    type: 'attachment'
                }
            },

            scrollCollapse: true,
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                {
                    data: 'title',
                    name: 'attachments.title'
                },
                {
                    data: 'description',
                    name: 'attachments.description'
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ]
        });



    });
</script>
@endpush