@extends('layouts.app')
@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    /* tr th {
        text-align: center;
    } */
    hr {
        border-top: 1px solid #b1adad;
    }
</style>
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allExchangeBrokerReports'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member"> </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.SelectClass')</label>
                                            <v-select class="vue-select2"
                                                      v-model="selected_class"
                                                      label="name"
                                                      :options="member_class">
                                            </v-select>
                                            <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.TransactionType') </label>
                                            <select class="form-control" name="transaction_type" >
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="Commission">@lang('layout.Commission')</option>
                                                <option value="Exchange">@lang('layout.Exchange')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                            <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                        </div>
                                        @if(systemConfig()[29] == 1)
                                        <div class="col-md-1">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="exchangeBroker_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>

                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->

        </div>

    </report-modal>
</div>

<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ExchangeBrokerList') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">
                <span onclick="getRecord();" class="btn blue">
                    <i class="fa fa-refresh"></i>
                </span>
                @permission(['exchangeBroker-export'])
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                @endpermission
                
                @permission(['exchangeBroker-create'])
                <a href="{{route('exchangeBroker.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission

            </div>
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
        </div>
        <div class="portlet-body">
            <!-- start list -->
            <table class="table table-striped table-bordered table-hover" id="exchangeBroker" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th width="1%">@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.ExchangedCurrency')</th>
                        <th>@lang('layout.Received')</th>
                        <th>@lang('layout.Remain')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Amount') @lang('layout.Commission')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.DueDate')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th> 
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>
    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component("v-select", VueSelect.VueSelect);

    function printVoucher(id,sendWhatsapp = null) {
        var a = document.createElement('a');
        a.href = "{{url('chequePrintVoucher')}}/" + id + "/" + sendWhatsapp;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    function sendVoucherToWhatsapp(id,sendWhatsapp) {
        var a = document.createElement('a');
        a.href = "{{url('chequePrintVoucher')}}/" + id + "/" + sendWhatsapp;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    /**
     * we load approperiat datable according
     * to it's site_id
     */
    var my_table = 0;
    $(document).ready(function() {
        getRecord();
    });

    function getRecord() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        if (my_table != 0) {
            my_table.destroy();
        }
        my_table = $('#exchangeBroker').DataTable({
            ajax: '{{route("exchangeBroker.index")}}',
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:12}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            destroy: true,
            paging: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [
                {
                    data: 'number',
                    name: 'exchange_brokers.number'
                },
                {
                    data: 'Member',
                    name: 'members.name'
                },
                {
                    data: 'amount',
                    name: 'bank_tran.amount'
                },
                {
                    data: 'currency',
                    name: 'exchange_brokers.currency'
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'ex_currency',
                    name: 'exchange_brokers.ex_currency'
                },
                {
                    data: 'rec_amount',
                    name: 'rec_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'remain_amount',
                    name: 'remain_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'commission_amount',
                    name: 'commission_amount',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Date',
                    name: 'date',
                    searchable: false
                },
                {
                    data: 'dueDate',
                    name: 'dueDate',
                    searchable: false
                },
                {
                    data: 'username',
                    name: 'users.name'
                },
                {
                    data: 'description',
                    name: 'exchange_brokers.description'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    }


    // for new modal
    var cust_rep = {!!customeReportNewData('exchangeBroker_index') !!};

    var currency2 ={!! $currency!!}
    var member_class  = {!!json_encode($member_class)!!}

    var vu = new Vue({
        el: '#print-modal',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_show: false,
            pdfRoute: '{!!route("exchangeBroker.report") !!}',
            excelRoute: '{!! route("exchangeBroker.report") !!}',
            selectedMember: null,
            currency: currency2,
            selectedCurrency: null,
            member: [],
            selected_class:null,
            member_class:member_class,
            customReportData: [
                {
                    Name: '@lang("layout.Type")',
                    column_name: 'type',
                    checkedColumn: (cust_rep.type) ? 'checked' : '',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''
                },
                {
                    Name: '@lang("layout.Description")',
                    column_name: 'description',
                    checkedColumn: (cust_rep.description) ? 'checked' : '',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''
                },
                {
                    Name: '@lang("layout.Date")',
                    column_name: 'date',
                    checkedColumn: (cust_rep.date) ? 'checked' : '',
                    column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''
                },
                {
                    Name: '@lang("layout.Member")',
                    column_name: 'member',
                    checkedColumn: (cust_rep.member) ? 'checked' : '',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amount',
                    checkedColumn: (cust_rep.amount) ? 'checked' : '',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''
                },
                {
                    Name: '@lang("layout.Rate")',
                    column_name: 'rate',
                    checkedColumn: (cust_rep.rate) ? 'checked' : '',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''
                },
                {
                    Name: '@lang("layout.Total")',
                    column_name: 'total',
                    checkedColumn: (cust_rep.total) ? 'checked' : '',
                    column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedCurrency")',
                    column_name: 'exchangedCurrency',
                    checkedColumn: (cust_rep.exchangedCurrency) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedCurrency___percent)?cust_rep.exchangedCurrency___percent:''
                },
                {
                    Name: '@lang("layout.Received")',
                    column_name: 'received',
                    checkedColumn: (cust_rep.received) ? 'checked' : '',
                    column_percentage:(cust_rep.received___percent)?cust_rep.received___percent:''
                },
                {
                    Name: '@lang("layout.Commission")',
                    column_name: 'commission',
                    checkedColumn: (cust_rep.commission) ? 'checked' : '',
                    column_percentage:(cust_rep.commission___percent)?cust_rep.commission___percent:''
                },
                {
                    Name: '@lang("layout.DueDate")',
                    column_name: 'dueDate',
                    checkedColumn: (cust_rep.dueDate) ? 'checked' : '',
                    column_percentage:(cust_rep.dueDate___percent)?cust_rep.dueDate___percent:''
                },
                {
                    Name: '@lang("layout.Remain")',
                    column_name: 'remain',
                    checkedColumn: (cust_rep.remain) ? 'checked' : '',
                    column_percentage:(cust_rep.remain___percent)?cust_rep.remain___percent:''
                },
                {
                    Name: '@lang("layout.TransactionConfirm")',
                    column_name: 'transaction_confirm',
                    checkedColumn: (cust_rep.transaction_confirm) ? 'checked' : '',
                    column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''
                },
                {
                    Name: '@lang("layout.MonetarySource")',
                    column_name: 'monetary_source',
                    checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                    column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {
                    Name: '@lang("layout.TransactionType")',
                    column_name: 'trans_type',
                    checkedColumn: (cust_rep.trans_type) ? 'checked' : '',
                    column_percentage:(cust_rep.trans_type___percent)?cust_rep.trans_type___percent:''
                },
                {
                    Name: '@lang("layout.Income")',
                    column_name: 'income',
                    checkedColumn: (cust_rep.income) ? 'checked' : '',
                    column_percentage:(cust_rep.income___percent)?cust_rep.income___percent:''
                },
                {
                    Name: '@lang("layout.User")',
                    column_name: 'user',
                    checkedColumn: (cust_rep.user) ? 'checked' : '',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'brokerCurrency',
                    checkedColumn: (cust_rep.brokerCurrency) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerCurrency___percent)?cust_rep.brokerCurrency___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'brokerAmount',
                    checkedColumn: (cust_rep.brokerAmount) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerAmount___percent)?cust_rep.brokerAmount___percent:''
                },
                {
                    Name: '@lang("layout.Received")',
                    column_name: 'brokerReceived',
                    checkedColumn: (cust_rep.brokerReceived) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerReceived___percent)?cust_rep.brokerReceived___percent:''
                },
                {
                    Name: '@lang("layout.Remained")',
                    column_name: 'brokerRemained',
                    checkedColumn: (cust_rep.brokerRemained) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerRemained___percent)?cust_rep.brokerRemained___percent:''
                },
                {
                    Name: '@lang("layout.Income")',
                    column_name: 'brokerIncomAll',
                    checkedColumn: (cust_rep.brokerIncomAll) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerIncomAll___percent)?cust_rep.brokerIncomAll___percent:''
                },
                {
                    Name: '@lang("layout.Commission")',
                    column_name: 'brokerCommissionAll',
                    checkedColumn: (cust_rep.brokerCommissionAll) ? 'checked' : '',
                    column_percentage:(cust_rep.brokerCommissionAll___percent)?cust_rep.brokerCommissionAll___percent:''
                },
            ],
            cust_rep: cust_rep
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },

            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vu.member = [];
                        vu.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vu.getDate(vu.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vu.from_date = null;
                    vu.to_date = null;
                    if (response.data) {
                        vu.from_date = response.data.start;
                        vu.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vu.period = 'CustomDates';
                    vu.from_date = null;
                    vu.to_date = null;
                    })
                } else {
                    vu.from_date = null;
                    vu.to_date = null;
                }
                }
            },
        }
    });


    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.show_create = true;

            }
        }
    });

    // /for new modal

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });

</script>


@endpush