{{-- @extends('layouts.app')
@section('style')
<style type="text/css">
    .setting_menu li.active a,
    .ver-inline-menu li.active i {
        background-color: #d4d7dc !important;
        color: #393a3d !important;
    }
    .ver-inline-menu li a {
        background: #eceef1 !important;
        border-left: solid 2px #eceef1;
        color: #393a3d !important;
    }
    .ver-inline-menu li i {
        background: #eceef1 !important;
    }
    .t_head {
        background-color: #eceef1 !important;
    }
    .t_body {
        background-color: #eceef1 !important;
    }
    .report_a_title{
        color: #393a3d;
    }
    a.report_a_title:hover{
        color: #393a3d;
        text-decoration: none;
    }
    .table-advance {
        text-align: center !important;
    }
    .container{
        margin-top: -5px;
        width: 100%;
        background-color: #f3f5f9;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }
    .content{
        transition: max-height 0.3s ease-out;
    }
    .toggle-button{
        position: absolute;
        text-align: center;
        cursor: pointer;
        font-size: 24px;
        margin-top: 10px;
    }
    #icon{
        font-size: 20px;
        background-color: #f3f5f9;
        padding: 7px;
    }
    .content.collapsed{
        max-height: 0;
        overflow:hidden; 
    }
    .content.expanded{
        max-height: 200px;
    }
    .shake-container{
        display: inline-block;
    }
    .shake{
        display: block;
    }
    .topBtn{
        background-color: #2ca317; 
        color: white;
        transition: 1s;
    }
    .topBtn:hover{
        background-color: transparent;
        border: 1px solid #2ca317;
        color:#2ca317; 
        transition: 1s;
    }
    .titleBtn:hover{
        text-decoration: none;
    }
    .titleBtn:focus{
        text-decoration: none;
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="container" >
    <div class="content">
        <div style="display: flex;justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <h3>@lang('menu.Transactions')</h3>
            <div >
                <div class="btn-group">
                    @permission('purchase-create')
                    <a href="{{route('purchase.create')}}" type="button" class="btn topBtn">@lang('layout.AddNew')</a>
                    <button type="button" class="btn topBtn dropdown-toggle" data-toggle="dropdown" id="dropdownButton">
                        <span class="caret"></span>
                    </button>
                    @endpermission
                    <ul class="dropdown-menu dropdown-menu-right" role="menu">
                        @permission('loan-create')
                        <li>
                            <a href="{{route('loan.index')}}">@lang('menu.DepositAndWithdrawal')</a>
                        </li>
                        @endpermission
                        @permission('cheque-create')
                        <li>
                            <a href="{{route('cheque.index')}}">@lang('layout.Cheque')</a>
                        </li>
                        @endpermission
                        @permission('currencyExchange-create')
                        <li>
                            <a href="{{route('currencyExchange.index')}}">@lang('menu.CurrencyExchange')</a>
                        </li>
                        @endpermission
                        @permission('exchangeBroker-create')
                        <li>
                            <a href="{{route('exchangeBroker.create')}}">@lang('menu.ExchangeBroker')</a>
                        </li>
                        @endpermission
                        @permission('transferAccounts-create')
                        <li>
                            <a href="{{route('transferAccounts.create')}}">@lang('menu.TransferAccount')</a>
                        </li>
                        @endpermission
                        @permission('memberTransfer-create')
                        <li>
                            <a href="{{route('memberTransfer.create')}}">@lang('menu.MemberTransfer')</a>
                        </li>
                        @endpermission
                        @permission('memberExchange-create')
                        <li>
                            <a href="{{route('memberExchange.create')}}">@lang('menu.MemberExchange')</a>
                        </li>
                        @endpermission
                    </ul>
                </div>
                <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
            </div>
        </div>
        <div style="display: flex;justify-content: center; width: 100%;margin-top: 10px !important;flex-wrap: wrap;">
            @permission('loan-list')
            <div style="width: 19%;background-color: #7ccc04;margin: 0px 10px 10px 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap; padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('loan.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important; color: white;">@lang('menu.DepositAndWithdrawal')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;"><span>(@lang('layout.Deposit'))</span> {{myRound($getAllLoans)}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;"><span>(@lang('layout.Withdrawal'))</span> {{myRound($payAllLoans)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('loan.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-cc-mastercard"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('cheque-list')
            <div style="width: 19%;background-color: #b6babf;margin: 0px 0px 10px 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap; padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('cheque.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.Cheque')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Receive')) {{$chequeReceive}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Send')) {{$chequeSend}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('cheque.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-credit-card"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @if(systemConfig()[4] != 0 )
            @permission('currencyExchange-list')
            <div style="width: 19%;background-color: #fb8001;margin: 0px 0px 10px 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap; padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('currencyExchange.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.CurrencyExchange')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.SaleCurrency')) {{myround($buyCurrency)}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.BuyCurrency')) {{myround($saleCurrency)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('currencyExchange.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-exchange"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @endif
            @permission('exchangeBroker-list')
            <div style="width: 19%;background-color: #0175c0;margin: 0px 0px 10px 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('exchangeBroker.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.ExchangeBroker')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$exchangeBrokers}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('exchangeBroker.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('transferAccounts-list')
            <div style="width: 19%;background-color: #1fa7f2;margin: 0px 0px 10px 10px;color: white;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('transferAccounts.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: white;">@lang('menu.TransferAccount')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                           
                            <p style="padding: 0px !important; margin: 0px !important;">{{myRound($transferAccounts)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('transferAccounts.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: white;" class="fa fa-money"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('memberTransfer-list')
            <div style="width: 19%;background-color: rgba(251, 239, 91, 1);margin: 0px 10px 10px 10px;color: black;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('memberTransfer.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: black;">@lang('menu.MemberTransfer')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($memberTransfer)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('memberTransfer.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: black;" class="fa fa-send-o"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
            @permission('memberExchange-list')
            <div style="width: 19%;background-color: rgba(163, 209, 118, 1);margin: 0px 0px 10px 10px;color: black;padding: 0px !important;">
                <div style="display: flex;justify-content: space-between;flex-wrap: wrap;padding: 0px !important;">
                    <div style="padding: 0px 10px;">
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <a href="{{route('memberExchange.index')}}" class="titleBtn"><p style="padding: 0px !important; margin: 0px !important;color: black;">@lang('menu.MemberExchange')</p></a>
                        </div>
                        <div style="padding: 0px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$memberExchange}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                    <div>
                        <a href="{{route('memberExchange.index')}}"><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: black;" class="fa fa-exchange"></i></a>
                    </div>
                </div>
            </div>
            @endpermission
        </div>
    </div>
    <div class="toggle-button" onclick="toggleContent()">
        <i id="icon" class="fa fa-chevron-up"></i>
    </div>
</div>
<div class="container1" style="margin-top: 3em;padding: 10px;border-radius: 8px;box-shadow: 0px 0px 5px #d7d7d7;">
    <div style="display: flex;justify-content: space-between;flex-wrap: wrap;">
        <div style="width: 100%;" class="shake-container">
            <img src="{{asset('menu_img/SaleImages/6.PNG')}}" style="width: 100%;height: 60vh;border-radius: 8px;" alt="Image" class="shake">
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush --}}

@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.Transactions')</h3>
                <div >
                    <div class="btn-group">
                        @permission('purchase-create')
                        <a href="{{route('purchase.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn btn-success dropdown-toggle" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @permission('loan-create')
                            <li>
                                <a href="{{route('loan.index')}}">@lang('menu.DepositAndWithdrawal')</a>
                            </li>
                            @endpermission
                            @permission('cheque-create')
                            <li>
                                <a href="{{route('cheque.index')}}">@lang('layout.Cheque')</a>
                            </li>
                            @endpermission
                            @if(systemConfig()[4] != 0 )
                            @permission('currencyExchange-create')
                            <li>
                                <a href="{{route('currencyExchange.index')}}">@lang('menu.CurrencyExchange')</a>
                            </li>
                            @endpermission
                            @endif
                            @permission('exchangeBroker-create')
                            <li>
                                <a href="{{route('exchangeBroker.create')}}">@lang('menu.ExchangeBroker')</a>
                            </li>
                            @endpermission
                            @permission('transferAccounts-create')
                            <li>
                                <a href="{{route('transferAccounts.create')}}">@lang('menu.TransferAccount')</a>
                            </li>
                            @endpermission
                            @permission('memberTransfer-create')
                            <li>
                                <a href="{{route('memberTransfer.create')}}">@lang('menu.MemberTransfer')</a>
                            </li>
                            @endpermission
                            @permission('memberExchange-create')
                            <li>
                                <a href="{{route('memberExchange.create')}}">@lang('menu.MemberExchange')</a>
                            </li>
                            @endpermission
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('loan-list')
                <a href="{{route('loan.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.DepositAndWithdrawal')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-cc-mastercard"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;"><span>(@lang('layout.Deposit'))</span> {{myRound($getAllLoans)}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;"><span>(@lang('layout.Withdrawal'))</span> {{myRound($payAllLoans)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('cheque-list')
                <a href="{{route('cheque.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                            <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                                <div style="padding: 0px !important; margin: 0px !important;">
                                    <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Cheque')</p></div>
                                </div>
                                <div>
                                    <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-credit-card"></i></div>
                                </div>
                            </div>
                            <div style="padding: 0px 5px !important; margin: 0px !important;">
                                <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Receive')) {{$chequeReceive}} {{getHomeCurrency()['code']}}</p>
                                <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.Send')) {{$chequeSend}} {{getHomeCurrency()['code']}}</p>
                            </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[4] != 0 )
                @permission('currencyExchange-list')
                <a href="{{route('currencyExchange.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.CurrencyExchange')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.SaleCurrency')) {{myround($buyCurrency)}} {{getHomeCurrency()['code']}}</p>
                            <p style="padding: 0px !important; margin: 0px !important;">(@lang('layout.BuyCurrency')) {{myround($saleCurrency)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @permission('exchangeBroker-list')
                <a href="{{route('exchangeBroker.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ExchangeBroker')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$exchangeBrokers}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('transferAccounts-list')
                <a href="{{route('transferAccounts.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.TransferAccount')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myRound($transferAccounts)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('memberTransfer-list')
                <a href="{{route('memberTransfer.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.MemberTransfer')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(251, 239, 91, 1);" class="fa fa-send-o"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($memberTransfer)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('memberExchange-list')
                <a href="{{route('memberExchange.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding: 5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.MemberExchange')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(163, 209, 118, 1);" class="fa fa-exchange"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$memberExchange}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush