@extends('layouts.app')
@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    /* tr th {
        text-align: center;
    } */
    hr {
        border-top: 1px solid #b1adad;
    }
</style>
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ExchangeBrokerEdit') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">
            </div>
        </div>
        <div class="portlet-body">
            <!-- BEGIN FORM-->
            {!! Form::model($exchangeBroker, ['method' => 'PATCH','class'=>'form-horizontal', 'id'=>'exchangeBroker-form', 'route' => ['exchangeBrokerRow.update',$exchangeBroker->id]]) !!}
            {{ csrf_field() }}
            <div class="form-body  col-md-12" id="app" v-cloak>
                <div class="row" style="margin-bottom: 20px; padding-bottom: 20px;">
                    <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12">
                                <div class="col-lg-2">
                                    <label class="control-label ">@lang('layout.Vendor')</label>
                                    <!-- <div class="input-group"> -->
                                        <v-select class="vue-select2" v-model="selectedMember" disabled label="name" :options="member" @search="MemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                        <!-- <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div> -->
                                </div>
                                <div class="col-lg-2">
                                    <label class="control-label ">@lang('layout.Vendor')</label>
                                    <!-- <div class="input-group"> -->
                                        <v-select class="vue-select2" v-model="selectedMember" disabled label="name" :options="member" @search="MemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                        <!-- <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                    </div> -->
                                </div>
                                <div class="col-lg-2">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" readonly value="{{$exchangeBroker->number}}">
                                    <input type="hidden" name="detail_id" value="{{$detail_id}}">
                                </div>
                                <div class="col-lg-2">
                                    <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                    <input type="text" class="form-control" readonly value="{{ __('layout.'.$exchangeBroker->type)}}">
                                    <!-- <input type="hidden" name="type" value="{{$exchangeBroker->type}}"> -->
                                </div>
                                <div class="col-lg-2" style="padding: 0px !important;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" :options="currency" disabled @Click.native="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" readonly>
                                            <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2">
                                    <label class="control-label">@lang('layout.Amount') <span class="text-danger">( @{{amount_to_word}} )</span></label>
                                    <!-- <div class="input-group"> -->
                                    <input type="number" name="amount" class="form-control" v-model="amount" step="any" min="0" readonly data-vv-as="@lang('layout.Amount')">
                                    <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span> -->
                                    <!-- </div> -->
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" id="getdate" class="form-control date" autocomplete="off" name="date" readonly value="{{$exchangeBroker->date}}">
                                </div>
                                <div style="padding: 0px !important;" v-show="exchangeBrokerType == 'Commission'">
                                    <div class="col-lg-2">
                                        <label class="control-label">@lang('layout.Commission')</label>
                                        <div class="input-group">
                                            <input type="number" name="commiss_amount" value="{{$exchangeBroker->commission_amount}}" class="form-control">
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="select_commiss_currency" v-model="commiss_currency">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <label class="control-label">@lang('layout.Type') @lang('layout.Commission')</label>
                                        <select class="form-control" name="commission_type" v-model="commission_type">
                                            <option value="Cash">@lang('layout.Cash')</option>
                                            <option value="ReceivableAccount">@lang('layout.ReceivableAccount')</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-2" v-if="commiss_currency"  style="padding: 0px !important;">
                                        <div :class="comcurrency_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency2" label="code" :options="currency" @Click.native="setCommSize(selectedCurrency2.code)"> </v-select>
                                            <input type="hidden" name="commiss_currency" v-bind:value="(selectedCurrency2)?selectedCurrency2.code:null" />
                                        </div>
                                        <div :class="comrate_len" v-show="selectedCurrency2.code != code">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <input v-model="selected_rate2" class="form-control" type="number" step="any" min="0">
                                            <input type="hidden" name="commiss_rate" :value="selected_rate2">
                                        </div>
                                    </div>
                                    <div class="col-lg-2" v-if="commiss_currency && commission_type == 'Cash'" >
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id" v-model="defaultAccount1">
                                            <option v-for="Account in accountUpdateComm" :value="Account.id">@{{ Account.name }}</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-2" v-if="!commiss_currency && commission_type == 'Cash'" >
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-lg-2">
                                        <label class="control-label">@lang('layout.Income')</label>
                                        <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                        </v-select>
                                        <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                                    </div>
                                </div>
                            </div>
                        </div>    
                    </div>
                </div>
                <!-- begin brokerDetail -->
                <div class="row">
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Customer')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Rate')</th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                <th class="text-center"><i class="fa fa-ellipsis-h"></i></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(record,index) in brokerDetail">
                                <td class="text-center" style="vertical-align: middle;">@{{index+1}}</td>
                                <td class="highlight text-center" style="vertical-align: middle;">
                                    <v-select label="name" v-model="record.selected" :options="temp_member_list" @search="MemberSearchRow" @click.native="addNew('brokerDetail',index)" placeholder="@lang('layout.Select')">
                                    </v-select>
                                    <input type="hidden" name="row_buyer_id[]" :value="(record.selected==null)?null:record.selected.id">
                                </td>
                                <td class="text-center" style="vertical-align: middle;">
                                    <input class="form-control" type="number" name="row_amount[]" v-model.number="record.amount" placeholder="@lang('layout.Amount')">
                                </td>
                                <td class="text-center" style="vertical-align: middle;">
                                    <v-select v-model="record.currency" label="code" disabled :options="currency" @click.native="setSizeRow(index)"> </v-select>
                                    <input type="hidden" name="row_currency[]" v-bind:value="(record.currency==null)?null:record.currency.code" />
                                </td>
                                <td class="text-center" style="vertical-align: middle;">
                                    <input v-model="record.rate" class="form-control" type="number" step="any" min="0" >
                                    <input type="hidden" name="row_rate[]" :value="record.rate">
                                </td>
                                <td class="text-center" style="vertical-align: middle;">
                                    <input class="form-control" type="text" name="row_description[]" v-model="record.description" placeholder="@lang('layout.Description')">
                                </td>
                                <td class="text-center" style="vertical-align: middle;">
                                    <span v-on:click="deleteItem('brokerDetail',index)"><i class="paddint-both glyphicon glyphicon-trash text-danger"></i></span>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <!-- end brokerDetail -->
                <div class="row" >
                    <div class="col-lg-12 text-center">
                        <button v-if="isError ==false" type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Update')</button>
                        <a href="{{route('exchangeBroker.show',$exchangeBroker->id)}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        <hr />
                    </div>
                </div>
                <cmodal :show='showModal' @close="showModal=false">
                </cmodal>
            </div>
            {!! Form::close() !!}

            <!-- END FORM-->
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')

<script>
    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component("v-select", VueSelect.VueSelect);

    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')

            }
        }
    });

    // /for new modal

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });

    //begin new member
    var cm = Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                vm.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },

                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        vm.selectedMember = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });


    var Banks = {!! $bank!!}
    var all_currency = {!! $currencies!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
    var Currency1 ={!! $currency!!}
    var exchangeBroker ={!! $exchangeBroker !!}
    var one = {!!json_encode(Currency()->getCurrency()) !!};
    var two = {!! json_encode(Currency()->getCurrency()) !!};
    var tree = {!! json_encode(Currency()->getCurrency()) !!};
    var code = '{!! getHomeCurrency()["code"] !!}';
    let rates ={!! $rates !!};
    let income = {!!$income!!};
    let company = {!!$company!!};
    let selectedBrokerDetail = {!!$selectedBrokerDetail!!};

    var vm = new Vue({
        el: '#app',
        data: {
            commission_type: 'Cash',
            exchangeBroker: exchangeBroker,
            all_currency: all_currency,
            company:company,
            selected_company:null,
            selectedCurrencyTemp: null,
            paymentCurrency: two,
            selectedCurrency2: tree,
            // currency1:{!! json_encode(getCurrencies()) !!},
            currency1: [],
            selected_rate: exchangeBroker.rate,
            selected_rate1: 1,
            selected_rate2: 1,
            exchange_amount: null,
            currency_len: 'col-md-12',
            rate_len: 'col-md-0',
            pcurrency_len: 'col-md-12',
            prate_len: 'col-md-0',
            comcurrency_len: 'col-md-12',
            comrate_len: 'col-md-0',
            first_currency: 0,
            second_currency: 0,
            lastAmount: null,
            description1: false,
            description2: false,
            code: code,
            selectedCurrency: one,
            currency: {!!json_encode(getCurrencies()) !!},
            bankes: {!!$banks!!},
            selectedBank: null,
            defaultValue: 0,
            defaultValue1: 0,
            defaultAmount: 0,
            defaultAccount: "{{ $exchangeBroker->account_id }}",
            defaultAccount1: "{{ $exchangeBroker->account_id }}",
            firstAccount: "{{ $exchangeBroker->account_id }}",
            firstAccount1: "{{ $exchangeBroker->account_id }}",
            temp_member_list: [],
            brokerDetail: [],
            amount: {{$exchangeBroker->amount}},
            amount_to_word: null,
            balance: 0,
            exchangeBrokerType: '{{$exchangeBroker->type}}',
            income: income,
            selectedIncome: null,
            listAccounts: [],
            currencyList: Currency,
            selectedMember: {!! $selectedMember !!}, 
            selectedSender: null,
            selectedReciever: null,
            disabled: false,
            type: 'bank',
            account: {},
            ref_no: '',
            msg: '',
            isError: false,
            showModal: false,
            sender: false,
            reciever: false,
            commiss_currency: false,
            summary: [],
            memberClass: memberClass,
            selected_class: null,
            member: [],
            simple_member: [],
            branch_type: false
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.firstAccount != -1) {
                            if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.firstAccount;
                                this.firstAccount = -1;
                                break;
                            }
                        }
                        else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;
                            break;
                        }
                    }

                }
                
                return test;
            },
            accountUpdateComm() {
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency2.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue1 = test[0].id;
                } else {
                    this.defaultValue1 = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.firstAccount1 != -1) {
                            if (this.bankes[x][z] == this.firstAccount1 && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.firstAccount1;
                                this.firstAccount1 = -1;
                                break;
                            }
                        } else if (this.bankes[x][z] == this.defaultValue1 && z == 'id') {
                            this.defaultAccount1 = this.defaultValue1;
                            break;
                        }
                    }

                }
                return test;
            },
            checkLoan() {
                var x = (this.exchangeBrokerType == 'Commission') ? true : false;
                return x;
            },

            subtotal: function() {
                var sum = 0;
                for (var i = 0; i < this.brokerDetail.length; i++) {
                    if (this.brokerDetail[i].amount != null && this.brokerDetail[i].amount) {
                        sum += (this.brokerDetail[i]['amount']);
                    }
                }
                return sum;
            },

        },
        mounted: function() {
            this.checkSelected();
            if (this.exchangeBroker) {
                @if($exchangeBroker->class_id)
                    this.selected_class = _.find(memberClass, (o) => o.id == {{$exchangeBroker->class_id}});
                @endif

                if (this.exchangeBroker.select_commiss_currency) {
                    if ("{{ $exchangeBroker->commission_currency }}" != this.code) {
                        this.comcurrency_len = 'col-md-6';
                        this.comrate_len = 'col-md-6';
                    }
                    @if($exchangeBroker->commiss_rate)
                        this.selected_rate2 = {{$exchangeBroker->commiss_rate}};
                    @endif
                    this.commiss_currency = true;
                }
                if (income && this.exchangeBroker.income_account_id) {
                    this.selectedIncome = _.find(income, (c) => c.id == this.exchangeBroker.income_account_id);
                } else {
                    if (income.length > 0) {
                        this.selectedIncome = income[0];
                    }
                }

                if (this.exchangeBroker.ex_currency) {
                    if ("{{ $exchangeBroker->ex_currency }}" != this.code) {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                    @if($exchangeBroker->ex_rate)
                        this.selected_rate1 = {{$exchangeBroker->ex_rate}};
                    @endif
                }

                if (this.exchangeBroker.commission_type) {
                    this.commission_type = this.exchangeBroker.commission_type;
                }
            }

            if ("{{ $exchangeBroker->currency }}" == this.code) {
                this.currency_len = 'col-md-12';
                this.rate_len = 'col-md-0';
            } else {
                this.currency_len = 'col-md-6';
                this.rate_len = 'col-md-6';
            }

            if(this.selected_rate > 0){
                this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
            }

            for (var i = 0; i < selectedBrokerDetail.length; i++) {
               var currency = one;
                for (var x in this.currency) {
                    for (z in this.currency[x]) {
                        if (this.currency[x][z] == selectedBrokerDetail[i].currency) {
                            currency = this.currency[x];
                        }
                    }
                }
                
                this.brokerDetail.push({amount: selectedBrokerDetail[i].amount, selected: selectedBrokerDetail[i].buyer, currency: currency, rate: selectedBrokerDetail[i].rate, description: selectedBrokerDetail[i].description});
            }
            var currency = one;
            var rate = 1;
            if (this.selectedCurrency) {
                currency = this.selectedCurrency;
                rate = this.selectedCurrency.exchange_rate;
            }
            if(selectedBrokerDetail.length == 0){
                this.brokerDetail.push({amount: null, selected: null, description: null, currency: currency, rate: rate});
            }

            // this.setSize(this.selectedCurrency.code)
            // this.setCommSize(this.selectedCurrency2.code)

            // console.log(123, this.currency);
            this.getTranslateToWord(this);
        },
        created() {
            this.setRates();
        },
        methods: {

            checkSelected() {
                var allCarrencies = {!! json_encode(getCurrencies()) !!};
                for (var x in allCarrencies) {
                    for (z in allCarrencies[x]) {
                        if (allCarrencies[x][z] == "{!! $exchangeBroker->currency !!}") {
                            if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                this.currency_len = 'col-md-6';
                                this.rate_len = 'col-md-6';
                            }
                            this.selectedCurrency = allCarrencies[x];
                        }
                        if (allCarrencies[x][z] == "{!! $exchangeBroker->commission_currency !!}") {
                            if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                this.currency_len = 'col-md-6';
                                this.rate_len = 'col-md-6';
                            }
                            this.selectedCurrency2 = allCarrencies[x];
                            // console.log(3223, this.selectedCurrency2);
                        }

                        if (allCarrencies[x][z] == "{!! $exchangeBroker->ex_currency !!}") {
                            if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                this.pcurrency_len = 'col-md-6';
                                this.prate_len = 'col-md-6';
                            }
                            this.paymentCurrency = allCarrencies[x];
                        }
                    }
                }

            },

            setRates() {

                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);

                Currency = [];
                Currency1 = [];

                c.forEach((a) => {

                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });

                c1.forEach((a) => {
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });


                    });
                });

                // for ensuring for each currency rate is defined

                c.forEach((a) => {

                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                c1.forEach((a) => {

                    let found = false;

                    Currency1.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }

                    });

                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                this.currency = Currency;
                this.currency1 = Currency1;


            },
            getSummary() {
                if (vm.selectedMember) {
                    var id = vm.selectedMember.id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            } else {
                                vm.summary = [];
                            }
                        })
                        .catch(function(error) {
                            vm.summary = [];
                            console.log(error);
                        });
                }
            },
            getTranslateToWord(vm = null) {
                if (!vm) {
                    vm = this;
                }
                vm.amount_to_word = null;
                if (vm.amount) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.amount_to_word = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },
            get_exchange() {
                if (vm.selected_rate > 0) {
                    vm.exchange_amount = myRound((vm.amount * vm.selected_rate1) / vm.selected_rate);
                }
            },
            set_rate() {
                if (vm.paymentCurrency.code == vm.code) {
                    if (vm.exchange_amount > 0 && vm.amount > 0) {
                        vm.selected_rate = myRound((vm.amount) / (vm.exchange_amount));
                    }
                } else {
                    if (vm.exchange_amount > 0) {
                        vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate));
                    }
                }
            },

            setSizeRow(index) {
                if (this.brokerDetail[index]) {
                    if (this.brokerDetail[index].currency) {
                        // console.log(2222, this.brokerDetail[index].currency);
                        this.brokerDetail[index].rate = this.brokerDetail[index].currency.exchange_rate;
                    }
                }
            },

            setSize(selected_code) {
                this.paymentCurrency = this.selectedCurrency;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;
                if (selected_code == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                } else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }
                this.pcurrency_len = this.currency_len;
                this.prate_len = this.rate_len;
            },
            setPaymentSize(selected_code) {
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;

                if (selected_code == this.code) {
                    this.pcurrency_len = 'col-md-12';
                    this.prate_len = 'col-md-0';
                } else {
                    this.pcurrency_len = 'col-md-6';
                    this.prate_len = 'col-md-6';
                }
            },
            setCommSize(selected_code) {
                this.selected_rate2 = this.selectedCurrency2.exchange_rate;
                if (selected_code == this.code) {
                    this.comcurrency_len = 'col-md-12';
                    this.comrate_len = 'col-md-0';
                } else {
                    this.comcurrency_len = 'col-md-6';
                    this.comrate_len = 'col-md-6';
                }
            },
            check_code(code) {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    this.selected_rate1 = this.selected_rate;
                }

            },

            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
    
            MemberSearchRow: _.debounce((search, loading) => {
                loading(true);
                // let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.temp_member_list = [];
                        vm.temp_member_list = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            SimpleMemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.simple_member = [];
                        vm.simple_member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
                if (ref_no != null) {



                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: vm.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'loans'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // vm.temp_items=response.data;
                                vm.msg = "@lang('layout.DuplicateData')";
                                vm.isError = true;
                            } else {
                                vm.msg = 'no';
                                vm.isError = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },



            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        vm.submitForm1();
                        // regForm(e.target);
                    }
                });
            },
            submitForm1() {
                vm.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("exchangeBroker-form").submit()
                    } else {
                        vm.disabled = false;
                    }
                });
            },
            
            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (selectedBrokerDetail.length == 0) {
                        if (type == 'brokerDetail') {
                            var currency = one;
                            var rate = 1;
                            if (this.selectedCurrency) {
                                currency = this.selectedCurrency;
                                rate = this.selectedCurrency.exchange_rate;
                            }
                            if (this.brokerDetail[index + 1] == undefined) {
                                this.temp_member_list=[];
                                this.brokerDetail.push({amount: null, selected: null, description: null, currency: currency, rate: rate});
                            }
                        }
                    }
                }
            },

            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'brokerDetail') {
                        this.brokerDetail.splice(index, 1);
                    }
                }
            },

            onComplete: function() {
                document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },

            clearData: function() {
                $('#loan-submit').trigger('reset');
                vm.exchangeBrokerType = 'Commission';
                vm.amount = null;
                vm.ref_no = null;
                vm.selectedMember = null;
                vm.selectedSender = null;
                vm.selectedReciever = null;
                vm.exchange_amount = null;
                vm.amount_to_word = null;
            },

            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            test(defaultAccount) {
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            break;
                        }
                    }

                }

            },
        }
    });
</script>


@endpush