@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('exchangeBroker_index');
$_type = !in_array('type', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_member = !in_array('member', $report);
$_amount = !in_array('amount', $report);
$_rate = !in_array('rate', $report);
$_total = !in_array('total', $report);
$_exchangedCurrency = !in_array('exchangedCurrency', $report);
$_received = !in_array('received', $report);
$_commission = !in_array('commission', $report);
$_dueDate = !in_array('dueDate', $report);
$_remain = !in_array('remain', $report);

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ExchangeBrokerReport')</h3>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
        <th>
            <div class="center">@lang('layout.Record') </div>
        </th>
        <th>@lang('layout.Customer') </th>
        <th>@lang('layout.Amount') </th>
        <th>@lang('layout.Rate') </th>
        <th>@lang('layout.PayAmount') </th>
        <th>@lang('layout.Remain') </th>
        <th>@lang('layout.Description') </th>
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_amount = 0;
  $total_rec_amount = 0;
  $currencyIn = [];
  $currencyOut = [];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
        $total_amount += $record->amount;

        if ($record->rec_amount > 0) {
        $total_rec_amount += $record->rec_amount;
        }

    ?>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->Member}}</td>
    <td class="center">{{myRound($record->amount)}} {{$record->currency}}</td>
    <td class="center">{{$record->rate}}</td>
    <td class="center">{{myRound($record->rec_amount)}} {{$record->currency}}</td>
    <td class="center">{{myRound($record->amount - $record->rec_amount)}} {{$record->currency}}</td>
    <td class="center">
      
      @if(isset($report_format))
      {{$record->description}}
      @else
      {!! wordwrap($record->description,40,"<br/>\n",false) !!}
      @endif

    </td>
  </tr>
  @endforeach
</table>

<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.Total')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Amount') : {{myRound($total_amount)}} </div>
    </td>
    <td>
      <div class="center"> @lang('layout.PayAmount') : {{myRound($total_rec_amount)}} </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Remain') : {{myRound($total_amount - $total_rec_amount)}} </div>
    </td>
  </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection