@extends('layouts.app')

@section('content')

<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ExchangeBrokerDetails')
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th class="text-center">@lang('layout.Vendor')</th>
                        <th class="text-center">@lang('layout.Amount')</th>
                        <th class="text-center">@lang('layout.Rate')</th>
                        <th class="text-center">@lang('layout.Received')</th>
                        <th class="text-center">@lang('layout.Remain')</th>
                        <th class="text-center">@lang('layout.Received')</th>
                        @if($exchangeBroker->type == 'Exchange')
                        <th class="text-center">@lang('layout.Income')</th>
                        @endif
                        <th class="text-center">@lang('layout.Type')</th>
                        <th class="text-center">@lang('layout.Description')</th>
                        <th class="text-center">@lang('layout.User')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center"> {{ $exchangeBroker->Member}} </td>
                        <td class="text-center"> {{ myRound($exchangeBroker->amount)}} {{ $exchangeBroker->currency}} </td>
                        <td class="text-center"> {{myRound($exchangeBroker->rate)}} </td>
                        <td class="text-center"> {{myRound($rec_amount)}} {{ $rec_currency}} </td>
                        <td class="text-center"> {{myRound($exchangeBroker->amount - $rec_amount)}} {{ $exchangeBroker->currency}} </td>
                        <td class="text-center"> {{myRound($pay_amount)}} {{ $pay_currency}} </td>
                        @if($exchangeBroker->type == 'Exchange')
                        <td class="text-center"> {{myRound($income_amount)}} {{ $rec_currency}} </td>
                        @endif
                        <td class="text-center"> {{ __('type.'.$exchangeBroker->type) }} </td>
                        <td class="text-center"> {{$exchangeBroker->description}} </td>
                        <td class="text-center"> {{$exchangeBroker->username}} </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class=" hidden-print">
    <div class="tabbable tabbable-tabdrop">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab3" data-toggle="tab" id="tab_cheque">@lang('layout.ExchangeCheque')</a>
            </li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="tab3">
                <div class="row">
                    <div class="col-md-12">
                        <!-- BEGIN EXAMPLE TABLE PORTLET-->
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.ExchangeCheque')</span>
                                </div>
                                <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerCheque"/>
                                    <input type="hidden" name="report_format" value="excel"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->exchange_broker_id}}"/> 
                                    <input type="hidden" name="detail_id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                    {{Form::close()}} 

                                    {{Form::open(['route' => 'exchangeBroker.report','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="exchangeBrokerCheque"/>
                                    <input type="hidden" name="report_format" value="pdf"/>
                                    <input type="hidden" name="id" value="{{$exchangeBroker->exchange_broker_id}}"/> 
                                    <input type="hidden" name="detail_id" value="{{$exchangeBroker->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i>  @lang('layout.PDF')</button>
                                    {{Form::close()}}  
                                </div>
                            </div>
                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="exchangeBrokerCheque">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Customer') </th>
                                        <th>@lang('layout.Vendor') </th>
                                        <th>@lang('layout.CardOwner') </th>
                                        <th>@lang('layout.CardNumber') </th>
                                        <th>@lang('layout.TrackingNumber') </th>
                                        <th>@lang('layout.ShabaNumber') </th>
                                        <th>@lang('layout.Amount') </th>
                                        <th>@lang('layout.Currency') </th>
                                        <th>@lang('layout.Rate') </th>
                                        <th>@lang('layout.Exchange') @lang('layout.Amount') </th>
                                        <th>@lang('layout.ExchangedCurrency') </th>
                                        <th>@lang('layout.ExchangedRate') </th>
                                        <th>@lang('layout.Date') </th>
                                        <th>@lang('layout.Description') </th>
                                        <th>@lang('layout.Action') </th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection

@push('scripts')

<script>
    $(document).ready(function() {

        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#exchangeBrokerCheque').DataTable({
            ajax:{
                    url:'{{route("exchangeBrokerCheques.show",$exchangeBroker->id)}}',
                    data:{type:'exchangeBrokerCheque'}
                },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                destroy: true,
                paging: true,
                buttons: [{
                        extend: 'excel',
                        text: '',
                        key: {
                            key: 'x',
                            altkey: true
                        }
                    }],
                columns:[
                    { data: 'Member', name: 'Member' },
                    { data: 'ToMember', name: 'ToMember' },
                    { data: 'card_owner', name: 'card_owner' },
                    { data: 'card_number', name: 'card_number' },
                    { data: 'tracking_number', name: 'tracking_number' },
                    { data: 'shaba_number', name: 'shaba_number' },
                    { data: 'from_pay_amount', name: 'from_pay_amount' },
                    { data: 'from_pay_currency', name: 'from_pay_currency' },
                    { data: 'from_pay_rate', name: 'from_pay_rate' },
                    { data: 'to_pay_amount', name: 'to_pay_amount' },
                    { data: 'to_pay_currency', name: 'to_pay_currency' },
                    { data: 'to_pay_rate', name: 'to_pay_rate' },
                    { data: 'date', name: 'date' },
                    { data: 'description', name: 'description' },
                    { data: 'action', name: 'action',orderable:false,searchable:false }
                ]

            });



    });
</script>
@endpush