@extends('layouts.app')

@section('content')

<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.ExchangeBrokerDetails')
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
        </div>
    </div>
    <div class="portlet-body">
        <div class="table-scrollable">
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>@lang('layout.Customer') </th>
                        <th>@lang('layout.CardOwner') </th>
                        <th>@lang('layout.CardNumber') </th>
                        <th>@lang('layout.TrackingNumber') </th>
                        <th>@lang('layout.ShabaNumber') </th>
                        <th>@lang('layout.Received')</th>
                        <th>@lang('layout.Rate') </th>
                        <th>@lang('layout.PayAmount') </th>
                        <th>@lang('layout.Rate') </th>
                        <th>@lang('layout.Type') </th>
                        <th>@lang('layout.Date') </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $exchangeBroker->ToMember}} </td>
                        <td class=""> {{ $exchangeBroker->card_owner}} </td>
                        <td class=""> {{ $exchangeBroker->card_number}} </td>
                        <td class=""> {{ $exchangeBroker->tracking_number}} </td>
                        <td class=""> {{ $exchangeBroker->shaba_number}} </td>
                        <td class=""> {{ myRound($exchangeBroker->to_pay_amount)}} {{ $exchangeBroker->to_pay_currency}} </td>
                        <td class=""> {{myRound($exchangeBroker->to_pay_rate)}} </td>
                        <td class=""> {{ myRound($exchangeBroker->to_rec_amount)}} {{ $exchangeBroker->to_rec_currency}} </td>
                        <td class=""> {{myRound($exchangeBroker->to_rec_rate)}} </td>
                        <td class=""> {{ __('type.'.$exchangeBroker->type) }} </td>
                        <td class=""> {{ ConvertDate($exchangeBroker->date) }} </td>
                    </tr>
                </tbody>
            </table>
            <table class="table table-striped table-bordered table-advance table-hover">
                <thead>
                    <tr>
                        <th>@lang('layout.Vendor') </th>
                        <th>@lang('layout.Received')</th>
                        <th>@lang('layout.Rate') </th>
                        <th>@lang('layout.PayAmount') </th>
                        <th>@lang('layout.Rate') </th>
                        @if($exchangeBroker->type == 'Exchange')
                        @if($exchangeBroker->ExpMember)
                        <th>@lang('layout.MemberStatement') </th>
                        @else
                        <th>@lang('layout.Income') </th>
                        @endif
                        <th>@lang('layout.Account') </th>
                        @if($exchangeBroker->ExpMember)
                        <th>@lang('layout.VendorForFine') </th>
                        @endif
                        @endif
                        <th>@lang('layout.Description') </th>
                        <th>@lang('layout.User') </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class=""> {{ $exchangeBroker->Member}} </td>
                        <td class=""> {{ myRound($exchangeBroker->from_pay_amount)}} {{ $exchangeBroker->from_pay_currency}} </td>
                        <td class=""> {{myRound($exchangeBroker->from_pay_rate)}} </td>

                        <td class=""> {{ myRound($exchangeBroker->from_rec_amount)}} {{ $exchangeBroker->from_rec_currency}} </td>
                        <td class=""> {{myRound($exchangeBroker->from_rec_rate)}} </td>
                        @if($exchangeBroker->type == 'Exchange')
                        <td class=""> {{ myRound($exchangeBroker->bank_tran_amount)}} {{ $exchangeBroker->bank_tran_currency}} </td>
                        <td class=""> {{ $exchangeBroker->bank }} </td>
                        @if($exchangeBroker->ExpMember)
                        <td class=""> {{ $exchangeBroker->ExpMember }} </td>
                        @endif
                        @endif
                        <td class=""> {{ $exchangeBroker->description }} </td>
                        <td class=""> {{$exchangeBroker->username}} </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>



@endsection

@push('scripts')

<script>

</script>
@endpush