@extends('layouts.app')

@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    /* tr th {
        text-align: center;
    } */
    hr {
        border-top: 1px solid #b1adad;
    }
</style>

<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light ">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>&nbsp;
                <span class="caption-subject bold uppercase">@lang('layout.ExchangeBrokerEdit') &nbsp; &nbsp; &nbsp; </span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">

            </div>
        </div>
        <div class="portlet-body">

            <!-- BEGIN FORM-->
            {!! Form::model($exchangeBroker, ['method' => 'PATCH','class'=>'form-horizontal', 'id'=>'exchangeBroker-form', 'route' => ['exchangeBrokerCheque.update',$exchangeBroker->id]]) !!}
            {{ csrf_field() }}
            <div class="form-body  col-md-12" id="app" v-cloak>
                <div class="row" >
                    <div class="col-md-12">
                        <br/>
                        <input type="hidden" name="exchange_broker_id" value="{{$exchangeBroker->exchange_broker_id}}" >
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label ">@lang('layout.Vendor')</label>
                                <h4>{{$exchangeBroker->Member}} </h4>
                                <input type="hidden" name="member_id" value="{{$exchangeBroker->from_member_id}}" >
                            </div>
                            <div class="col-md-2">
                                <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                <h4>{{$exchangeBroker->type}} </h4>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label ">@lang('layout.Customer')</label>
                                <h4>{{$exchangeBroker->ToMember}} </h4>
                                <input type="hidden" name="customer_id" value="{{$exchangeBroker->to_member_id}}" >
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="text" id="getdate" class="form-control date" autocomplete="off" value="{{$exchangeBroker->date}}" name="date" >
                            </div>
                            @if($exchangeBroker->type == 'Exchange')
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.Account')</label>
                                <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                    <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                    </option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.Income')</label>
                                <v-select class="vue-select2" v-model="selectedIncome" label="name" :options="income">
                                </v-select>
                                <input type="hidden" name="income_id" :value="(!selectedIncome)?null:selectedIncome.id" >
                            </div>
                            @endif
                        </div>
                    </div>
                        <div class="row">
                            <div class="col-md-4" style="padding: 0px !important;">
                                <div :class="currency_len">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <v-select v-model="selectedCurrency" label="code" :options="currency" disabled> </v-select>
                                    <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                </div>
                                <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <label class="control-label">@lang('layout.Rate') </label>
                                    <div :class="{'has-error':selectedCurrency.rate < 0}">
                                        <!-- <div class="input-group"> -->
                                        <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" @keyup="check_code(selectedCurrency.code), get_exchange()" @click="check_code(selectedCurrency.code), get_exchange()">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div> -->
                                        <input type="hidden" name="currency_rate" :value="selected_rate">
                                    </div>
                                </div>
                            </div>
                            @if($exchangeBroker->type == 'Exchange')
                            <div class="col-md-2">
                                <div v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <label class="control-label">@lang('layout.Default_Rate') </label>
                                    <div :class="{'has-error':selectedCurrency.rate < 0}">
                                        <!-- <div class="input-group"> -->
                                        <input v-model="selected_rate_ex_rate" class="form-control" type="number" step="any" min="0" @keyup="check_code(selectedCurrency.code), get_exchange()" @click="check_code(selectedCurrency.code), get_exchange()">
                                        <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div> -->
                                        <input type="hidden" name="currency_rate_ex" :value="selected_rate_ex_rate">
                                    </div>
                                </div>
                            </div>
                            @endif
                            <div class="col-md-3">
                                <label class="control-label">@lang('layout.Amount')</label>
                                <vue-numeric
                                    class="form-control"
                                    v-model="amount"
                                    :max="99999999999999"
                                    :currency="selectedCurrency.code"
                                    :precision="precision()"
                                    @input="get_exchange(), getTranslateToWord()"
                                    >
                                </vue-numeric>
                                <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                
                                <span class="required">@{{ errors.first('amount') }}</span>
                            </div>

                            <div class="col-md-3" v-if="amount_to_word" >
                                <label class="control-label">@lang('layout.TotalInLeters'):</label>
                                <span class="col-md-12">@{{amount_to_word}}</span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4" style="padding: 0px !important;">
                                <div :class="pcurrency_len">
                                    <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                    <v-select v-model="paymentCurrency" label="code" :options="currency1"  disabled > </v-select>
                                    <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                </div>
                                <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                    <label class="control-label">@lang('layout.Rate') </label>
                                    <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                        <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()">
                                        <input type="hidden" name="rate" :value="selected_rate1">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                <vue-numeric
                                    class="form-control"
                                    v-model="exchange_amount"
                                    :max="99999999999999"
                                    :currency="paymentCurrency.code"
                                    :precision="precision()"
                                    @input="set_rate()"
                                    >
                                </vue-numeric>
                                <input type="hidden" name="exchange_amount" v-model="exchange_amount" class="form-control" min="0" step="any">
                            </div>
                            @if($exchangeBroker->type == 'Exchange')
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <input type="number" readonly name="from_exchange_amount" :value="final_exchange_amount" class="form-control" min="0" step="any">
                            </div>
                            <div class="col-md-4">
                                <label class="control-label ">@lang('layout.VendorForFine')</label>
                                <!-- <div class="input-group"> -->
                                    <v-select class="vue-select2" v-model="selectedMember1" label="name" :options="member" @search="MemberSearch" >
                                    </v-select>
                                    <input type="hidden" name="exp_member_id" :value="(!selectedMember1)?null:selectedMember1.id" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>

                                    <!-- <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span> 
                                </div> -->
                            </div>
                            @endif
                            
                        </div>
                        <div class="row">
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.CardOwner')</label>
                                {!! Form::text('card_owner', null, array('placeholder' => __('layout.CardOwner'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.CardNumber')</label>
                                {!! Form::text('card_number', null, array('placeholder' => __('layout.CardNumber'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.ShabaNumber')</label>
                                {!! Form::text('shaba_number', null, array('placeholder' => __('layout.ShabaNumber'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-2">
                                <label class="control-label">@lang('layout.TrackingNumber')</label>
                                {!! Form::text('tracking_number', null, array('placeholder' => __('layout.TrackingNumber'),'class' => 'form-control')) !!}
                            </div>
                            <div class="col-md-4">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2)) !!}
                            </div>
                        </div>
                        
                    <div class="col-md-8">
                    </div>
                    
                    <div class="col-md-4">
                        <div class="row">
                            <div class="dashboard-stat2" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                <table class="dashboard-tabel table-bordered" width="100%">
                                    <thead>
                                        <tr>
                                            <th colspan="3" ><center>@lang('layout.Vendor')</center></th>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                            <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                            <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <span>
                                            <tr v-for="summ in summary">
                                                <td>
                                                    @{{ summ.currency }}
                                                </td>
                                                <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                <td>
                                                    @{{format_number(Number(summ.invoice)) }}
                                                </td>
                                            </tr>
                                        </span>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="dashboard-stat2" v-if="selectedBuyer" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                <table class="dashboard-tabel table-bordered" width="100%">
                                    <thead>
                                        <tr>
                                            <th colspan="3" ><center>@lang('layout.Customer')</center></th>
                                        </tr>
                                        <tr>
                                            <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                            <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                            <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <span>
                                            <tr v-for="summ in summary1">
                                                <td>
                                                    @{{ summ.currency }}
                                                </td>
                                                <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                <td>
                                                    @{{format_number(Number(summ.invoice)) }}
                                                </td>
                                            </tr>
                                        </span>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row" >
                    <div class="col-md-8 text-center">
                        <br>
                        <button v-if="isError ==false" type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('exchangeBroker.show',$exchangeBroker->exchange_broker_id)}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        <hr />
                    </div>
                </div>
                <cmodal :show='showModal' @close="showModal=false">
                </cmodal>
            </div>
            {!! Form::close() !!}

            <!-- END FORM-->
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@push('scripts')

<script>
    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default);

    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')

            }
        }
    });

    // /for new modal

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });


    var Banks = {!! $bank!!}
    var all_currency = {!! $currencies!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
    var Currency1 ={!! $currency!!}
    var exchangeBroker ={!! $exchangeBroker !!}
    var one = {!!json_encode(getHomeCurrency()) !!};
    var two = {!! json_encode(getHomeCurrency()) !!};
    var tree = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()["code"] !!}';
    let rates ={!! $rates !!};
    let income = {!!$income!!};
    let company = {!!$company!!};

    var vm = new Vue({
        el: '#app',
        data: {
            exchangeBroker: exchangeBroker,
            all_currency: all_currency,
            company:company,
            selected_company:null,
            selectedCurrencyTemp: null,
            paymentCurrency: two,
            selectedCurrency2: tree,
            currency1: [],
            selected_rate_ex_rate: exchangeBroker.to_rec_rate,
            selected_rate: exchangeBroker.from_pay_rate,
            selected_rate1: 1,
            selected_rate2: 1,
            exchange_amount: null,
            currency_len: 'col-md-12',
            rate_len: 'col-md-0',
            pcurrency_len: 'col-md-12',
            prate_len: 'col-md-0',
            comcurrency_len: 'col-md-12',
            comrate_len: 'col-md-0',
            first_currency: 0,
            second_currency: 0,
            lastAmount: null,
            description1: false,
            description2: false,
            code: code,
            selectedCurrency: one,
            currency: {!!json_encode(getCurrencies()) !!},
            bankes: {!!$banks!!},
            selectedBank: null,
            defaultValue: 0,
            defaultValue1: 0,
            defaultAmount: 0,
            defaultAccount: "{{$exchangeBroker->bank_id}}",
            defaultAccount1: "",
            firstAccount: "",
            firstAccount1: "",
            temp_member_list: [],
            brokerDetail: [],
            amount: {{$exchangeBroker->amount}},
            amount_to_word: null,
            balance: 0,
            exchangeBrokerType: '{{$exchangeBroker->type}}',
            income: income,
            selectedIncome: null,
            listAccounts: [],
            currencyList: Currency,
            selectedMember: {{$exchangeBroker->from_member_id}}, 
            selectedBuyer: {{$exchangeBroker->to_member_id}}, 
            selectedMember1: null, 
            selectedSender: null,
            selectedReciever: null,
            disabled: false,
            type: 'bank',
            account: {},
            ref_no: '',
            msg: '',
            isError: false,
            showModal: false,
            sender: false,
            reciever: false,
            commiss_currency: false,
            summary: [],
            summary1: [],
            memberClass: memberClass,
            selected_class: null,
            member: [],
            simple_member: [],
            branch_type: false,
            final_exchange_amount : 0
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                }) 
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.firstAccount != -1) {
                            if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.firstAccount;
                                this.firstAccount = -1;
                                break;
                            }
                        }
                        else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;
                            break;
                        }
                    } 
                } 
                return test;
            },
            accountUpdateComm() {
                var b = _.clone(Banks)
                var test = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency2.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue1 = test[0].id;
                } else {
                    this.defaultValue1 = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.firstAccount1 != -1) {
                            if (this.bankes[x][z] == this.firstAccount1 && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.firstAccount1;
                                this.firstAccount1 = -1;
                                break;
                            }
                        } else if (this.bankes[x][z] == this.defaultValue1 && z == 'id') {
                            this.defaultAccount1 = this.defaultValue1;
                            break;
                        }
                    }

                }
                return test;
            },
            checkLoan() {
                var x = (this.exchangeBrokerType == 'Commission') ? true : false;
                return x;
            },

        },
        mounted: function() {
            this.checkSelected();
            if (this.exchangeBroker) {
                
                if (this.exchangeBroker.to_pay_currency) {
                    if ("{{ $exchangeBroker->to_pay_currency }}" != this.code) {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                    @if($exchangeBroker->to_pay_rate)
                        this.selected_rate1 = {{$exchangeBroker->to_pay_rate}};
                    @endif
                }

                if (income && this.exchangeBroker.income_id) {
                    this.selectedIncome = _.find(income, (c) => c.id == this.exchangeBroker.income_id);
                } else {
                    if (income.length > 0) {
                        this.selectedIncome = income[0];
                    }
                }

            }

            if ("{{ $exchangeBroker->from_pay_currency }}" == this.code) {
                this.currency_len = 'col-md-12';
                this.rate_len = 'col-md-0';
            } else {
                this.currency_len = 'col-md-6';
                this.rate_len = 'col-md-6';
            }

            @if($exchangeBroker->type == 'Exchange')
                if(this.selected_rate_ex_rate > 0){ 
                    // this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate_ex_rate);
                    @if(systemConfig()[30] == 1)
                    this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate_ex_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                    @else 
                    this.exchange_amount = myRound((this.amount * this.selected_rate1) / this.selected_rate_ex_rate);
                    @endif
                }
            @else
                if(this.selected_rate > 0){ 
                    @if(systemConfig()[30] == 1)
                    this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                    @else 
                    this.exchange_amount = myRound((this.amount * this.selected_rate1) / this.selected_rate);
                    @endif

                }
            @endif 

            @if($selectedExpMember)
                this.selectedMember1 = {!! $selectedExpMember !!};
            @endif


            // this.brokerDetail.push({amount: null, selected: null, description: null, currency: one, rate: 1});

            // this.setSize(this.selectedCurrency.code)
            // this.setCommSize(this.selectedCurrency2.code)

            // console.log(123, this.currency);
            this.getTranslateToWord(this);
            this.getSummary(this);
            this.getSummary1(this);

            @if(systemConfig()[30] == 1)
            this.final_exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
            @else 
            this.final_exchange_amount = myRound((this.amount / this.selected_rate) * this.selected_rate1);
            @endif
        },
        created() {
            this.setRates();
        },
        methods: {

                // "to_pay_currency" => "AFN"
                // "to_pay_rate" => 98.45

                // "from_pay_amount" => 10000000.0
                // "from_pay_currency" => "IRR"

            checkSelected() {
                var allCarrencies = {!! json_encode(getCurrencies()) !!};
                for (var x in allCarrencies) {
                    for (z in allCarrencies[x]) {
                        if (allCarrencies[x][z] == "{!! $exchangeBroker->from_pay_currency !!}") {
                            if (allCarrencies[x][z] != "getHomeCurrency()['code']") {
                                this.currency_len = 'col-md-6';
                                this.rate_len = 'col-md-6';
                            }
                            this.selectedCurrency = allCarrencies[x];
                        }

                        if (allCarrencies[x][z] == "{!! $exchangeBroker->to_pay_currency !!}") {
                            if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                this.pcurrency_len = 'col-md-6';
                                this.prate_len = 'col-md-6';
                            }
                            this.paymentCurrency = allCarrencies[x];
                        }
                    }
                }

            },

            setRates() {

                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);

                Currency = [];
                Currency1 = [];

                c.forEach((a) => {

                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });

                c1.forEach((a) => {
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });


                    });
                });

                // for ensuring for each currency rate is defined

                c.forEach((a) => {

                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                c1.forEach((a) => {

                    let found = false;

                    Currency1.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }

                    });

                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                this.currency = Currency;
                this.currency1 = Currency1;


            },
            getSummary(vm) {
                if (vm.selectedMember) {
                    var id = vm.selectedMember;
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.summary = response.data;
                        } else {
                            vm.summary = [];
                        }
                    })
                    .catch(function(error) {
                        vm.summary = [];
                        console.log(error);
                    });
                }
            },
            getSummary1(vm) {
                if (vm.selectedBuyer) {
                    var id = vm.selectedBuyer;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary1 = response.data;
                            } else {
                                vm.summary1 = [];
                            }
                        })
                        .catch(function(error) {
                            vm.summary1 = [];
                            console.log(error);
                        });
                }
            },
            getTranslateToWord(vm = null) {
                if (!vm) {
                    vm = this;
                }
                vm.amount_to_word = null;
                if (vm.amount) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.amount_to_word = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },
            get_exchange() {
                let vm = this;
                // console.log('rate get_exchange',vm.selected_rate1);
                @if($exchangeBroker->type == 'Exchange')
                    if(vm.selected_rate_ex_rate > 0){ 
                        // @if(systemConfig()[30] == 1)
                        // vm.exchange_amount = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate_ex_rate) * vm.paymentCurrency.static_rate) / vm.selected_rate1);
                        // console.log('type Exchange' , vm.exchange_amount);
                        // @else 
                        // vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate_ex_rate);
                        // @endif 
                        @if(systemConfig()[30] == 1)
                        // console.log(vm.selected_rate1);
                        vm.exchange_amount = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate_ex_rate) * vm.paymentCurrency.static_rate) / vm.selected_rate1);
                        @else 
                        vm.exchange_amount = myRound((vm.amount * vm.selected_rate1) / vm.selected_rate_ex_rate);
                        @endif
                    }
                @else
                    if (vm.selected_rate > 0) {
                        @if(systemConfig()[30] == 1)
                        // console.log(vm.selected_rate1);
                        vm.exchange_amount = myRound(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) * vm.paymentCurrency.static_rate) / vm.selected_rate1);
                        @else 
                        vm.exchange_amount = myRound((vm.amount * vm.selected_rate1) / vm.selected_rate);
                        @endif
                    }
                @endif
            },
            set_rate() {
                let vm = this;
                if (vm.paymentCurrency.code == vm.code) {
                    @if($exchangeBroker->type == 'Exchange')
                        if (vm.exchange_amount > 0 && vm.amount > 0) {
                            // @if(systemConfig()[30] == 1)
                            // vm.selected_rate_ex_rate = myRound((vm.exchange_amount / vm.amount) * vm.selectedCurrency.static_rate);
                            // @else 
                            // vm.selected_rate_ex_rate = myRound((vm.amount) / (vm.exchange_amount));
                            // @endif

                            @if(systemConfig()[30] == 1)
                            vm.selected_rate = myRound((vm.exchange_amount / vm.amount) * vm.selectedCurrency.static_rate); 
                            @else 
                            vm.selected_rate = myRound((vm.amount) / (vm.exchange_amount));
                            @endif
                        }
                    @else
                        if (vm.exchange_amount > 0 && vm.amount > 0) {
                            @if(systemConfig()[30] == 1)
                            vm.selected_rate = myRound((vm.exchange_amount / vm.amount) * vm.selectedCurrency.static_rate); 
                            @else 
                            vm.selected_rate = myRound((vm.amount) / (vm.exchange_amount));
                            @endif
                        }
                    @endif
                } else {
                    @if($exchangeBroker->type == 'Exchange')
                        if (vm.exchange_amount > 0) {
                            // @if(systemConfig()[30] == 1)
                            // vm.selected_rate1 = myRound(((vm.amount /  vm.selectedCurrency.static_rate * vm.selected_rate_ex_rate) / vm.exchange_amount) * vm.paymentCurrency.exchange_rate);
                            // @else 
                            // vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate_ex_rate));
                            // @endif
                      
                            @if(systemConfig()[30] == 1)
                            // vm.selected_rate1 = myRound(((vm.amount / vm.selected_rate * vm.selectedCurrency.static_rate) / vm.exchange_amount) * vm.paymentCurrency.exchange_rate);
                            vm.selected_rate1 = Number.parseFloat(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate_ex_rate) / vm.exchange_amount) * vm.paymentCurrency.static_rate).toFixed(7);
                            @else 
                            vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate_ex_rate));
                            @endif
                      
                        }
                        @else
                        if (vm.exchange_amount > 0) {
                            @if(systemConfig()[30] == 1)
                            // vm.selected_rate1 = myRound(((vm.amount / vm.selected_rate * vm.selectedCurrency.static_rate) / vm.exchange_amount) * vm.paymentCurrency.exchange_rate);
                            vm.selected_rate1 = Number.parseFloat(((vm.amount / vm.selectedCurrency.static_rate * vm.selected_rate) / vm.exchange_amount) * vm.paymentCurrency.static_rate).toFixed(7);
                            @else 
                            vm.selected_rate1 = myRound((vm.exchange_amount) / (vm.amount / vm.selected_rate));
                            @endif
                        }
                    @endif
                }
            },


            setSizeRow(index) {
                if (this.brokerDetail[index]) {
                    if (this.brokerDetail[index].currency) {
                        // console.log(2222, this.brokerDetail[index].currency);
                        this.brokerDetail[index].rate = this.brokerDetail[index].currency.exchange_rate;
                    }
                }
            },

            setSize(selected_code) {
                this.paymentCurrency = this.selectedCurrency;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;

              

                if (selected_code == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                } else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }
                this.pcurrency_len = this.currency_len;
                this.prate_len = this.rate_len;
            },
            setPaymentSize(selected_code) {
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;
                if (selected_code == this.code) {
                    this.pcurrency_len = 'col-md-12';
                    this.prate_len = 'col-md-0';
                } else {
                    this.pcurrency_len = 'col-md-6';
                    this.prate_len = 'col-md-6';
                }
            },
            setCommSize(selected_code) {
                this.selected_rate2 = this.selectedCurrency2.exchange_rate;
                if (selected_code == this.code) {
                    this.comcurrency_len = 'col-md-12';
                    this.comrate_len = 'col-md-0';
                } else {
                    this.comcurrency_len = 'col-md-6';
                    this.comrate_len = 'col-md-6';
                }
            },
            check_code(code) {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    this.selected_rate1 = this.selected_rate;
                } 
            },

            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),
    
            MemberSearchRow: _.debounce((search, loading) => {
                loading(true);
                // let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.temp_member_list = [];
                        vm.temp_member_list = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            SimpleMemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.simple_member = [];
                        vm.simple_member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
                if (ref_no != null) {



                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: vm.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'loans'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // vm.temp_items=response.data;
                                vm.msg = "@lang('layout.DuplicateData')";
                                vm.isError = true;
                            } else {
                                vm.msg = 'no';
                                vm.isError = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },



            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        vm.submitForm1();
                        // regForm(e.target);
                    }
                });
            },
            submitForm1() {
                vm.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("exchangeBroker-form").submit()
                    } else {
                        vm.disabled = false;
                    }
                });
            },
            
            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'brokerDetail') {
                        if (this.brokerDetail[index + 1] == undefined) {
                            this.temp_member_list=[];
                            this.brokerDetail.push({amount: null, selected: null, description: null, currency: one, rate: 1});
                        }
                    }
                }
            },


            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'brokerDetail') {
                        this.brokerDetail.splice(index, 1);
                    }
                }
            },

            onComplete: function() {
                document.getElementById("account-form").submit()
                //                this.$emit('on-complete')
                //                alert('Yay. Done!');
            },

            clearData: function() {
                $('#loan-submit').trigger('reset');
                vm.exchangeBrokerType = 'Commission';
                vm.amount = null;
                vm.ref_no = null;
                vm.selectedMember = null;
                vm.selectedSender = null;
                vm.selectedReciever = null;
                vm.exchange_amount = null;
                vm.amount_to_word = null;
            },

            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            test(defaultAccount) {
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            break;
                        }
                    }

                }

            },
        }
    });
</script>


@endpush