@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('exchangeBroker_index');
$_type = !in_array('type', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_member = !in_array('member', $report);
$_amount = !in_array('amount', $report);
$_rate = !in_array('rate', $report);
$_total = !in_array('total', $report);
$_exchangedCurrency = !in_array('exchangedCurrency', $report);
$_received = !in_array('received', $report);
$_commission = !in_array('commission', $report);
$_dueDate = !in_array('dueDate', $report);
$_remain = !in_array('remain', $report);

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ExchangeBrokerReport')</h3>
@if($exchangeBroker)
<br/>
<table class="main-table">
    <thead>
        <tr>
            <th>@lang('layout.Vendor')</th>
            <th>@lang('layout.Amount')</th>
            <th>@lang('layout.Rate')</th>
            <th>@lang('layout.Received')</th>
            <th>@lang('layout.Remain')</th>
            <th>@lang('layout.Received')</th>
            @if($exchangeBroker->type == 'Exchange')
            <th>@lang('layout.Income')</th>
            @endif
            <th>@lang('layout.Type')</th>
            <th>@lang('layout.Description')</th>
            <th>@lang('layout.User')</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td class=""> {{ $exchangeBroker->Member}} </td>
            <td class=""> {{ myRound($exchangeBroker->amount)}} {{ $exchangeBroker->currency}} </td>
            <td class=""> {{myRound($exchangeBroker->rate)}} </td>
            <td class=""> {{myRound($rec_amount)}} {{ $rec_currency}} </td>
            <td class=""> {{myRound($exchangeBroker->amount - $rec_amount)}} {{ $exchangeBroker->currency}} </td>
            <td class=""> {{myRound($pay_amount)}} {{ $pay_currency}} </td>
            @if($exchangeBroker->type == 'Exchange')
            <td class=""> {{myRound($income_amount)}} {{ $rec_currency}} </td>
            @endif
            <td class=""> {{ __('type.'.$exchangeBroker->type) }} </td>
            <td class=""> {{$exchangeBroker->description}} </td>
            <td class=""> {{$exchangeBroker->username}} </td>
        </tr>
    </tbody>    
</table>
@endif
<br/>

<table class="main-table">

  <thead>
    <tr class="bg">
        <th>
            <div class="center"> @lang('layout.Record') </div>
        </th>
        <th>@lang('layout.Customer') </th>
        <th>@lang('layout.Vendor') </th>
        <th>@lang('layout.CardOwner') </th>
        <th>@lang('layout.CardNumber') </th>
        <th>@lang('layout.TrackingNumber') </th>
        <th>@lang('layout.ShabaNumber') </th>
        <th>@lang('layout.Amount') </th>
        <th>@lang('layout.Rate') </th>
        <th>@lang('layout.Exchange') @lang('layout.Amount') </th>
        <th>@lang('layout.ExchangedRate') </th>
        <th>@lang('layout.Date') </th>
        <th>@lang('layout.Description') </th>
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_amount = 0;
  $total_rec_amount = 0;
  $currencyIn = [];
  $currencyOut = [];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
        if ($record->from_pay_amount > 0) {
        $total_amount += $record->from_pay_amount;
        }
        if ($record->to_pay_amount > 0) {
        $total_rec_amount += $record->to_pay_amount;
        }
    ?>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->Member}}</td>
    <td class="center">{{$record->ToMember}}</td>
    <td class="center">{{$record->card_owner}}</td>
    <td class="center">{{$record->card_number}}</td>
    <td class="center">{{$record->tracking_number}}</td>
    <td class="center">{{$record->shaba_number}}</td>
    <td class="center">{{myRound($record->from_pay_amount)}} {{$record->from_pay_currency}}</td>
    <td class="center">{{myRound($record->from_pay_rate)}}</td>
    <td class="center">{{myRound($record->to_pay_amount)}} {{$record->to_pay_currency}}</td>
    <td class="center">{{myRound($record->to_pay_rate)}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">
    <?php
      $des = wordwrap($record->description, 40, "<br/>\n", false);
      echo $des;
    ?>
    </td>
  </tr>
  @endforeach
</table>

<table class="main-table">
  <tr class="bg">
    <td colspan="2">
      <div class="center">@lang('layout.Total')</div>
    </td>
  </tr>
  <tr>
    <td>
      <div class="center"> @lang('layout.Amount') : {{myRound($total_amount)}} </div>
    </td>
    <td>
      <div class="center"> @lang('layout.Exchange') @lang('layout.Amount') : {{myRound($total_rec_amount)}} </div>
    </td>
  </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection