@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('exchangeBroker_index');
$_type = !in_array('type', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);
$_member = !in_array('member', $report);
$_amount = !in_array('amount', $report);
$_rate = !in_array('rate', $report);
$_total = !in_array('total', $report);
$_exchangedCurrency = !in_array('exchangedCurrency', $report);
$_received = !in_array('received', $report);
$_commission = !in_array('commission', $report);
$_dueDate = !in_array('dueDate', $report);
$_remain = !in_array('remain', $report);
$_transaction_confirm = !in_array('transaction_confirm', $report);
$_trans_type= !in_array('trans_type', $report);
$_monetary_source= !in_array('monetary_source', $report);
$_income= !in_array('income', $report);
$_user= !in_array('user', $report);
$_brokerCurrency= !in_array('brokerCurrency', $report);
$_brokerAmount= !in_array('brokerAmount', $report);
$_brokerReceived= !in_array('brokerReceived', $report);
$_brokerRemained= !in_array('brokerRemained', $report);
$_brokerIncomAll= !in_array('brokerIncomAll', $report);
$_brokerCommissionAll= !in_array('brokerCommissionAll', $report);



$report_percent = customeReportNewPercent('exchangeBroker_index');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_dueDate_percent= (array_key_exists('dueDate___percent', $report_percent))?$report_percent['dueDate___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_exchangedCurrency_percent= (array_key_exists('exchangedCurrency___percent', $report_percent))?$report_percent['exchangedCurrency___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_received_percent= (array_key_exists('received___percent', $report_percent))?$report_percent['received___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_commission_percent= (array_key_exists('commission___percent', $report_percent))?$report_percent['commission___percent']:null;
    $_remain_percent= (array_key_exists('remain___percent', $report_percent))?$report_percent['remain___percent']:null;
    $_transaction_confirm_percent= (array_key_exists('transaction_confirm___percent', $report_percent))?$report_percent['transaction_confirm___percent']:null;
    $_monetary_source_percent= (array_key_exists('monetary_source___percent', $report_percent))?$report_percent['monetary_source___percent']:null;
    $_trans_type_percent= (array_key_exists('trans_type___percent', $report_percent))?$report_percent['trans_type___percent']:null;
    $_income_percent= (array_key_exists('income___percent', $report_percent))?$report_percent['income___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_brokerCurrency_percent= (array_key_exists('brokerCurrency___percent', $report_percent))?$report_percent['brokerCurrency___percent']:null;
    $_brokerAmount_percent= (array_key_exists('brokerAmount___percent', $report_percent))?$report_percent['brokerAmount___percent']:null;
    $_brokerReceived_percent= (array_key_exists('brokerReceived___percent', $report_percent))?$report_percent['brokerReceived___percent']:null;
    $_brokerRemained_percent= (array_key_exists('brokerRemained___percent', $report_percent))?$report_percent['brokerRemained___percent']:null;
    $_brokerIncomAll_percent= (array_key_exists('brokerIncomAll___percent', $report_percent))?$report_percent['brokerIncomAll___percent']:null;
    $_brokerCommissionAll_percent= (array_key_exists('brokerCommissionAll___percent', $report_percent))?$report_percent['brokerCommissionAll___percent']:null;

// dd($_dueDate_percent);

?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.ExchangeBrokerReport')</h3>
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
  </tr>
</table>

@if($member_name || $transaction_type || $currency || $member_class_name || $transaction_confirm)
<table class="main-table" style="margin: 6px 0px;" >
    <tr>
      @if($transaction_type)
      <td>
        <span>@lang('layout.Type')</span>: {{__('layout.'.ucfirst($transaction_type))}}
      </td>
      @endif
      @if($currency)
      <td>
        <span>@lang('layout.Currency')</span>: {{$currency}}
      </td>
      @endif

      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif      
      @if($member_name)
      <td>
        <span>@lang('layout.Name')</span>: {{$member_name}}
      </td>
      @endif

      @if($transaction_confirm)
      <td>
        <span>@lang('layout.TransactionConfirm')</span>:    @lang('layout.yes')
      </td>
      @endif 

 
    </tr>
</table>
@endif

<br>
<table class="main-table">

  <thead>
    <tr class="bg">
      <td class="center">
        <div >@lang('layout.Record')</div>
      </td>
      <td class="center">
        <div >@lang('layout.Number')</div>
      </td>
      @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif>
        <div > @lang('layout.Date')</div>
      </td>
      @endif
  @if($_description)<td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>
        <div > @lang('layout.Description')</div>
      </td>@endif
      @if(!$member_name)
      @if($_member)<td class="center" @if($_member_percent) width="{{$_member_percent}}%" @endif>
        <div > @lang('layout.Member') </div>
      </td>@endif
      @endif
      @if($_amount)<td class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif>
        <div > @lang('layout.Amount')</div>
      </td>@endif
      
      @if($_rate)
      <td class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif>
        <div > @lang('layout.Rate')</div>
      </td>
      @endif
      @if(!$currency)
      @if($_exchangedCurrency)
      <td class="center" @if($_exchangedCurrency_percent) width="{{$_exchangedCurrency_percent}}%" @endif>
        <div > @lang('layout.ExchangedCurrency')</div>
      </td>
      @endif
      @endif
      @if($_received)
      <td class="center" @if($_received_percent) width="{{$_received_percent}}%" @endif>
        <div > @lang('layout.Received')</div>
      </td>
      @endif
      @if($_remain)
      <td class="center" @if($_remain_percent) width="{{$_remain_percent}}%" @endif>
        <div > @lang('layout.Remain')</div>
      </td>
      @endif
      @if(!$transaction_type)  @if($_type)<td class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif>
        <div > @lang('layout.Type')</div>
      </td>@endif @endif
      @if($_commission)
      <td class="center" @if($_commission_percent) width="{{$_commission_percent}}%" @endif>
        <div >@lang('layout.Amount') @lang('layout.Commission')</div>
      </td>
      @endif
      @if($_income)
      <td class="center" @if($_income_percent) width="{{$_income_percent}}%" @endif>
        <div >@lang('layout.Income')</div>
      </td>
      @endif
      
      @if($_dueDate)
      <td class="center" @if($_dueDate_percent) width="{{$_dueDate_percent}}%" @endif>
        <div > @lang('layout.DueDate')</div>
      </td>
      @endif
      @if(systemConfig()[29] == 1)
      @if(!$transaction_confirm)
      @if($_transaction_confirm)
      <td  class="center" @if($_transaction_confirm_percent) width="{{$_transaction_confirm_percent}}%" @endif>
        <div > @lang('layout.TransactionConfirm')</div>
      </td>
      @endif
      @endif
      @endif
      @if($_monetary_source) <td class="center"  @if($_monetary_source_percent) width="{{$_monetary_source_percent}}%" @endif><div > @lang('layout.MonetarySource')</div></td> @endif
      @if($_trans_type) <td class="center"  @if($_trans_type_percent) width="{{$_trans_type_percent}}%" @endif><div > @lang('layout.TransactionType')</div></td> @endif
      @if($_user)
      <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif>
        <div > @lang('layout.User')</div>
      </td>
      @endif
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency_in = 0;
  $total_income_amount = 0;
  $total_profitAndLost = 0;
  $currencyIn = [];
  $currencyOut = [];
  ?>
  @foreach($data AS $record)
  <tr>
    <?php
    if ($record->commiss_rate > 0) {
      // $total_profitAndLost += ($record->commission_amount / $record->commiss_rate);
      
      $total_profitAndLost += (((systemConfig()[30] == 1)?1:0)?  ($record->commission_amount/$record->com_tra_static_rate*$record->commiss_rate)  :  ($record->commission_amount / $record->commiss_rate));

    }

    if ($record->income_amount > 0) {
      $total_income_amount += $record->income_amount;
    }
    
    if (array_key_exists($record->currency, $currencyIn)) {
      $currencyIn[$record->currency]['amount'] = $currencyIn[$record->currency]['amount'] + $record->amount;
      $currencyIn[$record->currency]['rec_amount'] = $currencyIn[$record->currency]['rec_amount'] + $record->rec_amount;
    } else {
      $currencyIn[$record->currency]['amount'] = $record->amount;
      $currencyIn[$record->currency]['rec_amount'] = $record->rec_amount;
    }

    ?>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    @if($_date)<td class="center"> {{convertDate($record->Date)}} </td>@endif

    @if($_description)<td style="@if($_description_percent) text-align: justify; @endif"> 
      {{$record->description}} 
            {{-- @if(isset($report_format))
              {{$record->description}}
            @else
              {!! wordwrap($record->description,40,"<br/>\n",false) !!}
            @endif --}} 
        </td>@endif
    @if(!$member_name)
    @if($_member)<td style="text-align: center;">{{$record->Member}}</td>@endif
    @endif
    @if($_amount)<td class="center"> {{myRound($record->amount)}} {{$record->currency}} </td>@endif
    @if($_rate)<td class="center">{{myRound($record->rate)}}</td>@endif
    @if(!$currency)
    @if($_exchangedCurrency)<td class="center">{{$record->ex_currency}}</td>@endif
    @endif
    @if($_received)<td class="center">{{myRound($record->rec_amount)}} {{$record->currency}} </td>@endif
    @if($_remain)<td class="center">{{myRound($record->amount - $record->rec_amount)}} {{$record->currency}} </td>@endif
    @if(!$transaction_type)  @if($_type)<td class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif @endif
    @if($_commission)<td class="center">{{myRound($record->commission_amount)}} {{ $record->commission_currency}}</td>@endif
    @if($_income)<td class="center">{{myRound($record->income_amount)}}   {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
    @if($_dueDate)<td class="center">{{ convertDate($record->dueDate) }}</td>@endif
    @if(systemConfig()[29] == 1)
    @if(!$transaction_confirm)
    @if($_transaction_confirm)
    @if($record->transaction_confirm == 'On')
    <td class="center"> @lang('layout.yes') </td>
    @else
    <td class="center"> @lang('layout.no') </td>
    @endif
    @endif
    @endif
    @endif
    @if($_monetary_source)<td  class="center">{{$record->monetary_source}}</td>@endif
    @if($_trans_type)<td  class="center">{{$record->trans_type}}</td>@endif
    @if($_user)
    <td style="text-align: center;">{{$record->username}}</td>
    @endif  
  </tr>
  @endforeach
</table>
@if($_total)
@if($currencyIn)
<table class="main-table">
  <tr class="bg">
    <td colspan="3">
      <div class="center">@lang('layout.Total') @lang('layout.Receive')</div>
    </td>
  </tr>
  <tr>
    <td style="text-align: center; font-weight: bold;">
      <div class="center"> @lang('layout.Record')</div>
    </td>
    @if($_brokerCurrency)
    <td style="text-align: center; font-weight: bold;" @if($_brokerCurrency_percent) width="{{$_brokerCurrency_percent}}%" @endif>
      <div class="center"> @lang('layout.Currency') </div>
    </td>
    @endif
    @if($_brokerAmount)
    <td style="text-align: center; font-weight: bold;" @if($_brokerAmount_percent) width="{{$_brokerAmount_percent}}%" @endif>
      <div class="center"> @lang('layout.Amount') </div>
    </td>
    @endif
    @if($_brokerReceived)
    <td style="text-align: center; font-weight: bold;" @if($_brokerReceived_percent) width="{{$_brokerReceived_percent}}%" @endif>
      <div class="center"> @lang('layout.Received') </div>
    </td>
    @endif
    @if($_brokerRemained)
    <td style="text-align: center; font-weight: bold;" @if($_brokerRemained_percent) width="{{$_brokerRemained_percent}}%" @endif>
      <div class="center"> @lang('layout.Remain') </div>
    </td>
    @endif
  </tr>
  <?php
  $count = 0;
  foreach ($currencyIn as $key => $currency) {
  ?>
    <tr>
      <td style="text-align: center;">
        <div class="center">{{++$count}}</div>
      </td>
      @if($_brokerCurrency)
      <td style="text-align: center;">
        <div class="center">{{$key}}</div>
      </td>
      @endif
      @if($_brokerAmount)
      <td style="text-align: center;">
        <div class="center">{{myRound($currency['amount'])}}</div>
      </td>
      @endif
      @if($_brokerReceived)
      <td style="text-align: center;">
        <div class="center">{{myRound($currency['rec_amount'])}}</div>
      </td>
      @endif
      @if($_brokerRemained)
      <td style="text-align: center;">
        <div class="center">{{myRound($currency['amount'] - $currency['rec_amount'])}}</div>
      </td>
      @endif
    </tr>
  <?php
  }
  ?>
</table>
@endif

<table class="main-table">
  <?php 
    $colspan = 2;  
  ?>
  <tr class="bg">
    @if(!$_brokerIncomAll)   <?php  $colspan = $colspan-1;  ?>@endif
    @if(!$_brokerCommissionAll)   <?php  $colspan = $colspan-1;  ?>@endif
    <td colspan="{{$colspan}}">
      <div class="center">@lang('layout.Income')</div>
    </td>
  </tr>
  <tr>
    @if($_brokerIncomAll)
    <td @if($_brokerIncomAll_percent) width="{{$_brokerIncomAll_percent}}%" @endif>
      <div class="center"> @lang('layout.Income') : {{myRound($total_income_amount)}}  {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
    @endif
    @if($_brokerCommissionAll)
    <td @if($_brokerCommissionAll_percent) width="{{$_brokerCommissionAll_percent}}%" @endif>
      @if($_commission)
      <div class="center"> @lang('layout.Commission') : {{myRound($total_profitAndLost)}}  {{getHomeCurrency()[getCurrencyType()]}} </div>
      @endif
    </td>
    @endif
  </tr>
</table>
@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection