@extends('layouts.app')
@section('content')
    <div class="portlet"> 
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.EstimateInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th class="hidden-xs">
                                <i class="fa fa-user"></i>  @lang('layout.Customer') 
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency') 
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th> 
                                <i class="fa "></i> @lang('layout.Amount') 
                            </th>
                            <th> 
                                <i class="fa "></i> @lang('layout.Discount') 
                            </th>
                        
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Description') 
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>   
                            <td class="hidden-xs"> {{ $estimate->name }}  </td>
                            <td class="hidden-xs"> {{ convertDate($estimate->date)}}  </td>
                            <td class="hidden-xs"> {{ $estimate->currency }}  </td>
                            <td class="hidden-xs"> {{ $estimate->rate }}  </td>
                            <td class="hidden-xs"> {{ myRound($total)}}  </td>
                            <td class="hidden-xs"> {{ myRound($estimate->discount) }}  </td>
                            <td class="hidden-xs"> 
                            <?php
                            // $count= strlen($estimate->description);
                            // $temp=$estimate->description;
                            // $myCol=$count/30;
                            // if($count>30)
                            // {
                            //     if($count%30)
                            //     {
                            //         $myCol++;
                            //     }
                            // }
                            // $data=[];
                            // for($i=0;$i<$myCol;$i++)
                            // {
                            //    array_push($data, substr($temp, $i*30,30));
                                
                            // }
                            // foreach($data AS $rec)
                            // {
                            //     echo $rec.'<br>';
                            // }
                            ?>
                            <?php
                                $des = wordwrap($estimate->description,80,"<br/>\n",false);
                                echo $des;
                            ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
        <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.EstimateDetails') </span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                        @permission('estimate-export')
                            {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="Estimate_Details"/>
                            <input type="hidden" name="id" value="{{$estimate->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                            {{Form::close()}} 

                            {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                            <input type="hidden" name="type" value="Estimate_Details"/>
                            <input type="hidden" name="id" value="{{$estimate->id}}"/> 
                            <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                            {{Form::close()}} 
                        @endpermission  
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="tabbable-line tabbable-custom-profile">
                        <ul class="nav nav-tabs">  
                            <li class="active">
                            <a href="#both" data-toggle="tab" id="tab-on" >
                            <i class="fa  "></i><b> @lang('layout.Item') </b></a>
                            </li> 
                            <li class="">
                            <a href="#ex-transport" data-toggle="tab" id="tab-trasnport">
                            <i class="fa  "></i><b> @lang('layout.Service') </b></a>
                            </li> 


                        </ul>  
                        <br>
                        <div class="tab-content padding" style="padding: 0px;">
                            <div class="tab-pane active" id="both">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                        
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="sales">
                                                <thead>
                                                <tr>  
                                                    <th>@lang('layout.ItemName')</th>
                                                    <th>@lang('layout.Site')</th>
                                                    @if(searchByCodeLocation()=="true")
                                                    <th>@lang('layout.Location')</th>
                                                    @endif  
                                                    <th>@lang('layout.MeasureUnit')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Price')</th>
                                                    <th>@lang('layout.Total')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                            </div> 

                            <div class="tab-pane" id="ex-transport">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="service">
                                            <thead>
                                                <tr>  
                                                    <th>@lang('layout.ServiceName')</th>
                                                    <th>@lang('layout.MeasureUnit')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Price')</th>
                                                    <th>@lang('layout.Total')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
@endsection
@push('scripts')
<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax:{
                url:'{{route("estimate.show",$estimate->id)}}',
                data:{type:'items'}
            },

            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                { data: 'item', name: 'item' },
                { data: 'site', name: 'site' , orderable:false,searchable:false },
                @if(searchByCodeLocation()=="true")
                { data: 'location', name: 'location' , orderable:false,searchable:false },
                @endif  
                { data: 'measure_unit', name: 'measure_unit', orderable:false,searchable:false  },
                { data: 'quatity', name: 'quatity',orderable:false,searchable:false },
                { data: 'price', name: 'price',orderable:false,searchable:false},
                { data: 'total', name: 'total',orderable:false,searchable:false},
        ]
        });


        $('#service').DataTable({
                    ajax:{
                        url:'{{route("estimate.show",$estimate->id)}}',
                        data:{type:'service'}
                    },
                    pageLength:'{{getPageRows()}}',
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    columns: [

                        { data: 'item', name: 'items.name' },
                        { data: 'measure_unit', name: 'measure_unit', orderable:false,searchable:false  },
                        { data: 'qty', name: 'sale_order_services.qty'},
                        { data: 'price', name: 'sale_order_services.price'},
                        { data: 'total', name: 'total', orderable:false,searchable:false}
                ]
            });

    });
</script>



@endpush
