@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                :value-type="'estimates'"
                @closed="closeModal">
            <div slot=body>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example"
                                           name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example"
                                           autocomplete="off" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal> 
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.EstimatesList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('estimate-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                         </span>
                    @endpermission
                    @permission('estimate-create')
                    <a href="{{route('estimate.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_filter_data">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered " cellspacing="0" id="estimate">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <div id="factor-obj">
    <!-- @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>

        @endif -->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        @if (Session('sale_id'))
        saleOrderfactorPrint("{{Session('sale_id')}}")

        @endif



        function saleOrderfactorPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('saleOrderFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        function factorPrint(id) {


            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: "{{url('/')}}/salePrint/" + id,
                type: 'get',
                cache: false,

            }).done(function () {

                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                $('#factor-obj').html(s);


                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
                .fail(function () {
                    console.log("error");
                });


        }
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#estimate').DataTable({
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                ajax: {
                    url: '{{route("estimate.index")}}',
                    data: function (d) {
                        d.type = "estimate";
                    }
                },
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                columns: [

                    {data: 'number', name: 'sales_orders.number'},
                    {data: 'name', name: 'members.name'},
                    {data: 'currency', name: 'sales_orders.currency'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'date', name: 'sales_orders.date'},
                    {data: 'discount', name: 'sales_orders.discount'},
                    {data: 'totalAmount', name: 'totalAmount', orderable: false, searchable: false},
                    {data: 'description', name: 'sales_orders.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}

                ]


            });


            $('#btnPrint').click(function () {
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

                // window.print();
                // window.open("data:application/pdf," + escape(data=""));
                $.ajax({
                    // This PHP file will generate the PDF and save it to your server
                    // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    url: '{{route("sale.show",1)}}',
                    type: 'get',
                    cache: false,

                }).done(function () {

                    var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    $('#factor-obj').html(s);


                    // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                })
                    .fail(function () {
                        console.log("error");
                    });

            });


        });


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });


        new Vue({
            el: '#company_filter_data',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object')
                    {
                        data_table.clear();
                        data_table.ajax.reload()
                    }
                }
            }
        });


    </script>


@endpush
