@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('estimates_detail'); 
$_item_name=in_array('item_name', $report);
$_site=in_array('site', $report);
$_measure_unit=in_array('measure_unit', $report);
$_quantity=in_array('quantity', $report);
$_currency=in_array('currency', $report);
$_price=in_array('price', $report);
$_total_amount=in_array('total_amount', $report);
?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.EstimateDetails')</h3>

@if($info && $info !=[])
<table class="main-table">
 
  <tr class="bg"> 
    <td class="center">@lang('layout.Number')</td>
    <td class="center">@lang('layout.Member')</td>
    <td class="center">@lang('layout.Currency')</td>
    <td class="center">@lang('layout.Rate')</td>
    <td class="center">@lang('layout.Discount')</td>
    <td class="center">@lang('layout.Date')</td>
    <td class="center">@lang('layout.Description')</td>
  </tr>
  <tr>
    <td class="center">{{$info->number}}</td>
    <td class="center">{{$info->name}}</td>
    <td class="center">{{$info->currency}}</td>
    <td class="center">{{$info->rate}}</td>
    <td class="center">{{$info->discount}}</td>
    <td class="center">{{convertDate($info->date)}}</td>
    <td style="text-align: justify">

      {{$info->description}}

        {{-- @if(isset($report_format))
        {{$info->description}}
        @else
        {!! wordwrap($info->description,40,"<br/>\n",false) !!}
        @endif --}}

    </td>
  </tr>


</table>
<br>
@endif


<table class="main-table">
<thead>
  <tr class="bg"> 

  <td class="center"><div>  @lang('layout.Record') </div></td>  
  @if($_item_name)<td  class="center">@lang('layout.ItemName')</td>@endif
  @if($_site)<td  class="center">@lang('layout.Site')</td>@endif
  @if(searchByCodeLocation()=="true")<td  class="center">@lang('layout.Location')</td>@endif  
  @if($_measure_unit)<td  class="center">@lang('layout.MeasureUnit')</td>@endif
  @if($_quantity)<td  class="center">@lang('layout.Quantity')</td>@endif
  @if($_price)<td  class="center">@lang('layout.Price')</td>@endif
  @if($_total_amount)<td  class="center">@lang('layout.TotalAmount')</td>@endif
</tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
@if($_item_name)<td  class="center">{{$record->item}}</td>@endif
@if($_site)<td  class="center">{{$record->site}}</td>@endif
@if(searchByCodeLocation()=="true")<td  class="center">{{$record->location}}</td>@endif  
@if($_measure_unit)<td  class="center">{{$record->measure_unit}}</td>@endif
@if($_quantity)<td  class="center">{{$record->quatity}}</td>@endif
@if(systemConfig()[30] == 1)
@if($_price)<td  class="center">{{myRound(($record->cost*$info->static_rate / $info->rate))}}</td>@endif
@if($_total_amount)<td class="center">{{myRound((($record->cost*$record->quatity)*$info->static_rate / $info->rate))}}</td>@endif
@else 
@if($_price)<td  class="center">{{myRound(($record->cost*$info->rate))}}</td>@endif
@if($_total_amount)<td class="center">{{myRound((($record->cost*$record->quatity)*$info->rate))}}</td>@endif 
@endif


</tr>
@endforeach

</table>

<?php
$count = 0;
?>

@if(count($saleOrderService)>0)
<br>
<table class="main-table">
  <tr class="bg">
    <th>@lang('layout.Record') </th>
    <th>@lang('layout.ServiceName')</th>
    <th>@lang('layout.MeasureUnit')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Price')</th>
    <th>@lang('layout.TotalAmount')</th>
  </tr>
  @foreach($saleOrderService AS $service)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$service->item}}</td>
    <td class="center">{{$service->measure_unit}}</td>
    <td class="center">{{$service->qty}}</td>
    <td class="center">{{myRound($service->price)}}</td>
    <td class="center">{{myRound((($service->price*$service->qty)))}}</td>
  </tr>
  @endforeach
</table>
@endif
<br>
<table class="main-table">
<tr>
  <td class="center" colspan="2">@lang('layout.Total')</td>
  <td class="center" colspan="5">{{$total}}&nbsp;{{$info->currency}}</td>
</tr> 
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection