@extends('layouts.app')
@section('style')

    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">
    <style> 
        .dashboard-stat2 {
            padding: 0;
        }
 

        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        } 

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }




        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
    </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
        select#parentCategory{
            border: 1px solid #ddd;
        }
        .cmodal-container
        {
            width: 800px !important;
        }
            /* border: none !important; */
        .have-border
        {
            border: 1px solid lightgray !important;

        }
        cmodal[v-cloak] {
            display: none;
        }

    </style>

@stop



@section('content')
@include('inventories.cmodal')

    <div class="row" id="salse">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewInvoice')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            
            <div class="portlet-body form" id="item-service">
 
 
                {{Form::open(['route' => 'invoice.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}

                    <div class="tab-content">
                    <div class="tab-pane active" id="home">
                <div id="salse" v-cloak>

                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Customer')</label>
                                        <div class="col-md-8">
                                            <v-autocomplete :items="customerList" v-model="customer" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='customerUpdate'
                                                            :input-attrs="{}"
                                                            placeholder="@lang('layout.SelectCustomer')">
                                            </v-autocomplete>
                                            <input type="hidden" name="customer" :value="(customer)?customer.id:null">
                                            <input type="hidden" value="{{$saleOrder->id}}" name="saleorderId">

                                        </div>
                                    </div>
                                </div>

                                <div  class="col-lg-3  col-md-3  col-xs-12">
                                    <div class="fom-group">
                                        <label class="control-label col-md-4"> </label>
                                        <div class="col-md-8">
                                            <button class="btn green" type=button id="show-cmodal"
                                             @click="showcModal = true">@lang('layout.NewCustomer') <i class="fa fa-plus"> </i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Currency') </label>
                                        <div class="col-md-8">
                                            <select class="form-control " v-model="selectedCurrency"  required="required" @click='myRound'>

                                                <option v-for="optionCurrency in currencyList"
                                                        :value="optionCurrency">@{{optionCurrency.code}}
                                                </option>
                                            </select>

                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>

                                        </div>
                                    </div>
                                </div>

                                {{--<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">--}}
                                    {{--<div class="form-group">--}}
                                        {{--<label class="control-label col-md-4">@lang('layout.Account') </label>--}}
                                        {{--<div class="col-md-8">--}}

                                            {{--<select class="form-control" name="bank_account">--}}
                                                {{--<option v-for="Account in accountUpdate" :value="Account.id">@{{--}}
                                                    {{--Account.name }}--}}
                                                {{--</option>--}}
                                            {{--</select>--}}

                                        {{--</div>--}}
                                    {{--</div>--}}
                                {{--</div>--}}


                            </div>
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Discount') </label>
                                        <div class="col-md-8 ">
                                            <div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
                                            
                                                <input  v-model="discountFiled"  class="form-control"
                                                        type="number" min="0"
                                                        max="100" @change="changeValue">
                                                <span  v-if="discountIsAmount"  @click="percentToCurrency" class="input-group-addon">@{{selectedCurrency.symbol}}
                                                    <input type="hidden" name="discount_type" value="currency">
                                                </span>
                                                <span  v-else @click="percentToCurrency" class="input-group-addon" >%
                                                    <input type="hidden" name="discount_type" value="percent">
                                                </span>
                                                <input type="hidden" name="discountTotal" :value="discount">
                                                <input type="hidden" name="discount" :value="discountFiled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Date') </label>
                                        <div class="col-md-8">
                                            <div>
                                                <!-- <input class="form-control" id="getdate"
                                                        type="text">
                                                <input type="hidden" name="date" id="getdateTimps"> -->
                                                <input class="form-control" id="range-from-example" name="date" autocomplete="off">

                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div  class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Rate') </label>
                                        <div class="col-md-8 " >
                                            <div class="input-group">
                                                <input  v-model="roundData" class="form-control"
                                                        type="number" min="0" >
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>


                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.rate">
                                </div>

                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <label class="control-label col-md-4">@lang('layout.Description') </label>
                                        <div class="col-md-8 ">

                                            <textarea  name="description" class="form-control" rows="1">
                                                {{$saleOrder->description}}
                                            </textarea>
                                        </div>
                                    </div>

                                </div>
                                <!-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <label class="control-label col-md-4">@lang('layout.ExpireDate') </label>
                                        <div class="col-md-8 ">

                                            <input type="number" name="days" value="{{$saleOrder->dlDate}}" class="form-control">
                                        </div>
                                    </div>

                                </div> -->
 

                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                            <div class="dashboard-stat2 ">

                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(2) }}%)</small>
                                        </td>
                                        <td class="text-right">
                                                   <span class="text-right" data-counter="counterup"
                                                         data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>Sub-Total:</small>
                                        </td>
                                        <td class="text-right">
                                                    <span class="text-right" data-counter="counterup"
                                                          data-value="7800">@{{ subtotal.toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>
                        </div>


                    </div>

                    <div v-if="inventories.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName')  </th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Price')</th>
                                    <th class="text-center" style="min-width: 90px;"> @lang('layout.Total')</th>
                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(inventory,InventoryIndex) in inventories" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="inventory.items" v-model="inventory.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='update'
                                                        :input-attrs="{}"
                                                        @focus="setFocus(InventoryIndex)"
                                                        placeholder="@lang('layout.SelectItem')"
                                                        style="min-width: 220px  ;">
                                        </v-autocomplete>
                                        <input type="hidden" name="inventory_id[]" :value="(!inventory.item)?null:inventory.item.id">
                                    </td>
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="@lang('layout.Quantity')"
                                                 v-model="!inventory.item?null:inventory.item.site"
                                                 required="required">

                                            <option v-if="inventory.item"
                                                    v-for="sites in (!inventory.item?null:inventory.item.siteList)"
                                                    :value="sites">@{{sites.site_name}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="site_id[]" :value="(!inventory.item)?null:(inventory.item.site)?inventory.item.site.site_id:null">
                                    </td>
                                    <td >
                                        <input name="inventory_qty[]" class="form-control inpu-number-fild"  :class="{'input-has-error':(!inventory.item)?null:(inventory.item.qty < 0 )}" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="@lang('layout.Quantity')" />
                                    </td>
                                    <td>
                                        <input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:((inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit).toFixed(2)) - (inventory.item.qty) " placeholder="@lang('layout.OnHand')" disabled/>
                                    </td>
                                    <!-- <td>
                                        <input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:((inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit).toFixed(2)) - (inventory.item.qty-defaultAmounts[InventoryIndex].amount) " placeholder="@lang('layout.OnHand')" disabled/>
                                    </td> -->
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="Measure"
                                                 v-model="!inventory.item?null:inventory.item.measure"
                                                 required="required">

                                            <option v-if="inventory.item"
                                                    v-for="measures in (!inventory.item?null:inventory.item.measureList)"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                        </select>

                                        <input type="hidden" name="inventory_measure[]" :value="(!inventory.item)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                    </td>
                                    <td>
                                        <div class="input-group input_style">

                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Cost')" :value="(!inventory.item)?null:((inventory.item.avg_cost*inventory.item.measure.measure_unit/inventory.item.measure_unit)*selectedCurrency.rate).toFixed(2)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" name="inventory_price[]" class="form-control inner_input" :class="{'input-has-error':(!inventory.item)?null:inventory.item.rate<0}" placeholder="@lang('layout.Price')" :value="(!inventory.item)?null: Number.parseFloat(inventory.item.price*exchanged_rate).toFixed(3)" ref="in"  @input="setValuesAmount(InventoryIndex)">
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!inventory.item)?null:inventory.item.qty * (inventory.item.price*exchanged_rate)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <span  v-on:click="deleteItem(InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        {{--<a href="#"><i class="glyphicon glyphicon-trash"></i></a>--}}
                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>



                    <div v-if="services.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>


                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Quantity') </th>
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Measure')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Price')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>

                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(service,Index) in services" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="service.items" v-model="service.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='updateService'
                                                        :input-attrs="{}"
                                                        @focus="setServiceIndex(Index)"
                                                        placeholder="@lang('layout.SelectServices')">
                                        </v-autocomplete>

                                        <input type="hidden" name="service_id[]" :value="!service.item?null:service.item.id">

                                    </td>

                                    <td>
                                        <input name="service_qty[]" class="form-control inpu-number-fild" type="number"  :class="{'input-has-error':(!service.item)?null:service.item.qty<0}" v-model.number="(!service.item)?null:service.item.qty" placeholder="@lang('layout.Quantity')" />
                                    </td>
                                    {{--<td>--}}
                                    {{--<input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:((inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit).toFixed(2)) - inventory.item.qty " placeholder="@lang('layout.OnHand')" disabled/>--}}
                                    {{--</td>--}}
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="@lang('layout.Measure')"
                                                 v-model="!service.item?null:service.item.measure"
                                                 required="required">

                                            <option v-if="service.item"
                                                    v-for="measures in (!service.item?null:service.item.measureList)"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                        </select>
                                        <input type="hidden" name="service_measure[]" :value="!service.item?null:(service.item.measure)?service.item.measure.measure_id:null">
                                    </td>
                                    <td>
                                        <div class="input-group input_style">

                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Cost')" :value="(!service.item)?null:((service.item.cost*service.item.measure.measure_unit/service.item.measure_unit)*selectedCurrency.rate).toFixed(2)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" name="service_price[]" class="form-control inner_input" :class="{'input-has-error':(!service.item)?null:service.item.rate<0}" placeholder="@lang('layout.Price')" :value="(!service.item)?null:Number.parseFloat(service.item.rate*exchanged_rate).toFixed(3)"  ref="ins"  @input="setValuesAmountS(Index)">
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" class="form-control inner_input"  placeholder="@lang('layout.Total')" :value="(!service.item)?null:service.item.qty * (service.item.rate*exchanged_rate)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <span  v-on:click="deleteService(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div v-if="payments.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>


                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                    <th class="text-center" style="min-width: 60px;">@lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(payment,Index) in payments" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="payment.items" v-model="payment.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='updatePayment'
                                                        :input-attrs="{}"
                                                        @focus="setPaymentIndex(Index)"
                                                        placeholder="@lang('layout.SelectBank')">
                                        </v-autocomplete>

                                        <input type="hidden" name="payment_id[]" :value="!payment.item?null:payment.item.id">

                                    </td>
                                    <td>
                                        <span v-show="false">
                                            @{{ totalAmountes[Index] = Number(!payment.item?null:payment.item.totalAmount)+Number(!payment.item?null:payment.item.amount) }}
                                        </span>
                                        <input type="number" disabled class="form-control" v-model="!payment.item?null:totalAmountes[Index]">
                                    </td>

                                    <td>
                                        <input v-bind:disabled="!payment.item?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="!payment.item?null:payment.item.rate "
                                               class="form-control"
                                               placeholder="@lang('layout.Rate')" required/>
                                        <input v-if="payment.item" type="hidden" name="payment_rate[]"
                                               v-bind:value="payment.item.rate">
                                    <td>

                                            <input type="text" name="payment_Currency[]" class="form-control"
                                                   v-model="!payment.item?null:payment.item.code"
                                                   placeholder="@lang('layout.Currency')" required disabled/>

                                            <input v-if="payment.item" type="hidden" name="payment_currency[]"
                                                   v-bind:value="payment.item.code"/>

                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control"
                                                   v-model.number="!payment.item?null:payment.item.amount "
                                                   placeholder="@lang('layout.PayAmount')" required/>

                                            <input v-if="payment.item" type="hidden" name="payment_amount[]"
                                                   v-bind:value="payment.item.amount">

                                            <span class="input-group-addon">@{{(!payment.item)?null:payment.item.code}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control"
                                                   :value="!payment.item?null:(payment.item.amount*selectedCurrency.rate/payment.item.rate).toFixed(3)"
                                                   placeholder="@lang('layout.Total')" style="min-width: 100px" required disabled/>
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                    </td>

                                    <td>
                                        <span  v-on:click="deletePayment(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>



                    <div class="row">

                        <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')
                        </button>
                        <button v-if="services.length <= 0 " type="button" class="btn default" @click="addService">@lang('layout.Addservice')
                        </button>
                        <button  v-if="isError" type="button" class="btn green" @click="submitForm" :disabled="!checkQty">@lang('layout.Submit')</button>

                    </div>

                </div>
                </div> 
                </div>



            {{Form::close()}}
            </div>
            {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                        {{ csrf_field() }}

                <!-- BEGIN FORM-->
                <!-- {!! Form::open(array('route' => 'customer.store','method'=>'POST','class'=>'form-horizontal','files'=> true)) !!}
                {{ csrf_field() }} -->
        <cmodal :show="showcModal" @close="showcModal = false" v-cloak>
            <h3 slot='cheader'>@lang('layout.NewCustomer')</h3>
            <div slot="cbody">

                    <div class="row">
                        <div class="col-md-6">
                                <label class="cform-label" for="name">@lang('layout.Name'):</label>

                                    {!! Form::text('name', null, array('placeholder' =>__('layout.Name'),'class' => 'form-control','v-model'=>'newCustomers.name')) !!}
                        </div>
                        <div class="col-md-6">
                                <label class="cform-label">@lang('layout.Code'):</label>

                                    {!! Form::text('code',null, array('placeholder' => __('layout.Code'),'class' => 'form-control','v-model'=>'newCustomers.code')) !!}
                        </div>


                         <div class="col-md-6">
                                <label class="cform-label">@lang('layout.AccountsReceivable'):</label>
                                    {{Form::select('receivable[]',$receivable,Null,['class' => 'cform-control have-border','v-model'=>'newCustomers.receivable'])}}
                        </div>
                        <div class="col-md-6">
                                <label class="cform-label" for="payable">@lang('layout.AccountsPayable'):</label>
                                    {{Form::select('payable[]',$payable,Null,['class' => 'cform-control have-border','v-model'=>'newCustomers.payable'])}}

                    </div>
                         <div class="col-md-6">
                                 <label class="cform-label" for="phone">@lang('layout.Phone'):</label>
                                 
                                    {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control','v-model'=>'newCustomers.phone')) !!}
                                
                                     
                         </div>
                         <div class="col-md-6">
                                <label class="cform-label" for="address1">@lang('layout.Address'):</label>

                                  
                                  {!! Form::textarea('address1', null, array('placeholder' => __('layout.Address'),'class' => 'cform-control','rows' => 3, 'cols' => 30,'v-model'=>'newCustomers.address1')) !!}
                        </div>

                </div>
                </div>
                <hr>
                <div slot="cfooter">
                    <button type="button" class="modal-default-button btn green" @click="savePost">
                            @lang('layout.Submit')
                    </button>
                </div>
            </cmodal>
            {!! Form::close() !!}
            <!-- END FORM-->

    <!-- <button id="show-modal" @click="showcModal = true">New Post</button> -->


            

        </div>
        
    </div>
    </div>

    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')

    <script>

        // $('.date-picker').datepicker({
        //     autoclose: true
        // });

    </script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>

            $(document).ready(function(){
                        var to, from;
                      
                        from = $("#range-from-example").persianDatepicker({
                            altField: '#range-from-example-alt',
                            altFormat: 'u',
                            initialValue: true,
                            observer: true,
                            format: 'YYYY/MM/DD',
                            autoClose:true,
                     
                        });
                    });

   


        var Currency     = {!! $currency!!}
        var CustomerAll  = {!! $customer !!}
        var Banks        = {!! $banks!!}
        var InventoryAll = {!! $inventoryList!!};
        var serviceAll   = {!! $serviceList !!};
        var Account      = {!! $allBank !!}; 
 
        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox', {
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            }

        });


        Vue.component('cmodal', {
            template: '#cmodal-template',
            props: ['show']
        });
        var sales = new Vue({
            el:'#salse',
            data:{
                showcModal: false,
                categories:0,
                newCustomers: {
                    name: null,
                    code: {!!$code!!},
                    receivable: {!!$recevie!!},
                    payable: {!!$pay!!},
                    type: [1],
                    phone:'',
                    address1: '',
                },
                totalAmountes: [],
               
                inventories: [],
                roundData:1,
                inventoryIndex:0,
                serviceIndex:0,
                inventoryList:InventoryAll,
                serviceList: serviceAll ,
                services:[],
                currencyRate:1,
                customer:null,
                customerList:CustomerAll,
                selectedCurrency: {
                    id: parseInt('{{getHomeCurrency()["id"]}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["code"]}}',
                    rate: '{{getHomeCurrency()["id"]}}'
                },
                HomeCurrency: {
                    id: parseInt('{{getHomeCurrency()["id"]}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["code"]}}',
                    rate: '{{getHomeCurrency()["rate"]}}'
                },
                exchanged_rate: {!!getHomeCurrency()["rate"]!!},
                getPrice: 0,
                payments: [],
                num: [],
                paymentIndex:0,
                discountFiled: {!! $saleOrder->discount !!},
                discountDefault: {!! $saleOrder->discount !!},
                discountType: "",
                discountIsAmount:false,
                currencyList: Currency,
                saleorderItems: {!! $saleorderItems !!},
                saleorderServices: {!! $saleorderServices !!},
                listAccounts:[],
                account: {},
                tpl: temp,
                defaultAmounts:[],
            },
            created(){
                this.customerList = CustomerAll;
                for(var x = 0; x<this.customerList.length; x++){
                    if(this.customerList[x].id == {!! $saleOrder->member_id !!}){
                        this.customer = this.customerList[x];
                    }
                }

                for(var y = 0; y<this.currencyList.length;y++){
                    if(this.currencyList[y].code == "{!!$saleOrder->currency!!}"){
                        this.selectedCurrency = this.currencyList[y];
                        this.exchanged_rate = {!! $saleOrder->rate !!};

                    }
                }
                this.discountType =  "{!! $saleOrder->discount_type !!}";
                this.discountIsAmount = (this.discountType == '' || this.discountType == null || this.discountType == "currency")? true : false;
                for(var a = 0; a<this.saleorderItems.length; a++){
                    for(var b = 0;b<this.inventoryList.length; b++){
                        if(this.inventoryList[b].id == this.saleorderItems[a].inventory_id){
                            var item = this.inventoryList[b];
                            item.price = this.saleorderItems[a].cost;
                            item.qty = this.saleorderItems[a].quatity;
                            this.defaultAmounts.push({amount:this.saleorderItems[a].quatity});
                            this.inventories.push({
                                items: [],
                                item: item,
                            });

                        }
                    }
                }
                this.inventories.push({
                                items: [],
                                item: null,
                            });
                this.defaultAmounts.push({amount:0});

                for(var z = 0; z<this.saleorderServices.length; z++){
                    for(var m = 0; m<this.serviceList.length; m++){
                        if(this.serviceList[m].id == this.saleorderServices[z].inventory_id){
                            var item = this.serviceList[m];
                            item.rate = this.saleorderServices[z].price*this.exchanged_rate;
                            item.qty = this.saleorderServices[z].qty;
                            this.services.push({
                                items: [],
                                item: item,
                            });
                        }
                    }
                }

                this.services.push({
                            items: [],
                            item: null,
                        });
                this.payments.push({
                            items: [],
                            item: null,
                        });


            },
            computed:{
                
                myRound() {
                    
                    this.exchanged_rate = this.selectedCurrency.rate;
                    this.roundData = Number.parseFloat(this.selectedCurrency.rate).toFixed(3);
                },
                discount(){
                    var getvalue = this.discountDefault;
                    
                    if(this.discountIsAmount){

                        if(this.subtotal>0 && getvalue) {
                            console.log('distype',(parseFloat(getvalue) * 100) / (this.subtotal));
                            return  (parseFloat(getvalue) * 100) / (this.subtotal);
                        }else {
                            return 0;
                        }
                    }else {
                        
                        console.log('test',getvalue);
                        return getvalue;
                    }

                },
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                subtotal: function () {
                    var sum = 0;
                    
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item){
                            
                            sum += this.inventories[i]['item']['qty'] * (this.inventories[i]['item']['price']*this.exchanged_rate);
                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item)
                            sum += this.services[i]['item']['qty'] * this.services[i]['item']['rate']*this.exchanged_rate;

                    }


                    return sum;
                },
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item && this.payments[i]['item']['rate']>0) {
//
                            sum += (this.payments[i]['item']['amount'] * this.selectedCurrency.rate / this.payments[i]['item']['rate']) ;
                        }
                    }
                    return sum;
                },
                isError: function () {
                    var isError = false
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && ((this.inventories[i]['item']['qty'] > this.inventories[i]['item']['onHand']) || (this.inventories[i]['item']['qty'] < 0) || (this.inventories[i]['item']['rate'] < 0))){
                            isError = true;
                        }


                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && ( this.services[i]['item']['qty'] < 0 || this.services[i]['item']['rate'] < 0)){
                            isError = true;
                        }


                    }
                    if((isError) || (this.discount < 0) || (this.discount > 100 )){
                        return false;
                    }else {
                        return true;
                    }

                },
                checkQty:function(){
                    var c = true;

    
                    for(var s =0; s<this.inventories.length;s++){
                        if(this.inventories[s].item){
                            
                            var dq = ((this.inventories[s].item.site.OnHand * this.inventories[s].item.measure_unit)/this.inventories[s].item.measure.measure_unit).toFixed(2) - this.inventories[s].item.qty
                            if( dq < 0 ){
                                c = false;
                                break;
                            }
                        }
                    }
                    return c;
                }

            },
            methods:{

                setValuesAmount(index){

                    // console.log('amountes',this.$refs.in[value].value);
                    if(this.inventories[index].item){
                        this.inventories[index].item.rate = this.$refs.in[index].value/this.exchanged_rate; 
                        console.log('in refs',this.inventories[index].item.rate);
                    }
                },
                setValuesAmountS(index){

                    // console.log('amountes',this.$refs.ins[index].value);
                    if(this.services[index].item){
                        this.services[index].item.rate = this.$refs.ins[index].value/this.exchanged_rate; 
                        console.log('in refs service',this.services[index].item.rate);
                    }
                },
                percentToCurrency(){
                    this.discountIsAmount = !this.discountIsAmount;
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item)
                            sum += this.inventories[i]['item']['qty'] * this.inventories[i]['item']['price'];

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item)
                            sum += this.services[i]['item']['qty'] * this.services[i]['item']['rate'];

                    }
                    
                    if(this.discountIsAmount){
                        
                            
                            this.discountFiled = (this.discountFiled*sum/100).toFixed(2);
                            this.discountDefault = this.discountFiled;
                            console.log("in",this.discountFiled);
                    }
                    else {
                        this.discountFiled = (this.discountFiled*100/sum).toFixed(2);
                        console.log("out",this.discountFiled);
                        this.discountDefault = this.discountFiled;
                    }
                    
                },
                changeValue(){

                    this.discountDefault = this.discountFiled;
                },
                itemSelected (item) {
                    alert('selected');
                    console.log('Selected item!', item)
                },
                itemClicked (item) {
                    console.log('You clicked an item!', item)
                    alert('clicked');
                },
                getLabel (item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                deleteItem(index) {
                    this.inventories.splice(index, 1)
                },
                deleteService(index) {
                    this.services.splice(index, 1)
                },
                deletePayment(index){
                    this.payments.splice(index, 1)
                },
                update (text) {
                    var Animals1 = InventoryAll.slice();

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item != null && i != this.inventoryIndex ) {
                            if (Animals1.findIndex((item) => item.name == this.inventories[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.inventories[i].item.name), 1)

                        }

                    }
                    this.inventories[this.inventoryIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.inventoryIndex == this.inventories.length - 1 && this.inventories.length-3 < InventoryAll.length ) {
                        this.addInventory()
                    }
                    
                    if(this.inventories[this.inventoryIndex].item){

                        //if(this.exchanged_rate != {!!currency()->exchange_rate!!}){

                            // this.inventories[this.inventoryIndex].item.rate = this.inventories[this.inventoryIndex].item.amount/this.exchanged_rate;
                            // console.log('amount',this.inventories[this.inventoryIndex]['item']['amount']);
                            // console.log('exrate',this.exchanged_rate);
                            // console.log('amountnot exchanged',this.inventories[this.inventoryIndex]['item']['amount']);
                       // }
                    }
                    // if (this.rows[this.inventoryIndex].item != null)
                    //     this.priceUpdate(this.inventoryIndex)
                    
                },
                updateService (text) {
                    var Animals1 = serviceAll.slice();

                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item != null && i != this.serviceIndex ) {
                            if (Animals1.findIndex((item) => item.name == this.services[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.services[i].item.name), 1)

                        }

                    }
                    this.services[this.serviceIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.serviceIndex == this.services.length - 1 && this.services.length-3 < InventoryAll.length ) {
                        this.addService()
                    }
                    // if (this.rows[this.serviceIndex].item != null)
                    //     this.priceUpdate(this.serviceIndex)
                },
                updatePayment (text) {
                    var Animals1 = Account.slice();
                    var abs = -1;
                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1){
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)
                                abs = this.payments[i].item.id;
                            }
                            // console.log('aaaa',this.payments[i].item.id);
                        }
                    }

                    this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    })
                    abs = this.payments[this.paymentIndex].items.id;
                    if (this.paymentIndex == this.payments.length - 1)
                        this.newPayment()
                    if (this.payments[this.paymentIndex].item != null)
                        this.payeds;

                },
                setFocus(index){
                    
                    this.inventoryIndex = index;
                    this.update('')
                },
                setServiceIndex(index){
                    this.serviceIndex = index;
                    this.updateService('')
                },
                setPaymentIndex(index){
                    this.paymentIndex = index;
                    this.updatePayment('')
                },
                addInventory(){
                    this.inventories.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                addService(){
                    this.services.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                newPayment(){
                    this.payments.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                customerUpdate(text){
                    this.customerList = CustomerAll.slice().filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    });
                },
                bankUpdate(text) {
                    var b = _.clone(this.accounts)

                    this.listAccounts = b.filter((account) => {
                        return (new RegExp(text.toLowerCase())).test(account.name.toLowerCase())
                    })

                },
                submitForm() {

                    swal({
                        title:"@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                        text: "",
                        icon: "info",
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("sales-form").submit()

                        } else {

                        }
                    });

                },
                savePost() {

                // console.log('sdkfjh',sales.newCustomers.type);
                // alert(sales.newCustomers.type)

                var req = axios.post("{{route('customer.store')}}",sales.newCustomers)
                    .then(function (response) {
                        sales.showcModal = false;
                        sales.fieldErrors = [];
                        // vu.categories = response.data;
                        console.log('sdkfh',response.data);
                        axios.get("{{route('invoice.create')}}").then(function (response) {
                        console.log('sdkfh',response.data);

                            CustomerAll = response.data.customer;
                            sales.newCustomers.name= null;
                            sales.newCustomers.phone= '';
                            sales.newCustomers.address1= '';
                            sales.newCustomers.code= response.data.code;

                                
                        });
                        });



                    },


            }
        });


    </script>

@endpush
