@extends('layouts.factor-master')

@section('content')

<?php
$report = customeReport('estimates'); 
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_member=in_array('member', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_amount=in_array('amount', $report);
$_discount=in_array('discount', $report);

?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.EstimatesReport')</h3>
    <table class="main-table">
      <tr>
        @if($from_date)
        <td>
        <span>@lang('layout.FromDate')</span>:
        <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
      </td>
      @endif
      @if($to_date)
      <td>
        <span>@lang('layout.ToDate')</span>:
        <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
      </td>
      @endif
    </tr>
    </table>
<br>
  <table class="main-table">
<thead>
  <tr class="bg">
  <td class="center"><div >  @lang('layout.Record') </div></td>
  @if($_date)<td class="center">@lang('layout.Date')</td>@endif
  @if($_description)<td  class="center">@lang('layout.Description')</td>@endif
  @if($_member)<td  class="center">@lang('layout.Member')</td>@endif
  @if($_currency)<td  class="center">@lang('layout.Currency')</td>@endif
  @if($_rate)<td  class="center">@lang('layout.Rate')</td>@endif
  @if($_discount)<td  class="center">@lang('layout.Discount')</td>@endif
  <td  class="center">@lang('layout.Total')</td>
  <td  class="center">@lang('layout.User')</td>
 </tr>
</thead>
 <?php
 $count = 0;
 ?>
 @foreach($data AS $record) 
 <tr>
 <td class="center">{{++$count}}</td>
 @if($_date)<td  class="center">{{convertDate($record['date'])}}</td>@endif
 @if($_description)
<td  style="text-align: justify">


      @if(isset($report_format))
      {{$record['description']}}
      @else
      {!! wordwrap($record['description'],40,"<br/>\n",false) !!}
      @endif


  </td>
  @endif
 @if($_member)<td  class="center">{{$record['name']}}</td>@endif
 @if($_currency)<td  class="center">{{$record['currency']}}</td>@endif
 @if($_rate)<td class="center">{{$record['rate']}}</td>@endif
 @if($_discount)<td  class="center">{{$record['discount']}}</td>@endif
 <td  class="center">{{$record['total']}}</td> 
 <td  class="center">{{$record['user']}}</td> 
</tr>
  @endforeach   
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection