@extends('layouts.app')
@section('style')
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style type="text/css">

    </style>
@stop
@section('content')
    @include('employees.modal')
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="''"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="member_id" value="{{$employee->member_id}}"/>
                <input type="hidden" name="type" :value="type"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div id="print-modal_statement">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'vendorStatement'"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="type_name" value="Employee"/>
                <input type="hidden" name="member_id" value="{{$employee->member_id}}"/>

                <div class="row">
                    <div class="form-group">

                        <div>
                            <label>@lang('layout.HomeCurency')</label>
                            <input class="mt-checkbox" type="checkbox" name="home_currency" checked="">
                        </div>
                        <div class="col-md-8">
                            <label class="control-label ">@lang('layout.Currency') </label>
                            <select name="currency" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach(currencyList() AS $currency)
                                    <option value="{{$currency->code}}">{{$currency->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="col-md-4">
                            <label>@lang('menu.PayrollForm')</label>
                            <input class="mt-checkbox" type="checkbox" name="payrollForm" >
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option value="item">@lang('layout.WithItem')</option>
                                <option selected="selected" value="">@lang('layout.WithoutItem')</option>
                                <option value="afghan">@lang('layout.Satement1')</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.ReportType') </label>
                            <select name="report_type" id="" class="form-control">
                                <option value="">@lang('layout.SelectReportType')</option>
                                <option value="Receivable">@lang('layout.Payable')</option>
                                <option value="Payable">@lang('layout.Receivable')</option>
                            </select>  
                        </div>


                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    
    <div id="print_modal_inventory">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show"  :value-type="'member_item_stock'"
            @closed="closeModal">
            <div slot="body">
                    <input type="hidden" name="member_id" value="{{$employee->member_id}}"/>
                                 
                    <div class="row">
                        <div class="form-group">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label"> @lang('layout.Date')</label>
                                    <div class="input-group">
                                        <input class="form-control date" id="range-from-example" name="from_date"
                                            autocomplete="off">
                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                        <input class="form-control date" id="range-to-example" name="to_date"
                                            autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </report-modal>
    </div> 


    <div id="guarantor-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
            v-if="is_show" 
            :value-type="'member_guarantors'"
            @closed="closeModal">
    
            <div slot="body">
                 <input type="hidden" name="id" value="{{$employee->member_id}}"/>
            </div>
        </report-modal>
    </div>



    <!--    -->
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.EmployeeInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="tabbable-line tabbable-full-width">
                <ul class="nav nav-tabs">
                    <li class="">
                        <a href="#tab_1_1" data-toggle="tab">@lang('layout.Overview')  </a>
                    </li>
                    <li>
                        <a href="#tab_1_3" data-toggle="tab">@lang('layout.Info') </a>
                    </li>
                    <div class="pull-right" id="app19" v-cloak>
                        <button class="btn btn-success" v-if="!checkStatus"
                                onclick="location.href='{{route('memberOpeningBalance.create',$employee->id)}}'">@lang('layout.OpeningBalance')</button>


                    </div>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_1">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; padding: 0px 0px 0px 0px;">
                                <div style="display: flex;justify-content: space-around">
                                    <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-left: 10px !important; padding: 10px;">
                                        <div style="display: flex;align-items: center;">
                                            <div title="{{$employee->name}}" class="twPc-avatarLink" style="margin-left: 10px;">
                                                @if($employee->photo ==Null)
                                                    <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}" style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @else
                                                    <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$employee->photo)!!}" style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @endif
                                            </div>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th colspan="2" class="text-center" style="font-size: 20px;font-weight: bold;">{{$employee->name}}</th>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-briefcase"></i></th>
                                                    <td>{{$employee->job_name}}</td>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-mobile"></i></th>
                                                    <td>{{$employee->phone}}</td>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa fa-envelope"></i></th>
                                                    <td>{{$employee->email}}</td>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-home"></i></th>
                                                    <td>{{$employee->city}}</td>
                                                </tr>
                                                <tr>
                                                    <th><i class="fa fa-calendar-plus-o"></i></th>
                                                    <td>{{convertDate($employee->reg_date)}}</td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-lg-1 col-md-12 col-sm-12 col-xs-12"></div>
                                    <div class="col-lg-5 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                        <div class="col-md-12">
                                            <div class="portlet sale-summary">
                                                <div class="portlet-title" style="display: flex; justify-content: center;">
                                                    <div class="caption font-black sbold">  @lang('layout.EmployeeSummary') </div>
                                                    <div class="tools">
                                                        {{-- <a class="reload" href="javascript:;"> </a> --}}
                                                    </div>
                                                </div>
                                                <div class="portlet-body" id="member_statement" v-cloak>
                                                    <div v-if="isLoading">
                                                        <div class="table-scrollable">
                                                            <table class="table">
                                                                <tr>
                                                                    <td colspan="3" style="text-align: center">
                                                                        <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                                                                    </td>
    
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div v-else>
                                                    <div class="table-scrollable">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <thead>
                                                            <tr>
                                                                <th>
                                                                    <i class="fa fa-money"></i> @lang('layout.Currency')
                                                                </th>
                                                                <th class="">
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                                </th>
                                                                <th>
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                                </th>
    
                                                            </tr>
                                                            </thead>
                                                            <tbody v-if="summary">
                                                                <tr v-for="summ in summary">
                                                                    <td> @{{ summ.currency }} </td>
                                                                    <td> @{{format_number(Number(summ.invoice)) }} </td>
                                                                    <td> @{{ format_number(Number(summ.payment)) }}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    </div>
    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class=""> --}}
                            {{-- <div class="col-md-2">
                                <ul class="list-unstyled profile-nav">
                                    <li>
                                        <div title="{{$employee->name}}" class="twPc-avatarLink">
                                            @if($employee->photo ==Null)
                                                <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                     style="width:170px; height:170px;">
                                            @else
                                                <img class=" twPc-avatarImg"
                                                     src="{!!url('/uploads/'.$employee->photo)!!}"
                                                     style="width:170px; height:170px;">
                                            @endif
                                        </div>
                                    </li>
                                </ul>
                            </div> --}}
                            {{-- <div class="col-md-10"> --}}
                                {{-- <div class="row"> --}}
                                    {{-- <div class="col-md-6 profile-info">
                                        <h1 class="font-green sbold uppercase">{{$employee->name}}</h1>
                                        <div style="margin-top: 20%;">
                                            <ul class="list-inline">
                                                <li>
                                                    <i class="fa fa-user"></i> {{$employee->name}}</li>
                                                <li>
                                                    <i class="fa fa-briefcase"></i> {{$employee->job_name}}
                                                </li>

                                                <li>
                                                    <i class="fa fa-mobile"></i> {{$employee->phone}}</li>
                                                <li>
                                                    <i class="fa fa fa-envelope"></i> {{$employee->email}}</li>

                                                <li>
                                                    <i class="fa fa-home"></i> {{$employee->city}}</li>
                                                <li>
                                                    <i class="fa calendar-plus-o"></i> {{convertDate($employee->reg_date)}}
                                                </li>
                                            </ul>
                                        </div>
                                    </div> --}}
                                    <!--end col-md-8-->

                                    {{-- <div class="col-md-6">
                                        <div class="portlet sale-summary">
                                            <div class="portlet-title">
                                                <div class="caption font-red sbold">  @lang('layout.EmployeeSummary') </div>
                                                <div class="tools">
                                                    <a class="reload" href="javascript:;"> </a>
                                                </div>
                                            </div>
                                            <div class="portlet-body" id="member_statement" v-cloak>
                                                <div v-if="isLoading">
                                                    <div class="table-scrollable">
                                                        <table class="table">
                                                            <tr>
                                                                <td colspan="3" style="text-align: center">
                                                                    <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                                                                </td>

                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div v-else>
                                                <div class="table-scrollable">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                        <tr>
                                                            <th>
                                                                <i class="fa fa-money"></i> @lang('layout.Currency')
                                                            </th>
                                                            <th class="">
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                            </th>
                                                            <th>
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                            </th>

                                                        </tr>
                                                        </thead>
                                                        <tbody v-if="summary">
                                                            <tr v-for="summ in summary">
                                                                <td> @{{ summ.currency }} </td>
                                                                <td> @{{format_number(Number(summ.invoice)) }} </td>
                                                                <td> @{{ format_number(Number(summ.payment)) }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div> --}}

                                    <!--end col-md-4-->
                                {{-- </div> --}}
                                <!--end row-->
                            {{-- </div> --}}
                        {{-- </div> --}}
                        <div class="tabbable-line tabbable-custom-profile">
                            <ul class="nav nav-tabs">
                                <li class="active">
                                    <a href="#payments" data-toggle="tab" id="cus-payments">
                                        <i class="fa  "></i><b> @lang('layout.Pyments') </b></a>
                                </li>
                                <li class="">
                                    <a href="#receive" data-toggle="tab" id="emp-receive">
                                        <i class="fa  "></i><b> @lang('layout.Receive') </b></a>
                                </li>
                                <li class="">
                                    <a href="#payroll" data-toggle="tab" id="emp-payroll">
                                        <i class="icon-credit-card"></i><b> @lang('layout.Payroll') </b></a>
                                </li>
                                <li class="">
                                    <a href="#statement" data-toggle="tab" id="cus-statement">
                                        <i class="icon-credit-card"></i><b> @lang('layout.Statements') </b></a>
                                </li>
                                @if(systemConfig()[21] == 1)
                                <li class="">
                                    <a href="#inventory" data-toggle="tab" id="inventory-table">
                                        <i class="fa fa-database"></i><b> @lang('layout.Inventory') </b></a>
                                </li>
                                @endif

                                @if(getFlour()=="true")
                                <li class="">
                                    <a href="#guarantor" data-toggle="tab" id="guarantor-table">
                                        <i class="fa fa-user"></i><b> @lang('layout.Guarantor') </b></a>
                                </li>
                                @endif
                                <li class="">
                                    <a href="#attach" data-toggle="tab" id="attach-table">
                                        <i class="fa fa-paperclip"></i><b> @lang('layout.Attachments') </b>
                                    </a>
                                </li>
                                <li class=""> 
                                    <a href="#refer" data-toggle="tab" id="reference-table">
                                        <i class="fa fa-reply-all"></i> <b>@lang('layout.Reference')</b>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content padding" style="padding: 0px;">
                                <div class="tab-pane active" id="payments">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.PaymentsDetails')</span>
                                                    </div>
                                                    <div class="actions">
                                   
                                                        <span id="anchore-modal">
                                                            <a href="#" @click.prevent="showModal('all_pay')" id="" class="btn  btn-success">
                                                                <i class="fa fa-print"></i>
                                                            </a>
                                                        </span>

                                                    </div>
                                                </div>

                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="payment-table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Rate')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="receive">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.ReceiveDetails')</span>
                                                    </div>
                                                    <div class="actions">

                                                        <button onclick="openModal('receive')" id=""
                                                                class="btn  btn-success"><i class="fa fa-print"></i>
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="receive-table">
                                                        <thead>
                                                        <tr>

                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Type')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Discount')</th>
                                                            <th>@lang('layout.Date')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="payroll">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.PayrollDetails')</span>
                                                    </div>
                                                    <div class="actions">

                                                        <button onclick="openModal('all_payrolls')" id=""
                                                                class="btn  btn-success"><i class="fa fa-print"></i>
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="payroll-table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.FromDate')</th>
                                                            <th>@lang('layout.ToDate')</th>
                                                            <th>@lang('layout.WorkedDay')</th>
                                                            <th>@lang('layout.PaidLeave')</th>
                                                            <th>@lang('layout.OverTimeAddition')</th>
                                                            <th>@lang('layout.NetPayable')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Actions')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>

                                </div>
                                <div class="tab-pane" id="statement">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.StatementDetails')</span>
                                                    </div>
                                                    <div class="actions">


                                                        <button onclick="openModal('statement',true)" id=""
                                                                class="btn  btn-success"><i class="fa fa-print"></i>
                                                        </button>

                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="statement-table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Account')</th>
                                                            <th>@lang('layout.Description')</th>
                                                            <th>@lang('layout.Amount')</th>
                                                            <th>@lang('layout.Currency')</th>
                                                            <th>@lang('layout.Rate')</th>
                                                            <th>@lang('layout.Type')</th>
                                                            <th>@lang('layout.Receivable')</th>
                                                            <th>@lang('layout.Payable')</th>
                                                            <th>@lang('layout.Date')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>

                                </div>
                                <div class="tab-pane" id="inventory">
                                    <div class="portlet-body">
                                        <div class="portlet light bordered">
                                            <div class="portlet-title">
                                                <div class="caption font-dark">
                                                    <i class="icon-settings font-dark"></i>
                                                    <span class="caption-subject bold uppercase">@lang('layout.Inventory')</span>
                                                </div>
                                                <div class="actions">
                                                    <span id="modal-inventory">
                                                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success"> 
                                                        <i class="fa fa-print"></i>
                                                        </a>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                                <table class="table table-striped table-bordered table-hover" id="inventory_table">
                                                    <thead>
                                                    <tr>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.ReferenceNumber')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.SiteName')</th>
                                                    <th>@lang('layout.Category')</th>
                                                    <th>@lang('layout.Quantity')</th>
                                                    <th>@lang('layout.Measure')</th>
                                                    <th>@lang('layout.Price')</th>
                                                    <th>@lang('layout.Total')</th>
                                                    <th>@lang('layout.User')</th>
                                                    </tr>
                                                    </thead>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane " id="guarantor">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                            <div class="portlet light bordered">
                                                <div class="portlet-title">
                                                    <div class="caption font-dark">
                                                        <i class="icon-settings font-dark"></i>
                                                        <span class="caption-subject bold uppercase">@lang('layout.Guarantor')</span>
                                                    </div>
                                                    <div class="actions">
                                                        <span id="gua-modal">
                                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                               <i class="fa fa-print"></i>
                                                            </a>
                                                           </span>

                                                    </div>
                                                </div>

                                                <div class="portlet-body">
                                                    <table class="table table-striped table-bordered table-hover"
                                                           id="guarantor_table">
                                                        <thead>
                                                        <tr>
                                                            <th>@lang('layout.Name')</th>
                                                            <th>@lang('layout.FatherName')</th>
                                                            <th>@lang('layout.GrandFather')</th>
                                                            <th>@lang('layout.Phone')</th>
                                                            <th>@lang('layout.CurrentLocation')</th>
                                                            <th>@lang('layout.NationalNumber')</th>
                                                            <th>@lang('layout.IntroducedBy')</th>
                                                            <th>@lang('layout.Action')</th>
                                                        </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- END EXAMPLE TABLE PORTLET-->
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="attach">
                                    <div class="portlet light bordered">
                                        <div class="portlet-title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <div class="portlet light bordered">
                                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                                    @csrf
                                                    <input type="hidden" name="redirect_route" value="employee.show">
                                                    <input type="hidden" name="foreign_data_id" value="{{$employee->id}}">
                                                    <input type="hidden" name="path" value="uploads/employee">
                                                    <input type="hidden" name="table_name" value="members">
                                                    <div class="row">
                                                        <div class="col-md-6" style="margin-bottom: 15px;">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                <input type="text" name="title" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Date') </label>
                                                                <input type="text" name="date" class="form-control date" id="date" autocomplete="off"  />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                    <div style="margin: 0px 0px 5px 0px;">
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                        </span>
                                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                    </div>
                                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 150px;">
                                                                        <img src="" alt="">
                                                                    </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 180px; line-height: 10px;"></div>
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="margin-top-10" style="text-align: center">
                                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                        <a href="{{url()->previous()}}" class="btn default">@lang('layout.Cancel')</a>
                                                    </div>
                                                </form>
                                            </div>
                                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.AttachmentTitle')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>      
                                <div class="tab-pane" id="refer">
                                    <div class="portlet light bordered">
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="reference_table">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.Name')</th>
                                                    <th>@lang('layout.FatherName')</th>
                                                    <th>@lang('layout.Phone')</th>
                                                    <th>@lang('layout.Email')</th>
                                                    <th>@lang('layout.Address')</th>
                                                    <th>@lang('layout.City')</th>
                                                    <th>@lang('layout.District')</th>
                                                    <th>@lang('layout.Village')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>      


                            </div>
                        </div>
                    </div>
                    <!--tab_1_2-->
                    <div class="tab-pane" id="tab_1_3">
                        <div class=" profile-account">
                            <div class="col-md-3">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_1-1">
                                            <i class="icon-user"></i> @lang('layout.PersonalInfo') </a>
                                        <span class="after"> </span>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_2-2">
                                            <i class="icon-home"></i> @lang('layout.AddressInfo') </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-9">
                                <div class="tab-content">
                                    <div id="tab_1-1" class="tab-pane active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <tr style="background-color: rgb(80, 129, 141) !important;color: white;">
                                                        <th class="text-center">@lang('layout.Name')</th>
                                                        <th class="text-center">@lang('layout.Email')</th>
                                                        <th class="text-center">@lang('layout.Password')</th>
                                                        <th class="text-center">@lang('layout.Phone')</th>
                                                        <th class="text-center">@lang('layout.Phone2')</th>
                                                        <th class="text-center">@lang('layout.Code')</th>
                                                        <th class="text-center">@lang('layout.JobTitle')</th>
                                                        <th class="text-center">@lang('layout.Gender')</th>
                                                        <th class="text-center">@lang('layout.DateOfBirth')</th>
                                                        <th class="text-center">@lang('layout.Membership')</th>
                                                        <th class="text-center">@lang('layout.Date')</th>
                                                    </tr>
                                                    <tr >
                                                        <td class="text-center"> {{ $employee->name }}  </td>
                                                        <td class="text-center"> {{ $employee->email }}  </td>
                                                        <td class="text-center"> {{ $employee->password }} <a type="button" class="btn green hidden-print" name="btnprint" onclick="printPass()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>  </td>
                                                        <td class="text-center"> {{ $employee->phone }}  </td>
                                                        <td class="text-center"> {{ $employee->phone2 }}  </td>
                                                        <td class="text-center"> {{ $employee->code }}  </td>
                                                        <td class="text-center"> {{ $employee->job_name }}  </td>
                                                        <td class="text-center"> {{ $employee->gender }}  </td>
                                                        <td class="text-center"> {{ convertDate($employee->date_of_birth) }}  </td>
                                                        <td class="text-center"> {{ $employee->membership }}  </td>
                                                        <td class="text-center"> {{ convertDate($employee->reg_date)}}  </td>
                                                    </tr>
                                                </table>
                                                <table class="table">
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white !important;">
                                                        <th class="text-center">@lang('layout.BossName')</th>
                                                        <th class="text-center">@lang('layout.ReferenceNumber')</th>
                                                        <th class="text-center">@lang('menu.Shift')</th>
                                                        <th class="text-center">@lang('layout.Description')</th>
                                                        <th class="text-center">@lang('layout.CardOwner')</th>
                                                        <th class="text-center">@lang('layout.CardNumber')</th>
                                                        <th class="text-center">@lang('layout.ShabaNumber')</th>
                                                        <th class="text-center">@lang('layout.Bank')</th>
                                                        <th class="text-center">@lang('layout.Branch')</th>
                                                        <th class="text-center">@lang('layout.SalaryType')</th>
                                                    </tr>
                                                    <tr >
                                                        <td class="text-center"> {{ $employee->bossName }}  </td>
                                                        <td class="text-center"> {{ $employee->ref_no }}  </td>
                                                        <td class="text-center"> {{ $employee->shift }}  </td>
                                                        <td class="text-center"> {{ $employee->description }}  </td>
                                                        <td class="text-center"> {{ $employee->card_owner }} </td>
                                                        <td class="text-center"> {{ $employee->card_number }} </td>
                                                        <td class="text-center"> {{ $employee->shaba_number }} </td>
                                                        <td class="text-center"> {{ $employee->bank }} </td>
                                                        <td class="text-center"> {{ $employee->branch }} </td>
                                                        <td class="text-center">  @if($employee->salaryType){{__('layout.'.$employee->salaryType)}} @endif</td>
                                                    </tr>
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white;">
                                                        <th class="text-center">@lang('layout.GrandFather')</th>
                                                        <th class="text-center">@lang('layout.NationalNumber')</th>
                                                        <th class="text-center">@lang('layout.NationalVolume')</th>
                                                        <th class="text-center">@lang('layout.Page')</th>
                                                        <th class="text-center">@lang('layout.RegistrationNumber')</th>
                                                        <th class="text-center">@lang('layout.IntroducedBy')</th>
                                                        <th class="text-center">@lang('layout.IdentifyType')</th>
                                                    </tr>
                                                    <tr >
                                                        <td class="text-center"> {{ $employee->grand_father_name }}  </td>
                                                        <td class="text-center"> {{ $employee->national_number }}  </td>
                                                        <td class="text-center"> {{ $employee->national_volume }}  </td>
                                                        <td class="text-center"> {{ $employee->national_page }}  </td>
                                                        <td class="text-center"> {{ $employee->national_reg_number }}  </td>
                                                        <td class="text-center"> {{ $employee->introduced_by }}  </td>
                                                        @if($employee->identify_type != '')
                                                        <td class=""> {{__("layout.".$employee->identify_type)}}  </td>
                                                        @else
                                                        <td class=""> </td>
                                                        @endif
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_2-2" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white !important;">
                                                        <th class="text-center">@lang('layout.Address1')</th>
                                                        <th class="text-center">@lang('layout.Address2')</th>
                                                        <th class="text-center">@lang('layout.PostCode')</th>
                                                        <th class="text-center">@lang('layout.City')</th>
                                                        <th class="text-center">@lang('layout.Country')</th>
                                                        <th class="text-center">@lang('layout.Nationality')</th>
                                                    </tr>
                                                    <tr >
                                                        <td class="text-center"> {{ $employee->address1 }}  </td>
                                                        <td class="text-center"> {{ $employee->address2 }}  </td>
                                                        <td class="text-center"> {{ $employee->post_code }}  </td>
                                                        <td class="text-center"> {{ $employee->city }}  </td>
                                                        <td class="text-center"> {{ $employee->country }}  </td>
                                                        <td class="text-center"> {{$employee->nationality}} </td>
                                                    </tr> 
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white !important;">
                                                        <th class="text-center">@lang('layout.CurrentLocation')</th>
                                                        <th class="text-center">@lang('layout.MainLocation')</th>
                                                    </tr>
                                                    <tr >
                                                        <td class="text-center"> {{ $employee->current_location }}  </td>
                                                        <td class="text-center"> {{ $employee->main_location }}  </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <iframe id="payframe" style="display: none;"></iframe>
@endsection
@include('print.modal')
@push('scripts')


    <script>
        Vue.component('modal', {
            template: '#modal-template'
        });
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });


        @if (Session('payment_id'))
        printVoucher("{{Session('payment_id')}}")

        @endif
        function printVoucher(id) {
            document.location.href = "{{url('printPayment')}}/" + id;

        }


        @if (Session('receive_id'))
        printVoucherreceive("{{Session('receive_id')}}")

        @endif
        function printVoucherreceive(id) {
            document.location.href = "{{url('printReceive')}}/" + id;


        }

        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#payment-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                destroy: true,
                ajax: {
                    url: '{{route("employee.show",$employee->member_id)}}',
                    data: {type: 'payment'}
                },
                columns: [
                    {data: 'Account', name: 'accounts.name'},
                    {data: 'Date', name: 'Date', searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                    {data: 'currency', name: 'Currency', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });


        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#emp-receive').on('shown.bs.tab', function (event) {

                $('#receive-table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                     pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    retrieve: true,
                    destroy: true,
                    ajax: {
                        url: '{{route("employee.show",$employee->member_id)}}',
                        data: {type: 'receive'}
                    },


                    columns: [
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'type', name: 'type.receivable_payments'},
                        {data: 'amount', name: 'transactions.amount'},
                        {data: 'currency', name: 'currency', orderable: false, searchable: false},
                        {data: 'discount', name: 'discount', orderable: false, searchable: false},
                        {data: 'Date', name: 'Date', searchable: false},
                        {data: 'description', name: 'description.receivable_payments'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });
            });
        });


        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#emp-payroll').on('shown.bs.tab', function (event) {

                $('#payroll-table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    destroy: true,
                    retrieve: true,
                    ajax: {
                        url: '{{route("employee.show",$employee->member_id)}}',
                        data: {type: 'payroll'}
                    },


                    columns: [
                        {data: 'account', name: 'accounts.name'},
                        {data: 'From_Date', name: 'From_Date', orderable: false, searchable: false},
                        {data: 'To_Date', name: 'To_Date', orderable: false, searchable: false},
                        {data: 'Worked_Days', name: 'Worked_Days', orderable: false, searchable: false},
                        {data: 'Paid_Leave', name: 'paid_leave', orderable: false, searchable: false},
                        {data: 'overtime_addition', name: 'overtime_addition', orderable: false, searchable: false},
                        {data: 'Net_Payable', name: 'net_payable', orderable: false, searchable: false},
                        {data: 'Currency', name: 'account', orderable: false, searchable: false},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });
            });
        });
        //end payrol
        // statement
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-statement').on('shown.bs.tab', function (event) {
                $('#statement-table').DataTable({
                    scrollCollapse: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    serverSide: true,
                    paging: true,
                    destroy: true,
                    retrieve: true,
                    order: [[8, "asc"]],
                    ajax: {
                        url: '{{route("employee.show",$employee->member_id)}}',
                        data: {type: 'statements'}
                    },
                    columns: [
                        {data: 'Account', name: 'Account'},
                        {data: 'Description', name: 'Description'},
                        {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                        {data: 'Currency', name: 'Currency'},
                        {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                        {data: 'Type', name: 'Type'},
                        {data: 'Receiable', name: 'Receiable', orderable: false, searchable: false},
                        {data: 'Payable', name: 'Payable', orderable: false, searchable: false},
                        {data: 'Date', name: 'Date'}
                    ]
                });
            });
        });

        //Begin Inventory
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#inventory-table').on('shown.bs.tab', function (event) {

                $('#inventory_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("employee.show",$employee->member_id)}}',
                        data: {type: 'inventory'}
                    },
                    columns: [
                        { data: 'type',          name: 'type', searchable:false,orderable:true },
                        { data: 'number',        name: 'number', searchable:false,orderable:true },
                        { data: 'ref_no',        name: 'ref_no', searchable:false,orderable:true },
                        { data: 'date',          name: 'date', searchable:false,orderable:true },
                        { data: 'name',          name: 'name', searchable:false,orderable:true },
                        { data: 'siteName',      name: 'siteName', searchable:false,orderable:false },
                        { data: 'cat',           name: 'cat', searchable:false,orderable:false },
                        { data: 'quantity',      name: 'quantity', searchable:false,orderable:false },
                        { data: 'measure',       name: 'measure', searchable:false,orderable:false },
                        { data: 'cost',          name: 'cost', searchable:false,orderable:false },
                        { data: 'total',         name: 'total', searchable:false,orderable:false },
                        { data: 'user',          name: 'user', searchable:false,orderable:false }
                        
                    ]
                });

            });
        });
        //End inventory        
        
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#guarantor-table').on('shown.bs.tab', function (event) {

                $('#guarantor_table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                    pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("employee.show",$employee->member_id)}}',
                        data: {type: 'guarantor'}
                    },
                    columns: [
                        { data: 'name',          name: 'member_guarantor.name'},
                        { data: 'father_name',          name: 'member_guarantor.father_name'},
                        { data: 'grand_father_name',          name: 'member_guarantor.grand_father_name'},
                        { data: 'phone',          name: 'member_guarantor.phone'},
                        { data: 'current_location',          name: 'member_guarantor.current_location'},
                        { data: 'national_number',          name: 'member_guarantor.national_number'},
                        { data: 'introduced_by',          name: 'member_guarantor.introduced_by'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false}


                    ]
                });

            });
        });

        $(document).ready(function () {
        $('#attachment').DataTable({
                ajax: {
                    url: '{{route("employee.show",$employee->member_id)}}',
                    data: {type: 'attachment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'Date', name: 'attachments.date'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });  
        });

        $(document).ready(function (){
            $('#reference_table').DataTable({
                ajax: {
                    url: '{{route("employee.show",$employee->member_id)}}',
                    data: {type: 'guarantor'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    { data: 'name',name: 'member_guarantor.name'},
                    { data: 'father_name',          name: 'member_guarantor.father_name'},
                    { data: 'phone',          name: 'member_guarantor.phone'},
                    { data: 'email', name: 'member_guarantor.email'},
                    { data: 'address', name: 'member_guarantor.address'},
                    { data: 'city', name: 'member_guarantor.city'},
                    { data: 'district', name: 'member_guarantor.district'},
                    { data: 'village', name: 'member_guarantor.village'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });

        function openModal(type, is_statment = false) {
            if (is_statment == false) {

                anchorM.showModal(type);
            }
            else {
                vm_statement.$data.is_show = true;
            }
        }

        var mems = new Vue({
            el: '#member_statement',
            data: {
                summary: null,
                isLoading:true
            },
            mounted: function() {
                var member = {{$employee->member_id}};
                this.getSummary(member);
            },
            methods: {
               
                getSummary(member) {
                if (member) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: member,
                            }
                        })
                        .then(function(response) {
                            mems.summary = response.data;
                            mems.isLoading = false;
                            // console.log(123, mems.summary);
                        })
                        .catch(function(error) {
                            // mems.summary = [];
                            console.log(error);
                        });
                }
            },
           
            }
        });  

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchorM = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function (type = null) {
                    vm.$data.type = type;
                    console.log('trr', type)
                    vm.$data.is_show = true;
                }
            }
        });        

        new Vue({
            el: '#app19',
            data:{
                checkStatus: "{{$employee->status}}"
            },
       
        });


        var vm_statement = new Vue({

            el: '#print-modal_statement',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var vm_inventory = new Vue({

        el: '#print_modal_inventory',
        data: {
            is_show: false,
            pdfRoute: '{!!route("export.PDFAll") !!}',
            excelRoute: '{!! route("export.ExcelAll") !!}',
            type: null,
            selectedSite:null
        },

        methods: {
            closeModal: function () {
                this.is_show = !this.is_show;
            }
        }
        });

        var modal_inventory= new Vue({
        el: '#modal-inventory',
        methods: {
            showModal: function () {
                console.log('trr')
                vm_inventory.$data.is_show = true;

            }
        
        }
        }); 

        var vm_gua =new Vue({
            el: '#guarantor-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}'
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
        });

        var modal_gua= new Vue({
            el: '#gua-modal',
            methods: {
                showModal: function () {
                    vm_gua.$data.is_show = true;

                }
                
            }
        });
        function printPass(){
            // var b = document.getElementById('ppp');
            // console.log(b);
            var a = window.open('','','height=500,width=500');
            a.document.write('<h2>');
            a.document.write('Name :  {{ $employee->name }}');
            a.document.write('<br/>');
            a.document.write('Email :  {{ $employee->email }}');
            a.document.write('<br/>');
            a.document.write('Password :  {{ $employee->password }}');
            a.document.write('</h2>');
            a.document.write('<p>');
            a.document.write('Address :  {{ url("/member/login") }}');
            a.document.write('</p>');
            a.document.close();
            a.print();
        }

    </script>



@endpush
