@extends('layouts.app')
@section('style')
<style type="text/css">
    body, html{
        height: 100%;
    }
    .background{
        position: relative;
        width: 100%;
        height: 100vh;
        background-image: url('{{asset('menu_img/SaleImages/Capture6.PNG')}}');
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        overflow-y: auto;
    }
    .overlay{
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.651);
        display: flex;
        justify-content: center;
        align-items: flex-start;
        padding-top: 20px;
    }
    .cards{
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        width: 100%;
        max-width: 1600px;
        padding: 10px;
        box-sizing: border-box;
        gap: 10px;
    }
    .allCards{ 
        width: 19%;
        /* height: 80px; */
        min-height: 90px;
        background-color: white;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(235, 232, 232, 0.877);
        transition: .5s;
    }
    .allMainCard{ 
        width: 19%;
        /* height: 80px; */
        min-height: 100px;
        border-radius: 10px;
        transition: .5s;
    }
    .allMainCard:hover{
        text-decoration: none;
    }
    .allCards:hover{
        background-color: rgba(255, 255, 255, 0.787);
        transition: .5s;
    }
    .allCards:hover a{
        text-decoration: none;
    }
    @media(max-width: 1024px){
        .allCards{
            width: 22%;
        }
        .allMainCard{
            width: 22%;
        }
    }
    @media(max-width: 768px){
        .allCards{
            width: 45%;
        }
        .allMainCard{
            width: 45%;
        }
    }
    @media(max-width: 480px){
        .allCards{
            width: 90%;
        }
        .allMainCard{
            width: 90%;
        }
    }
    .caret{
        transition: transform 0.3s ease;
    }
    .caret.open{
        transform: rotate(90deg);
    }
</style>
@stop
@section('content')
<div class="background">
    <div class="overlay">
        <div class="cards">
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('layout.Employee')</h3>
                <div>
                    <div class="btn-group">
                        @permission('employee-list')
                        <a href="{{route('employee.create')}}" type="button" class="btn topBtn" style="background-color: #50818d;color: white;">@lang('layout.AddNew')</a>
                        <button type="button" class="btn topBtn dropdown-toggle btn-success" data-toggle="dropdown" id="dropdownButton">
                            <span class="caret"></span>
                        </button>
                        @endpermission
                        <ul class="dropdown-menu dropdown-menu-right" role="menu">
                            @permission('employee-list')
                            <li>
                                <a href="{{route('employee.create')}}">@lang('menu.Employee')</a>
                            </li>
                            @endpermission
                            @permission('jobTitle-list')
                            <li>
                                <a href="{{route('jobTitle.create')}}">@lang('menu.JobTitle')</a>
                            </li>
                            @endpermission
                            @permission('employeeAttendanceClass-create')
                            <li>
                                <a href="{{route('employeeAttendanceClass.create')}}">@lang('menu.EmployeeAttendanceClass')</a>
                            </li>
                            @endpermission
                            @permission('salaryDetails-list')
                            <li>
                                <a href="{{route('salaryDetails.create')}}">@lang('menu.SalaryDetails')</a>
                            </li>
                            @endpermission
                            @permission('payroll-list')
                            <li>
                                <a href="{{route('payroll.create')}}">@lang('menu.Payroll')</a>
                            </li>
                            @endpermission
                            @permission('paySalary-create')
                            <li>
                                <a href="{{route('paySalary.create')}}">@lang('menu.PaySalary')</a>
                            </li>
                            @endpermission
                            @permission('itemTypePayroll-create')
                            <li>
                                <a href="{{route('item.type.payroll.create')}}">@lang('menu.PayrollType')</a>
                            </li>
                            @endpermission
                            @permission('payrollPriceLevel-create')
                            <li>
                                <a href="{{route('payroll.price.level.create')}}">@lang('menu.ItemPriceLevel')</a>
                            </li>
                            @endpermission
                            @permission('payroll-create')
                            <li>
                                <a href="{{route('payroll.form.create')}}">@lang('menu.PayrollForm')</a>
                            </li>
                            @endpermission
                            @permission('employeeSalaryCategory-create')
                            <li>
                                <a href="{{route('employeeSalaryCategoryCreate.create')}}">@lang('menu.EmployeeSalaryCategory')</a>
                            </li>
                            @endpermission
                            @if(systemConfig()[6] != 0 )
                            @permission('payrollTax-list')
                            <li>
                                <a href="{{route('payrollTax.create')}}">@lang('menu.PayrollTax')</a>
                            </li>
                            @endpermission
                            @endif
                            @permission('EmployeeAssessment-list')
                            <li>
                                <a href="{{route('employeeAssessment.create')}}">@lang('menu.EmployeeAssessment')</a>
                            </li>
                            @endpermission
                            @permission('EmployeeRewards-create')
                            <li>
                                <a href="{{route('employeeRewards.create')}}">@lang('menu.EmployeeRewards')</a>
                            </li>
                            @endpermission
                            @permission('attendance-create')
                            <li>
                                <a href="{{route('attendanceSheet.create')}}">@lang('menu.AttendanceSheet')</a>
                            </li>
                            @endpermission
                            @permission('attendanceType-create')
                            <li>
                                <a href="{{route('attendanceType.create')}}">@lang('menu.AttendanceSheetType')</a>
                            </li>
                            @endpermission
                            @permission('attendanceType-create')
                            <li>
                                <a href="{{route('shift.create')}}">@lang('menu.Shift')</a>
                            </li>
                            @endpermission
                            @permission('leave-create')
                            <li>
                                <a href="{{route('leaveType.create')}}">@lang('menu.Leave')</a>
                            </li>
                            @endpermission
                            @permission('overtimeType-create')
                            <li>
                                <a href="{{route('overtimeType.create')}}">@lang('menu.OvertimeType')</a>
                            </li>
                            @endpermission
                            @permission('Supervisor-create')
                            <li>
                                <a href="{{route('supervisor.create')}}">@lang('menu.Supervisor')</a>
                            </li>
                            @endpermission
                        </ul>
                    </div>
                    <a href="#" class="btn btn-danger">@lang('layout.Back') <i class="fa fa-reply"></i></a>
                </div>
            </div>
            <div class="cards">
                @permission('employee-list')
                <a href="{{route('employee.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Employee')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-users"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$employee}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('jobTitle-list')
                <a href="{{route('jobTitle.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.JobTitle')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-tablet"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$jobTitles}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('employeeAttendanceClass-list')
                <a href="{{route('employeeAttendanceClass.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.EmployeeAttendanceClass')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-tablet"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$employeeAttendanceClass}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('salaryDetails-list')
                <a href="{{route('salaryDetails.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.SalaryDetails')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-reorder"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$salaryDetails}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('payroll-list')
                <a href="{{route('payroll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Payroll')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-file-text-o"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($payroll)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('paySalary-list')
                <a href="{{route('paySalary.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.PaySalary')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{myround($paySalary)}} {{getHomeCurrency()['code']}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('itemTypePayroll-list')
                <a href="{{route('item.type.payroll.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PayrollType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(110, 140, 168, 1);" class="fa fa-money"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$itemType}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('payrollPriceLevel-list')
                <a href="{{route('payroll.price.level.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.ItemPriceLevel')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(77, 94, 137, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$levels}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('payroll-list')
                <a href="{{route('payroll.form.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PayrollForm')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(44, 160, 28, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$payrollItemCharge}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('employeeSalaryCategory-list')
                <a href="{{route('employeeSalaryCategory.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.EmployeeSalaryCategory')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 166, 164, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$employeeCategory}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @if(systemConfig()[6] != 0 )
                @permission('payrollTax-list')
                <a href="{{route('payrollTax.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.PayrollTax')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(1, 131, 128, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$payrollTax}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @endif
                @permission('EmployeeAssessment-list')
                <a href="{{route('employeeAssessment.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.EmployeeAssessment')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(89, 192, 148, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$employeeAssessment}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('EmployeeRewards-list')
                <a href="{{route('employeeRewards.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.EmployeeRewards')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgb(139, 173, 105);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$employeeRewards}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
            </div>
            <div class="mainHeader" style="display: flex; justify-content: space-between;width: 100%;flex-wrap: wrap;">
                <h3 style="color: white;">@lang('menu.HR')</h3>
            </div>
            <div class="cards">
                @permission('attendance-list')
                <a href="{{route('attendanceSheet.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.AttendanceSheet')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #7ccc04;" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$attendanceSheet}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('attendanceType-list')
                <a href="{{route('attendanceType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.AttendanceSheetType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #b6babf;" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$attendanceType}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('attendanceType-list')
                <a href="{{route('shift.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Shift')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #fb8001;" class="fa fa-book"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$shift}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('leave-list')
                <a href="{{route('leaveType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Leave')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #0175c0;" class="fa fa-tablet"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$leaveTypes}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('overtimeType-list')
                <a href="{{route('overtimeType.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.OvertimeType')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: #1fa7f2;" class="fa fa-tablet"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$overtimeType}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('EmployeeAssessment-list')
                <a href="{{route('overTimeRequest.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('layout.OverTimeRequest')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(32, 57, 87, 1);" class="fa fa-align-left"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                        </div>
                    </div>
                </a>
                @endpermission
                @permission('Supervisor-list')
                <a href="{{route('supervisor.index')}}" class="allMainCard" style="cursor: pointer;">
                    <div class="allCards" style="width: 100%;">
                        <div style="padding: 0px 10px;display: flex;justify-content: space-between;width: 100%;">
                            <div style="padding: 0px !important; margin: 0px !important;">
                                <div class="titleBtn"><p style="padding:5px 0px !important; margin: 0px !important;font-weight: bold;">@lang('menu.Supervisor')</p></div>
                            </div>
                            <div>
                                <div><i style="font-size: 30px;vertical-align: middle;margin: 0.5em;color: rgba(110, 140, 168, 1);" class="fa fa-user"></i></div>
                            </div>
                        </div>
                        <div style="padding: 0px 5px !important; margin: 0px !important;">
                            <p style="padding: 0px !important; margin: 0px !important;">{{$vendor}}</p>
                        </div>
                    </div>
                </a>
                @endpermission
            </div>
        </div>
    </div>
</div>
@endsection
@push('scripts')
<script>
    const dropdownButton = document.getElementById('dropdownButton');
    const caret = dropdownButton.querySelector('.caret');
    dropdownButton.addEventListener('click', ()=>{
        caret.classList.toggle('open');
    });
    function toggleContent(){
        var content = document.querySelector('.content');
        var icon = document.getElementById('icon');
        if(content.classList.contains('collapsed')){
            content.classList.remove('collapsed');
            content.classList.add('expanded');
            icon.classList.remove('fa-chevron-down');
            icon.classList.add('fa-chevron-up');
        }else{
            content.classList.remove('expanded');
            content.classList.add('collapsed');
            icon.classList.remove('fa-chevron-up');
            icon.classList.add('fa-chevron-down');
        }
    }
</script>
<script type="text/javascript">
    new Vue({
        el: "#system_setting",
        data: {
            settings: settingAll,
            measures: measures,
            sites: sites,
            enable_notify: false
        },
        mounted() {
        },
        methods: {
        }
    });
</script>
@endpush