@extends('layouts.app')
@section('style')
<style>
    .hide_btn {
        display: none;
    }
    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
            display: none !important;
    }
</style>
@endsection
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_statment'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type_name" value="Employee"/>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="2">@lang('layout.WithoutStatment')</option>
                                <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                                <option value="1">@lang('layout.All')</option>
                            </select>
                        </div>

                    <!--  <div  class="col-md-4">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                        </v-select>
                        <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                    </div> -->

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2"
                                      v-model="selectedMember"
                                      :multiple="true" label="name"
                                      @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   :value="member_id.length > 0 ? member_id:null">
                        </div>

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <select name="class_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectClass')</option>
                                @foreach($member_class as  $class)
                                    <option value="{{$class->id}}">{{$class->name}}</option>
                                @endforeach
                            </select>
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.ReportType') </label>
                            <select name="report_type" id="" class="form-control">
                                <option value="">@lang('layout.SelectReportType')</option>
                                <option value="Receivable">@lang('layout.Payable')</option>
                                <option value="Payable">@lang('layout.Receivable')</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Status') </label>
                            <select name="status" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                <option value="active">@lang('layout.Active')</option>
                                <option value="inActive">@lang('layout.InActive')</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.EmploymentType') </label>
                            <select name="employment_type" id="" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                <option value="salary">@lang('layout.SalaryBased')</option>
                                <option value="contract">@lang('layout.ContractBased')</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                        <label class="control-label">@lang('layout.Currency') </label>
                        <select class="form-control" v-model="selected_currency" >
                            <option v-for="curre in currencies" :value="curre">@{{ curre.code }}</option>
                        </select>
                        <input type="hidden" name="currency" v-bind:value="(selected_currency)?selected_currency.code:null"/>
                        </div>
                        <div class="col-md-6">
                        <span v-if="selected_currency">
                            <span v-if="selected_currency.code != code">
                            <label class="control-label">@lang('layout.Rate') </label>
                                    <div class="input-group">
                                        <input v-model="selected_currency.rate" class="form-control" name="currency_rate"
                                            type="number" step="any" min="0"  >
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                            </span>
                        </span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    @include('employees.modal')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.EmployeeList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('employee-export')
                    <span id="anchore-modal">
                           <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                              <i class="fa fa-print"></i>
                           </a>
                       </span>
                    @endpermission
                    @permission('employee-create')
                    <a href="{{route('employee.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                    @if (fingerprint() == 'true')
                    @permission('employee-edit')
                    <a href="{{route('employee_member.edit')}}">
                        <button id="sample_editable_1_new" class="btn">
                            <i class="fa fa-pencil"></i> @lang('layout.Fingerprint')
                        </button>
                    </a>
                    @endpermission
                    @endif
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-bordered table-hover" cellspacing="0" id="employee">
                    <thead>
                        <tr>
                            {{--<th>Code</th>--}}
                            <th >@lang('layout.Code')</th>
                            <th>@lang('layout.CardId')</th>
                            <th>@lang('layout.FullName')</th>
                            <th>@lang('layout.JobTitle')</th>
                            @if(getCustomerStatement() =="true")
                                <th>@lang('layout.TotalBalances') 
                                @if(getCustomerStatementType() == "currency")
                                    <span></span>
                                    @else
                                        {{getHomeCurrency()["code"]}} 
                                    @endif
                                
                                </th>
                            @endif
                            <th>@lang('layout.FatherName')</th>
                            <th>@lang('layout.BloodGroup')</th>
                            <th>@lang('layout.Phone')</th>
                            <th>@lang('layout.CreatedAt')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#employee').DataTable({
                ajax: '{{route("employee.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                serverSide: true,

                paging: true,
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'id_card', name: 'id_card'},
                    {data: 'name', name: 'name'},
                    {data: 'job_title', name: 'job_title', orderable: false, searchable: false},
                        @if(getCustomerStatement() =="true") {
                        data: 'totalBalances',
                        name: 'totalBalances',
                        orderable: false,
                        searchable: false
                    }, @endif
                    
                    {data: 'father_name', name: 'father_name'},
                    {data: 'blood_group', name: 'blood_group'},
                    {data: 'phone', name: 'phone'},
                    {data: 'created_at', name: 'created_at', searchable: false},
                    {data: 'status', name: 'status'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


                ]


            });


        });
        Vue.component('v-select', VueSelect.VueSelect);


        // for new modal

        var currencies = {!! $currencies !!};
        var code = '{!! getHomeCurrency()['code'] !!}';

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                // selectedMember:null,
                memberlist: [],
                currencies: currencies,
                selected_currency: null,
                code: code,
                selectedMember: [],
                member_id: []

            },

            watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Employee',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload()
                }
            }
        });
    </script>
@endpush