@extends('layouts.app')
@section('style')

<style>

</style>
@stop
@section('content')

<div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Fingerprint') </span>
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">


              
                    <div  id="app" v-cloak>
                      <!-- BEGIN FORM-->
                      {!! Form::open(array('route' => 'employee_member.update','method'=>'PATCH','class'=>'form-horizontal')) !!}
                    
                          <div class="form-body">
                          <div class="row" >
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <div class="form-group">
                                        
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.SelectClass')</label>
                                            <select class="list-style form-control" @change="changeCategory(this)" v-model="selected_class">
                                                    <option value="">@lang('layout.SelectClass')</option>
                                                    <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                            </select>
                                        </div>
                                    </div> 
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <div >
                                    <select class="list-style form-control"  @change="changeCategory(this)" v-model="type">
                                        @foreach($type as $key=>$value)
                                            <option value="{{$value}}">{{__('type.' . $value)}}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>
                                <div class="col-md-1">
                                    <label class="control-label">&nbsp;</label>
                                    <div >
                                        <button type="button" @click="changeCategory(this)" class=" form-control btn green">@lang('layout.Search')</button>
                                    </div>
                                </div>
                            <br/>
                            <br/>
                            <br/>
                            </div>
                        
                          <div class="row" style=" overflow-y: scroll; height:600px;">               
                            <table class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr style="background-color: rgb(174, 183, 178)">
                                        <th colspan="6">@lang('layout.SelectAll') </th>
                                    </tr> 
                                    <tr style="background-color: rgb(174, 183, 178);">
                                        <th style="background-color: #6b716b;"><input type="checkbox" name="selectedItem"  @change="selectAll(this)" v-model="selectedAll"> </th>
                                        <th>@lang('layout.Code') </th>
                                        <th>@lang('layout.Name') </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(item,index) in items">
                                        <input type="hidden" :name="'id['+index+']'" v-model="item.id">
                                        <td class="highlight" style="background-color: rgb(174, 183, 178);">
                                            <input type="checkbox" :name="'selected_item['+index+']'" :checked="item.selected" >
                                        </td>
                                          <td class="highlight">
                                            <div class="success"></div>
                                            @{{item.code}} 
                                          </td>
                                        <td class="highlight">
                                            <div class="success"></div>
                                            <input type="text" :name="'name['+index+']'" :value="item.name" class="form-control" >
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                                              
                          </div>
                          <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                              <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                              <a href="{{route('customer.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                          </div>  
                      {!! Form::close() !!}
                  </div>
                
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">
 Vue.component("v-select", VueSelect.VueSelect);

  var member_class = {!! $member_class !!}
  var items = [];
  new Vue({
    el: '#app',
    data: {
      category:member_class,
      selected_class:null,
      type:'Employee',
      items:items,
      selectedAll:false,
      member_class:member_class,

    },

 

    methods:
    {
      changeCategory(e)
      {
        var selected_class=this.selected_class;
        var type=this.type;
        let vmc = this;
        vmc.items = [];
        if (selected_class || type) {
            console.log(12, type, selected_class);
                axios.get("{{route('employee_member.edit')}}", {
                    params: {
                        type: type,
                        selected_class: selected_class
                    }
                }).then(
                response => {
                    
                    if (response.data) {
                        if (response.data.member) {
                            vmc.items = response.data.member;
                            for(var i=0;i<vmc.items.length;i++)
                            { 
                                vmc.items[i].selected=true;
                            }
                        }
                    }

                }).catch(error => console.log(error));
            
        }
        
      },
      toggleCheck(index)
      {
        // this.items[index].selected=!this.items[index].selected;
      },
     //Select * Records
      selectAll(e)
      {
        
         for(var i=0;i<this.items.length;i++)
        { 
           if(this.selectedAll==true)
           {
             this.items[i].selected=true;
           }
           else
           {
               this.items[i].selected=null;
           }
         
        }
      }
    }
  });

</script>
@endpush