@extends('layouts.app')
@section('style')
<link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <style>
    .v-select .selected-tag{
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
            display: none !important;
        }
</style> 
@stop 
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EmployeeInformation') </span>
                </div>
                <div class="tools">
                  
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($employee,['method' => 'PATCH','route' => ['employee.update',$employee->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.FullName')</label>
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!} 
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code', null, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                        </div>
                         <div class="col-md-3">
                                <label class="control-label">@lang('layout.CardId')</label> 
                                    {!! Form::number('id_card',null, array('placeholder' => __('layout.CardId'),'class' => 'form-control')) !!}  
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    
                    <div id="app">
					<div class="row">
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Type')</label>
                                <div>
                                 {!! Form::select('type[]', $type,$employee->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                                </div>
                        </div>
                        <div class="col-md-2">
                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                            {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'class' => 'form-control' ,'autocomplete'=>'off')) !!}
                        </div>
						<div class="col-md-2">
                                <label class="control-label">@lang('layout.FatherName')</label>
                                {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'class' => 'form-control')) !!} 
                        </div>

                        <div class="col-md-2">
                            <label class="control-label">@lang('layout.IdentifyType')</label>
                            <select name="identify_type" id="" class="form-control" v-model="identify_type">
                                <option value=""> @lang('layout.Select') </option>
                                <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                            </select>
                        </div> 
                        
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.AttendanceType')</label>
                            <div>
                                <select  class="form-control" v-model="selected_attendance_type">
                                    <option  disabled="disabled">@lang('layout.SelectType')</option>
                                    <option v-for="at_type in attendance_type" :value="at_type">@{{ at_type.type }}</option>
                                </select>
                                <input type="hidden" name="attendance_type"
                               :value="selected_attendance_type? selected_attendance_type.tag: null">
                            </div>
                        </div> 
                        <!--/span-->
                     
                    </div> 
                    <div class="row">
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.SalaryType')</label>
                            <select name="salaryType" class="form-control">
                                <option value="Montly" @if($employee->salaryType=="Montly") selected @endif>@lang('layout.Montly')</option>
                                <option value="Daily" @if($employee->salaryType=="Daily") selected @endif >@lang('layout.Daily')</option>
                                <option value="Weekly"@if($employee->salaryType=="Weekly") selected @endif >@lang('layout.Weekly')</option>
                                <option value="TwoWeek" @if($employee->salaryType=="TwoWeek") selected @endif >@lang('layout.TwoWeek')</option>
                                <option value="TwiceAMonth" @if($employee->salaryType=="TwiceAMonth") selected @endif>@lang('layout.TwiceAMonth')</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('menu.Shift')</label>
                            <div >
                            <select name="shift" class="list-style form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach($shift as $key=>$value)
                                    <option value="{{$value->id}}" @if($employee->shift_id == $value->id) selected @endif >{{$value->name}}</option>
                                @endforeach
                            </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.AccountsReceivable')</label>
                            <div>
                                <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                </v-select>
                                <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.AccountsPayable')</label>
                            <div>
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                    </v-select>
                                    <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                            </div>
                        </div>
                        @if (fingerprint() =='true')
                        <div class="col-md-1">
                            <label>@lang('layout.Fingerprint')</label>
                            <div class="col-md-12 mt-checkbox">
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" name="addfinger" @if($employee->finger_device == 'on') checked="" @endif >
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        @endif
                    </div>
                    </div>


                    <br>

                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------Begin Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TAB PORTLET-->
                            <div class="portlet light bordered" >
                                
                                <div class="portlet-body">
                                    <div class="tabbable tabbable-tabdrop">
                                        <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                                            <!-- <li class="dropdown pull-right tabdrop"><a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false"><i class="fa fa-ellipsis-v"></i>&nbsp;<i class="fa fa-angle-down"></i> <b class="caret"></b></a><ul class="dropdown-menu"><li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false">Section 8</a>
                                            </li></ul></li> -->
                                            <li class="active">
                                                <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.Reference')</a>
                                            </li> 
                                            
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="tab1">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Address1')</label>
                                                              {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.Address2')</label>
                                                                {!! Form::text('address2', null, array('placeholder' =>__('layout.Address2'),'class' => 'form-control')) !!}
                                                     </div>
                                                     <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.PostCode')</label>
                                                                 {!! Form::number('post_code', null, array('placeholder' => __('layout.PostCode'),'class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                          <label class="control-label">@lang('layout.City')</label>
                                                              {!! Form::text('city', null, array('placeholder' =>__('layout.City'),'class' => 'form-control')) !!}
                                                  </div>
                          
                                                  <div class="col-md-6" id="countries">
                                                          <label class="control-label ">@lang('layout.Country')</label>
                                                          <div >
                                                             <v-select label="name" v-model="selectedCountry" :options="countries">
                                                              </v-select>
                                                              <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                              <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                          </div>
                                                  </div>
                                              </div>
                                            </div>
                                            <div class="tab-pane " id="tab2">
                                                <div class="row" id="countries_code">
                                                    <div class="col-md-6">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                            <div class="col-md-7">
                                                                {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                                            </div>
                                                            <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                        </div>
                                                    </div>
                                                     <div class="col-md-6">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::number('phone2', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                     <div class="col-md-3">
                                                            <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    <div class="col-md-3">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Password')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::text('password', null, array('placeholder' => __('layout.Password'),'class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab5">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                            {!! Form::text('date_of_birth', null, array('placeholder' => __('layout.DateOfBirth'),'class' => 'form-control date','autocomplete' => 'off')) !!}
                                                    </div>
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Date')</label>
                                                                {!! Form::text('reg_date', null, array('placeholder' => __('layout.Date'),'class' => 'form-control date','autocomplete' => 'off')) !!}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab6">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                            <?php
                                                                $photo = null;
                                                                if($employee && $employee->photo!=null)
                                                                {
                                                                    $photo =  $employee->photo;
                                                                }
                                                            ?>
                                                            <div class="col-md-4">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                        <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                                    </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                                            style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                                <span class="btn default btn-file">
                                                                                    <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                    <!-- <input type="file" name="photo">  -->
                                                                                    {!! Form::file('photo', []) !!}</span>
                                                                            {!! Form::hidden('photo1', (!$employee)?null:$employee->photo) !!}
                                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                                            data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="tab-pane " id="tab7">
                                                <div class="row" id="app2">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.BloodGroup')</label>
                                                        <select name="blood_group" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            <option value="+O" <?php if($employee->blood_group == '+O'){ echo 'selected';} ?> >+O</option>
                                                            <option value="+A" <?php if($employee->blood_group == '+A'){ echo 'selected';}?> >+A</option>
                                                            <option value="+B" <?php if($employee->blood_group == '+B'){ echo 'selected';}?> >+B</option>
                                                            <option value="+AB" <?php if($employee->blood_group == '+AB'){ echo 'selected';}?> >+AB</option>
                                                            <option value="-O" <?php if($employee->blood_group == '-O'){ echo 'selected';}?> >-O</option>
                                                            <option value="-A" <?php if($employee->blood_group == '-A'){ echo 'selected';}?> >-A</option>
                                                            <option value="-B" <?php if($employee->blood_group == '-B'){ echo 'selected';}?> >-B</option>
                                                            <option value="-AB" <?php if($employee->blood_group == '-AB'){ echo 'selected';}?> >-AB</option>
                                                        </select>
                                                    </div>  
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('menu.EmployeeAttendanceClass')</label>
                                                        <div>
                                                            <v-select  label="name" :options="attendance_class" v-model="selected_attendance_class" ></v-select>
                                                            <input type="hidden" name="attendance_class_id" :value="!selected_attendance_class?null:selected_attendance_class.id" >
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.BossName')</label>
                                                        <div>
                                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member" :multiple="true" > </v-select>
                                                            <input type="hidden" name="parent_id" :value="parent_id.length > 0 ? parent_id:null">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Membership')</label>
                                                        <div style="border: 1px dotted ;">
                                                            <label class="radio-inline">
                                                                <input type="radio" name="membership" @if($employee->membership == 'free') checked @endif value="free"> @lang('layout.Free') </label>
                                                            <label class="radio-inline">
                                                            <input type="radio" name="membership" @if($employee->membership == 'professiona') checked @endif value="professiona" > @lang('layout.Professional') </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Class')</label>
                                                        <select name="class" class="form-control select_style">
                                                            <option value="">کلاس را انتخاب کنید</option>
                                                            @forEach($class as $key => $value)
                                                                <option value="{{$key}}" {{$employee-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                                            @endforeach
                                                        </select>
                                                        {{-- {!! Form::select('class', $class,$employee->class_id, array('class' => 'form-control')) !!} --}}
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Gender')</label>
                                                        <div style="border: 1px dotted ;">
                                                            <label class="radio-inline">
                                                                <input type="radio" name="gender" @if($employee->gender == 'male') checked @endif value="male"> @lang('layout.Male') </label>
                                                            <label class="radio-inline">
                                                            <input type="radio" name="gender" @if($employee->gender == 'female') checked @endif value="female" > @lang('layout.Female') </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control">{{$employee->description}}</textarea>   
                                                    </div>
                                                    <!--/span-->
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.GrandFather')</label>
                                                        {!! Form::text('grand_father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.CurrentLocation')</label>
                                                        {!! Form::text('current_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.MainLocation')</label>
                                                        {!! Form::text('main_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.NationalNumber')</label>
                                                        {!! Form::text('national_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.NationalVolume')</label>
                                                        {!! Form::text('national_volume', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Page')</label>
                                                        {!! Form::text('national_page', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.RegistrationNumber')</label>
                                                        {!! Form::text('national_reg_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.IntroducedBy')</label>
                                                        {!! Form::text('introduced_by', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.Nationality')</label>
                                                        {!! Form::text('nationality', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.CardOwner')</label>
                                                        {!! Form::text('card_owner', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.CardNumber')</label>
                                                        {!! Form::text('card_number', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.ShabaNumber')</label>
                                                        {!! Form::text('shaba_number', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.Bank')</label>
                                                        {!! Form::text('bank', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.Branch')</label>
                                                        {!! Form::text('branch', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>

                                            </div>
                                            <div class="tab-pane " id="tab8">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                             <label class="control-label">@lang('layout.JobTitle')</label>
                                                                 {!! Form::select('job_title_id[]', $jobTitle,$employee->memberJobtitle, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'job_title')) !!}
                                                     </div>
                                                    <div class="col-md-6">
                                                            <label for="employee-task" class="control-label">@lang('layout.EmployeeTask')</label>
                                                            <div >
                                                                <select name="employee_task" id="employee-task" class="list-style form-control">
                                                                    <option>@lang('layout.Select')</option>
                                                                    @foreach($priceLevels as $priceLevel)
                                                                        <option value="{{ $priceLevel->id }}"
                                                                            @if($employee->member_payroll_price_level_id == $priceLevel->id)
                                                                                selected
                                                                            @endif>
                                                                            {{$priceLevel->name}}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                    </div>
                                                    <!--/span-->
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab9" >
                                                <div id="guarantor">
                                                    <div class="row"  style="border: 1px solid rgba(82, 82, 82, 0.169);padding:15px;border-radius: 5px; margin-bottom: 10px;" v-for="(item,index) in member_guarantor">
                                                        <div class="col-lg-12">
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="control-label">@lang('layout.Name')</label>
                                                                    {!! Form::text('gu_name[]', null, array('v-model' =>'(!item)?null:item.gu_name','class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <label class="control-label">@lang('layout.FatherName')</label>
                                                                    {!! Form::text('gu_father_name[]', null, array('v-model' =>'(!item)?null:item.gu_father_name','class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div> 
                                                                <div class="col-md-3">
                                                                    <label class="control-label" >@lang('layout.Phone')</label>
                                                                    {!! Form::text('gu_phone[]', null, array('v-model' =>'(!item)?null:item.gu_phone', 'class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div> 
                                                                <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Email')</label>
                                                                    {!! Form::text('gu_email[]', null, array('v-model' =>'(!item)?null:item.gu_email','tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Address')</label>
                                                                    {!! Form::text('gu_address[]', null, array('v-model' =>'(!item)?null:item.gu_address','tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <label class="control-label">@lang('layout.City')</label>
                                                                    {!! Form::text('gu_city[]', null, array('v-model' =>'(!item)?null:item.gu_city','tabindex' =>'5','class' => 'form-control')) !!}
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.District')</label>
                                                                    {!! Form::text('gu_district[]', null, array('v-model' =>'(!item)?null:item.gu_district','tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                                </div>
                                                                <div class="col-md-3">
                                                                    <label class="control-label ">@lang('layout.Village')</label>
                                                                    {!! Form::text('gu_village[]', null, array('v-model' =>'(!item)?null:item.gu_village','class' => 'form-control')) !!}
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                {{-- <div class="col-md-3">
                                                                    <label class="control-label  ">@lang('layout.Country')</label>
                                                                    <v-select label="name" v-model="selectedCountry1" :options="countries"> </v-select>
                                                                    <input type="hidden" name="gu_country[]" :value="(selectedCountry1==null)?null:selectedCountry1.name">
                                                                </div> --}}
                                                            </div>
                                                        </div>
                                                        <!--/span-->
                                                    </div>
                                                    <button type="button" @click="addNew()" class="btn btn-success">
                                                        <i class="fa fa-plus"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------End Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>


                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <div class="row">
                                <div class="col-md-12">
                                     <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <a href="{{route('employee.index')}}" type="button" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection
@push('scripts')

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    Vue.component('v-select', VueSelect.VueSelect);

  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $employee !!};

    var countries = {!!$countries!!};
    var selectedCountry = {!!$selectedCountry!!};

    var employeeAttendanceClass={!! json_encode($employeeAttendanceClass) !!};
    var selected_attendance_class={!! json_encode($selected_attendance_class) !!};

  new Vue({
    el:'#app',
    data:{
        employee_attendance_type:"{{$attendance_type}}",
        attendance_type: [
            {tag: 'daily', type: '@lang("layout.Daily")'},
            {tag: 'hourly', type: '@lang("layout.Hourly")'},
            {tag: 'shifty', type: '@lang("layout.Shifty")'}
            ],
        selected_attendance_type: null,
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
        identify_type: null

    },
    mounted:function(){
        if (customer.identify_type) {
                this.identify_type = customer.identify_type;
        }
        this.attendance_type.forEach((at_type) => {
            if (at_type.tag == this.employee_attendance_type) {
                this.selected_attendance_type = at_type;
                return;
            }
        })

        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
            //      this.selected_receivable=this.receivable[j];
            //   }
          }

          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }
    },
    

  });  

  var vu = new Vue({
    el:'#app2',
    data:{
        // employee_attendance_type:"{{$attendance_type}}",

        attendance_type: [
            {tag: 'daily', type: '@lang("layout.Daily")'},
            {tag: 'hourly', type: '@lang("layout.Hourly")'},
            {tag: 'shifty', type: '@lang("layout.Shifty")'}
            ],
        selected_attendance_type: null,
        member:[],
        parent_id:[],
        selectedMember: null,
        attendance_class:employeeAttendanceClass,
        selected_attendance_class:selected_attendance_class
    },

    watch: {
        selectedMember: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
            x.push(e.id);
            });

            this.parent_id = x;
            // console.log('x value');
            // console.log(x);
        }
    }, 

    created(){

        // this.attendance_type.forEach((at_type) => {
        //     if (at_type.tag == this.employee_attendance_type) {
        //         this.selected_attendance_type = at_type;
        //         return;
        //     }
        // })

        @if($selectedMember)
        this.selectedMember = {!! $selectedMember !!};
        @endif
    },

    methods:{
        
        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            var multitype = ['Owner', 'Supervisor'];
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    multitype: multitype
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vu.member = [];
                    vu.member = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

    }

  });


  new Vue({
    el:'#countries',
    data:{
        countries:countries,
        selectedCountry:selectedCountry
    }
   
  });  
  new Vue({
    el:'#countries_code',
    data:{
        countries:countries,
        selectedCountry:selectedCountry
    }
   
  });

let memberGuarantor = {!! json_encode( $memberGuarantor ) !!}
 var gua =  new Vue({
    el:'#guarantor',
    data:{
        employee: [],
        member_guarantor:
        [],
        memberGuarantor: memberGuarantor
    },
    mounted:function(){
        for(var i=0; i< this.memberGuarantor.length; i++ ){
            this.member_guarantor.push({
                gu_name: this.memberGuarantor[i].name,
                gu_father_name: this.memberGuarantor[i].father_name,
                gu_phone: this.memberGuarantor[i].phone,
                gu_email: this.memberGuarantor[i].email,
                gu_address: this.memberGuarantor[i].address,
                gu_city: this.memberGuarantor[i].city,
                gu_district: this.memberGuarantor[i].district,
                gu_village: this.memberGuarantor[i].village,
            });

        }

        // for(var m = 4; m > this.memberGuarantor.length; m--){
        //     this.nmember_guarantorote.push({
        //         gu_name: null,
        //     })
        // }
        // console.log(this.member_guarantor);
    },
    methods:{
        addNew(index) {
            console.log("ddddd");
            if (this.member_guarantor[index + 1] == undefined) {
                this.member_guarantor.push({gu_name: null, gu_father_name: null,gu_grand_father_name:null,gu_phone:null});
            }
        }
    }
    

  });  



    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });

</script>
@endpush