@extends('layouts.app')
@section('style')
 <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
    <style>
        .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@stop
@section('content')
    <div class="row"  id="app" v-cloak>
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewEmployee') </span>
                </div>
                <div class="tools">  
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'employee.store','method'=>'POST','class'=>'form-horizontal','files'=> true,'id'=>'employee-save-form',)) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.FullName')</label>
                                        {!! Form::text('name', null, array('class' => 'form-control','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!} 
                                        <span class="required">@{{ errors.first('name') }}</span>
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code',$code, array('placeholder' => 'Code','class' => 'form-control')) !!}  
                        </div>   
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.CardId')</label>
                                    {!! Form::number('id_card',$id_card, array('placeholder' => __('layout.CardId'),'class' => 'form-control')) !!}
                        </div>
                        <!--/span-->
                    </div>
					
					<div class="row">
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Type')</label>
                                <div >
                                <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                                    @foreach($type as $key=>$value)
                                        @if($value == __('type.Employee'))
                                            <option selected value="{{$key}}">{{$value}}</option>
                                        @else
                                            <option value="{{$key}}">{{$value}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                </div>
                        </div>
						<div class="col-md-2">
                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                            {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'class' => 'form-control','autocomplete'=>'off')) !!}
                        </div>
                        <div class="col-md-2">
                            <label class="control-label">@lang('layout.FatherName')</label>
                            {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'class' => 'form-control')) !!} 
                        </div>
                        <div class="col-md-2">
                            <label class="control-label">@lang('layout.IdentifyType')</label>
                            <select name="identify_type" id="" class="form-control">
                                <option value=""> @lang('layout.Select') </option>
                                <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                            </select>
                        </div> 
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.AttendanceType')</label>
                            <select name="attendance_type" class="form-control">
                                <option disabled="disabled">@lang('layout.SelectType')</option>
                                <option value="daily">@lang('layout.Daily')</option>
                                <option value="hourly">@lang('layout.Hourly')</option>
                                <option value="shifty">@lang('layout.Shifty')</option>
                            </select>
                        </div>   
                        <!--/span-->
                       
                        <!--/span-->
                    </div> 
                    <!--/row-->


                    
                    <div class="row">
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.SalaryType')</label>
                            <select name="salaryType" class="form-control">
                                <option disabled selected>@lang('layout.SelectType')</option>
                                <option value="Daily">@lang('layout.Daily')</option>
                                <option value="Weekly">@lang('layout.Weekly')</option>
                                <option value="TwoWeek">@lang('layout.TwoWeek')</option>
                                <option value="TwiceAMonth">@lang('layout.TwiceAMonth')</option>
                                <option value="Montly">@lang('layout.Montly')</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('menu.Shift')</label>
                            <div >
                            <select name="shift" class="list-style form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach($shift as $key=>$value)
                                    <option value="{{$value->id}}">{{$value->name}}</option>
                                @endforeach
                            </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                <div>
                                    <v-select label="name" v-model="selected_receivable" :options="receivable">
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                </div>
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                <div>
                                      <v-select label="name" v-model="selected_payable" :options="payable">
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                </div>
                        </div>
                        @if (fingerprint() =='true')
                        <div class="col-md-1">
                            <label>@lang('layout.Fingerprint')</label>
                            <div class="col-md-12 mt-checkbox">
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" name="addfinger">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        @endif
                    </div>



                    <br>
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------Begin Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TAB PORTLET-->
                            <div class="portlet light bordered" >
                                
                                <div class="portlet-body">
                                    <div class="tabbable tabbable-tabdrop">
                                        <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                                            <!-- <li class="dropdown pull-right tabdrop"><a class="dropdown-toggle" data-toggle="dropdown" href="#" aria-expanded="false"><i class="fa fa-ellipsis-v"></i>&nbsp;<i class="fa fa-angle-down"></i> <b class="caret"></b></a><ul class="dropdown-menu"><li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false">Section 8</a>
                                            </li></ul></li> -->
                                            <li class="active">
                                                <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                            </li>

                                            <li class="">
                                                <a href="#tab3" data-toggle="tab" aria-expanded="false"><i class="fa fa-money"></i> @lang('layout.OpeningBalance')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                            </li> 
                                            @if(getFlour()=="true")
                                            <li class="">
                                                <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-user"></i> @lang('layout.Guarantor')</a>
                                            </li>
                                            @endif
                                            <li class="">
                                                <a href="#tab10" data-toggle="tab" aria-expanded="false"><i class="fa fa-reply-all"></i>@lang('layout.Reference')</a>
                                            </li>
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="tab1">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                            <label class="control-label ">@lang('layout.Address1')</label>
                                                              {!! Form::text('address1', null, array('class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-3">
                                                            <label class="control-label ">@lang('layout.Address2')</label>
                                                            {!! Form::text('address2', null, array('class' => 'form-control')) !!}
                                                     </div>
                                                     <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.PostCode')</label>
                                                            {!! Form::number('post_code', null, array('class' => 'form-control')) !!} 
                                                    </div>

                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-6">
                                                          <label class="control-label">@lang('layout.City')</label>
                                                            {!! Form::text('city', null, array('class' => 'form-control')) !!}
                                                  </div>
                          
                                                  <div class="col-md-6" id="countries">
                                                          <label class="control-label">@lang('layout.Country')</label>
                                                             <v-select label="name" v-model="selectedCountry" :options="countries">
                                                              </v-select>
                                                              <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                              <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                  </div>
                                              </div>
                                            </div>
                                            <div class="tab-pane" id="tab2">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                            <div class="col-md-7">
                                                                {!! Form::text('phone', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                            <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                    </div>
                            
                                                    <div class="col-md-6">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::number('phone2', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                            
                                                    <!--/span-->
                                                   
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                        <div class="col-md-9">
                                                            {!! Form::text('email', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                </div> 
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab3">
                                                <!---start currency----->
                                                <div class="row" style="margin: 0px">
                                                       <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                           <thead>
                                                               <th>#</th>
                                                               <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                               <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                               <th style="min-width: 300px">@lang('layout.Receivable')</th>
                                                               <th style="min-width: 300px">@lang('layout.Payable')</th>
                                                               <th style="min-width: 300px">@lang('layout.Description')</th>
                                                           </thead>
                                                           <tbody>
                                                               <tr v-for="(currencies,index) in currency">
                                                                   <td class="hilight">
                                                                       <div class="input-group">
                                                                         <span>@{{currencies.id}}</span>
                                                                      
                                                                       </div>
                                                                   </td>
                                                                   <td class="hilight">
                                                                       <div class="input-group">
                                                                         <label>@{{currencies.code}}</label>
                                                                         <input type="hidden" :name="'op_currency_code['+index+']'" :value="(!currencies)?null:currencies.code" />
                                                                       </div>
                                                                   </td>
                                                                   <td class="hilight">
                                                                         <input type="number" :name="'op_currency_rate['+index+']'" v-model="(!currencies)?null:currencies.exchange_rate"  :readonly="(!currencies)?null:currencies.code == defaultCurrency()['code']" class="form-control" />
                                                                   </td>
                                                                   <td class="hilight">
                                                                            <input type="number" :name="'op_receivable['+index+']'" class="form-control" :disabled="!!currencies.payable"
                                                                                   v-model.number="currencies.receivable" />
                                                                            
                                                                            <input type="hidden" :name="'op_type['+index+']'" class="form-control"
                                                                                   :value="(currencies.payable && currencies.payable !=null && currencies.payable !=0)?'payable':(currencies.receivable && currencies.receivable !=null && currencies.receivable !=0)?'receivable':''">
                                                                   </td>
                                                                   <td class="hilight">
                                                                        <input type="number" :name="'op_payable['+index+']'" class="form-control" :disabled="!!currencies.receivable"
                                                                               v-model.number="currencies.payable" />
                                                                    </td>
                                                                    <td class="hilight">
                                                                        <textarea name="descriptionTwo[]" id="" cols="30" rows="1" class="form-control"></textarea>
                                                                    </td>
                                                               </tr>
                                                           </tbody>
                                                       </table>
                                                   
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab5">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                                                            <div class="col-md-9">
                                                                 <input type="text" id="reg_date" name="reg_date" class="form-control date" autocomplete="off" >
                                                                 
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                                            <div class="col-md-9">
                                                                <input type="text" id="date_of_birth" name="date_of_birth" class="form-control date" autocomplete="off">
                                                                 
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab6">

                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                     

                                                        <?php
                                                        // $logo = null;
                                                        // if($company && $company->logo!=null)
                                                        // {
                                                        //     $logo =  $company->logo;
                                                        // }
                                                    ?>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="#" alt=""/>
                                                            </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail"
                                                                    style="max-width: 200px; max-height: 150px;"></div>
                                                                <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <!-- <input type="file" name="photo">  -->
                                                                            {!! Form::file('photo', []) !!}</span>
                                                                    <a href="javascript:;" class="btn default fileinput-exists"
                                                                    data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    </div>
                                                </div>

                                            </div>
                                            <div class="tab-pane" id="tab7">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.BloodGroup')</label>
                                                        <select name="blood_group" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            <option value="+O">+O</option>
                                                            <option value="+A">+A</option>
                                                            <option value="+B">+B</option>
                                                            <option value="+AB">+AB</option>
                                                            <option value="-O">-O</option>
                                                            <option value="-A">-A</option>
                                                            <option value="-B">-B</option>
                                                            <option value="-AB">-AB</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-3" >
                                                        <label class="control-label">@lang('menu.EmployeeAttendanceClass')</label>
                                                        <v-select label="name" :options="attendance_class" v-model="selected_attendance_class"></v-select>
                                                        <input type="hidden" name="attendance_class_id" :value="!selected_attendance_class?null:selected_attendance_class.id" >
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.BossName')</label>
                                                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member" :multiple="true" > </v-select>
                                                        <input type="hidden" name="parent_id" :value="parent_id.length > 0 ? parent_id:null">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Membership')</label>
                                                        <div style="border: 1px dotted ;">
                                                            <label class="radio-inline">
                                                                <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') 
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input type="radio" name="membership" value="professiona" >@lang('layout.Professional') 
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3" id="memberClassDiv">
                                                        <label class="control-label ">@lang('layout.Class')</label>
                                                        {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => __('layout.SelectClass')])}}
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Gender')</label>
                                                        <div style="border: 1px dotted ;">
                                                            <label class="radio-inline">
                                                                <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') 
                                                            </label>
                                                            <label class="radio-inline">
                                                                <input type="radio" name="gender" value="female" > @lang('layout.Female') 
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control"></textarea>  
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.GrandFather')</label>
                                                        {!! Form::text('grand_father_name', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.CurrentLocation')</label>
                                                        {!! Form::text('current_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.MainLocation')</label>
                                                        {!! Form::text('main_location', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.NationalNumber')</label>
                                                        {!! Form::text('national_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.NationalVolume')</label>
                                                        {!! Form::text('national_volume', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Page')</label>
                                                        {!! Form::text('national_page', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.RegistrationNumber')</label>
                                                        {!! Form::text('national_reg_number', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.IntroducedBy')</label>
                                                        {!! Form::text('introduced_by', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Nationality')</label>
                                                        {!! Form::text('nationality', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label">@lang('layout.CardOwner')</label>
                                                        {!! Form::text('card_owner', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.CardNumber')</label>
                                                        {!! Form::text('card_number', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.ShabaNumber')</label>
                                                        {!! Form::text('shaba_number', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.Bank')</label>
                                                        {!! Form::text('bank', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class="control-label">@lang('layout.Branch')</label>
                                                        {!! Form::text('branch', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab8">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                         <div class="form-group">
                                                             <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                             <div class="col-md-9">
                                                                 <select role="button"    name="job_title_id[]" multiple="multiple"  class="list-style form-control" id="job_title">
                                                                     @foreach($jobTitle as $key=>$value)
                                                                      
                                                                          @if($value == 'Customer')
                                                                             <option selected value="{{$key}}">{{$value}}</option>
                                                                         @else
                                                                             <option value="{{$key}}">{{$value}}</option>
                                                                         @endif
                                                                        
                                                                     @endforeach
                                                                 </select>
                                                             </div>
                                                         </div>
                                                    </div>
                                                     
                            
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label for="employee-task" class="control-label col-md-3">@lang('layout.EmployeeTask')</label>
                                                            <div class="col-md-9">
                                                                <select name="employee_task" id="employee-task" class="list-style form-control">
                                                                    <option>@lang('layout.Select')</option>
                                                                    @foreach($priceLevels as $priceLevel)
                                                                        <option value="{{ $priceLevel->id }}">
                                                                            {{$priceLevel->name}}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--/span-->
                                                </div>
                                                <!--/row-->
                                            </div>
                                            @if(getFlour()=="true")
                                            <div class="tab-pane" id="tab9">
                                                    <div v-for="(item,index) in member_guarantor" style="margin-bottom: 40px;">
                                                            <span style="color: rgb(84, 199, 211)">@lang('layout.Guarantor')--(@{{index+1}})</span>
                                                            
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.Name')</label>
                                                                {!! Form::text('gu_name[]', null, array('class' => 'form-control','@click'=>"addNew(index)",'autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-2">
                                                                <label class="control-label">@lang('layout.FatherName')</label>
                                                                {!! Form::text('gu_father_name[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-2">
                                                            <label class="control-label ">@lang('layout.GrandFather')</label>
                                                            {!! Form::text('gu_grand_father_name[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                        <div class="col-md-4">
                                                                <label class="control-label" >@lang('layout.Phone')</label>
                                                                {!! Form::text('gu_phone[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div> 
                                                    </div> 
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.Address')</label>
                                                                {!! Form::text('gu_address[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label">@lang('layout.City')</label>
                                                                    {!! Form::text('gu_city[]', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label class="control-label  ">@lang('layout.Country')</label>
                                                            {!! Form::text('gu_country[]', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-2">
                                                            <label class="control-label ">@lang('layout.District')</label>
                                                            {!! Form::text('gu_district[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-2">
                                                            <label class="control-label ">@lang('layout.Village')</label>
                                                            {!! Form::text('gu_village[]', null, array('class' => 'form-control')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.CurrentLocation')</label>
                                                                {!! Form::text('gu_current_location[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.MainLocation')</label>
                                                                {!! Form::text('gu_main_location[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.JobTitle')</label>
                                                                {!! Form::text('gu_job_title[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.NationalNumber')</label>
                                                                {!! Form::text('gu_national_number[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.NationalVolume')</label>
                                                                {!! Form::text('gu_national_volume[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-2">
                                                                <label class="control-label ">@lang('layout.Page')</label>
                                                                {!! Form::text('gu_national_page[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-2">
                                                                <label class="control-label ">@lang('layout.RegistrationNumber')</label>
                                                                {!! Form::text('gu_national_reg_number[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                                <label class="control-label ">@lang('layout.IntroducedBy')</label>
                                                                {!! Form::text('gu_introduced_by[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                        </div>
                                                        <div class="col-md-4">
                                                            {{-- {!! Form::file('gu_photo[]', null, array('class' => 'form-control')) !!}  --}}
                                                            {{-- <input :name="'gu_photo['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')"> --}}
                                                            {{-- <div class="form-group">
                                                                    <div class="col-md-8">
                                                                        <div class="fileinput fileinput-new" data-provides="fileinput" style="padding-top: 7px;"> 
                                                                            <div class="fileinput-new thumbnail" style="width: 100px; height: 70px;">
                                                                            <img src="#" alt=""/>
                                                                            </div>
                                                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                                                style="max-width: 200px; max-height: 150px;"></div>
                                                                            <div>
                                                                                    <span class="btn default btn-file">
                                                                                        <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                        <!-- <input type="file" name="photo">  -->
                                                                                        {!! Form::file('gu_photo[]', []) !!}</span>
                                                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                                                data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div> --}}
                                                            </div>
                                                    </div>

                                                    <br>
                                                        <span  @click="addNew('index')">
                                                            <i class="fa fa-plus" style="color: green; font-size:20px;cursor: pointer;" ></i>
                                                        </span>
                                                        <span v-if="member_guarantor.length >1 "  v-on:click="deleteItem('index')"><i
                                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;font-size:20px;cursor: pointer;"></i></span>


                                                    </div>

                                            </div>
                                            @endif
                                            <div class="tab-pane" id="tab10">  
                                                <div class="row" style="border: 1px solid rgba(82, 82, 82, 0.169);padding:15px;border-radius: 5px; margin-bottom: 10px;" v-for="(item,index) in member_guarantor">
                                                    <div class="col-lg-12">
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <label class="control-label">@lang('layout.Name')</label>
                                                                {!! Form::text('gu_name[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div> 
                                                            <div class="col-md-3">
                                                                <label class="control-label">@lang('layout.FatherName')</label>
                                                                {!! Form::text('gu_father_name[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div> 
                                                            <div class="col-md-3">
                                                                <label class="control-label" >@lang('layout.Phone')</label>
                                                                {!! Form::text('gu_phone[]', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div> 
                                                            <div class="col-md-3">
                                                                <label class="control-label ">@lang('layout.Email')</label>
                                                                {!! Form::text('gu_email[]', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                        </div> 
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <label class="control-label ">@lang('layout.Address')</label>
                                                                {!! Form::text('gu_address[]', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-md-3">
                                                                <label class="control-label">@lang('layout.City')</label>
                                                                {!! Form::text('gu_city[]', null, array('tabindex' =>'5','class' => 'form-control')) !!}
                                                            </div>
                                                            <div class="col-md-3">
                                                                <label class="control-label ">@lang('layout.District')</label>
                                                                {!! Form::text('gu_district[]', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                            </div>
                                                            <div class="col-md-3">
                                                                <label class="control-label ">@lang('layout.Village')</label>
                                                                {!! Form::text('gu_village[]', null, array('class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            {{-- <div class="col-md-3">
                                                                <label class="control-label  ">@lang('layout.Country')</label>
                                                                <v-select label="name" v-model="selectedCountry1" :options="countries"> </v-select>
                                                                <input type="hidden" name="gu_country[]" :value="(selectedCountry1==null)?null:selectedCountry1.name">
                                                            </div> --}}
                                                            {{-- <div class="col-md-3">
                                                                <div class="form-group">
                                                                    <label class="control-label col-md-2">@lang('layout.Photo')</label><br>
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="padding-top: 7px;"> 
                                                                        <div class="fileinput-new thumbnail" style="width: 200px; height: 40px;">
                                                                        <img src="#" alt=""/>
                                                                        </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px;"></div>
                                                                        <div>
                                                                            <span class="btn default btn-file">
                                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                <!-- <input type="file" name="photo">  -->
                                                                                {!! Form::file('gu_photo[]', null) !!}
                                                                            </span>
                                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div> --}}
                                                        </div>
                                                    </div>
                                                </div>
                                                <button type="button" @click="addNew" class="btn btn-success">
                                                    <i class="fa fa-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>

                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------End Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>

                </div>
                 
                <div class="form-actions" >
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row" >
                                <div class="col-md-12 text-center">
                                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit') </button>
                                    <button type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                    <a href="{{route('employee.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>
    </div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>



  @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
  Vue.use(VeeValidate, {
    locale: 'en',
  });
  @endif


    Vue.component('v-select', VueSelect.VueSelect);



  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var currency={!! json_encode($currency) !!};
  var employeeAttendanceClass={!! json_encode($employeeAttendanceClass) !!};
  var countries = {!!$countries!!};


  var vu = new Vue({
    el:'#app',
    data:{
        payable:payable,
        selected_payable:null,
        receivable:receivable,
        currency:currency,
        selected_receivable:null,
        disabled: false,
        attendance_class:employeeAttendanceClass,
        selected_attendance_class:null,
        selectedCountry1:{
            id:'Afghanistan',
            name:'Afghanistan',
            dial_code:'0093'
        },
        countries:countries,
        selectedCountry:{
            id:'Afghanistan',
            name:'Afghanistan',
            dial_code:'0093'
        },
        member:[],
        parent_id:[],
        selectedMember: null,
        member_guarantor:
            [
                {gu_name: null, gu_father_name: null,gu_grand_father_name:null,gu_phone:null}

            ] 

    },

    watch: {
        selectedMember: function(newVal, oldVal) {
            let x = [];
            newVal.forEach(function(e) {
            x.push(e.id);
            });

            this.parent_id = x;
            // console.log('x value');
            // console.log(x);
        }
    },

    methods:{
        handleSubmit(e) {
            this.$validator.validate().then(valid => {
                if (valid) {
                    // console.log(e);
                    // alert(e.target);
                    regForm(e.target);
                }
            });
        },
        // generic function for adding item to list
        addNew(index) {
            if (this.member_guarantor[index + 1] == undefined) {
                this.member_guarantor.push({gu_name: null, gu_father_name: null,gu_grand_father_name:null,gu_phone:null});
            }
        },
        saveAndNew() {
            this.$validator.validate()
            
            .then(valid => {
                if (valid) {
                    vu.disabled = true;
                    var url = "{{route('employee.store')}}";
                    form_id = 'employee-save-form';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                        .then(function (response) {
                            toggleBlock(0);
                            if (response.data.result == 1) {
                                $('#' + form_id).trigger('reset');
                                //$('#success-sound')[0].play();
                                toastr.success('', response.data.message);
                                location.reload();
                                
                            }
                            else {
                                var message = "{{__('message.Warning')}}";
                                vu.disabled = false;
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                            }
                        })
                        .catch(function (error) {
                            toggleBlock(0);
                            vu.disabled = false;
                            console.log(error);
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        });

                }
            })
        },

        MemberSearch: _.debounce((search, loading) => {
            loading(true);
            var multitype = ['Owner', 'Supervisor'];
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'SearchMember', 
                    keyword: search,
                    multitype: multitype
                }
            })
            .then(function(response) {
                if (response.data.length > 0) {
                    // console.log(response.data);
                    vu.member = [];
                    vu.member = response.data;
                }
                loading(false);
            })
            .catch(function(error) {
                loading(false);
                console.log(error);
            })
        }, getDebounceTime()),

        addNew(index) {
            console.log('fdd')
            if (this.member_guarantor[index + 1] == undefined) {
                this.member_guarantor.push({gu_name: null, gu_father_name: null,gu_grand_father_name:null,gu_phone:null});
            }

        },
        deleteItem(index) {
            this.member_guarantor.splice(index, 1);
        }, 
        
    },
    mounted:function(){
        if(this.payable)
        {
            this.selected_payable=this.payable[0];

        }
         if(this.receivable)
        {
            this.selected_receivable=this.receivable[0];
        }
    }
  });  

    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });

</script>
 
@endpush