@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-ribbon.css')}}" rel="stylesheet" type="text/css">
<style>

.mt-element-ribbon .ribbon {
      float: {{(session()->get('system_direction') == 'ltr')? "left":"right"}};
}
</style>
@endsection
@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.EmployeeAssessmentShow')
            </div>
            <div class="tools">
            </div> 
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Code')</th>
                        <th>@lang('layout.Employee')</th>
                        <th>@lang('menu.EmployeeAssessmentCategory')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>{{$employeeAssessment->number}}</td>
                        <td>{{$employeeAssessment->code}}</td>
                        <td>{{$employeeAssessment->employee_name}}</td>
                        <td>{{$employeeAssessment->assessment_category_name}}</td>
                        <td>{{$employeeAssessment->date}}</td>
                        <td>{{$employeeAssessment->user}}</td>

                    </tr>
            
                    </tbody>
                </table>
                @if($employeeAssessment->type && $employeeAssessment->amount > 0)
                <br>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Amount')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>{{__('layout.'.ucfirst($employeeAssessment->type))}}</td>
                        <td>{{$employeeAssessment->currency}}</td>
                        <td>{{$employeeAssessment->rate}}</td>
                        <td>{{myRound($employeeAssessment->amount)}}</td>
                    </tr>
            
                    </tbody>
                </table>
                @endif
            </div>
            <div class="row">
                @if($employeeAssessment->comments)
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <div class="ribbon ribbon-color-default uppercase">@lang('layout.Comments')</div>
                        <p class="ribbon-content">
                            {{$employeeAssessment->comments}}
                        </p>
                    </div>
                </div>
                @endif
                @if($employeeAssessment->labels)
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <div class="ribbon ribbon-color-default uppercase">@lang('layout.Labels')</div>
                        <p class="ribbon-content">
                            {{$employeeAssessment->labels}}
                        </p>
                    </div>
                </div>
                @endif
                @if($employeeAssessment->description)
                <div class="col-lg-4 col-md-4 col-xs-12">
                    <div class="mt-element-ribbon bg-grey-steel">
                        <div class="ribbon ribbon-color-default uppercase">@lang('layout.Description')</div>
                        <p class="ribbon-content">
                            {{$employeeAssessment->description}}
                        </p>
                    </div>
                </div>
                @endif
            </div>

          

        </div>
    </div>


@endsection