@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('menu.PlattsRate') {{$platts_category_name}}</h4>
  @if($from_date || $to_date)
  <table class="main-table">
      <tr class="bg">
          @if($from_date)
              <td>
                  <span>@lang('layout.FromDate')</span>:
                  <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
              </td>
          @endif
          @if($to_date)
              <td>
                  <span>@lang('layout.ToDate')</span>:
                  <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
              </td>
          @endif
      </tr>
  </table>
  <br>
  @endif

  
{{-- <table class="main-table">
    <thead>
    <tr style="background-color: yellow">
      <th>@lang('layout.Record')</th>
      <th>@lang('menu.PlattsCategory')</th>
      <th>@lang('layout.Date')</th>
      <th>@lang('layout.Currency')</th>
      <th>@lang('layout.Rate')</th>
      <th>@lang('layout.Items')</th>
    </tr>
    </thead>

    <?php
      $count = 0;
    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
      $plattsRateDetail = $record['plattsRateDetail'];
    ?>
    <tr>
      <td class="center">{{++$count}}</td>
      <td class="center">{{$record['platts_category']}}</td>
      <td class="center">{{convertDate($record['date'])}}</td>
      <td class="center">{{$record['currency']}}</td>
      <td class="center">{{$record['rate']}}</td>
      
	  <td >
      <table class="main-table" style="width:100%">
        <tr class="bg">
          <td width="50%" class="center">@lang('layout.Item')</td>
          <td width="50%" class="center">@lang('layout.Rate')</td>
        </tr>
        @foreach($plattsRateDetail AS $row)
        <tr>
          <td class="center">{{$row['name']}}</td>
          <td class="center">{{myRound($row['amount'])}}</td>
        </tr>
        @endforeach
      </table>
	  </td>
    </tr>
    @endforeach

  </tbody>
</table> --}}

{{-- <table class="main-table">
  <thead>
  <tr style="background-color: yellow">
    <th>@lang('layout.Record')</th>
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Currency')</th>
  </tr>
  </thead>

  <?php
    $count = 0;
  ?>
  <tbody>
  @foreach($data AS $record)
  <?php
    $plattsRateDetail = $record['plattsRateDetail'];
  ?>
  <tr style="background-color: rgb(234, 212, 185)">
    <td class="center">{{++$count}}</td>
    <td class="center">{{convertDate($record['date'])}}</td>
    <td class="center">{{$record['currency']}}</td>
  </tr>
  @foreach($plattsRateDetail AS $row)
  <tr>
      <tr>
        <td class="center">{{$row['name']}}</td>
        <td class="center">{{myRound($row['amount'])}}</td>
      </tr>
    </tr>
    @endforeach
  @endforeach

</tbody>
</table> --}}

<?php
$count = 0;
?>

<table class="main-table">
  @foreach($data AS $record)
  <thead>
    
  <tr style="background-color: rgb(247, 247, 122)">
    <th>@lang('layout.Record') : {{++$count}}</th>
    <th>@lang('layout.Date') @lang('layout.Jalali'): {{convertDate($record['date'])}}</th>
    <th>@lang('layout.Date') @lang('layout.Gregorian'): {{$record['date']}}</th>
    <th>@lang('layout.Currency') : {{$record['currency']}}</th>
  </tr>
  </thead>
  <tbody>
  
  <?php
    $plattsRateDetail = $record['plattsRateDetail'];
  ?>
  <tr style="background-color: rgb(234, 212, 185)">
    <td class="center"></td>
    <td class="center">@lang('layout.Item')</td>
    <td class="center">@lang('layout.Measure')</td>
    <td class="center">@lang('layout.Rate')</td>
  </tr>
  @foreach($plattsRateDetail AS $row)
      <tr>
        <td class="center">{{$count}}</td>
        <td class="center">{{$row['name']}}</td>
        <td class="center">{{$row['symbol']}}</td>
        <td class="center">{{myRound($row['amount'])}}</td>
      </tr>
    @endforeach
</tbody>
@endforeach
</table>




<table class="main-table">
  <tr style="background-color: rgb(243, 243, 214)">
   <td><div class="center"><b>@lang('layout.Qty1')</b></div></td>
   <td><div class="center">{{count($data)}}</div></td>
 </tr>
 </table>
 
 <table class="main-table">
 <tr style="background-color: rgb(243, 243, 214)">
   <td style="font-weight: bold" class="center"> @lang('layout.Record')</td>
   <td style="font-weight: bold" class="center"> @lang('layout.Item') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Total') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Average') </td>
   <td style="font-weight: bold" class="center"> @lang('layout.Currency') </td>
 </tr>
 <?php
 $count=0;
 foreach($total As $t)
 {
   ?>
   <tr style="background-color: rgb(243, 243, 214)">
     <td class="center">{{++$count}}</td>
     <td class="center">{{$t->name}}</td>
     <td class="center">{{myRound($t->amount)}}</td>
     <td class="center">{{myRound($t->amount/count($data))}}</td>
     <td class="center">{{$t->currency}}</td>
 
   </tr>
   <?php
 }
 ?>
 
 </table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection