@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<style>

</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EmployeeAssessmentCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'employeeAssessment.store','method'=>'POST','class'=>'form-horizontal','id'=>'employee_assessment_form')) !!}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Employee')</label>
                                     <v-select
                                      label="name" 
                                      v-model="selected_member" 
                                      :options="memberlist"
                                      @search="onMemberSearch"
                                      >
                                      <template #option="option">
                                        <span v-if="option.photo"><img :src="imagePath+'/'+option.photo" style="height: 40px;width:40px"> @{{option.name}} </span>
                                      </template>
                                    </v-select>
                                    <input type="hidden" name="employee_id" :value="(selected_member==null)?null:selected_member.id" v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    <span class="required">@{{ errors.first('employee_id') }}</span>
                                </div>
                            </div> 
                        </div> 
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('menu.EmployeeAssessmentCategory')</label>
                                     <v-select label="name" v-model="selected_assessment_category" :options="assessmentCategory">
                                    </v-select>
                                    <input type="hidden" name="assessment_category_id" :value="(selected_assessment_category==null)?null:selected_assessment_category.id" v-validate="'required'" data-vv-as="@lang('menu.EmployeeAssessmentCategory')">
                                    <span class="required">@{{ errors.first('platts_category_id') }}</span>
                                </div>
                            </div> 
                        </div> 
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Number')</label>
                                  <input type="number" name="number" value="{{$number}}" v-validate="'required|numeric'" data-vv-as="@lang('layout.Number')" class="form-control" autocomplete="off">
                                  <span class="required">@{{ errors.first('number') }}</span>
                                </div>
                            </div> 
                        </div> 
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Code')</label>
                                  <input type="text" name="code"  class="form-control" autocomplete="off">
                                </div>
                            </div> 
                        </div> 
                      </div>
                      <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                          <div class="form-group">
                               <div class="col-md-12">
                                <label class="control-label">@lang('layout.Date')</label>
                                  <input type="text" name="date" class="form-control date" autocomplete="off">
                              </div>
                          </div> 
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Comments')</label>
                                  {!! Form::textarea('comments', null, array('class' => 'form-control','rows' => 2)) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                          <div class="form-group">
                              <div class="col-md-12">
                                <label class="control-label">@lang('layout.Labels')</label>
                                {!! Form::textarea('labels', null, array('class' => 'form-control','rows' => 2)) !!}
                              </div>
                          </div>
                        </div> 
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Description')</label>
                                  {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 2,'v-model'=>'(!selected_assessment_category)?null:selected_assessment_category.description')) !!}
                                </div>
                            </div>
                        </div> 
                      </div>
                      <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="border: 1px dotted; margin-top: 10px;">
                            <div class="md-radio-inline">
                                <div class="md-radio">
                                    <input type="radio" id="radio1" name="type" v-model="assessment_type" value="rewards" class="md-radiobtn" :checked="assessment_type == 'rewards'">
                                    <label for="radio1">
                                        <span class="inc"></span>
                                        <span class="check"></span>
                                        <span class="box"></span> @lang('layout.Rewards') </label>
                                </div>
                                <div class="md-radio">
                                    <input type="radio" id="radio2" name="type" v-model="assessment_type" value="fines" class="md-radiobtn" :checked="assessment_type == 'fines'">
                                    <label for="radio2">
                                        <span class="inc"></span>
                                        <span class="check"></span>
                                        <span class="box"></span> @lang('layout.Fines') </label>
                                </div>
                            </div>
                        </div>

                      </div>
                      <br>

                      
                      


                  <!-- begin Payments Reward and Penalty-->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover" v-show="assessment_type">
                      <thead>
                          <tr>
                              <th class="text-center">@lang('layout.Account')</th>
                              <th class="text-center">@lang('layout.Currency')</th>
                              <th class="text-center"> @lang('layout.Rate')</th>
                              <th class="text-center">@lang('layout.Amount')</th>

                          </tr>
                      </thead>
                      <tbody>
                          <tr>
                            <td class="highlight" v-if="assessment_type == 'fines'">
                              <v-select label="name" v-model="selected_income" :options="income_accounts">
                              </v-select>
                              <input type="hidden" name="account_id" :value="(selected_income == null)?null:selected_income.id">
                            </td>
                            <td class="highlight" v-if="assessment_type == 'rewards'">
                              <v-select label="name" v-model="selected_expense" :options="expense_accounts">
                              </v-select>
                              <input type="hidden" name="account_id" :value="(selected_expense == null)?null:selected_expense.id">
                            </td>

                              <td class="highlight">
                                <v-select label="code" v-model="selected_currency" :options="currency">
                                  
                                </v-select>
                                <input type="hidden" name="currency" :value="(selected_currency==null)?null:selected_currency.code" >
                              </td>
                              <td>
                                <input type="number" :disabled="(selected_currency==null)?false:(selected_currency.code =='{{getHomeCurrency()['code']}}')"  v-model.number="(!selected_currency)?null:selected_currency.rate" class="form-control">
                                <input v-if="selected_currency !=null" type="hidden" name="rate" :value="selected_currency.rate">
                              </td>
                              <td class="highlight">
                                  <input type="text" name="amount" class="form-control" autocomplete="off" tabindex="1">
                              </td> 
                          </tr>
                      </tbody>

                  </table>
                  <!-- end Payments Reward and Penalty -->       
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <button type="button" class="btn blue" :disabled="disabled"  @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('employeeAssessment.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')
<script type="text/javascript">

  @if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
  Vue.use(VeeValidate, {
      locale: 'en',
  });
  @endif

  Vue.component('v-select', VueSelect.VueSelect);

  var assessmentCategory      = {!! $assessmentCategory !!}
  var currency                = {!! $currency !!}
  var homeCurrency            = {!!json_encode(getHomeCurrency()) !!};
  var income_accounts         = {!! $income_accounts !!}
  var expense_accounts        = {!! $expense_accounts !!}

  var imagePath = "{{url('uploads/')}}";
  


  var v =  new Vue({
    el: '#app',
    data: {
      disabled:false,
      assessmentCategory:assessmentCategory,
      selected_assessment_category:null,
      currency:currency,
      selected_currency:null,
      memberlist: [],
      selected_member:null,
      selected_currency:homeCurrency,
      assessment_type:'',
      income_accounts:income_accounts,
      expense_accounts:expense_accounts,
      selected_income:null,
      selected_expense:null,
      // "1714195219.PNG"
      imagePath:imagePath
      


    },
    methods:
    {

      onMemberSearch(search, loading) {
            loading(true);
            this.searchMember(search, loading, this);
        },

        searchMember(search, loading, vm) {
            axios.get("{{route('callMethod.search')}}", {
                params: {
                    method_name: 'member',
                    type: 'Employee',
                    search: search,
                }
            })
              .then(function (response) {
                  this.memberlist = [];
                  if (response.data.length > 0) {
                      vm.memberlist = response.data;
                  }
                  loading(false);
              })
              .catch(function (error) {
                  console.log(error);
              })
        },

      saveAndNew() {
        this.$validator.validate()
            
        .then(valid => {
          if (valid) {
            v.disabled = true;
            var url = "{{route('employeeAssessment.store')}}";
            form_id = 'employee_assessment_form';
            var data = $('#' + form_id).serialize();
                    console.log('data',data)
            toggleBlock(true);
            axios.post(url, data)
              .then(function (response) {
                toggleBlock(0);
                if (response.data.result == 1) {
                  $('#' + form_id).trigger('reset');
                  //$('#success-sound')[0].play();
                  toastr.success('', response.data.message);
                  location.reload();
                  
                }
                else {
                  var message = "{{__('message.Warning')}}";
                  v.disabled = false;
                  //$('#error-sound')[0].play();
                  toastr.warning('', message);
                }
              })
              .catch(function (error) {
                            toggleBlock(0);
                v.disabled = false;
                console.log(error);
                var message = "{{__('message.Warning')}}";
                //$('#error-sound')[0].play();
                toastr.warning('', message);
              });

          }
        })
      }
    }

  });

</script>


@endpush