@extends('layouts.app')
@section('style')
    <style type="text/css">
        .customer_p{
            font-size:30px;
            font-weight:bold;
            font-style:normal;
            color: #32c5d2;
        }
    </style>

@endsection

@section('content')

<?php
$report = customeReportNew('employee_assessment_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_code= !in_array('code', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_assessmentCategory= !in_array('assessmentCategory', $report);
$_type= !in_array('type', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_amount= !in_array('amount', $report);
$_comments= !in_array('comments', $report);
$_labels= !in_array('labels', $report);
$_description= !in_array('description', $report);


$report_percent = customeReportNewPercent('employee_assessment_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_assessmentCategory_percent= (array_key_exists('assessmentCategory___percent', $report_percent))?$report_percent['assessmentCategory___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
$_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
$_comments_percent= (array_key_exists('comments___percent', $report_percent))?$report_percent['comments___percent']:null;
$_labels_percent= (array_key_exists('labels___percent', $report_percent))?$report_percent['labels___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;

// dd($report, $report_percent);

?>
<div id="app">
    <h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeAssessmentReport') - JSPDF</h3>


        <button @click="printjs">@lang('layout.Print')</button>

    @if($from_date || $to_date || $assessment_category_name)
    <table class="main-table">
        <tr class="bg">
            @if($assessment_category_name)
                <td>
                    <span>@lang('menu.EmployeeAssessmentCategory')</span>: {{$assessment_category_name}}
                </td>
            @endif 
            @if($from_date)
                <td>
                    <span>@lang('layout.FromDate')</span>:
                    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                </td>
            @endif
            @if($to_date)
                <td>
                    <span>@lang('layout.ToDate')</span>:
                    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                </td>
            @endif
        </tr>
    </table>
    <br>
    @endif



    <table class="table table-striped table-bordered table-advance" id="emp_ass"> 
            <tr style="background-color: #d8d8f7">
                @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
                @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
                @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
                {{-- @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif --}}
                @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif>@lang('layout.Code')</th>@endif
                @if(!$member)
                    @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.Employee')</th>@endif
                @endif
                @if(!$assessment_category_name)
                @if($_assessmentCategory)<th @if($_assessmentCategory_percent) width="{{$_assessmentCategory_percent}}%" @endif>@lang('menu.EmployeeAssessmentCategory')</th>@endif
                @endif
                @if($_comments)<th @if($_comments_percent) width="{{$_comments_percent}}%" @endif>@lang('layout.Comments')</th>@endif
                @if($_labels)<th @if($_labels_percent) width="{{$_labels_percent}}%" @endif>@lang('layout.Labels')</th>@endif
            </tr>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
        <tr>
            @if($_record)<td class="center">{{++$count}}</td>@endif
            @if($_number)<td class="center">{{$record->number}}</td>@endif
            @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
            {{-- @if($_description)<td class="center" style="text-align: center;">{{$record->description}}</td>@endif --}}
            @if($_code)<td class="center">{{$record->code}}</td>@endif
            @if(!$member)
                @if($_employee)<td style="text-align: center;">{{$record->employee_name}}</td>@endif
            @endif
            @if(!$assessment_category_name)
            @if($_assessmentCategory)<td class="center">{{$record->assessment_category_name}}</td>@endif
            @endif
            @if($_comments)<td  style="text-align: center;">{{$record->comments}}</td>@endif
            @if($_labels)<td  style="text-align: center;">{{$record->labels}}</td>@endif

        </tr>
        @endforeach
    </table>
    <br>
    <table class="table" id="second_table">
        <tr>
            
            <th>@lang('layout.Record')</th>
            <th>@lang('menu.EmployeeAssessmentCategory')</th>
            <th>@lang('layout.Total')</th>
        </tr>
        @foreach($count_date AS $key=>$value)
        <tr>
            <td class="center">{{++$key}}</td>
            <td class="center">{{$value->category_name}}</td>
            <td class="center">{{$value->total_category}}</td>
        </tr>
        @endforeach
    </table>

    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table>

                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>

                </table>
            </td>
            @endforeach
        </tr>
    </table>
</div>
<!-- End signature -->
@endsection

@push('scripts')
<script src="{{url('assets/app/js/app.js')}}"></script>
        <script src="{{url('assets/app/js/all-lrt.js')}}"></script>
<script src="{{url('/vuejs/vue.min.v2.6.12.js')}}"></script>
<script src="{{ url('/js/jspdf.umd.min.js') }}" type="text/javascript"></script>
<script src="{{ url('/js/jspdf.plugin.autotable.js') }}" type="text/javascript"></script>

    <script>


    let v = new Vue({
            el: '#app',
            data: {
                name:"saeed"
            },
            methods: {
                printjs(){
                    const { jsPDF } = jspdf
                    const {autoTable} ='jspdf-autotable'
                    const doc = new jsPDF({
                        orientation: 'p',
                        unit: 'mm',
                        format: 'a4',
                        // encryption: {
                        //     userPassword: "user",
                        //     ownerPassword: "saeed",
                        //     userPermissions: ["print", "modify", "copy", "annot-forms"]
                        // }
                    });
                    

                    axios.get("{{route('note.create')}}")
                    .then(function (response) {

                        var fontPath = "{{url('Farsi_font/'.getFont().'.ttf')}}";
                        var company_logo = "{{company()['logo']}}";
                        // company_logo = (company_logo)?company_logo:"logo.png";
                        // var logoPath = "{{url('uploads')}}"+"/"+company_logo;
                        
                        company_logo = "logo.png";
                        var logoPath = "{{url('uploads')}}"+"/"+company_logo;
                        
                        
                        console.log('daaaaaaaaaaa',response,fontPath,logoPath,company_logo);
                        var body = response.data.note_all;
                        var company_name = response.data.company_name;
                        var company_phone = response.data.company_phone;
                        var y = 10;
                        doc.addFileToVFS("CustomeFont.ttf", fontPath);
                        doc.addFont(fontPath, 'CustomeFont', 'normal');
                        doc.setFont('CustomeFont');
                        doc.setLineWidth(2);
                        // doc.text("Test Company this is a header", 10, y=y+10);
                        doc.autoPrint({variant: 'non-conform'});
                        doc.setTextColor(40);
                        doc.setDirection = "rtl";
                        // doc.setLanguage("en-US");

                        // const pageCount = doc.internal.getNumberOfPages();
                        // for (let i = 1; i <= pageCount; i++) {
                        //     doc.setPage(i);
                        //     doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                        // }

                        if (logoPath) {
                            doc.addImage(logoPath, "png", 10, 15, 10, 10);
                        }
                        doc.setFontSize(25);
                        doc.setTextColor(255,0,0)

                        var companyTextWidth = doc.getTextWidth(company_name);
                        var pageWidth = doc.internal.pageSize.getWidth();
                        var companyCenterX = ((pageWidth-companyTextWidth)/2) + (companyTextWidth/2);

                        doc.text(company_name, companyCenterX, 22,'center')

                        doc.setFontSize(12);
                        doc.setTextColor(255,0,0)
                        
                        var companyPhoneTextWidth = doc.getTextWidth(company_phone);
                        var companyPhoneRightX = pageWidth - companyPhoneTextWidth - 10;
                        doc.text(company_phone, companyPhoneRightX, 22)
                        
                        doc.setLineWidth(0.2);
                        doc.line(10, y+18, 200, y+18);
                        // doc.setR2L(true);
                        
                        //this add for rtl
                        var rtlTable = $('#emp_ass').clone();
                        rtlTable.find('tr').each(function(){
                            var tds = $(this).children('td,th').get().reverse();
                            $(this).append(tds);
                        })
                        var first_table_title  = "@lang('layout.EmployeeAssessmentReport')";
                        var firstTableTextWidth = doc.getTextWidth(first_table_title);
                        var pageWidth = doc.internal.pageSize.getWidth();
                        var firstTableCenterX = ((pageWidth-firstTableTextWidth)/2) + (firstTableTextWidth/2);

                        doc.text(first_table_title,firstTableCenterX,y+25,'center')
                        doc.autoTable({
                            body: body,
                            // html: '#emp_ass',
                            // html: rtlTable.get()[0],
                            startY: y+30,
                            useCss:true,
                            // head:[['Date','Number','Amount','Currency']],
                            // columns: [
                            //     { dataKey: 'id', header: '@lang("layout.ID")' },
                            //     { dataKey: 'name', header: '@lang("layout.Name")' },
                            //     { dataKey: 'fatherName', header: '@lang("layout.FatherName")' },
                            //     { dataKey: 'description', header: '@lang("layout.Description")' },
                            // ],
                            foot:[['','','Amount','Currency','']],
                            theme: 'grid',
                            // theme: 'striped',
                            styles:{
                                font:'CustomeFont',
                                fontSize:12,
                                //this add for rtl
                                halign:'right'

                            },
                            bodyStyles:{
                                // cellWidth:22.75
                            },
                            columnStyles:{
                                0: {
                                    cellWidth:32.75
                                },1: {
                                    cellWidth:22.75
                                },2: {
                                    cellWidth:22.75
                                },3: {
                                    cellWidth:22.75
                                },4: {
                                    cellWidth:22.75
                                },5: {
                                    cellWidth:22.75
                                },6: {
                                    cellWidth:22.75
                                },7: {
                                    cellWidth:12.75
                                }
                            },
                            didDrawPage: function(data) {
                                console.log(data);

                                var currentdate = new Date(); 
                                var datetime =   currentdate.getDate() + "/"
                                                + (currentdate.getMonth()+1)  + "/" 
                                                + currentdate.getFullYear() + " ----- "  
                                                + currentdate.getHours() + ":"  
                                                + currentdate.getMinutes() + ":" 
                                                + currentdate.getSeconds();
                                // const currentPage = data.pageNumber;
                                // const pageNumber = `Page ${currentPage} - ${datetime}`;
                                // doc.setFontSize(10);
                                // doc.text(pageNumber,100,285);

                                // const pageCount = doc.internal.getNumberOfPages();
                                // for (let i = 1; i <= pageCount; i++) {
                                //     doc.setFontSize(10);
                                //     doc.setPage(i);
                                //     doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                                // }

                                doc.setFontSize(20);
                                doc.setTextColor(255,0,0)
                                // doc.text("CHACO Company  - َشرکت حسابدار خبره", 10, 10);
                                // doc.addImage(logoPath, "png", 10, 10, 10, 10);


                                // if (logoPath) {
                                //     doc.addImage(logoPath, "png", data.settings.margin.left, 15, 10, 10);
                                // }
                                // doc.text('Report', data.settings.margin.left + 80, 22)
                                // doc.text('Phone', data.settings.margin.left + 120, 22)


                                // doc.line(3, 70, margins.width + 43,70);
                                // doc.setLineWidth(0.2);
                                // doc.line(10, y+18, 200, y+18);

                               
                                
                                
                                //create image data using base64
                                // var imgData = 'data:image/jpeg;base64,'+ Base64.encode('Koala.jpeg');
                                // doc.addImage(imgData, 'JPEG', 10, 10, 200, 200);


                                // doc.setLineWidth(1);
                                // doc.line(10, y, 200, y);
                            }
                        })

                        // center text 
                        var second_table_title  = "@lang('layout.EmployeeAssessmentReport')";
                        var textWidth = doc.getTextWidth(second_table_title);
                        var pageWidth = doc.internal.pageSize.getWidth();
                        var centerX = ((pageWidth-textWidth)/2) + (textWidth/2);

                        finalY = doc.lastAutoTable.finalY
                        doc.text(second_table_title,centerX,finalY+10,'center');
                         //this add for rtl
                         var rtlTable2 = $('#second_table').clone();
                         rtlTable2.find('tr').each(function(){
                            var tds = $(this).children('td,th').get().reverse();
                            $(this).append(tds);
                        })

                         //Second Table
                         doc.autoTable({
                            // columns: [
                            //     { dataKey: 'id', header: '@lang("layout.ID")' },
                            //     { dataKey: 'name', header: '@lang("layout.Name")' },
                            //     { dataKey: 'fatherName', header: '@lang("layout.FatherName")' },
                            //     { dataKey: 'description', header: '@lang("layout.Description")' }
                            // ],
                            // body: body,
                            html:rtlTable2.get()[0],
                            startY:finalY+20,
                            // showHead: 'firstPage',
                            styles:{
                                font:'CustomeFont',
                                fontSize:12,
                                // cellPadding:1,
                                // lineWidth:0.2,
                                // lineColor:[200,80,120]

                            },
                            // margin: { left: 107 },
                            didDrawPage: function(data) {
                                console.log(data);

                                var currentdate = new Date(); 
                                var datetime =   currentdate.getDate() + "/"
                                                + (currentdate.getMonth()+1)  + "/" 
                                                + currentdate.getFullYear() + " ----- "  
                                                + currentdate.getHours() + ":"  
                                                + currentdate.getMinutes() + ":" 
                                                + currentdate.getSeconds();

                                // const currentPage = data.pageNumber;
                                // const pageNumber = `Page ${currentPage} - ${datetime}`;
                                
                                // doc.text(pageNumber,100,285);

                                doc.setFontSize(20);
                                doc.setTextColor(255,0,0)
                                // doc.text("CHACO Company  - َشرکت حسابدار خبره", 10, 10);
                                // doc.line(3, 70, margins.width + 43,70);

                               
                            }
                        })


                        //Page Number
                        const pageCount = doc.internal.getNumberOfPages();
                        for (let i = 1; i <= pageCount; i++) {
                            doc.setPage(i);
                            doc.setFontSize(10);
                            doc.setTextColor(255,0,0)
                            doc.text('Page ' + String(i)+ ' of ' + String(pageCount),100,285,null,null,"right");
                        }

                        


                        doc.save('auto_table_with_javascript_data');

						
                    })
                    .catch(function (error) {
                    });




                }
            }
        })


    </script>
@endpush