@extends('layouts.factor-master')
@section('style')
    <style type="text/css">
        .customer_p{
            font-size:30px;
            font-weight:bold;
            font-style:normal;
            color: #32c5d2;
        }
    </style>

@endsection

@section('content')

<?php
$report = customeReportNew('employee_assessment_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_code= !in_array('code', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_assessmentCategory= !in_array('assessmentCategory', $report);
$_type= !in_array('type', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_amount= !in_array('amount', $report);
$_comments= !in_array('comments', $report);
$_labels= !in_array('labels', $report);
$_description= !in_array('description', $report);


$report_percent = customeReportNewPercent('employee_assessment_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_assessmentCategory_percent= (array_key_exists('assessmentCategory___percent', $report_percent))?$report_percent['assessmentCategory___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
$_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
$_comments_percent= (array_key_exists('comments___percent', $report_percent))?$report_percent['comments___percent']:null;
$_labels_percent= (array_key_exists('labels___percent', $report_percent))?$report_percent['labels___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;


?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeAssessmentReport')</h3>
<p>@lang('layout.Type'): {{__('layout.'.ucfirst($assessment_type))}}</p>

@if($member)
<table class="main-table">
    <tr class="center">
        <td class="customer_p">{{$member->name}}</td>
        <td>@lang('layout.Code') : {{$member->code}}</td>
        <td>@lang('layout.JobTitle') : {{$member->job_name}}</td>
        <td>@lang('layout.Email') : {{$member->email}}</td>
        <td>@lang('layout.Phone') : {{$member->phone}}, {{$member->phone2}}</td>

    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">

            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
            @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            {{-- @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif --}}
            @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif>@lang('layout.Code')</th>@endif
            @if(!$member)
                @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.Employee')</th>@endif
            @endif
            @if($_assessmentCategory)<th @if($_assessmentCategory_percent) width="{{$_assessmentCategory_percent}}%" @endif>@lang('menu.EmployeeAssessmentCategory')</th>@endif
            @if($_comments)<th @if($_comments_percent) width="{{$_comments_percent}}%" @endif>@lang('layout.Comments')</th>@endif
            @if($_labels)<th @if($_labels_percent) width="{{$_labels_percent}}%" @endif>@lang('layout.Labels')</th>@endif
            @if($_type)<th @if($_type_percent) width="{{$_type_percent}}%" @endif>@lang('layout.Type')</th>@endif
            @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif>@lang('layout.Currency')</th>@endif
            @if($_rate)<th @if($_rate_percent) width="{{$_rate_percent}}%" @endif>@lang('layout.Rate')</th>@endif
            @if($_amount)<th @if($_amount_percent) width="{{$_amount_percent}}%" @endif>@lang('layout.Amount')</th>@endif


        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_number)<td class="center">{{$record->number}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        {{-- @if($_description)<td class="center" style="text-align: center;">{{$record->description}}</td>@endif --}}
        @if($_code)<td class="center">{{$record->code}}</td>@endif
        @if(!$member)
            @if($_employee)<td style="text-align: center;">{{$record->employee_name}}</td>@endif
        @endif
        @if($_assessmentCategory)<td class="center">{{$record->assessment_category_name}}</td>@endif
        @if($_comments)<td style="text-align: center;">{{$record->comments}}</td>@endif
        @if($_labels)<td style="text-align: center;">{{$record->labels}}</td>@endif
        @if($_type)<td class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif
        @if($_currency)<td class="center">{{$record->currency}}</td>@endif
        @if($_rate)<td class="center">{{$record->rate}}</td>@endif
        @if($_amount)<td class="center">{{myRound($record->amount)}}</td>@endif


    </tr>
    @endforeach
</table>

<br>
<table class="main-table">
    <tr>
        
        <th>@lang('layout.Record')</th>
        <th>@lang('menu.EmployeeAssessmentCategory')</th>
        <th>@lang('layout.Total')</th>
    </tr>
    @foreach($count_data AS $key=>$value)
    <tr>
        <td class="center">{{++$key}}</td>
        <td class="center">{{$value->category_name}}</td>
        <td class="center">{{$value->total_category}}</td>
    </tr>
    @endforeach
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection