@extends('layouts.factor-master')
@section('style')
    <style type="text/css">
        .customer_p{
            font-size:30px;
            font-weight:bold;
            font-style:normal;
            color: #32c5d2;
        }
    </style>

@endsection

@section('content')

<?php
$report = customeReportNew('employee_assessment_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_code= !in_array('code', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_assessmentCategory= !in_array('assessmentCategory', $report);
$_type= !in_array('type', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_amount= !in_array('amount', $report);
$_comments= !in_array('comments', $report);
$_labels= !in_array('labels', $report);
$_description= !in_array('description', $report);


$report_percent = customeReportNewPercent('employee_assessment_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_assessmentCategory_percent= (array_key_exists('assessmentCategory___percent', $report_percent))?$report_percent['assessmentCategory___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
$_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
$_comments_percent= (array_key_exists('comments___percent', $report_percent))?$report_percent['comments___percent']:null;
$_labels_percent= (array_key_exists('labels___percent', $report_percent))?$report_percent['labels___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;

// dd($report, $report_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeAssessmentReport')</h3>


@if($from_date || $to_date)
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif




@if($assessment_category_name)
<table class="main-table">
    <tr class="bg">
        @if($assessment_category_name)
            <td>
                <span>@lang('menu.EmployeeAssessmentCategory')</span>: {{$assessment_category_name}}
            </td>
        @endif 
       
    </tr>
</table>
<br>
@endif


@if($member)
<table class="main-table">
    <tr class="center">
        <td class="customer_p">{{$member->name}}</td>
        <td>@lang('layout.Code') : {{$member->code}}</td>
        <td>@lang('layout.JobTitle') : {{$member->job_name}}</td>
        <td>@lang('layout.Email') : {{$member->email}}</td>
        <td>@lang('layout.Phone') : {{$member->phone}}, {{$member->phone2}}</td>

    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">
            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
            @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            {{-- @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif --}}
            @if($_code)<th @if($_code_percent) width="{{$_code_percent}}%" @endif>@lang('layout.Code')</th>@endif
            @if(!$member)
                @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.Employee')</th>@endif
            @endif
            @if(!$assessment_category_name)
            @if($_assessmentCategory)<th @if($_assessmentCategory_percent) width="{{$_assessmentCategory_percent}}%" @endif>@lang('menu.EmployeeAssessmentCategory')</th>@endif
            @endif

            @if($_comments)
                <th @if($_comments_percent) width="{{$_comments_percent}}%" @endif>@lang('layout.Comments')</th>
            @endif

            @if($_labels)
                <th @if($_labels_percent) width="{{$_labels_percent}}%" @endif>@lang('layout.Labels')</th>
            @endif
        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_number)<td class="center">{{$record->number}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        {{-- @if($_description)<td class="center" style="text-align: center;">{{$record->description}}</td>@endif --}}
        @if($_code)<td class="center">{{$record->code}}</td>@endif
        @if(!$member)
            @if($_employee)<td style="text-align: center;">{{$record->employee_name}}</td>@endif
        @endif
        @if(!$assessment_category_name)
        @if($_assessmentCategory)<td class="center">{{$record->assessment_category_name}}</td>@endif
        @endif
        @if($_comments)<td  style="text-align: center;">{{$record->comments}}</td>@endif
        @if($_labels)<td  style="text-align: center;">{{$record->labels}}</td>@endif

    </tr>
    @endforeach
</table>
<br>
<table class="main-table">
    <tr>
        
        <th>@lang('layout.Record')</th>
        <th>@lang('menu.EmployeeAssessmentCategory')</th>
        <th>@lang('layout.Total')</th>
    </tr>
    @foreach($count_date AS $key=>$value)
    <tr>
        <td class="center">{{++$key}}</td>
        <td class="center">{{$value->category_name}}</td>
        <td class="center">{{$value->total_category}}</td>
    </tr>
    @endforeach
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection