@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.EditEmployeeRewards')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
          
                {!! Form::model($employeeRewards, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['employeeRewards.update',$employeeRewards->id]]) !!}

                <div class="form-body">

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.EmployeeName')</label>
                        <div class="col-md-9">
                        <v-select @input="getSummary" class="vue-select2" v-model="selectedMember"
                            @search="MemberSearch" label="name" :options="employee">
                        </v-select>
                        <input type="hidden" name="member_id" v-model="(!selectedMember)?null:selectedMember.id"
                               v-validate="'required'" data-vv-as="@lang('layout.Member')">
                        <span class="required">@{{errors.first('member_id')}}</span>
                    </div>
                </div>
                </div>

                    <div class="col-md-4">
                        <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.ExpenseAccount')</label>
                        <div class="col-md-9">
                        <v-select placeholder="@lang('layout.ExpenseAccount')" tabindex = "5" label="name"  :options="expenses" v-model="expenseAccount" ></v-select>
                        <input type="hidden" name="expense_account" v-validate="'required'" data-vv-as="@lang('layout.ExpenseAccount')" :value="(expenseAccount)?expenseAccount.id:null">
                        <span class="required">@{{ errors.first('expense_account') }}</span>
                    </div>
                    </div>
                </div>
                    
                    <div class="col-md-4">
                                            
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Number'):</label>
                            <div class="col-md-9">
                                <input type="text" name="number" value="{{$employeeRewards->number}}" class="form-control" autocomplete="off">
                            </div>
                        </div>
                    </div>
                  
                   
                </div>
                <div class="row">
                  
                    <div class="col-md-4"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text"value="{{convertDate($employeeRewards->date)}}" name="date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                    </div>

               
                <div class="col-md-4">
                     
                      
                    <div class="form-group">
                        
                        <label class="control-label col-md-3">@lang('layout.Currency')</label>
                        <div class="col-md-9">
                         <v-select label="code" @input="selectedRate"
                          :options="currency"
                          v-model="selected_currency">
                                                                      
                         </v-select>
                        <input type="hidden" name="currency" :value="selected_currency.code">
                        </div>
                    </div>
                </div>  
                 <div class="col-md-4">
                     <div class="form-group">

                            <label class="control-label col-md-3">@lang('layout.Rate') </label>
                            <div class="input-group col-md-9">
                                <input v-model="selected_currency.exchange_rate" class="form-control"
                                       type="number" step="any" min="0">
                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                            </div>
                    </div>
                    <input type="hidden" name="currency_rate" :value="selected_currency.exchange_rate">
                </div>  
                




                    <div class="col-md-4" v-if="this.salaryAmount">
                        <div class="form-group">
                            <label class="control-label col-md-5">@lang('layout.AmountFromBasicSalary'): </label>
                            <div class="col-md-7">
                                <input type="checkbox" style="font-size:12px;height:20px"  v-model="use_basic_saraly">
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="row">
                    
                    <div class="col-md-4">
                                            
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Amount'):</label>
                            <div class="col-md-9">
                                <input type="number" name="amount" value="{{$employeeRewards->amount}}" class="form-control" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')">{{$employeeRewards->description}}</textarea>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-4" v-if="use_basic_saraly">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.BasicSalary'):</label>
                            <div class="input-group col-md-9">
                                <input type="number" class="form-control" :value="(!salary)?null:salary.amount" readonly>
                                    <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4" v-if="use_basic_saraly">
                        <span v-if="(selectedEmployee && selectedEmployee.currency != '{{getHomeCurrency()["code"]}}')?selectedEmployee.currency:null">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.SalaryRate'): </label>
                                <div :class="{'has-error':selectedCurrency.rate < 0}">
                                    <div class="input-group col-md-9">
                                        <input v-model="selectedEmployee.rate" class="form-control" 
                                               type="number" min="0" step="any" readonly>
                                        <span class="input-group-addon">@{{(selectedEmployee)?selectedEmployee.currency:null}}</span>
                                    </div>
                                </div>
                            </div>
                        </span>
                    </div>

                    
                    
                </div>
                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    {{-- <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> --}}
                    <a href="{{route('employeeRewards.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        let home = {!! $homeCurrency !!};
        let expenses = {!! $Expense !!};
        let employeeRewards = {!! $employeeRewards !!};
        // var work_time = {!!getCompanyWorkAmount()['hourly']!!};
        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: home,
                selectedOvertimeType : null,
                selectedEmployee     : null,
                expenses:expenses,
                expenseAccount:null,
                rate: 0,
                currency:{!! json_encode($currency) !!},
                selected_currency :{!! json_encode(Currency()->getCurrency()) !!},
                qty:null,
                employee:[],
                selectedMember:{!!$selectedMember!!},
                amount:null,
                salary:null,
                salaryAmount:0,
                farmer_contract_list:[],
                selectedFarmerContract:null,
                use_basic_saraly:null,
                work_time:8
            },
            mounted(){
                @if(getCompanyWorkAmount()['hourly'])
                var work_time = {!!getCompanyWorkAmount()['hourly']!!};
                this.work_time = work_time;
                @endif

                if (employeeRewards.expense_id) {
                    this.expenseAccount=_.find(expenses,(v)=>v.id==employeeRewards.expense_id);
                }
                
                this.checkSelected();

            },
            computed:{
                netPayable()
                        {
                            var total=0;
                            var qty     = parseFloat((this.qty)?this.qty:0);
                            if(this.selectedEmployee && this.use_basic_saraly) {
                                total=((this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])/(30*this.work_time))*qty;
                            }
                            else
                            {
                                total = this.amount*this.qty
                            }
                             return total;
                        },
                over_amount(){
                    var amount=this.amount;
                    if(this.selectedEmployee && this.use_basic_saraly)
                    {
                        amount = (this.salaryAmount * this.selectedCurrency.exchange_rate/this.selectedEmployee['rate'])/(30*this.work_time);
                    }
                    return amount;
                },
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },
            },
            methods: {
                checkSelected(){ 
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                            if(allCarrencies[x][z] == "{!! $employeeRewards->currency !!}"){

                                this.selected_currency = allCarrencies[x];
                                this.selected_currency.rate="{!! $employeeRewards->rate !!}";
                                this.selected_currency.exchange_rate="{!! $employeeRewards->rate !!}";
                                
                                break;
                            }
                        }

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            regForm(e.target);
                        }
                    });
                },
                MemberSearch: _.debounce((search, loading) => {  
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Employee'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.employee = [];
                            vu.employee = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('employeeRewards.store')}}";
                                form_id = 'employeeRewards';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selectedEmployee = null;
                                            vu.selectedOvertimeType = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },

                getSalary(){
                    if(this.selectedEmployee)
                    {   
                        this.getSalaryRecord(this.selectedEmployee.id);
                    
                    } 
                },
                
                getSummary() {
                    if (this.selectedMember) {
                        // this.getSummaryRecor(this.selectedMember.id, this);
                    }

                },
                
                
                getSalaryRecord(id)
                {
                        $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async:false,
                        data:{
                            method_name:'memberSalary',
                            employee_id:id,
                            },
                        success:function(data){
                            this.salary=data;

                            if(this.salary !=undefined && this.salary !=null)
                            {
                              this.salaryAmount=this.salary.amount;
                              this.selectedEmployee['currency']=this.salary.currency;
                              this.selectedEmployee['sal_id']=this.salary.id;
                              this.selectedEmployee['rate']=this.salary.rate;
                            }
                        }.bind(this),

                        error: function(error){
                            console.log(error)
                        }
                    });
                    
                },

                  // submit the form
	//    setData:function() {
	// 	this.expenseAccount= _.find({!!json_encode($Expense) !!}, (o) => o.id == {{$employeeRewards->expense_transaction_id}})

	// }
               
            }
        });
        // vu.setData();

    </script>
@endpush 