@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('employee_rewards_index');
$_record= !in_array('record', $report);
$_number= !in_array('number', $report);
$_date= !in_array('date', $report);
$_employee= !in_array('employee', $report);
$_amount= !in_array('amount', $report);
$_currency= !in_array('currency', $report);
$_account_name= !in_array('account_name', $report);
$_rate= !in_array('rate', $report);
$_description= !in_array('description', $report);



$report_percent = customeReportNewPercent('employee_rewards_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
$_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_account_name_percent= (array_key_exists('account_name___percent', $report_percent))?$report_percent['account_name___percent']:null; 

// dd($report, $report_percent); 

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.EmployeeLeavesReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
    <tr>
      @if($from_date)
      <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
<br>
@endif
<table class="main-table">
        <tr class="bg">
            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Record')</th>@endif
            @if($_number)<th @if($_number_percent) width="{{$_number_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif
            @if($_employee)<th @if($_employee_percent) width="{{$_employee_percent}}%" @endif>@lang('layout.EmployeeName')</th>@endif
            @if($_amount)<th @if($_amount_percent) width="{{$_amount_percent}}%" @endif>@lang('layout.Amount')</th>@endif
            @if($_rate)<th @if($_rate_percent) width="{{$_rate_percent}}%" @endif>@lang('layout.Rate')</th>@endif
            @if($_currency)<th @if($_currency_percent) width="{{$_currency_percent}}%" @endif>@lang('layout.Currency')</th>@endif
            @if($_account_name)<th @if($_account_name_percent) width="{{$_account_name_percent}}%" @endif>@lang('layout.AccountName')</th>@endif 
        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_number)<td class="center">{{$record->number}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif 
        @if($_employee)<td  style="text-align: center;">{{$record->employeename}}</td>@endif
        @if($_amount)<td class="center"> {{$record->amount}} </td>@endif
        @if($_rate)<td class="center" > {{$record->rate}}</td>@endif
        @if($_currency)<td class="center" > {{$record->currency}}</td>@endif
        @if($_account_name)<td class="center" > {{$record->account_name}}</td>@endif 
    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table> 
<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table> 
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr> 
            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection