@extends('layouts.app')

@section('content')



    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_statment'"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="type_name" value="Driver"/>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="1">@lang('layout.WithoutStatment')</option>
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <select name="class_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectClass')</option>
                                @foreach($member_class as  $class)
                                    <option value="{{$class->id}}">{{$class->name}}</option>
                                @endforeach
                            </select>
                        </div>
						
                    </div>
                    </div>
					<div class="row">
					<div class="form-group">
					<div class="col-md-4">
						<label class="control-label ">@lang('menu.TransportCompany') </label>
						<select name="tcompany_id" id="" class="form-control">
							<option value="">@lang('layout.SelectTransportCompany')</option>
							@foreach($transportCompany as  $tcompany)
                              <option value="{{$tcompany['id']}}">{{$tcompany['name']}}</option>
							@endforeach
						</select>
					</div>
                    <div class="col-md-4">
                        <label class="control-label ">@lang('layout.ReportType') </label>
                        <select name="report_type" id="" class="form-control">
                            <option value="">@lang('layout.SelectReportType')</option>
                            <option value="Receivable">@lang('layout.Payable')</option>
                            <option value="Payable">@lang('layout.Receivable')</option>
                        </select>
                    </div>
                    </div>

                </div>


                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off"
                                           name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off"
                                           name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.DriverOrCompanyList')</span>
                </div>
                <div class="tools">
				
				</div>
                <div class="pull-right">
                    @permission('driver-export')
                    <span id="anchore-modal">
                           <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                              <i class="fa fa-print"></i>
                           </a>
                       </span>
                    @endpermission
                    @permission('driver-create')
                    <a href="{{route('driver.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
			
				
            <div class="portlet-body" >

				<div class="col-md-4" id="driver_t">
					<div class="form-group">
						<!-- label class="control-label ">@lang('menu.TransportCompany') </label -->
						<select name="tcompany_id" @Click="getData()" v-model="tcompany_id" class="form-control">
							<option value="0">@lang('layout.SelectTransportCompany')</option>
							@foreach($transportCompany as  $tcompany)
                              <option value="{{$tcompany['id']}}">{{$tcompany['name']}}</option>
							@endforeach
						</select>
					</div>
				</div>
					
				<template v-cloak id="company_ll">
					<company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover"  cellspacing="0" width="100%" id="driver">
                    <thead>
                    <tr>
                        <th>@lang('layout.Code') </th>
                        <th>@lang('layout.FullName') </th>
                        <th>@lang('layout.LastName') </th>
                        <th>@lang('layout.FatherName') </th>
                        <th>@lang('layout.SSID') </th>
                        @if(getCustomerStatement() =="true")
                        <th>@lang('layout.TotalBalances') {{getHomeCurrency()["code"]}} </th> 
                        @endif
                        <th>@lang('layout.Phone') </th>
                        <th>@lang('layout.CreatedAt') </th>
                        <th>@lang('layout.User') </th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                    </thead>
                    <tfoot>

                    </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

 
	function getRecord()
    {	
		$('#driver').DataTable({
			ajax:{
				url:'{{route("driver.index")}}',
				data:{tcompany_id:vtr.tcompany_id}
			},
			pageLength: '{{getPageRows()}}',
            destroy: true,
			scrollCollapse: true,
			serverSide: true,
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
			paging: true,
			order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
			columns: [
				{data: 'code', name: 'code'},
				{data: 'name', name: 'name'},
				{data: 'last_name', name: 'last_name'},
				{data: 'father_name', name: 'father_name'},
				{data: 'ss_id', name: 'ss_id'},
				@if(getCustomerStatement() =="true") 
                {
                    data: 'totalBalances',
                    name: 'totalBalances',
                    orderable: false,
                    searchable: false
                }, 
                @endif
				{data: 'phone', name: 'phone'},
				{data: 'created_at', name: 'created_at', orderable: false, searchable: false},
				{data: 'user', name: 'users.name'},
				{data: 'actions', name: 'account', orderable: false, searchable: false},


			]
		});
	}
	
	    $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
	
			getRecord();
	
        });
        Vue.component('v-select', VueSelect.VueSelect);


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                memberlist: [],

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Driver',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });
		
        var vtr = new Vue({
            el: '#driver_t',
            data: {
                tcompany_id: 0,
            },
            methods: {
				getData(){
					getRecord();
				}
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });

    </script>


@endpush
