@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')
{{-- {{dd($driver)}} --}}
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.DriverOrCompanyEdit') </span>
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($driver,['method' => 'PATCH','route' => ['driver.update',$driver->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.FullName')</label>
                            {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control')) !!}
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                {!! Form::text('code', null, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.SSID')</label>
                                {!! Form::text('ss_id', null, array('placeholder' => __('layout.SSID'),'class' => 'form-control')) !!} 
                        </div> 
                        <!--/span-->
                    </div>
                    <!--/row-->

                <div class="row">
                      <div class="col-md-3">
                                <label class="control-label">@lang('layout.LastName')</label>
                                {!! Form::text('last_name', null, array('placeholder' => __('layout.LastName'),'class' => 'form-control')) !!} 
                        </div>   

                    <div class="col-md-3">
                            <label class="control-label">@lang('layout.FatherName')</label>
                            {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'class' => 'form-control')) !!}
                    </div>
                    <div class="col-md-3" id="app2">
                            <label class="control-label">@lang('menu.TransportCompany')</label>
                                <select name="transport_company" class="form-control" v-model="selected_transport_company">
                                    <option value="">@lang('layout.SelectTransportCompany')</option>
                                    @foreach($transport_company as $tcompany)
                                   <option value="{{$tcompany['id']}}">{{$tcompany['name']}}</option>
                                    @endforeach
                                </select>
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Type')</label>
                                {!! Form::select('type[]', $type,$driver->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                        </div>      
                    </div>      
                    <div class="row" id="app">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                        </div>
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                      <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                            </div>
                        </div>


                    <br>
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------Begin Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TAB PORTLET-->
                            <div class="portlet light bordered" >
                                
                                <div class="portlet-body">
                                    <div class="tabbable tabbable-tabdrop">
                                        <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                    
                                            <li class="active">
                                                <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-car"></i> @lang('layout.CarType')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                            </li> 
                    
                                            
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="tab1">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Address1')</label>
                                                            {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Address2')</label>
                                                            {!! Form::text('address2', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                     </div>
                    
                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-6">
                                                          <label class="control-label">@lang('layout.City')</label>
                                                          {!! Form::text('city', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                  </div>

                                                  <div class="col-md-6" id="countries">
                                                        <label class="control-label">@lang('layout.Country')</label>
                                                           <v-select label="name" v-model="selectedCountry" :options="countries">
                                                            </v-select>
                                                            <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                </div>

                                              </div>
                                            </div>
                                            <div class="tab-pane" id="tab2">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Phone')</label>
                                                        {!! Form::text('phone', null, array('class' => 'form-control')) !!}
                                                    </div>
                            
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Phone2')</label>
                                                            {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                    </div>
                            
                                                    <!--/span-->
                                                   
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Email')</label>
                                                        {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                                </div> 
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab5">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Date')</label>
                                                            <input type="text"  name="reg_date" class="form-control date" autocomplete="off" value="{{convertDate($driver->reg_date)}}">
                                                    </div>
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                            <input type="text"  name="date_of_birth" class="form-control date" autocomplete="off" value = "{{convertDate($driver->date_of_birth)}}">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab6">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                        <?php
                                                            $photo = null;
                                                            if($driver && $driver->photo!=null)
                                                            {
                                                                $photo =  $driver->photo;
                                                            }
                                                        ?>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                    <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                                </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail"
                                                                        style="max-width: 200px; max-height: 150px;"></div>
                                                                    <div>
                                                                            <span class="btn default btn-file">
                                                                                <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                <!-- <input type="file" name="photo">  -->
                                                                                {!! Form::file('photo', []) !!}</span>
                                                                        {!! Form::hidden('photo1', (!$driver)?null:$driver->photo) !!}
                                                                        <a href="javascript:;" class="btn default fileinput-exists"
                                                                        data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab7">
                                                    <!--/row-->
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.CarType')</label>
                                                            {!! Form::text('car_type', $driver->car, array('placeholder' =>__('layout.CarType'),'class' => 'form-control')) !!}
                                                        </div> 
                                                        <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.PlateNumber')</label>
                                                            {!! Form::text('plate_number', $driver->plateNumber, array('placeholder' =>__('layout.PlateNumber'),'class' => 'form-control')) !!}
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Rent')</label>
                                                            {!! Form::number('rent', null, array('placeholder' =>__('layout.Rent'),'class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Commitment')</label>
                                                            <textarea type="textarea" rows="2" name="commitment"  class="form-control">{{$driver->Dcomit}}</textarea>
                                                    </div>
                                                    </div>
                    
                                            </div>
                                            <div class="tab-pane" id="tab8">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.VisaIssueDate')</label>
                                                        <input type="text" name="visa_issue_date" class="form-control date" autocomplete="off" value="{{convertDate($driver->visa_issue_date)}}">
                                                    </div> 
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.VisaEndDate')</label>
                                                        <input type="text" name="visa_end_date" class="form-control date" autocomplete="off" value="{{convertDate($driver->visa_end_date)}}">
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Type')</label>
                                                        <select name="driver_type" class="list-style form-control">
                                                            <option value="OwnDriver" <?php if($driver->driver_type == 'OwnDriver'){ echo'selected'; } ?> >@lang('layout.OwnDriver')</option>
                                                            <option value="ForeignDriver" <?php if($driver->driver_type == 'ForeignDriver'){ echo'selected'; } ?> >@lang('layout.ForeignDriver')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class=" control-label">@lang('layout.ForeignDriver')</label>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox"  name="foreign_type" <?php if($driver->foreign_type == 'ok'){ echo'checked'; } ?> value="ok" >
                                                            <span style="border: 1px solid #000000; background: white;"></span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6" id="memberClassDiv">
                                                        <label class="control-label ">@lang('layout.Class')</label>
                                                        <select name="class" class="form-control select_style">
                                                            <option value="">کلاس را انتخاب کنید</option>
                                                            @forEach($class as $key => $value)
                                                                <option value="{{$key}}" {{$driver-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                                            @endforeach
                                                        </select>
                                                        {{-- {{Form::select('class',$class,$driver->class_id,['class' => 'form-control','placeholder' => 'Select Class'])}} --}}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>
                    
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------End Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>

                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" class="btn default">@lang('layout.Cancel')</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection
@push('scripts')

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
script>
<script>

    Vue.component('v-select', VueSelect.VueSelect);
  
  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $driver!!};
  var transport_company={!! $transport_company!!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        transport_company:transport_company,
        selected_receivable:null,
        customer:customer,

    },
    mounted:function(){
        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
            //      this.selected_receivable=this.receivable[j];
            //   }
          }

          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }
    },

  });  

  new Vue({
    el:'#app2',
    data:{
        selected_transport_company:"{!!$driver->transport_company_id!!}",

    },
    mounted:function(){
        console.log('ddddd',this.selected_transport_company)
     
    },

  });


    var gen = {!! json_encode($driver) !!}
    // console.log('asdf',gen['membership'])
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });
    
	
		var countries = {!!$countries!!};
    var selectedCountry = {!!$selectedCountry!!};
	
     new Vue({
    el:'#countries',
    data:{
        countries:countries,
        selectedCountry:selectedCountry
    }
   
	});


    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });
	
</script>
@endpush