@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 
@stop
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.DriverOrCompanyCreate') </span>
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" id="app" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'driver.store','method'=>'POST','class'=>'form-horizontal','id'=>'form-driver','files'=> true)) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.FullName')</label>
                                    {!! Form::text('name', null, array('class' => 'form-control')) !!} 
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                {!! Form::text('code', $code, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                        </div>
                        <div class="col-md-3">
                            <label class="control-label">@lang('layout.SSID')</label>
                               {!! Form::text('ss_id', null, array('placeholder' => __('layout.SSID'),'class' => 'form-control')) !!} 
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->

                   <div class="row">
                      <div class="col-md-3">
                                <label class="control-label">@lang('layout.LastName')</label>
                                {!! Form::text('last_name', null, array('placeholder' => __('layout.LastName'),'class' => 'form-control')) !!} 
                        </div>   

                    <div class="col-md-3">
                            <label class="control-label">@lang('layout.FatherName')</label>
                            {!! Form::text('father_name', null, array('placeholder' => __('layout.FatherName'),'class' => 'form-control')) !!}
                    </div>
                    <div class="col-md-3">
                        <label class="control-label">@lang('menu.TransportCompany')</label>
                        <select name="transport_company" class="form-control">
                          <option value="">@lang('layout.SelectTransportCompany')</option>
                          @foreach($transportCompany as $tcompany)
                          <option value="{{$tcompany['id']}}">{{$tcompany['name']}}</option>
                          @endforeach
                        </select>
                </div> 
                <div class="col-md-3">
                        <label class="control-label">@lang('layout.Type')</label>
                        <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                            @foreach($type as $key=>$value)
                                @if($value == __('type.Driver'))
                                    <option selected value="{{$key}}">{{$value}}</option>
                                @else
                                    <option value="{{$key}}">{{$value}}</option>
                                @endif
                            @endforeach
                        </select>
                </div>
                     
                </div>        
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                    <v-select label="name" v-model="selected_receivable" :options="receivable">
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                        </div>
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                      <v-select label="name" v-model="selected_payable" :options="payable">
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                        </div>
                    </div>
					
                    
                    <br>
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------Begin Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TAB PORTLET-->
                            <div class="portlet light bordered" >
                                
                                <div class="portlet-body">
                                    <div class="tabbable tabbable-tabdrop">
                                        <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                    
                                            <li class="active">
                                                <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-car"></i> @lang('layout.CarType')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                            </li> 
                    
                                            
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="tab1">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Address1')</label>
                                                            {!! Form::text('address1', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Address2')</label>
                                                            {!! Form::text('address2', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                     </div>
                    
                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-6">
                                                          <label class="control-label">@lang('layout.City')</label>
                                                          {!! Form::text('city', null, array('class' => 'form-control','autocomplete'=>'off')) !!}
                                                  </div>
                          
                                                  <div class="col-md-6" id="countries">
                                                          <label class="control-label">@lang('layout.Country')</label>
                                                          <v-select label="name" v-model="selectedCountry" :options="countries">
                                                            </v-select>
                                                            <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                  </div>
                                              </div>
                                            </div>
                                            <div class="tab-pane" id="tab2">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Phone')</label>
                                                        {!! Form::text('phone', null, array('class' => 'form-control')) !!}
                                                    </div>
                            
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Phone2')</label>
                                                            {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                    </div>
                            
                                                    <!--/span-->
                                                   
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Email')</label>
                                                        {!! Form::text('email', null, array('placeholder' => __('layout.Email'),'class' => 'form-control')) !!}
                                                </div> 
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab5">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Date')</label>
                                                            <input type="text"  name="reg_date" class="form-control date" autocomplete="off">
                                                    </div>
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.DateOfBirth')</label>
                                                            <input type="text"  name="date_of_birth" class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab6">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                     
                    
                                                        <?php
                                                        // $logo = null;
                                                        // if($company && $company->logo!=null)
                                                        // {
                                                        //     $logo =  $company->logo;
                                                        // }
                                                    ?>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="#" alt=""/>
                                                            </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail"
                                                                    style="max-width: 200px; max-height: 150px;"></div>
                                                                <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <!-- <input type="file" name="photo">  -->
                                                                            {!! Form::file('photo', []) !!}</span>
                                                                    <a href="javascript:;" class="btn default fileinput-exists"
                                                                    data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                    
                    
                                                    </div>
                                                </div>
                    
                                            </div>
                                            <div class="tab-pane" id="tab7">
                                                    <!--/row-->
                                                    <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.CarType')</label>
                                                            {!! Form::text('car_type', null, array('placeholder' =>__('layout.CarType'),'class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.PlateNumber')</label>
                                                            {!! Form::text('plate_number', null, array('placeholder' =>__('layout.PlateNumber'),'class' => 'form-control')) !!}
                                                    </div>
                                                    </div>
                                                    <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Rent')</label>
                                                            {!! Form::number('rent', null, array('placeholder' =>__('layout.Rent'),'class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Commitment')</label>
                                                            <textarea type="textarea" rows="2" name="commitment"  class="form-control"></textarea>
                                                    </div>
                                                    </div>
                    
                                            </div>
                                            <div class="tab-pane" id="tab8">
                                            <div class="row">
                                                <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.VisaIssueDate')</label>
                                                        {!! Form::text('visa_issue_date', null, array('placeholder' =>__('layout.VisaIssueDate'),'class' => 'form-control date')) !!}
                                                </div> 
                                                <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.VisaEndDate')</label>
                                                        {!! Form::text('visa_end_date', null, array('placeholder' =>__('layout.VisaEndDate'),'class' => 'form-control date')) !!}
                                                </div>
                                            </div>
    
                                            <div class="row">
                                                <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.Type')</label>
                                                        <select name="driver_type" class="list-style form-control">
                                                            <option selected value="OwnDriver">@lang('layout.OwnDriver')</option>
                                                            <option value="ForeignDriver">@lang('layout.ForeignDriver')</option>
                                                        </select>
                                                </div>
                                                <div class="col-md-6">
                                                            <label class=" control-label">@lang('layout.ForeignDriver')</label>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox"  name="foreign_type" value="ok" >
                                                            <span style="border: 1px solid #000000; background: white;"></span>
                                                            </label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6" id="memberClassDiv">
                                                        <label class="control-label ">@lang('layout.Class')</label>
                                                        {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => __('layout.SelectClass')])}}
                                                </div>
                                                </div>
    
    
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>
                    
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------End Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                 
                </div>
                 
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                                    <a href="{{route('driver.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>
    </div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);

 
  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var countries = {!!$countries!!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        countries:countries,
        selectedCountry:{
            id:'Afghanistan',
            name:'Afghanistan'
        }
    },

    methods:{
        
        saveAndNew()
        {
            this.$validator.validate()
            .then(valid =>{
                if(valid)
                { 
                    var url="{{route('driver.store')}}";
                    form_id='form-driver';
                    var data= $('#'+form_id).serialize();
                    // console.log(444, data);
                    toggleBlock(true);
                    axios.post(url,data)
                    .then(function(response){
                            toggleBlock(0);
                            if(response.data.result==1)
                            {
                                $('#'+form_id).trigger('reset');
                                
                                toastr.success('',response.data.message); 
                                location.reload();
                            
                            }
                            else
                            {
                                var message="{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('',message);
                            }
                    })
                    .catch(function(error){
                    toggleBlock(0);
                        console.log(error);
                        var message="{{__('message.Warning')}}";
                        //$('#error-sound')[0].play();
                        toastr.warning('',message);
                    });
                
                }
            })
        },
    },
    mounted:function(){
        if(this.payable)
        {
            this.selected_payable=this.payable[0];
        }
         if(this.receivable)
        {
            this.selected_receivable=this.receivable[0];
        }
    }
  });
  
    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });
</script>

 
@endpush