@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allDrawings'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" @search="onMemberSearch" label="name" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                    @if(systemConfig()[5] != 0 )
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Project') </label>
                            <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                            </v-select>
                            <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                        </div>
                    </div>
                    @endif
                    @if(systemConfig()[20] == 1)
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.ContractName')</label>
                            <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="contract">
                            </v-select>
                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                        </div>
                    </div>
                    @endif
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


<br>
    <div class="tabbable tabbable-tabdrop">
        <ul class="nav nav-tabs">
            <li class="active">
                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.DrawingList')</a>
            </li>
            <!-- <li class="">
                <a href="#tab2" data-toggle="tab" id="tab_payment"> <i class="fa fa-area-chart"></i> @lang('menu.Charts')</a>
            </li> -->
        </ul>



<div class="tab-content">
            <div class="tab-pane active" id="tab1">

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.DrawingList')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    <span id="anchore-modal">
                       <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                          <i class="fa fa-print"></i>
                       </a>
                    </span>
                    @permission('drawing-list')
                    <a href="{{route('drawing.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="drawing">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Equity')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        @if(systemConfig()[5] != 0 )
                        <th>@lang('layout.Project')</th>
                        @endif
                        @if(systemConfig()[20] == 1)
                        <th>@lang('layout.Contract')</th>
                        @endif
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    </div>



    <div class="tab-pane" id="tab2">
            
    <!----------------------------------------------------------------------------
    | BEGIN  Charts
    |---------------------------------------------------------------------------->
    <!-- <div class="row">
        <div class="col-md-6 col-sm-6">

        <div class="col-md-12 col-sm-12" id="drawing-chart">
            <div :class="fullSc">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>
                    </div>
                        <div class="actions">
                            <button type="submit" class="btn green" onclick="printChart('drawing_chart')" ><i class="fa fa-print"></i></button>
                            <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                            <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                <i class="fa fa-expand"></i>
                            </a>

                        </div>
                </div>
                <div class="portlet-body" >
                    <div class="alert alert-info" v-show="loading">
                        <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                    </div>
                    <div  >
                        <canvas  id="drawing_chart" height="280" width="600" ></canvas>
                    </div>
                </div>
            </div>
        </div>
        </div>        
        
        <div class="col-md-6 col-sm-6">

        <div class="col-md-12 col-sm-12" id="drawing-currency-chart">
            <div :class="fullSc">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="fa fa-area-chart font-red" style="font-size: 25px"></i>
                    </div>
                        <div class="actions">
                            <button type="submit" class="btn green" onclick="printChart('drawing_currency_chart')" ><i class="fa fa-print"></i></button>
                            <button type="submit" class="btn blue" @click="getData()"><i class="fa fa-repeat"></i></button>
                            <a class="btn red" data-container="false" data-placement="bottom" href="javascript:;" data-original-title="" title="" @click="fullScreen()">
                                <i class="fa fa-expand"></i>
                            </a>

                        </div>
                </div>
                <div class="portlet-body" >
                    <div class="alert alert-info" v-show="loading">
                        <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}"/>
                    </div>
                    <div  >
                        <canvas  id="drawing_currency_chart" height="280" width="600" ></canvas>
                    </div>
                </div>
            </div>
        </div>
        </div>
        </div> -->
    <!----------------------------------------------------------------------------
    | End Charts
    |---------------------------------------------------------------------------->            
            
    </div>
		</div>
	</div>

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script src="{{ asset('chart/Chart.bundle.js') }}"></script>
    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        $(document).ready(function (){
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#drawing').DataTable({
                ajax: '{{route("drawing.index")}}',
                // pageLength: '{{getPageRows()}}',
                // order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                // responsive:'{{responsiveDataTable()}}',
                // pagingType:'{{paginationType()}}',
                // sort: true,
                // scrollCollapse: true,
                // paging: true,
                serverSide: true,
                // buttons: [{
                //     extend: 'excel',
                //     text: '',
                //     key: {
                //         key: 'x',
                //         altkey: true
                //     }
                // }],
                columns: [
                    {data: 'number', name: 'drawings.number'},
                    {data: 'name', name: 'members.name'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'drawing_account', name: 'drawing_account', orderable: false, searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    @if(systemConfig()[5] != 0 )
                    {data: 'project_name', name: 'project_name' , orderable: false, searchable: false},
                    @endif
                    @if(systemConfig()[20] == 1)
                    {data: 'contract_name', name: 'contract_name' , orderable: false, searchable: false},
                    @endif
                    {data: 'date', name: 'date'},
                    {data: 'username', name: 'users.name'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });


        // for new modal
        let contract = {!! $contract !!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                member: [],
                project_list: [],
                selectedProject: null,
                selectedContract: null,
                contract: contract,
            },
            methods: {
                ProjectSearch:_.debounce((search,loading)=>{
				   vm.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						vm.project_list=response.data;
						console.log('test 22',vm.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Owner',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.member = [];
                        if (response.data.length > 0) {
                            vm.member = response.data;
                            // console.log('data', vm.member);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });
        // for new modal


        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });




// //--------------------------------------------------------
// //              Begin chart                      
// //--------------------------------------------------------//

// let drawing = new Vue({
//         el:'#drawing-chart',
//         data:{
//             chart:null,
//             dates:[],
//             label:[],
//             color:[],
//             loading:false,
//             type:'drawing',
//             measure:null,
//             fullSc:'portlet light bordered'

//         },
//         mounted(){
//            this.getData();
//         },
//         methods: { 
//             getData: function() {
//                 this.loading = true;
//                 if(this.chart !=null){
//                     this.chart.destroy();
//                 }
                
//                 type_temp=this.type;
//                 measure_unit = '';
//                 if(this.measure !=null)
//                 {
//                  measure_unit = this.measure.id;
//                 }


//                 // var from_date = document.getElementById('sale_chart_from_date').value;
//                 // var to_date   = document.getElementById('sale_chart_to_date').value;
                
//                axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

//                     .then(response =>{
//                        if(response.data.todayIncomeExpense.length>0){

//                             this.dates = response.data.todayIncomeExpense;
//                             this.label = response.data.todayIncomeExpenseLabel;
//                             this.color = response.data.todayIncomeExpenseColor;

//                             drawing.chartData(this.dates,this.label,this.color);
//                        }
                       
                      
//                     })
                    
//                     .catch(function (error) {
//                     })
//                     .finally(()=>(this.loading=false));
                
//             },
//             fullScreen(){
//                 if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
//                     this.fullSc = 'portlet light bordered';
//                 }
//                 else
//                 {
//                     this.fullSc = 'portlet light bordered portlet-fullscreen';
//                 }
//             },
//             chartData(dates,label,color){
//                 var ctx_drawing = document.getElementById("drawing_chart");
//                 drawing.chart = new Chart(ctx_drawing, {
//                 type: 'bar',
//                 // type: 'polarArea',
//                 // type: 'doughnut',
//                 // type: 'line',
//                 // type: 'radar',
//                 // type: 'bubble',
//                 // type: 'scatter',
//                 data:{
//                         labels: label,
//                         datasets: [{
//                             backgroundColor: color,
//                             data: dates,
//                             borderWidth:2
//                         }],
//                 },
//                 options: {
//                     legend:{
//                         display:false,
//                         position:'right',
//                         align:'center',
                      
//                         labels:{
//                             // fontSize:18,
//                             // fontColor:'red',
//                             // boxWidth:80
//                             // boxHeight:80

                            
//                         }
//                     },
//                     elements: {
//                         rectangle: {
//                             borderWidth: 2,
//                             borderColor: 'rgb(0, 255, 0)',
//                             borderSkipped: 'bottom'
//                         }
//                     },
//                     responsive: true,
//                     title: {
//                         display: false,
//                         text: '@lang("layout.MaxSaleItem")',
//                         // position:'left',
//                         // fontSize: 16,
//                     }
//                 }
//             }); 
//             }

//             }
//         }); 

// //--------------------------------------------------------
// //              End chart                      
// //--------------------------------------------------------//

// //--------------------------------------------------------
// //              Begin chart                      
// //--------------------------------------------------------//

// let drawingCurrency = new Vue({
//         el:'#drawing-currency-chart',
//         data:{
//             chart:null,
//             dates:[],
//             label:[],
//             color:[],
//             loading:false,
//             type:'drawing_currency',
//             measure:null,
//             fullSc:'portlet light bordered'

//         },
//         mounted(){
//            this.getData();
//         },
//         methods: { 
//             getData: function() {
//                 this.loading = true;
//                 if(this.chart !=null){
//                     this.chart.destroy();
//                 }
                
//                 type_temp=this.type;
//                 measure_unit = '';
//                 if(this.measure !=null)
//                 {
//                  measure_unit = this.measure.id;
//                 }
                
//                axios.get("{{route('home.chartjsTest')}}?type="+type_temp)

//                     .then(response =>{
//                        if(response.data.todayIncomeExpense.length>0){

//                             this.dates = response.data.todayIncomeExpense;
//                             this.label = response.data.todayIncomeExpenseLabel;
//                             this.color = response.data.todayIncomeExpenseColor;

//                             drawingCurrency.chartData(this.dates,this.label,this.color);
//                        }
                       
                      
//                     })
                    
//                     .catch(function (error) {
//                     })
//                     .finally(()=>(this.loading=false));
                
//             },
//             fullScreen(){
//                 if(this.fullSc == 'portlet light bordered portlet-fullscreen'){
//                     this.fullSc = 'portlet light bordered';
//                 }
//                 else
//                 {
//                     this.fullSc = 'portlet light bordered portlet-fullscreen';
//                 }
//             },
//             chartData(dates,label,color){
//                 var ctx_drawing_currency = document.getElementById("drawing_currency_chart");
//                 drawingCurrency.chart = new Chart(ctx_drawing_currency, {
//                 // type: 'bar',
//                 type: 'polarArea',
//                 // type: 'doughnut',
//                 // type: 'line',
//                 // type: 'radar',
//                 // type: 'bubble',
//                 // type: 'scatter',
//                 data:{
//                         labels: label,
//                         datasets: [{
//                             backgroundColor: color,
//                             data: dates,
//                             borderWidth:2
//                         }],
//                 },
//                 options: {
//                     legend:{
//                         display:true,
//                         position:'right',
//                         align:'center',
                      
//                         labels:{
//                             // fontSize:18,
//                             // fontColor:'red',
//                             // boxWidth:80
//                             // boxHeight:80

                            
//                         }
//                     },
//                     elements: {
//                         rectangle: {
//                             borderWidth: 2,
//                             borderColor: 'rgb(0, 255, 0)',
//                             borderSkipped: 'bottom'
//                         }
//                     },
//                     responsive: true,
//                     title: {
//                         display: false,
//                         text: '@lang("layout.MaxSaleItem")',
//                         // position:'left',
//                         // fontSize: 16,
//                     }
//                 }
//             }); 
//             }

//             }
//         }); 

// //--------------------------------------------------------
// //              End chart                      
// //--------------------------------------------------------//

    </script>
@endpush
