@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewDrawing') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app" >
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'drawing.store','method'=>'POST','class'=>'from-horizontal','id'=>'drawing-submit')) !!}
                {{ csrf_field() }} 
                    <div class="form-body" v-cloak >
                        <div  class="row">   
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select class="vue-select2" v-model="selectedEmployee" label="name"
                                                :options="{{$member}}">
                                        </v-select>
                                         <input type="hidden" name="employee" v-model.number="(!selectedEmployee)?null:selectedEmployee.member_id">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Equity')</label>
                                            {{Form::select('equity_account_id',$equity,null,['class' => 'form-control'])}}
                                    </div> 
                                      <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number"   name="number" class="form-control" step="any" min="0"  value="{{$number}}">
                                        
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="currency_len">
                                           <label class="control-label">@lang('layout.DrawingCurrency')</label>
                                            <select  class="form-control" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code)">
                                                 <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/> 
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate" class="form-control"
                                                           type="number" min="0" step="any" @keyup="check_code(paymentCurrency.code)">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate1" :value="selected_rate">
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                            <span class="input-group-addon" v-if="selectedBank">@{{ ( Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount))).toFixed(precision()) }}</span>
                                        </div>
                                    </div>
                                </div> 
                                <div class="row">  
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="pcurrency_len">
                                           <label class="control-label">@lang('layout.Currency')</label>
                                            <select  class="form-control" v-model="paymentCurrency" v-on:change="setPaymentSize(paymentCurrency.code)" disabled>
                                                 <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code"/> 
                                        </div>
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate1" class="form-control"
                                                           type="number" min="0" @keyup="check_code1(selectedCurrency.code)" step="any">
                                                    <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="paymentrate" :value="selected_rate1">
                                            </div>
                                        </div> 
                                    </div>                                       
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        {{Form::number('amount',null,['class' => 'form-control' ,'step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        @if(systemConfig()[30] == 1)
                                        <div class="input-group">
                                            <input type="number" :value="((amount /static_rate * selected_rate)   *  static_rate1  / selected_rate1).toFixed(3)" class="form-control" min="0" step="any">
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                        </div> 
                                        @else 
                                        <div class="input-group">
                                            <input type="number" :value="(amount*selected_rate1/(selected_rate)).toFixed(3)" class="form-control" min="0" step="any">
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                        </div>   
                                        @endif
                                    </div>
                                    @if(systemConfig()[5] != 0 )
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                       <label class="control-label">@lang('layout.Project')</label>
                                       {{-- <div>
                                           <input class="form-control date" id="range-from-example" name="date" autocomplete="off">
                                       </div> --}}
                                       <v-select class="vue-select2" label="name" @search="ProjectSearch" :options="project_list" v-model="selectedProject">
                                       </v-select>
                                       <input type="hidden" name="project_id" v-model.number="(!selectedProject)?null:selectedProject.project_id">
                                   </div>
                                   @endif
                                   @if(systemConfig()[20] == 1) 
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                       <label class="control-label">@lang('layout.ContractName')</label>
                                       <v-select class="vue-select2" placeholder="@lang('layout.Select')" v-model="selectedContract" label="company_name" :options="contract">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                   </div>
                                   @endif
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                        <label class="control-label">@lang('layout.Date') </label>
                                        <div>
                                            <input class="form-control date" id="range-from-example" name="date" autocomplete="off">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                    </div> 
                                </div> 
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-default" style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Payable')</th>
                                                    <th>@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedEmployee">
                                                   <tr v-for="summ in (selectedEmployee)?selectedEmployee.sumary:null" >
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ summ.payment }}</td>
                                                      <td>
                                                          @{{summ.invoice }}
                                                      </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>                            
                            </div>
                        </div>
                    
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                          <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        
                        <a href="{{route('drawing.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')

<script>
     Vue.component("v-select", VueSelect.VueSelect);
        var Banks     = {!! $bank!!}
        var Member    = {!!$member!!}
        var Currency  = {!! $currency!!}
        var Currency1  = {!! $currency!!}
        var one = {!! json_encode(getHomeCurrency()) !!}
        var two = {!! json_encode(getHomeCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        let contract = {!! $contract !!};

        

   var vm =  new Vue({
        el: '#app',
        data: {
                selectedCurrency:{!!json_encode(getHomeCurrency()) !!},
                paymentCurrency:{!!json_encode(getHomeCurrency()) !!},
                default_currency:two,
                currency:{!! json_encode(currencyList()) !!},
                currency1:{!! json_encode(currencyList()) !!},
                bankes: {!! $banks !!},
                selectedBank: null,
                number: "{{$number}}",
                old_number: "{{$number}}",
                defaultValue: 0,
                defaultAmount:0,
                defaultAccount: 0,
                amount:0, 
                selected_rate:1,
                selected_rate1:1,
                listAccounts:[],
                selectedEmployee:null,
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                isError: false,
                static_rate1: 1,
                static_rate: 1,
                selectedContract: null,
                contract: contract,
                project_list: [],
                selectedProject: null,
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                    for(var x in this.bankes){
                        for(z in this.bankes[x]){
                            if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;                                    
                                break;
                            }
                        }

                    }
                }
                return test;
            },
        },
        methods: {
                ProjectSearch:_.debounce((search,loading)=>{
				   vm.project_list=[];
				   loading(true);
				   axios.get("{{route('callMethod.search')}}",{
					params:{
					  method_name:'serarchProject',
					  keyword:search,
					}
				   })
				   .then(function (response)
				   {
					 this.project_list=[];
					 if(response.data.length>0)
					 {
						vm.project_list=response.data;
						console.log('test 22',vm.project_list);
					 }
					 loading(false);
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				},getDebounceTime()),
                saveAndNew() {

                    // this.$validator.validate()
                        // .then(valid => {
                        //     if (valid) {
                            // console.log(123);

                                var url = "{{route('drawing.store')}}";
                                form_id = 'drawing-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vm.number = Number(vm.old_number) + 1;
                                            vm.old_number = Number(vm.old_number) + 1;

                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            // }
                        // })
                },

            setSize(selected_code) {
                    // this.paymentCurrency=this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;
                    this.static_rate1 = this.paymentCurrency.static_rate;
                    this.static_rate = this.selectedCurrency.static_rate;
                    if(selected_code ==  this.code){
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len=this.currency_len;
                    this.prate_len=this.rate_len;
                }, 
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;
                    this.static_rate1 = this.paymentCurrency.static_rate;
                    
                    if(selected_code ==  this.code){
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else  {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code){
                    if(this.paymentCurrency.code == this.selectedCurrency.code){
                        this.selected_rate1 = this.selected_rate;
                    } 
                },
                check_code1(code){
                    if(this.paymentCurrency.code == this.selectedCurrency.code){
                        this.selected_rate = this.selected_rate1;
                    } 
                },
                test(defaultAccount){
                    for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == defaultAccount && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            } 
                        } 
                },
              
        }
    });  
</script>


@endpush
 