@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('drawing_index');

$_number= !in_array('number', $report);
$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_name= !in_array('name', $report);
$_account= !in_array('account', $report);
$_equity= !in_array('equity', $report);
$_amount= !in_array('amount', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_user= !in_array('user', $report);


$report_percent = customeReportNewPercent('drawing_index');
$_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_name_percent= (array_key_exists('name___percent', $report_percent))?$report_percent['name___percent']:null;
$_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
$_equity_percent= (array_key_exists('equity___percent', $report_percent))?$report_percent['equity___percent']:null;
$_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
$_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
$_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
$_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;

?>



 <h3 class="table-caption" style="text-align: center;">@lang('layout.DrawingsReport')</h3>
 <table class="main-table">
  <tr>
    @if($from_date)
    <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

<table class="main-table">
<thead>
  <tr class="bg">
 <td  class="center" >@lang('layout.Record') </td>
 @if($_number)<td  class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif >@lang('layout.Number')</td>@endif
 @if($_date)<td  class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif >@lang('layout.Date')</td>@endif
 @if($_description)<td  class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif >@lang('layout.Description')</td>@endif
 @if($_name)<td  class="center" @if($_name_percent) width="{{$_name_percent}}%" @endif >@lang('layout.Name') </td>@endif
 @if($_account) <td  class="center" @if($_account_percent) width="{{$_account_percent}}%" @endif >@lang('layout.Account')</td>@endif
 @if($_equity) <td  class="center" @if($_equity_percent) width="{{$_equity_percent}}%" @endif >@lang('layout.Equity')</td>@endif
 @if($_amount)<td  class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif >@lang('layout.Amount')</td>@endif
 @if($_currency)<td  class="center" @if($_currency_percent) width="{{$_currency_percent}}%" @endif >@lang('layout.Currency')</td>@endif
 @if($_rate)<td  class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif >@lang('layout.Rate')</td>@endif
 @if(systemConfig()[5] != 0 )
 <td  class="center">@lang('layout.Project')</td>
 @endif
 @if(systemConfig()[20] == 1)
 <td  class="center">@lang('layout.Contract')</td>
 @endif
 @if($_user)<td  class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif >@lang('layout.User')</td>@endif


</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
<tbody>
@foreach($data AS $record)
<tr>

<?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>

  
<td class="center">{{++$count}}</td>
@if($_number)<td class="center">{{$record->number}}</td>@endif
@if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
@if($_description)<td  class="center" style="@if($_description_percent) text-align: justify @endif">{{$record->Description}}</td>@endif
@if($_name)<td  class="center">{{$record->Name}}</td>@endif
@if($_account)<td  class="center">{{$record->Account}}</td>@endif
@if($_equity)<td  class="center">{{$record->DrawingAccount}}</td>@endif
@if($_amount)<td  class="center">{{round($record->Amount,2)}}</td>@endif
@if($_currency)<td  class="center">{{$record->Currency}}</td>@endif
@if($_rate)<td  class="center">{{$record->Rate}}</td>@endif
@if(systemConfig()[5] != 0 )
<td  class="center">{{$record->project_name}}</td>
@endif
@if(systemConfig()[20] == 1)
<td  class="center">{{$record->contract_name}}</td>
@endif
@if($_user)<td  class="center">{{$record->user}}</td>@endif
</tr>
@endforeach  
</tbody>
</table>

<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection