@extends('layouts.app')

@section('content')
@include('layouts.modal')

<!-- END PAGE HEADER-->

<!-- app discount from vendor excell -->
<div id="app4" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="discount_account_from_vendor" />
    <button id="show-modal4" style="display: none" type="button" @click="editExample4">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal4" @close="showModal4 = false">
        <div slot="body">
            <div class="row">
                <!--                  <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            <option value="discountToCustomer">@lang('layout.DiscountToCustomer')</option>
                            <option value="discountFromVendor">@lang('layout.DiscountFromVendor')</option>
                        </select>
                    </div> -->
                <div class="col-md-12">
                    <label class="control-label ">@lang('layout.SelectMember') </label>
                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                </div>

            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            <div slot="date">
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app discount from vendor excell -->

<!-- app discount from vendor pdf -->
<div id="app3" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="discount_account_from_vendor" />
    <button id="show-modal3" style="display: none" type="button" @click="editExample3">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal3" @close="showModal3 = false">
        <div slot="body">
            <div class="row">
                <!--                  <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            <option value="discountToCustomer">@lang('layout.DiscountToCustomer')</option>
                            <option value="discountFromVendor">@lang('layout.DiscountFromVendor')</option>
                        </select>
                    </div> -->
                <div class="col-md-12">
                    <label class="control-label ">@lang('layout.SelectMember') </label>
                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                </div>

            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            <div slot="date">
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app discount from vendor pdf -->

<!-- app -->
<div id="app" v-cloak>
    {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="discount_account_tocustomer" />
    <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <!--                  <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            <option value="discountToCustomer">@lang('layout.DiscountToCustomer')</option>
                            <option value="discountFromVendor">@lang('layout.DiscountFromVendor')</option>
                        </select>
                    </div> -->
                <div class="col-md-12">
                    <label class="control-label ">@lang('layout.SelectMember') </label>
                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                </div>

            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>

                            <div slot="date">
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- app -->
<div id="app2" v-cloak>
    {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
    <input type="hidden" name="type" value="discount_account_tocustomer" />
    <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
    <!-- use the modal component, pass in the prop -->
    <modal v-if="showModal" @close="showModal = false">
        <div slot="body">
            <div class="row">
                <!--                     <div  class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectType') </label>
                        <select name="type_name" id="" class="form-control">
                            <option  value="">@lang('layout.SelectType')</option>
                            <option value="discountToCustomer">@lang('layout.DiscountToCustomer')</option>
                            <option value="discountFromVendor">@lang('layout.DiscountForCustomer')</option>
                        </select>
                    </div> -->
                <div class="col-md-12">
                    <label class="control-label ">@lang('layout.SelectMember') </label>
                    <v-select class="vue-select2" v-model="selectedMember1" label="name" @search="MemberSearch" :options="member">
                    </v-select>
                    <input type="hidden" name="member_id" v-model.number="(!selectedMember1)?null:selectedMember1.id">
                </div>

            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example2" autocomplete="off" name="from_date">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example2" autocomplete="off" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div slot="footer">
            <button type="submit" class="btn btn-success" @click="ok">
                @lang('layout.Submit')
            </button>
            <button type="button" class="btn btn-danger" @click="close">
                @lang('layout.Cancel')
            </button>

        </div>
    </modal>
    {{Form::close()}}
</div>
<!-- BEGIN TAB PORTLET-->
<div class="tabbable tabbable-tabdrop">

    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.DiscountToCustomer')</a>
        </li>
        <li class="">
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.DiscountFromVendor')</a>
        </li>
    </ul>
    <div v-cloak id="company_ll">
        <company @company="setCompany"></company>
    </div>

    <div class="tab-content">
        <div class="tab-pane active" id="tab1">
            <!-- app -->
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bortdered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.DiscountList')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="pull-right">
                        @permission('discount-export')

                        <button type="submit" id="excell_all" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                        <button type="button" class="btn btn-success" id="print_pdf_all"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>

                        @endpermission

                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sale">
                        <thead>
                            <tr>
                                <th>@lang('layout.Type')</th>
                                <th>@lang('layout.TypeNumber')</th>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.Account')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                                <th>@lang('layout.Rate')</th>
                                <th>@lang('layout.Category')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Description')</th>
                                <th>@lang('layout.User')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
        <div class="tab-pane" id="tab2">
            <div class="portlet light bortdered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.DiscountList')</span>
                    </div>
                    <div class="tools"></div>
                    <div class="pull-right">
                        @permission('discount-export')

                        <button type="button" id="excell_from_vendor" class="btn btn-success"><i class="fa fa-file-excel-o"></i> @lang('layout.Excel')</button>

                        <button type="button" class="btn btn-success" id="pdf_from_vendor"><i class="fa fa-file-pdf-o"></i> @lang('layout.PDF')</button>

                        @endpermission

                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="paymentdiscount">
                        <thead>
                            <tr>
                                <th>@lang('layout.Type')</th>
                                <th>@lang('layout.TypeNumber')</th>
                                <th>@lang('layout.Name')</th>
                                <th>@lang('layout.Account')</th>
                                <th>@lang('layout.Amount')</th>
                                <th>@lang('layout.Currency')</th>
                                <th>@lang('layout.Rate')</th>
                                <th>@lang('layout.Category')</th>
                                <th>@lang('layout.Date')</th>
                                <th>@lang('layout.Description')</th>
                                <th>@lang('layout.User')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- END TAB PORTLET-->

<iframe id="payframe" style="display: none;"></iframe>


<!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')

<script>
    Vue.component("v-select", VueSelect.VueSelect);
    let data = {
        selected: '{!! getCompanyID() !!}'
    };

    let sale_data_table = null;
    let pay_data_table = null;
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        sale_data_table = $('#sale').DataTable({
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("discount.index")}}',
                data: {
                    type: 'sale'
                }
            },
            order: [
                ["{{orderByColumn()=='number'?1:8}}", "{{getRowOrder()}}"]
            ],
            pageLength: '{{getPageRows()}}',
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            columns: [{
                    data: 'category',
                    name: 'category',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'category_number',
                    name: 'category_number',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'Member',
                    name: 'members.name',
                },
                {
                    data: 'Account',
                    name: 'accounts.name',
                },
                {
                    data: 'amount',
                    name: 'amount',
                    orderable: true,
                    searchable: false
                },
                {
                    data: 'unit',
                    name: 'transactions.unit',
                },
                {
                    data: 'rate',
                    name: 'rate',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'type',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'date',
                    name: 'date',
                    orderable: true,
                    searchable: false
                },
                {
                    data: 'description',
                    name: 'description',
                    orderable: true,
                    searchable: false
                },
                {
                    data: 'user',
                    name: 'user',
                    orderable: true,
                    searchable: false
                },
            ]
        });

    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        pay_data_table = $('#tab_payment').on('shown.bs.tab', function(event) {
            $('#paymentdiscount').DataTable({
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("discount.index")}}',
                    data: {
                        type: 'payment'
                    }
                },
                order: [
                    ["{{orderByColumn()=='number'?1:8}}", "{{getRowOrder()}}"]
                ],
                pageLength: '{{getPageRows()}}',
                responsive: '{{responsiveDataTable()}}',
                pagingType: '{{paginationType()}}',
                columns: [{
                        data: 'category',
                        name: 'category',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'category_number',
                        name: 'category_number',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Member',
                        name: 'Member',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'Account',
                        name: 'Account',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'unit',
                        name: 'unit',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate',
                        name: 'rate',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'type',
                        name: 'type',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'date',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'description',
                        name: 'description',
                        orderable: true,
                        searchable: false
                    },
                    {
                        data: 'user',
                        name: 'user',
                        orderable: true,
                        searchable: false
                    },
                ]
            });
        });
    });


    new Vue({

        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                console.log('company emitted from child', event.company);
                data.selected = event.company;
                try {
                    if (typeof sale_data_table == 'object') {

                        sale_data_table.clear();
                        sale_data_table.ajax.reload();
                    }
                    if (typeof pay_data_table == 'object') {
                        try {
                            pay_data_table.clear();
                            pay_data_table.ajax.reload();
                        } catch (e) {

                        }

                    }
                } catch (e) {

                }

            }
        }
    });
    // register modal component
    var Modal = Vue.component('modal', {
        template: '#modal-template',
        methods: {
            ok: function() {
                this.$emit('ok')
            }
        }
    });

    var vu1 = new Vue({
        el: '#app',
        data: {
            showModal: false,
            showModal1: false,
            selectedMember: null,
            selectedMember1: null,
            member: [],
            member1: [],
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
                this.showModal1 = !this.showModal1;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample: function() {
                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        var to, from;
                        to = $("#range-to-example").persianDatepicker(modelDate());
                        from = $("#range-from-example").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu1.member = [];
                            vu1.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),
        },
    })
    $('#print_pdf_all').on('click', function(e) {
        $('#show-modal').click();
        e.preventDefault();
    })

    var vu2 = new Vue({
        el: '#app2',
        data: {
            showModal: false,
            showModal1: false,
            selectedMember: null,
            selectedMember1: null,
            member: [],
            member1: [],
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal = !this.showModal;
            },
            close: function(e) {
                this.showModal = !this.showModal;
            },
            editExample2: function() {
                //Your other code that launches the modal
                this.showModal = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        var to, from;
                        to = $("#range-to-example2").persianDatepicker(modelDate());
                        from = $("#range-from-example2").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu2.member = [];
                            vu2.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),
        },
    })
    $('#excell_all').on('click', function(e) {
        $('#show-modal2').click();
        e.preventDefault();
    })

    var vu3 = new Vue({
        el: '#app3',
        data: {
            showModal3: false,
            selectedMember: null,
            member: [],
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal3 = !this.showModal3;
            },
            close: function(e) {
                this.showModal3 = !this.showModal3;
            },
            editExample3: function() {
                //Your other code that launches the modal
                this.showModal3 = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        var to, from;
                        to = $("#range-to-example").persianDatepicker(modelDate());
                        from = $("#range-from-example").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu3.member = [];
                            vu3.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),
        },
    })
    $('#pdf_from_vendor').on('click', function(e) {
        $('#show-modal3').click();
        e.preventDefault();
    })

    var vu4 = new Vue({
        el: '#app4',
        data: {
            showModal4: false,
            selectedMember: null,
            member: [],
        },
        methods: {
            ok: function() {
                //alert('you clicked me');
                this.showModal4 = !this.showModal4;
            },
            close: function(e) {
                this.showModal4 = !this.showModal4;
            },
            editExample4: function() {
                //Your other code that launches the modal
                this.showModal4 = true;
                this.$nextTick(function() {
                    $(document).ready(function() {
                        var to, from;
                        to = $("#range-to-example").persianDatepicker(modelDate());
                        from = $("#range-from-example").persianDatepicker(modelDate());
                    });
                })
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu4.member = [];
                            vu4.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),
        },
    })
    $('#excell_from_vendor').on('click', function(e) {
        $('#show-modal4').click();
        e.preventDefault();
    })
</script>
@endpush