@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('discount','index');
$_type=in_array('type', $report);
$_date=in_array('date', $report);
$_name=in_array('name', $report);
$_account=in_array('account', $report);
$_currency=in_array('currency', $report);
$_amount=in_array('amount', $report);
$_rate=in_array('rate', $report);
?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.SaleTaxationReport')</h3>
<table  class="main-table">
<tr>
    <td>
      <span>@lang('layout.Currency') : </span>
      <span>  {{getHomeCurrency()[getCurrencyType()]}} </span>
    </td>
    <td>
       <span> @lang('layout.Rate') : </span>
      <span> {{Currency()->exchange_rate}} </span>
    </td>
     <td>
       <span> @lang('layout.Total') : </span>
      <span> {{$total}} </span>
     </td>
      
</tr>
<tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">
<thead>
  <tr class="bg">
 <td  class="center"><div > @lang('layout.Record')  </div></td>
 @if($_type)<td  class="center"><div > @lang('layout.Type')</div></td>@endif
 @if($_type)<td  class="center"><div > @lang('layout.TypeNumber')</div></td>@endif
 @if($_type)<td  class="center"><div > @lang('layout.Type')</div></td>@endif
 @if($_date)<td  class="center"><div > @lang('layout.Date')</div></td>@endif
 @if($_name)<td  class="center"><div > @lang('layout.Name') </div></td>@endif
 @if($_account)<td  class="center"><div > @lang('layout.Account')</div></td>@endif
 @if($_currency)<td  class="center"><div > @lang('layout.Currency')</div></td>@endif
 @if($_amount)<td  class="center"><div > @lang('layout.Amount')</div></td>@endif
 @if($_rate)<td  class="center"><div > @lang('layout.Rate')</div></td>@endif
</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
@if($_type)<td  class="center">{{__('layout.'.ucfirst($record->category))}}</td>@endif
@if($_type)<td  class="center">{{$record->category_number}}</td>@endif
@if($_type)<td  class="center">{{$record->type}}</td>@endif
@if($_date)<td  class="center">{{convertDate($record->date)}}</td>@endif
@if($_name)<td  class="center">{{$record->Member}}</td>@endif
@if($_account)<td  class="center">{{$record->Account}}</td>@endif
@if($_currency)<td  class="center">{{$record->unit}}</td>@endif
@if($_amount)<td  class="center">{{round($record->amount,2)}}</td>@endif
@if($_rate)<td  class="center">{{$record->rate}}</td>@endif
</tr>
@endforeach  
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection