@extends('layouts.app')
@section('style')
<style type="text/css">
    table.td{
        border-top:0px;
    }
    .header{    
    }
</style>
@stop
@section('content')
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.FixAssetDeliveryShow')</span>
                </div>
                <div class="tools"></div>
                <div class="actions">
                    <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
                        <input type="hidden" name="type" value="ngo_project_Details"/>
                        <input type="hidden" name="id" value="{{$deliveryFixedAsset->id}}"/> 
                        <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.Report') </button>
                    {{Form::close()}} -->
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-md-12">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th class="text-center">@lang('layout.Number')</th>
                                    <th class="text-center">@lang('layout.FixedAsset')</th>
                                    <th class="text-center">@lang('layout.Employee')</th>
                                    <th class="text-center">@lang('layout.Type')</th>
                                    <th class="text-center">@lang('layout.Description') </th>
                                    <th class="text-center">@lang('layout.Date') </th>
                                </tr>
                            </thead>
                            <tbody> 
                                <tr>  
                                    <td class="text-center"> {{ $deliveryFixedAsset->number}}  </td>
                                    <td class="text-center"> {{ $deliveryFixedAsset->fixed_asset}}  </td>
                                    <td class="text-center"> {{ $deliveryFixedAsset->customer}}  </td>
                                    <td class="text-center"> @if($deliveryFixedAsset->delivery_type) {{ __('layout.'.ucfirst($deliveryFixedAsset->delivery_type)) }} @endif </td>
                                    <td class="text-center"> {{ $deliveryFixedAsset->description}}</td>
                                    <td class="text-center"> {{ $deliveryFixedAsset->date}}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div> 
                    <div class="">
                        <div class="tabbable-line tabbable-custom-profile">
                            <ul class="nav nav-tabs">
                                <li class="">
                                    <a href="#tab_4-4" data-toggle="tab" id="Purch-table">
                                        <b> @lang('layout.Attachments') </b>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="tab-content">
                            <div id="tab_4-4" class="tab-pane active">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                                                    <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data" style="padding: 0.5% 1%;">
                                                        @csrf
                                                        <input type="hidden" name="redirect_route" value="deliveryFixAsset.show">
                                                        <input type="hidden" name="foreign_data_id" value="{{$deliveryFixedAsset->id}}">
                                                        <input type="hidden" name="path" value="uploads/deliveryFixAsset">
                                                        <input type="hidden" name="table_name" value="delivery_fix_asset">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="form-group">
                                                                    <label class="control-label"><i class="icon-settings font-dark"></i> @lang('layout.AttachmentTitle')</label>
                                                                    <input type="text" name="title" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <div class="form-group">
                                                                    <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                        <div>
                                                                            <span class="btn default btn-file">
                                                                                <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                                <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                                <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                            </span>
                                                                            <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                        </div>
                                                                        <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                                            <img src="" alt=""> 
                                                                        </div>
                                                                        <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> 
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="margin-top-0 text-center">
                                                            <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                            <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <table class="table table-striped table-bordered table-hover" id="attachment">
                                    <thead>
                                        <tr>  
                                            <th>@lang('layout.AttachmentTitle')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Action')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
@endsection
@push('scripts') 
<script>
    $(document).ready(function () {
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#attachment').DataTable({
                ajax:{
                    url:'{{route("deliveryFixAsset.show",$deliveryFixedAsset->id)}}',
                    data:{type:'attachment'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
                ]
            });
        });
    });
</script>
@endpush