@extends('layouts.app')
@section('content')
@include('layouts.modal')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'fixAssetDelivery_report'" @closed="closeModal">
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['customreport-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label ">@lang('layout.FixedAsset') </label>
                                            <v-select class="vue-select2" v-model="selectedproject" label="name" @search="onProjectSearch" :options="projectList">
                                            </v-select>
                                            <input type="hidden" name="fixed_asset_id" v-model.number="(!selectedproject)?null:selectedproject.id">
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Employee')</label>
                                            <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch" ></v-select>
                                            <input type="hidden" name="employee_id" :value="!selected_customer?null:selected_customer.id" required v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                            <span class="required">@{{ errors.first('employee_id') }}</span>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Type')</label>
                                            <select name="delivery_type" v-model="selected_type" class="form-control">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="delivery">@lang('layout.Delivery')</option>
                                                <option value="back">@lang('layout.Back')</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div slot="date">
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" autocomplete="off" name="from_date">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" autocomplete="off" name="to_date">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div> 
                            {{-- <div class="tab-pane" id="tab2" > 
                                <div class="portlet light bordered">
                                    <div class="portlet-body" >
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="fix_asset_sales_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <label> @{{ row.Name }}</label>
                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                        <label class="switch">
                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn" >
                                                            <span class="slider round"></span>
                                                        </label>
                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 60%;">
                                                            <option value="">@lang('layout.Select')</option>
                                                            <option value="2">2 %</option>
                                                            <option value="6">6 %</option>
                                                            <option value="10">10 %</option>
                                                            <option value="15">15 %</option>
                                                            <option value="20">20 %</option>
                                                            <option value="25">25 %</option>
                                                            <option value="30">30 %</option>
                                                            <option value="40">40 %</option>
                                                            <option value="50">50 %</option>
                                                            <option value="60">60 %</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div> --}}
                            <div class="tab-pane" id="tab2"> 
                                <div class="portlet light bordered">
                                    <div class="row">
                                        <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                            @csrf
                                            <input type="hidden" name="part_name" value="fix_asset_delivery_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 15px !important;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>  
                                                </div>
                                            </div>
                                            <div class="margin-top-10">
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET--> 
    <div class="row"> 
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.DeliveryFixAssetList') </span>
                </div>
                <div class="btn-group pull-right">
                    @permission(['DeliveryFixAsset-export'])
                    <span id="anchore-modal">
                        <a  @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission(['DeliveryFixAsset-create'])
                    <a href="{{route('deliveryFixAsset.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                    <div id="nGOProject" v-cloak>
                        <!-- <button class="btn btn-success" id="show-modal" @click="showModal =true">@lang('layout.AddNew')</button>
                            <modal v-if="showModal" @close="showModal = false">
                                <div slot="header">
                                    <div class="col-md-12 col-sm-12 col-xs-12">
                                        <h3>
                                            @lang('layout.projectCategoryCreate')
                                        </h3>
                                    </div>
                                    <div class="col-md-4">
                                        <div v-if="fieldErrors.length > 0">
                                            <p class="text-danger" fieldErrors>
                                                <spna v-text="fieldErrors"></spna>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <div slot="body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>@lang("layout.Name") <span class="required"> * </span></label>
                                                <input type="text" class="form-control" name="name" v-model="className">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>@lang("layout.Description") <span class="required"> * </span></label>
                                                <textarea class="form-control" name="description" v-model="description">      
                                                </textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div slot="footer">
                                    <button type=button class="btn btn-success" @click="addClass" >
                                        @lang('layout.OK')
                                    </button>
                                    <button type=button class="btn btn-danger"
                                            @click="showModal =false" >
                                        @lang('layout.Cancel')
                                    </button>
                                </div>
                            </modal>
                        -->
                    </div>
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="1" id="fixAssetSale" width="100%">
                    <thead>
                        <tr> 
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.FixedAsset')</th>
                            <th>@lang('layout.Employee')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Date') </th>
                            <th>@lang('layout.Description') </th>
                            <th>@lang('layout.User') </th>
                            <th>@lang('layout.Action') </th>
                        </tr>
                    </thead> 
                </table>
            </div>
        </div>
    </div> 
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        var cust_rep = {!!customeReportNewData('fix_asset_delivery_index')!!};
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;
        $(document).ready(function() { 
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#fixAssetSale').DataTable( {
                ajax: '{{route("deliveryFixAsset.index")}}',
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging:         true,
                columns: [
                { data: 'number', name: 'number' },
                { data: 'fixed_asset', name: 'fixed_asset' },
                { data: 'customer', name: 'customer' },
                { data: 'delivery_type', name: 'delivery_type' },
                { data: 'date', name: 'date' },
                { data: 'description', name: 'description' },
                { data: 'user', name: 'user' },
                { data: 'action', name: 'action', orderable:false, searchable:false },
                ] 
            }); 
        });
        Vue.component('modal',{
            template: '#modal-template'
        });
        let vu = new Vue({
            el: '#nGOProject',
            data:{
                showModal:false,
                fieldErrors:[],
                className: null,
                description: null,
            },
            methods:{
                addClass(){     
                    // var myData = {name: this.className,description:this.description};
                    axios.post("{{route('fixAssetSale.store')}}",{
                        name:this.className,
                        description:this.description
                    })
                    .then(function(response){
                        vu.showModal = false;
                        vu.className = null;
                        vu.description = null;
                        $('#fixAssetSale').DataTable().ajax.reload();
                    })
                }
            }
        });
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        //Begin Export Modal
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route("deliveryFixAsset.report") !!}',
                excelRoute: '{!! route("deliveryFixAsset.report") !!}',
                selectedproject: null,
                projectList: [],
                selected_type: 'delivery',
                customer: [],
                selected_customer: null,
                customReportData:
                [      
                {Name: '@lang("layout.Number")', column_name: 'fixedAssetNumber',checkedColumn:(cust_rep.fixedAssetNumber)?'checked':'',checkedColumn:(cust_rep.fixedAssetNumber)?'checked':'',column_percentage:(cust_rep.fixedAssetNumber___percent)?cust_rep.fixedAssetNumber___percent:''},
                {Name: '@lang("layout.FixedAsset")', column_name: 'fixedAsset',checkedColumn:(cust_rep.fixedAsset)?'checked':'',checkedColumn:(cust_rep.fixedAsset)?'checked':'',column_percentage:(cust_rep.fixedAsset___percent)?cust_rep.fixedAsset___percent:''},
                {Name: '@lang("layout.Employee")', column_name: 'employee',checkedColumn:(cust_rep.employee)?'checked':'',column_percentage:(cust_rep.employee___percent)?cust_rep.employee___percent:''},
                {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Employee'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.customer = [];
                            vm.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },
                //ajax call to get items
                searchProject(search, loading, vm) {
                    if (vu.selected_type == 'delivery') {
                    var type = 'on'
                    } else {
                        var type = 'off'
                    }
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'fixed_asset_management',
                            keyword: search,
                        }
                    })
                    .then(function (response) {
                        this.projectList = [];
                        if (response.data.length > 0) {
                            vm.projectList = response.data;
                            console.log('data', vm.projectList);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>
@endpush