@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">
@stop
@section('content')
<div class="row">

    <div class="portlet light bg-inverse">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.FixAssetDeliveryEdit') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom: 50%;" id="app">
            <!-- BEGIN FORM-->
            {!! Form::model($deliveryFixAsset,['method' => 'PATCH','route' => ['deliveryFixAsset.update',$deliveryFixAsset->id],'class'=>'form-horizontal','id'=>'sales-form']) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row" style="padding: 0px 20px;">
                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                        <div class="row" style="padding: 0px 10px;">
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="delivery_type" v-model="selected_type" class="form-control" @click="filterAssets()">
                                        <option value="delivery">@lang('layout.Delivery')</option>
                                        <option value="back">@lang('layout.Back')</option>
                                    </select>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.FixedAsset')</label>
                                    <v-select class="vue-select2" v-model="selectedAsset" label="name" @search="searchFixedAsset" :options="fixedAsset">
                                    </v-select>
                                    <input type="hidden" name="fixed_asset_id" v-model.number="(!selectedAsset)?null:selectedAsset.id" v-validate="'required'" data-vv-as="@lang('layout.FixedAsset')">
                                    <span class="required">@{{ errors.first('fixed_asset_id') }}</span>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="text" name="number" value="{{$deliveryFixAsset->number}}" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Employee')</label>
                                    <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch"></v-select>
                                    <input type="hidden" name="employee_id" :value="!selected_customer?null:selected_customer.id" required v-validate="'required'" data-vv-as="@lang('layout.Employee')">
                                    <span class="required">@{{ errors.first('employee_id') }}</span>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" class="form-control date" name="date" value="{{$deliveryFixAsset->date}}" autocomplete="off" placeholder="@lang('layout.Date')">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-center">
                <button type="button" class="btn green" @click="handleSubmit($event)" > @lang('layout.Update') </button>
                <button href="{{url('fixAssetSale.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel') </button>
            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection
@push('scripts')
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    Vue.component('v-select', VueSelect.VueSelect);
    var selected_customer = {!! $selected_customer !!};
    var selected_fixedAsset = {!! $selected_fixedAsset !!};
    let vu = new Vue({
        el: '#app',
        data: {
            fixedAsset: [],
            selectedAsset: selected_fixedAsset,
            selectedExpense: null,
            selectedIncome: null,
            amount: 0,
            fixedAssetAmount: 0,
            selected_type: "{{$deliveryFixAsset->delivery_type}}",
            customer: [],
            selected_customer: selected_customer,
            rate: 0,
            // selected_type: 'delivery',
        },
        computed: {
        },
        mounted: function () {
            
        },
        methods: {
            filterAssets(){
                vu.fixedAsset = [];
                vu.selectedAsset = null;
            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        regForm(e.target);
                    }
                });
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Employee'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        vu.customer = [];
                        vu.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //ajax call to get items
            searchFixedAsset(search, loading) {
                if (vu.selected_type == 'delivery') {
                    var type = 'on'
                } else {
                    var type = 'off'
                }
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        'search_column': 'name',
                        'filterColumn': 'status',
                        'filterValue': 'on',
                        'table_name': 'fixed_asset_management',
                        keyword: search,
                    }
                })
                .then(function (response) {
                    vu.fixedAsset = [];
                    if (response.data.length > 0) {
                        vu.fixedAsset = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },   
            get_depreciation_amount() {
                // console.log(444, vu.selectedAsset);
                if (vu.selectedAsset != null) {
                    let selectedAsset_id = vu.selectedAsset.id
                    // console.log(333, selectedAsset_id);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDepreciationAmount',
                            selectedAsset_id: selectedAsset_id
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            vu.fixedAssetAmount = response.data.data.fixedAssetAmount;
                            // console.log(3334, response.data.data);
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }

            },
        }
    });
</script>
@endpush