@extends('layouts.factor-master')
@section('content')
    <?php
        $report = customeReportNew('fix_asset_delivery_index');
        $_fixedAssetNumber = !in_array('fixedAssetNumber', $report);
        $_fixedAsset = !in_array('fixedAsset', $report);
        $_employee = !in_array('employee', $report);
        $_type = !in_array('type', $report);
        $_date = !in_array('date', $report);
        $_description = !in_array('description', $report);
        $_user = !in_array('user', $report);

        $report_percent = customeReportNewPercent('fix_asset_delivery_index');
        $_fixedAssetNumber_percent= (array_key_exists('fixedAssetNumber___percent', $report_percent))?$report_percent['fixedAssetNumber___percent']:null;
        $_fixedAsset_percent= (array_key_exists('fixedAsset___percent', $report_percent))?$report_percent['fixedAsset___percent']:null;
        $_employee_percent= (array_key_exists('employee___percent', $report_percent))?$report_percent['employee___percent']:null;
        $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
        $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
        $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
        $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    ?>
    <h3 class="table-caption" style="text-align: center;">@lang('layout.FixAssetDeliveryReport')</h3>
    @if($from_date || $to_date)
    <table class="main-table" style="border: none;">
        <tr style="border: none;">
            @if($from_date)
            <td style="border: none;">
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
            @endif
            @if($to_date)
            <td style="border: none;">
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
            @endif
        </tr>
    </table>
    @endif
    <table class="main-table" style="margin-top: 10px;">
        <thead>
            <tr class="bg" >
                <td class="center"><div>@lang('layout.Record')</div></td>
                @if($_fixedAssetNumber)
                <td class="center" @if($_fixedAssetNumber_percent) width="{{$_fixedAssetNumber_percent}}%" @endif><div>@lang('layout.Number')</div></td>
                @endif
                @if($_fixedAsset)
                <td class="center" @if($_fixedAsset_percent) width="{{$_fixedAsset_percent}}%" @endif><div> @lang('layout.FixedAsset')</div></td>
                @endif
                @if($_employee)
                <td class="center" @if($_employee_percent) width="{{$_employee_percent}}%" @endif><div> @lang('layout.Employee')</div></td> 
                @endif
                @if($_type)
                <td class="center" @if($_type_percent) width="{{$_type_percent}}%" @endif><div> @lang('layout.Type')</div></td> 
                @endif
                @if($_date)
                <td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>
                @endif 
                @if($_description)
                <td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif><div> @lang('layout.Description')</div></td>
                @endif
                @if($_user)
                <td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif><div>@lang('layout.User')</div></td> 
                @endif
            </tr>
        </thead>
        <?php
            $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_fixedAssetNumber)
                <td class="center">{{$record['number']}}</td>
                @endif
                @if($_fixedAsset)
                <td class="center">{{$record['fixed_asset']}}</td>
                @endif
                @if($_employee)
                <td style="text-align: center">{{$record['customer']}}</td>
                @endif
                @if($_type)
                <td class="center">{{($record['delivery_type'])?__('layout.'.ucfirst($record['delivery_type'])):null}}</td>
                @endif
                @if($_date)
                <td class="center">{{convertDate($record['date'])}}</td>
                @endif
                @if($_description)
                <td style="text-align: center;">{{$record['description']}}</td>
                @endif
                @if($_user)
                <td style="text-align: center">{{$record['user']}}</td>
                @endif
            </tr>
        @endforeach
    </table>
    <!--  signature -->
    <table style="width: 100%" class="signtable">
        <tr>
            @foreach(getCompanyInfo('sign','reports') AS $info)
            <td style="text-align: left; width:40%">
                <table >
                    <tr>
                        <td align="right" class="signsize">{{$info['name']}}</td>
                    </tr>     
                </table>
            </td>
            @endforeach
        </tr>
    </table>
    <!-- End signature -->
@endsection