@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")

<div class="row" >

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditDelivery') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
           


            <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                  <!-- begin sale order modal -->
                
                <!-- end sale order modal -->

                <!-- BEGIN FORM-->
                {{Form::model($delivery,['route' => ['delivery_service.update',$delivery->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                {{ csrf_field() }}

                    <div class="form-body">
                         <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                <!-- div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" class="form-control">
                                      </div>
                                    </div> 
                                </div -->
								
								
								<div class="col-md-4">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.SelectProject')</label> 
                                            <v-select label="name" v-model="selectedProject" :options="project_items"  @input="getFormulaItem(this)"  @search="ProjectSearch"></v-select> 
                                            <input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
                                            <input type="hidden" name="customer_id" :value="(!selectedProject)?null:selectedProject.customer_id">
                                        </div>
                                    </div> 
								
                                <div class="col-md-4">
									<div class="form-group">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" name="date" value="{{$delivery->date}}"  class="form-control date">
                                    </div>
                                </div>
								<div class="col-md-4">
									 <div class="form-group">
										  <label class="control-label">@lang('layout.Code') </label>
										  <input type="number" name="number" value="{{$delivery->number}}" class="form-control">
									  </div>
								</div>
								
                            </div>
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
								<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
									<div class="form-group">
										  
										  <div class="">
											<label class="control-label">@lang('layout.Currency')</label> 
											  <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
											  <input type="hidden" name="currency" :value="selected_currency.code"> 
										  </div>
									  </div> 
								  </div>

								   <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
									  <div class="form-group">
										  
										  <div class="">
											<label class="control-label">@lang('layout.Rate')</label> 
											   <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
										  </div>
									  </div> 
								  </div>
									<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
									  <div class="form-group">
										  <div class="">
											<label class="control-label">@lang('layout.Account')</label>
				
											   <v-select  label="name"  :options="approperiateBank" v-model="selected_banks"></v-select>
											   <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
										  </div>
									  </div> 
								  </div>
								</div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                               <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      <div class="">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea  name="description" class="form-control" rows="2" >{{$delivery->description}}</textarea>
                                      </div>
                                  </div> 
                              </div>
                            </div>
                          <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                        <!-- begin total -->
                           <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                      <td>
                                        <small>@lang('layout.Total') :</small>
                                      </td>
                                      <td class="text-right"><span data-counter="counterup"
                                         data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                                        </td>
                                    </tr>
                                 </table>
                           </div>
                        </div>
                    </div> 
                    

					<div v-if="services.length >0 " class="row">
								<li class="list-group-item bg-green bg-font-green"> @lang('layout.Service') </li>
                                    <div class="table-responsive333">
                                        <table id="table_content" class="table table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Cost')</th>
                                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                    <th></th>
                                              
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(service,index) in services">
                                                    <td>@{{index+1}}</td>
                                                    <td class="highlight">
                                                        <v-select label="name" v-model="service.item"  :options="all_services" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                          
                                                        </v-select>
                                                        <input type="hidden" name="item_id[]" :value="(service.item==null)?null:service.item.id">
                                                        <input type="hidden" name="project_services_id[]" :value="(service.item==null)?null:service.item.project_services_id">
                                                    </td>
                                                
                                                    <td>
                                                      <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                    </td>
                                                    <td class="highlight">
                                                        <select  v-model="(!service.item)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)" disabled>
                                                            <option value="null">@lang('layout.Select')</option>
                                                            <span v-if="(service.item ==null)?false:true">
                                                                <option  v-for="measure in (!service.item)?null:service.item.measure_list" :value="measure">
                                                                @{{measure.measure_name}}
                                                              </option> 
                                                            </span>    
                                                        </select>
                                                       
                                                        <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                    </td>
													<td>
                                                        <div class="input-group">
                                                              <input type="number" name="new_rate[]" class="form-control" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in" @input="setNewRate(index)"  placeholder="@lang('layout.Cost')">
                                                          </div>
                                                    </td>
                                                    <td>
                                                        <div class="input-group">
                                                              <input type="number" class="form-control inner_input" :value="(service.item==null)?null:getItemTotal(service.item,selected_currency.rate, null, null,null,null,null,selected_currency.static_rate).result"  placeholder="@lang('layout.Total')" disabled>
                                                          </div>
                                                    </td>
                                                    <td>
                                                         <span  v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>


                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('delivery.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>               
                                   
                     
                    </div>
                     
                {!! Form::close() !!}
                 
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">

@if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
Vue.use(VeeValidate, {
    locale: 'en',
});
@endif




  Vue.component('v-select', VueSelect.VueSelect);

 

// end new member
   var delivery = {!!$delivery!!}
   var serviceList = {!!$serviceList!!}
   var currency={!! $currency !!};
   var banks = {!! $banks !!};
   var selectedBanks = {!! $selectedBanks !!};
   var selected_currency = {!! $selectedCurrency !!};
   var projectItems = '';
   var projectNewItems = '';
   
  var v = new Vue({
    el: '#appInvoice',
    data: {
       
       delivery:delivery,
       serviceList:serviceList,
       projectItems:projectItems,
       projectNewItems:projectNewItems,
       expenseAccount:null,
       temp_items:[],
       projectNewItem:[],
	   
	   banks:banks,
       currency:currency,
       selected_currency:selected_currency,
       rate:0,
	   
		project_items:[],
		all_services:[],  
		selectedProject :null,
		selected_item:null,
		selected_banks:selectedBanks,
		items:[],
		selected_formula:null,
		formula_list:[],
      
       newCost:[
       null,
       null],
       inventories:[],
	   projectInventories:[],
	   services:[],
       
    },
    computed:{
       
	   selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
      },

          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  
                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                           sum +=new_rate*quantity;
                        }
                        else
                        {
                          sum +=quantity*((rate*smeasure_unit/measure_unit));
                        }
                        
                    }

                }
				for (var i = 0; i < this.projectInventories.length; i++) {
				//console.log('33',this.projectInventories);
                    if (this.projectInventories[i].item && this.projectInventories[i].item !=null)
                    {  
                        var quantity=this.projectInventories[i]['item']['quantity'];
                        var new_rate=this.projectInventories[i]['item']['new_rate'];
                        if(new_rate && quantity>0)
                        {
                           sum +=new_rate*quantity;
                        }
                    }

                }
				
				
				for (var i = 0; i < this.services.length; i++) {
				//console.log('33',this.projectInventories);
                    if (this.services[i].item && this.services[i].item !=null)
                    {  
                        var quantity=this.services[i]['item']['quantity'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        if(new_rate && quantity>0)
                        {
                          @if(systemConfig()[30] == 1)
                           sum +=new_rate*quantity * this.selected_currency.static_rate / this.selected_currency.exchange_rate;
                           @else 
                           sum +=new_rate*quantity * this.selected_currency.exchange_rate;
                           @endif
                        }
                    }

                }
				
				
              
                return sum.toFixed(precision());
          },

          // check payed amount
        
            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
				
				for (var i = 0; i < this.services.length; i++)
                 {
                    
                    if (this.services[i].item)
                    {
						flag=true;
					}
				 }
				 
				 if (this.selected_banks==null)
                    {
						flag=false;
					}else{
						flag=true;
					}
				 
                 if(flag==false)
                 {
                    isError = true;
                 }
                return isError;
              

            },
			
			// filter the banks according to selected currency
            approperiateBank:function()
           {
                var bankCopy=this.banks.slice();
                var tempBank=bankCopy.filter((account)=>{
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if(tempBank.length>0)
                {
                    // this.selected_banks=tempBank[0];
                }
                return tempBank;
           },
			
    },
   
    mounted:function(){
          // initialize the selected item
       
        
		if(this.delivery && this.delivery !=null)
                {
                     this.selectedProject = this.delivery;
                }
		
				
		  // initialize the selected item
        for(var i=0;i<this.serviceList.length;i++)
        {
          console.log('ssssssss',this.serviceList[i]);
          this.services.push({item:this.serviceList[i],items:null});
        }
        
				
		  // initialize the selected item
        // for(var i=0;i<this.projectNewItems.length;i++)
        // {
          // console.log('nnnnnssssssss',this.projectNewItems[i]);
          // this.projectInventories.push({item:this.projectNewItems[i]});
        // }
        // for(var m=4;m>this.projectNewItems.length;m--)
          // {
            // this.projectInventories.push({item:null});
          // }
		  
	  if(this.selectedProject && this.selectedProject !=null)
			{
				 this.onProjectItemSearch(this.selectedProject.project_id,this);
			}
        },
   
   methods:
    {
		
			   // Search Project 
      
        ProjectSearch:_.debounce((search,loading)=>{
           v.project_items=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',  
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
             {
                v.project_items=response.data;
                console.log('test 22',v.project_items);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),
	   
	      
	   
			getFormulaItem(e)
            {	
	    
                if(this.selectedProject && this.selectedProject !=null && this.selectedProject.project_id != delivery.project_id)
                {
					
					this.inventories=[];
					this.projectInventories=[];
					
					for(var m=2;m>0;m--)
					  {
						this.inventories.push({item:null});
					  }
			
					for(var m=2;m>0;m--)
					  {
						this.projectInventories.push({item:null});
					  }
				
				}
                if(this.selectedProject && this.selectedProject !=null)
                {
                     this.onProjectItemSearch(this.selectedProject.project_id,this);
                }
            },
          
         
           //ajax call to get items
           onProjectItemSearch:_.debounce((project_id,vm)=>{
               v.formula_list=[];
               v.selected_formula=null;
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'serarchDeliveryItem',
                  project_id:project_id,
                }
               })
               .then(function (response)
               {
                    console.log('sssss',response.data.projectItem);
                 v.items=[];
                 if(response.data.length>0)
                 {
                    vm.items=response.data;
                 }
				 //v.temp_items=[];
				 if(response.data.projectItem.length>0)
				 {
					v.temp_items=response.data.projectItem;
                  console.log('new data',v.temp_items);
				 }
				 //v.projectNewItem=[];
				 if(response.data.projectNewItem.length>0)
				 {
					v.projectNewItem=response.data.projectNewItem;
                  console.log('new data1',v.projectNewItem);
				 }
				 //v.all_services=[];
				 if(response.data.serviceList.length>0)
				 {
					v.all_services=response.data.serviceList;
                  // console.log('new data1',v.all_services);
				 }
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),
	   
	   
		handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
						// alert(e.target);
                        regForm(e.target);
                    }
                });
            },
		
        
	     // set new price
       setNewRate(index)
       {
              if(this.services[index].item)
              {
                @if(systemConfig()[30] == 1)
                 this.services[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.static_rate * this.selected_currency.exchange_rate;
                 @else 
                 this.services[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.exchange_rate;
                 @endif
              }
            
        
       },
	   
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       
           // calculate item price based on measure change
       
       // detect member change and searh
       

   
       //ajax call to get items
       onItemSearch:_.debounce((search,loading)=>{
          loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'itemSearchProcurment',
              keyword:search,
            }
           })
           .then(function (response)
           {
             //v.temp_items=[];
             if(response.data.length>0)
             {
                v.temp_items=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
      
        addItems(type)
       { 
            if(type !=null)
            {
                if(type=="delivery")
                { 
                    //this.temp_items=[];
                   this.inventories.push({item:null}); 
                }
                if(type=="project_inventory")
                { 
                    //this.temp_items=[];
                   this.projectInventories.push({item:null}); 
                }
                
            }
                 
          },

       // end item search

       // contract search


      
        
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          //this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                 // this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
             if(type=='project_inventory')
             {
                if(this.projectInventories[index+1]==undefined)
                {
                 // this.temp_items=[];
                  this.projectInventories.push({item:null});
                }
             }
			 if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             } 
             
             
          }
          
       },

       // in here you can check and decide to allow duplicate service or not
       checkExistingService(index=null,name='')
       {      
              var service_temp=this.all_services.slice();
              var service_temp1=[];
              for(var i=0;i<this.services.length;i++)
              {
                  if(this.services[i].item !=null)
                  {
                      var fined=service_temp.findIndex((item)=> item.name == this.services[i].item.name);
                      if(fined !=-1)
                      {
                        var o=service_temp.splice(service_temp.findIndex((item)=>item.name == this.services[i].item.name),1);
                      }
                  }
              }
              this.services[index].items = service_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
       
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
			 if(type=='project_inventory')
             {
                this.projectInventories.splice(index, 1);
             }
			   if(type=='service')
             {
                this.services.splice(index, 1);
             }
             
         }
          
       },
       // submit the form
       
	   // submit the form
	    measureChangeservice(index)
       {
           if(this.services[index].item !=null){
            var item=this.services[index].item;
            @if(systemConfig()[30] == 1)
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit) * this.selected_currency.static_rate /  this.selected_currency.exchange_rate);
            @else 
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.exchange_rate);
            @endif
            result=Number.parseFloat(temp).toFixed(precision());

            this.services[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
	   
	   
    },
    

  });

</script>



@endpush