  
@extends('layouts.app')
@section('style')
    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">
    <link rel="stylesheet" href="{{url('/vue/style.css')}}">
    <style>
        .dashboard-stat2 {
            padding: 0;
        }


        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }




        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
    </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }

    </style>

@stop



@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equal

  
izer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Enterbill')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
                <div class="tools">
                    <a href="" class="collapse"> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config"> </a>
                    <a href="" class="reload"> </a>
                    <a href="" class="remove"> </a>
                </div>
            </div>
            <div class="portlet-body form" id="item-service">


                {{Form::open(['route' => 'bill.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                <div id="salse" v-cloak>



                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                            <div class="row">
                                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Vendor')</label>
                                        <div class="col-md-8">
                                            <v-autocomplete :items="customerList" v-model="customer" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='customerUpdate'
                                                            :input-attrs="{}"
                                                            placeholder="select item">
                                            </v-autocomplete>
                                            <input type="hidden" name="vendor" :value="(customer)?customer.id:null">

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Currency') </label>
                                        <div class="col-md-8">
                                            <select class="form-control " v-model="selectedCurrency"  required="required">

                                                <option v-for="optionCurrency in currencyList"
                                                        :value="optionCurrency">@{{optionCurrency.code}}
                                                </option>
                                            </select>

                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">@lang('layout.Discount') </label>
                                        <div class="col-md-8 ">
                                            <div class="input-group" :class="{'has-error':discount<0 || discount>100 }">
                                                <input  v-model="discountFiled" class="form-control"
                                                        type="number" min="0"
                                                        max="100">

                                                <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%</span>

  
<input type="hidden" name="discount" :value="discount">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{--<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">--}}
                                    {{--<div class="form-group">--}}
                                        {{--<label class="control-label col-md-4">@lang('layout.Account') </label>--}}
                                        {{--<div class="col-md-8">--}}

                                            {{--<select class="form-control" name="bank_account">--}}
                                                {{--<option v-for="Account in accountUpdate" :value="Account.id">@{{--}}
                                                    {{--Account.name }}--}}
                                                {{--</option>--}}
                                            {{--</select>--}}

                                        {{--</div>--}}
                                    {{--</div>--}}
                                {{--</div>--}}


                            </div>
                            <div class="row">
                                <div class="col-lg-5 col-md-5$sale->id) col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <label class="control-label col-md-4">@lang('layout.Description') </label>
                                        <div class="col-md-8 ">

                                            <textarea  name="description" class="form-control" rows="1"></textarea>
                                        </div>
                                    </div>

                                </div>


                                <div  class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                    <div class="form-group" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label col-md-4">@lang('layout.Rate') </label>
                                        <div class="col-md-8 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <div class="input-group">
                                                <input  v-model="selectedCurrency.rate" class="form-control"
                                                        type="number" min="0" >
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>


                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.rate">
                                </div>



                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                            <div class="dashboard-stat2 ">

                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Discount'): (@

  
{{ Number.parseFloat(discount).toFixed(2) }}%)</small>
                                        </td>
                                        <td class="text-right">
                                                   <span class="text-right" data-counter="counterup"
                                                         data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(2) }}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>
                                            <small>@lang('layout.Payment'):</small>
                                        </td>
                                        <td class="text-right">
                                            <small class="font-green-sharp">
                                    <span class="text-right" data-counter="counterup"
                                          data-value="7800">@{{ payeds.toFixed(2)}}</span>
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </small>
                                        </td>
                                    </tr>


                                    <tr>
                                        <td>
                                            <small>Sub-Total:</small>
                                        </td>
                                        <td class="text-right">
                                                    <span class="text-right" data-counter="counterup"
                                                          data-value="7800">@{{ subtotal.toFixed(2)}}</span>
                                            <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                        </td>
                                    </tr>


                                </table>

                            </div>
                        </div>


                    </div>

                    <div v-if="inventories.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                    <th class="text-center" style="min-width: 120px;"> Inventory Site </th>
                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.Quantity')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.NewCost')</th>
                                    <th class="text-center" style="min-width: 90px;"> @lang('layout.Total')</th>
                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(inventory,InventoryIndex) in inventories" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{InventoryIndex}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="inventory.items" v-model="inventory.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='update'
                                                        :input-attrs="{}"
                                                        @focus="setFocus(InventoryIndex)"
                                                        placeholder="select item"
                                                        style="min-width: 220px  ;">
                                        </v-autocomplete>
                                        <input type="hidden" name="inventory_id[]" :value="(!inventory.item)?null:inventory.item.id">
                                    </td>
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="Quantity"
                                                 v-model="!inventory.item?null:inventory.item.site"
                                                 required="required">

                                            <option v-if="inventory.item"
                                                    v-for="sites in (!inventory.item?null:inventory.item.siteList)"
                                                    :value="sites">@{{sites.site_name}}
                                            </option>
                                        </select>
                                        <input type="hidden" name="site_id[]" :value="(!inventory.item)?null:(inventory.item.site)?inventory.item.site.site_id:null">
                                    </td>
                                    <td >
                                        <input name="inventory_qty[]" class="form-control inpu-number-fild"  :class="{'input-has-error':(!inventory.item)?null:(inventory.item.qty < 0 )}" type="number" v-model.number="(!inventory.item)?null:inventory.item.qty" placeholder="Quantity" />
                                    </td>
                                    <td>
                                        <input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit + inventory.item.qty " placeholder="On Hand" disabled/>
                                    </td>
                                    <td>
                                        <select  class="form-control input_style"
                                                 placeholder="Measure"
                                                 v-model="!inventory.item?null:inventory.item.measure"
                                                 required="required">

                                            <option v-if="inventory.item"
                                                    v-for="measures in (!inventory.item?null:inventory.item.measureList)"
                                                    :value="measures">@{{ measures.measure_name }}</option>
                                        </select>

                                        <input type="hidden" name="inventory_measure[]" :value="(!inventory.item)?null:(inventory.item.measure)?inventory.item.measure.measure_id:null">
                                    </td>
                                    <td>
                                        <div class="input-group input_style">

                                            <input type="number" class="form-control inner_input"  placeholder="Cost" :value="(!inventory.item)?null:((inventory.item.avg_cost*inventory.item.measure.measure_unit/inventory.item.measure_unit)*selectedCurrency.rate).toFixed(2)" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>

  
</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" name="inventory_price[]" class="form-control inner_input" :class="{'input-has-error':(!inventory.item)?null:inventory.item.rate<0}" placeholder="@lang('layout.NewCost')" v-model="(!inventory.item)?null:inventory.item.rate" >
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="number" class="form-control inner_input"  placeholder="Total" :value="(!inventory.item)?null:inventory.item.qty * inventory.item.rate" disabled>
                                            <span class="input-group-addon">
                                            <b>@{{selectedCurrency.symbol}}</b>
                                        </span>
                                        </div>
                                    </td>
                                    <td>
                                        <span  v-on:click="deleteItem(InventoryIndex)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        {{--<a href="#"><i class="glyphicon glyphicon-trash"></i></a>--}}
                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>



                    {{--<div v-if="services.length >0 " class="row">--}}
                        {{--<div class="table-responsive333">--}}
                            {{--<table id="table_content" class="table table-bordered table-striped">--}}
                                {{--<thead>--}}
                                {{--<tr>--}}


                                    {{--<th class="text-center" style="min-width: 8px;"> # </th>--}}
                                    {{--<th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>--}}
                                    {{--<th class="text-center" style="min-width: 120px;"> @lang('layout.Quantity') </th>--}}
                                    {{--<th class="text-center" style="min-width: 80px;">@lang('layout.Measure')</th>--}}
                                    {{--<th class="text-center" style="min-width: 60px;"> @lang('layout.Cost')</th>--}}
                                    {{--<th class="text-center" style="min-width: 120px;">@lang('layout.Price')</th>--}}
                                    {{--<th class="text-center" style="min-width: 60px;"> @lang('layout.Total')</th>--}}

                                    {{--<th style="min-width: 20px;"></th>--}}
                                {{--</tr>--}}
                                {{--</thead>--}}
                                {{--<tbody>--}}
                                {{--<tr v-for="(service,Index) in services" class="even">--}}
                                    {{--<td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>--}}
                                    {{--</td>--}}
                                    {{--<td class="td_one">--}}
                                        {{--<v-autocomplete :items="service.items" v-model="service.item" :get-label='getLabel'--}}
                                                        {{--:min-len='0'--}}
                                                        {{--:component-item='tpl' v-on:update-items='updateService'--}}
                                                        {{--:input-attrs="{}"--}}

  
{{--@focus="setServiceIndex(Index)"--}}
                                                        {{--placeholder="select item">--}}
                                        {{--</v-autocomplete>--}}

                                        {{--<input type="hidden" name="service_id[]" :value="!service.item?null:service.item.id">--}}

                                    {{--</td>--}}

                                    {{--<td>--}}
                                        {{--<input name="service_qty[]" class="form-control inpu-number-fild" type="number"  :class="{'input-has-error':(!service.item)?null:service.item.qty<0}" v-model.number="(!service.item)?null:service.item.qty" placeholder="Quantity" />--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                    {{--<input class="form-control spinner input_style" type="number" :value="(!inventory.item)?null:(!inventory.item.site)?null:((inventory.item.site.OnHand * inventory.item.measure_unit/inventory.item.measure.measure_unit).toFixed(2)) - inventory.item.qty " placeholder="On Hand" disabled/>--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                        {{--<select  class="form-control input_style"--}}
                                                 {{--placeholder="Measure"--}}
                                                 {{--v-model="!service.item?null:service.item.measure"--}}
                                                 {{--required="required">--}}

                                            {{--<option v-if="service.item"--}}
                                                    {{--v-for="measures in (!service.item?null:service.item.measureList)"--}}
                                                    {{--:value="measures">@{{ measures.measure_name }}</option>--}}
                                        {{--</select>--}}
                                        {{--<input type="hidden" name="service_measure[]" :value="!service.item?null:(service.item.measure)?service.item.measure.measure_id:null">--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                        {{--<div class="input-group input_style">--}}

                                            {{--<input type="number" class="form-control inner_input"  placeholder="Cost" :value="(!service.item)?null:((service.item.cost*service.item.measure.measure_unit/service.item.measure_unit)*selectedCurrency.rate).toFixed(2)" disabled>--}}
                                            {{--<span class="input-group-addon">--}}
                                            {{--<b>@{{selectedCurrency.symbol}}</b>--}}
                                        {{--</span>--}}
                                        {{--</div>--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                        {{--<div class="input-group input_style">--}}
                                            {{--<input type="number" name="service_price[]" class="form-control inner_input" :class="{'input-has-error':(!service.item)?null:service.item.rate<0}" placeholder="Price" v-model="(!service.item)?null:service.item.rate" >--}}
                                            {{--<span class="input-group-addon">--}}
                                            {{--<b>@{{selectedCurrency.symbol}}</b>--}}
                                        {{--</span>--}}
                                        {{--</div>--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                        {{--<div class="input-group input_style">--}}
                                            {{--<input type="number" class="form-control inner_input"  placeholder="Total" :value="(!service.item)?null:service.item.qty * service.item.rate" disabled>--}}

  
{{--<span class="input-group-addon">--}}
                                            {{--<b>@{{selectedCurrency.symbol}}</b>--}}
                                        {{--</span>--}}
                                        {{--</div>--}}
                                    {{--</td>--}}
                                    {{--<td>--}}
                                        {{--<span  v-on:click="deleteService(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>--}}

                                    {{--</td>--}}
                                {{--</tr>--}}

                                {{--</tbody>--}}
                            {{--</table>--}}
                        {{--</div>--}}
                    {{--</div>--}}

                    <div v-if="payments.length >0 " class="row">
                        <div class="table-responsive333">
                            <table id="table_content" class="table table-bordered table-striped">
                                <thead>
                                <tr>


                                    <th class="text-center" style="min-width: 8px;"> # </th>
                                    <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                    <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                    <th style="min-width: 20px;"></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr v-for="(payment,Index) in payments" class="even">
                                    <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                    </td>
                                    <td class="td_one">
                                        <v-autocomplete :items="payment.items" v-model="payment.item" :get-label='getLabel'
                                                        :min-len='0'
                                                        :component-item='tpl' v-on:update-items='updatePayment'
                                                        :input-attrs="{}"
                                                        @focus="setPaymentIndex(Index)"
                                                        placeholder="select Bank">
                                        </v-autocomplete>

                                        <input type="hidden" name="payment_id[]" :value="!payment.item?null:payment.item.id">

                                    </td>

                                    <td>
                                        <input v-bind:disabled="!payment.item?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="!payment.item?null:payment.item.rate "
                                               class="form-control"
                                               placeholder="Rate" required/>
                                        <input v-if="payment.item" type="hidden" name="payment_rate[]"
                                               v-bind:value="payment.item.rate">
                                    <td>

                                            <input type="text" name="payment_Currency[]" class="form-control"
                                                   v-model="!payment.item?null:payment.item.code"
                                                   placeholder="Currency" required disabled/>

                                            <input v-if="payment.item" type="hidden" name="payment_currency[]"

  
v-bind:value="payment.item.code"/>

                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control"
                                                   v-model.number="!payment.item?null:payment.item.amount "
                                                   placeholder="Pay Amount" required/>

                                            <input v-if="payment.item" type="hidden" name="payment_amount[]"
                                                   v-bind:value="payment.item.amount">

                                            <span class="input-group-addon">@{{(!payment.item)?null:payment.item.code}}</span>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="input-group">
                                            <input type="number" class="form-control"
                                                   :value="!payment.item?null:(payment.item.amount*selectedCurrency.rate/payment.item.rate).toFixed(3)"
                                                   placeholder="total" style="min-width: 100px" required disabled/>
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                    </td>

                                    <td>
                                        <span  v-on:click="deletePayment(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                    </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>
                    </div>



                    <div class="row">

                        <button v-if="inventories.length <= 0 " type="button" class="btn default" @click="addInventory">@lang('layout.AddItem')
                        </button>
                        <button v-if="services.length <= 0 " type="button" class="btn default" @click="addService">@lang('layout.Addservice')
                        </button>
                        <button v-if="payments.length <= 0 " type="button" class="btn default" @click="newPayment">@lang('layout.Addpayments')
                        </button>
                        <button  v-if="isError" type="button" class="btn green" @click="submitForm">@lang('layout.Submit')</button>

                    </div>

                </div>


            </div>

            {{Form::close()}}
        </div>

    </div>
    </div>


    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')
    <script>

        // $('.date-picker').datepicker({
        //     autoclose: true
        // });

    </script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    <script>


        var Currency     = {!! $currency!!}
        var CustomerAll  = {!! $customer !!}
        var Banks        = {!! $banks!!}
        var InventoryAll = {!! $inventoryList!!};
        var serviceAll   = {!! $serviceList !!};
        var Account      = {!! $allBank !!};

        Vue.use(VAutocomplete.default)
        Vue.use(VeeValidate);

        var temp = Vue.component('my-checkbox', {
            template: '#checkbox-template',
            props: {
                item: {required: true},
                searchText: {required: true}
            }

        });

        var sales = new Vue({
            el:'#salse',
            data:{

                inventories: [
                    {

  
items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,

                    }
                ],
                inventoryIndex:0,
                serviceIndex:0,
                inventoryList:InventoryAll,
                serviceList: serviceAll ,
                services:[
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,
                    },
                    {
                        items: [],
                        item: null,

                    }
                ],
                currencyRate:1,
                customer:null,
                customerList:CustomerAll,
                selectedCurrency: {
                    id: parseInt('{{getHomeCurrency()["id"]}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["code"]}}',
                    rate: '{{getHomeCurrency()["rate"]}}'
                },
                payments: [
                    {
                        items: [],
                        item: null,

                    }
                ],
                paymentIndex:0,
                discountFiled: 0,
                discountIsAmount:false,
                currencyList: Currency,
                listAccounts:[],
                account: {},

                tpl: temp
            },

            computed:{
                discount(){
                    if(this.discountIsAmount){

                        if(this.subtotal>0 && this.discountFiled) {
                            return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        }else {
                            return 0;
                        }
                    }else {

                        return this.discountFiled
                    }

                },
                accountUpdate() {
                    var b = _.clone(Banks)
                    return this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                },
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item)
                            sum += this.inventories[i]['item']['qty'] * this.inventories[i]['item']['rate'];

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item)
                            sum += this.services[i]['item']['qty'] * this.services[i]['item']['rate'];

                    }

                    return sum;
                },
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item && this.payments[i]['item']['rate']>0) {
//
                            sum += (this.payments[i]['item']['amount'] * this.selectedCurrency.rate / this.payments[i]['item']['rate']) ;
                        }
                    }
                    return sum;
                },
                isError: function () {
                    var isError = false
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && ((this.inventories[i]['item']['qty'] > this.inventories[i]['item']['onHand']) || (this.in

  
ventories[i]['item']['qty'] < 0) || (this.inventories[i]['item']['rate'] < 0))){
                            isError = true;
                        }


                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && ( this.services[i]['item']['qty'] < 0 || this.services[i]['item']['rate'] < 0)){
                            isError = true;
                        }


                    }
                    if((isError) || (this.discount < 0) || (this.discount > 100 )){
                        return false;
                    }else {
                        return true;
                    }

                },

            },
            methods:{
                itemSelected (item) {
                    alert('selected');
                    console.log('Selected item!', item)
                },
                itemClicked (item) {
                    console.log('You clicked an item!', item)
                    alert('clicked');
                },
                getLabel (item) {
                    if (item) {
                        return item.name
                    }
                    return ''
                },
                deleteItem(index) {
                    this.inventories.splice(index, 1)
                },
                deleteService(index) {
                    this.services.splice(index, 1)
                },
                deletePayment(index){
                    this.payments.splice(index, 1)
                },
                update (text) {
                    var Animals1 = InventoryAll.slice();

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item != null && i != this.inventoryIndex ) {
                            if (Animals1.findIndex((item) => item.name == this.inventories[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.inventories[i].item.name), 1)

                        }

                    }
                    this.inventories[this.inventoryIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.inventoryIndex == this.inventories.length - 1 && this.inventories.length-3 < InventoryAll.length ) {
                        this.addInventory()
                    }
                    // if (this.rows[this.inventoryIndex].item != null)
                    //     this.priceUpdate(this.inventoryIndex)
                },
                updateService (text) {
                    var Animals1 = serviceAll.slice();

                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item != null && i != this.serviceIndex ) {
                            if (Animals1.findIndex((item) => item.name == this.services[i].item.name) != -1)
                                Animals1.splice(Animals1.findIndex((item) => item.name == this.services[i].item.name), 1)

                        }

                    }
                    this.services[this.serviceIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())


                    })
                    if (this.serviceIndex == this.services.length - 1 && this.services.length-3 < InventoryAll.length ) {
                        this.addService()
                    }
                    // if (this.rows[this.serviceIndex].item != null)
                    //     this.priceUpdate(this.serviceIndex)
                },
                updatePayment (text) {
                    var Animals1 = Account.slice();

                    for (var i = 0; i < this.payments.length; i++) {
                        if (this.payments[i].item != null) {
                            if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1)

  
Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)

                        }

                    }

                    this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    })
                    if (this.paymentIndex == this.payments.length - 1)
                        this.newPayment()
                    if (this.payments[this.paymentIndex].item != null)
                        this.payeds;

                },
                setFocus(index){
                    this.inventoryIndex = index;
                    this.update('')
                },
                setServiceIndex(index){
                    this.serviceIndex = index;
                    this.updateService('')
                },
                setPaymentIndex(index){
                    this.paymentIndex = index;
                    this.updatePayment('')
                },
                addInventory(){
                    this.inventories.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                addService(){
                    this.services.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                newPayment(){
                    this.payments.push({
                            items: [],
                            item: null,
                        }
                    )
                },
                customerUpdate(text){
                    this.customerList = CustomerAll.slice().filter((item) => {
                        return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
                    });
                },
                bankUpdate(text) {
                    var b = _.clone(this.accounts)

                    this.listAccounts = b.filter((account) => {
                        return (new RegExp(text.toLowerCase())).test(account.name.toLowerCase())
                    })

                },
                submitForm() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("sales-form").submit()

                        } else {

                        }
                    });

                },


            }
        });


    </script>
@endpush