@extends('layouts.factor-master')

@section('content')

<?php
$report=customeReport('account','index');
?>
<h3></h3>

<table class="main-table">

 @if($data && count($data) > 0)

 <tr>
  <td>
    <span>@lang('layout.Project')</span>:
    <span>{{$data[0]->pro_name}}</span>
  </td>
  
  <td>
    <span>@lang('layout.Customer')</span>:
    <span>{{$data[0]->members_name}}</span>
  </td>
  
  <td>
    <span>@lang('layout.Date')</span>:
    <span>{{convertDate($data[0]->date)}}</span>
  </td>
  <td>
    <span>@lang('layout.Currency')</span>:
    <span>{{$data[0]->Currency}}</span>
  </td>
  <td>
    <span>@lang('layout.Description')</span>:
    <span>{{$data[0]->description}}</span>
  </td>
  <td>
    <span>@lang('layout.Rate')</span>:
    <span>{{$data[0]->rate}}</span>
  </td>
  <td>
    <span>@lang('layout.User')</span>:
    <span>{{$data[0]->user}}</span>
  </td>
</tr>
@endif

</table>




  <h3 class="table-caption" style="text-align: center;">@lang('layout.DeliveryReport')</h3>

<table class="main-table">
  <thead>
  <tr>
   <td><div class="center">  @lang('layout.Record') </div></td>
   
   <td><div class="center"> @lang('layout.ItemName')</div></td>
   <td><div class="center"> @lang('layout.MeasureUnit')</div></td>
   <td><div class="center"> @lang('layout.Quantity')</div></td>
   <td><div class="center"> @lang('layout.Amount')</div></td>
   <td><div class="center"> @lang('layout.Currency')</div></td>
   <td><div class="center"> @lang('layout.Description')</div></td>
   <td><div class="center"> @lang('layout.Date')</div></td>
   <td><div class="center"> @lang('layout.Status')</div></td>

 </tr>
</thead>
 <?php
 $count = 0;
 $perprice=0;
 $total_home_currency=0;
 $currencies=[];
 
 ?>

<tbody>
 @foreach($info AS $rec)
 <tr>

 <?php

    if(systemConfig()[30] == 1){
      $total_home_currency+=(($rec->cost * $rec->quantity) / $rec->static_rate *  $rec->rate);
    }else{
      $total_home_currency+=(($rec->cost * $rec->quantity) / $rec->rate);
    }

   if(array_key_exists($rec->Currency, $currencies))
   {
    $currencies[$rec->Currency]=$currencies[$rec->Currency]+($rec->cost * $rec->quantity);
  }
  else
  {

    $currencies[$rec->Currency]=($rec->cost * $rec->quantity);
  }
  ?>

 <td class="center">{{++$count}}</td>
 <td class="center">{{$rec->name}}</td>
 <td class="center">{{$rec->unit}}</td>
 <td class="center">{{$rec->quantity}}</td>
 <td class="center">{{$rec->cost}}</td>
 <td class="center">{{$rec->Currency}}</td>
 <td class="center">{{$rec->description}}</td>
 <td class="center">{{convertDate($rec->date)}}</td>
 <td  class="center">
  @if($rec->status){{__('type.'.$rec->status)}} @endif
  </td>
</tr>
  @endforeach   
</tbody>
</table>


<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection

