@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.DeliveryInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
						<th>@lang('layout.Code')</th>
						<th>@lang('layout.ProjectName')</th>
						<th>@lang('layout.Account')</th> 
						<th>@lang('layout.Date')</th>
						<th>@lang('layout.Description')</th>
                    </tr> 
                    </thead>
                    <tbody>
                    <tr>  
					
                        <td class="hidden-xs"> {{ $delivery->number }}  </td>
                        <td class="hidden-xs"> {{ $delivery->pro_name }}  </td>
                        <td class="hidden-xs"> {{ $delivery->name }}  </td>
                        <td class="hidden-xs"> {{ convertDate($delivery->date) }}</td>
                        <td class="hidden-xs"> {{ $delivery->description }}  </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.DeliveryDetails')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="delivery_details"/>
                           <input type="hidden" name="id" value="{{$delivery->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="delivery_details"/>
                           <input type="hidden" name="id" value="{{$delivery->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="sales">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Site')</th>
                            <th>@lang('layout.MeasureUnit')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Price')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div> 
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
 @push('scripts')
<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#sales').DataTable({
            ajax:'{{route("delivery.show",$delivery->id)}}',
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                { data: 'item', name: 'item' },
                { data: 'site', name: 'site' },
                { data: 'measure', name: 'measure_unit' },
                { data: 'qty', name: 'qty' },
                { data: 'cost', name: 'cost' },
        ]
        });

    });
</script>


@endpush 