@extends('layouts.factor-master')

@section('content')

    <h3 class="table-caption" style="text-align: center;">@lang('layout.DeliveryRefundReport')</h3>
    
    @if($from_date || $to_date)
        <table class="main-table">
            <tr>
                @if($from_date)
                    <td>
                        <span>@lang('layout.FromDate')</span>:
                        <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
                    </td>
                @endif
                @if($to_date)
                    <td>
                        <span>@lang('layout.ToDate')</span>:
                        <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
                    </td>
                @endif
            </tr>
        </table>
        <br>
    @endif


    <table class="main-table">

        <thead>
        <tr class="bg">
            <td>
                <div class="center">  @lang('layout.Record') </div>
            </td>
            <td>
                <div class="center"> @lang('layout.ProjectNumber')</div>
            </td>
            <th>@lang('layout.Number')</th>
            <th>@lang('layout.CustomerName')</th>
            <th>@lang('layout.ItemName')</th>
            <th>@lang('layout.Site')</th>
            <th>@lang('layout.Quantity')</th>
            <th>@lang('layout.Symbol')</th>
            <th>@lang('layout.Price')</th> 
            <th>@lang('layout.Date')</th>
            <th>@lang('layout.Description')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->project_number}}</td>
                <td class="center">{{$record->number}}</td>
                <td class="center">{{$record->member}}</td>
                <td class="center">{{$record->itemName}}</td>
                <td class="center">{{$record->site}}</td>
                <td class="center">{{$record->qty}}</td>
                <td class="center">{{$record->um}}</td>
                <td class="center">{{myRound($record->price)}}</td>
                <td class="center">{{convertDate($record->date)}}</td>
                <td class="center">{{$record->description}}</td>
            </tr>
        @endforeach
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection