@extends('layouts.factor-master')
@section('content')

<?php
$report=customeReport('adjustment_detail');
$_item_name=in_array('item_name', $report);
$_site=in_array('site', $report);
$_measure=in_array('measure', $report);
$_quantity=in_array('quantity', $report);
$_currency=in_array('currency', $report);
$_price=in_array('price', $report);
$_total_amount=in_array('total_amount', $report);

?>
<table class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.Project')</span>:
    <span>{{$info->pro_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:
    <span>{{$info->name}}</span>
  </td>
  <td>
    <span>@lang('layout.Description')</span>:
    <span>{{$info->description}}</span>
  </td>
</tr>
@endif
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.DeliveryReport')</h3>
<table class="main-table">

  <tr class="bg"> 
  <td><div class="center">  @lang('layout.Record') </div></td>  
   @if($_item_name)<td  class="center">@lang('layout.ItemName')</td>@endif
  @if($_site)<td  class="center">@lang('layout.Site')</td>@endif
  @if($_measure)<td  class="center">@lang('layout.MeasureUnit')</td>@endif
  @if($_quantity)<td class="center">@lang('layout.Quantity')</td>@endif
  @if($_currency)<td  class="center">@lang('layout.Currency')</td>@endif
  @if($_price)<td class="center">@lang('layout.Price')</td>@endif
  @if($_total_amount)<td  class="center">@lang('layout.TotalAmount')</td>@endif

</tr>
<?php
$count = 0;
$total=0;
?>
@foreach($data AS $record)
<?php
$total+=$record->cost*$record->qty;
?>
<tr>
<td class="center">{{++$count}}</td>

@if($_item_name)<td  class="center">{{$record->item}}</td>@endif
@if($_site)<td  class="center">{{$record->site}}</td>@endif
@if($_measure)<td  class="center">{{$record->measure}}</td>@endif
@if($_quantity)<td  class="center">{{$record->qty}}</td>@endif
@if($_currency)<td  class="center">{{getHomeCurrency()[getCurrencyType()]}}</td>@endif
@if($_price)<td  class="center">{{round($record->cost,2)}}</td>@endif
@if($_total_amount)<td  class="center">{{$record->cost*$record->qty}}</td>@endif

</tr>
@endforeach
<tr>
  <td class="center">{{++$count}}</td>
  <td class="center" colspan="2">@lang('layout.Total')</td>
  <td class="center" colspan="5">{{$total}}&nbsp;{{getHomeCurrency()[getCurrencyType()]}}</td>
</tr> 
</table>

<table>
  <tr>

  </tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection